<?php
//$session = '';

/*====================================================================*/
/*  ACS Start - Active Club Solutions - Version 11.0                  */
/*                                                                    */
/*  Version 7 is for the new version 2.0 of the frames                */
/*  Version 8 fixes a change to Google rendering engine               */
/*  Version 9 fixes sessions not being unique                         */
/*  Version 10 added scenario 9, which is cart and no catalog         */
/*                                                                    */
/*====================================================================*/
 
/*====================================================================*/
/*  start the session in PHP                                          */
/*====================================================================*/
   function ACSStartSession() 
   {
      global   $session;

      //$session = Salt();
      session_start();
   }
   add_action('init', 'ACSStartSession', 1);


/*====================================================================*/
/* get the hashed guestkey                                           */
/*====================================================================*/
   function ACSGetGuestKey() 
   {
      return md5($_SERVER['REMOTE_ADDR'] . $_SERVER['HTTP_USER_AGENT']);
   }
   add_shortcode( 'guestid', 'ACSGetGuestKey' );


   
/*====================================================================*/
/* get the hashed sessionid                                           */
/*====================================================================*/
   function ACSGetSession( $atts ) 
   {
      global   $session;

      //echo session_id().'<br>';
      //echo $session.'<br>';
      return session_id();
   }
   add_shortcode( 'sessionid', 'ACSGetSession' );

   add_action('wp_logout', 'ACSEndSession');
   add_action('wp_login', 'ACSEndSession');
   add_action('end_session_action', 'ACSEndSession');

/*====================================================================*/
/*  end the session                                                   */
/*====================================================================*/
   function ACSEndSession() 
   {
      session_destroy();
   }

/*====================================================================*/
/* Randon Token function                                              */
/*====================================================================*/
   function RandomToken( $length = 32 )
   {
      if(!isset($length) || intval($length) <= 8 )
      {  $length = 32;
      }
      if( function_exists('random_bytes') ) 
      {  return bin2hex(random_bytes($length));
      }
      if( function_exists('mcrypt_create_iv') ) 
      {  return bin2hex(mcrypt_create_iv($length, MCRYPT_DEV_URANDOM));
      }
      if( function_exists('openssl_random_pseudo_bytes') )
      {  return bin2hex(openssl_random_pseudo_bytes($length));
      }
   }

/*====================================================================*/
/* Salt used as an additional security that "hashes" the data         */
/*====================================================================*/
   function Salt()
   {
      return substr(strtr(base64_encode(hex2bin(RandomToken(32))), '+', '.'), 0, 44);
   }

/*====================================================================*/
/*  ACS scripts initialization ShortCode                              */
/*====================================================================*/
   add_shortcode('ACSScript', 'ACSScriptShortCode');
   function ACSScriptShortCode( $atts ) 
   {  
      global $counter, $wpdb;
      
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
        $active = $wpdb->get_results($sql, ARRAY_A);
        
        //$service_url = $active[0]['service_url'];
        $db_name       = $active[0]['db_name'];
        $cart_server   = $active[0]['server'];
        
        extract( shortcode_atts( array('server' => $cart_server, 'dbname' => $db_name ), $atts) );

        $counter = $counter + 1;
        
        if( $server == 'CA' || $server == 'ca' )
            $server = 'https://www.secureclubcartca.net';
        else
        if( $server == 'WA' || $server == 'wa' )
            $server = 'https://www.secureclubcartwa.net';
        else
        if( $server == 'TX' || $server == 'tx' )
            $server = 'https://www.secureclubcarttx.net';
        else
        if( $server == 'VA' || $server == 'va' )
            $server = 'https://www.secureclubcartva.net';
        else
        if( $server == 'TEST' || $server == 'test' )
            $server = 'https://www.secureclubcarttest.net';
        else
            $server = 'https://www.secureclubcarttest.net';
        
        if( $counter == 1 )
        {   
            $script = '<script id="CatalogScript" ACSHost="'.$server.'" type="text/javascript" src="'.$server.'/'.$dbname.'/js/cataloghost.js"></script>
                    <script>document.getElementsByTagName("BODY")[0].onresize = function() {ACSResizeFrame()};</script>';
        }
        else
            $script = '';
        
        return $script;
   }

/*====================================================================*/
/*  ACS frame scenarios ShortCode                                     */
/*====================================================================*/
   add_shortcode( 'ACSiFrame', 'ACSiFrameShortCode' );
   function ACSiFrameShortCode( $atts )
   {  extract(shortcode_atts( array(
         'server'          => 'TEST',
         'dbname'          => 'demodb_3',
         'fcrid'           => 'FC0000001',
         'fcridcart'       => '',
         'fcridclub'       => '',
         'scrollpoint'     => '0',
         'usesession'      => 'No',
         'menu'            => 'Yes',
         'bottommargin'    => '0',
         'waitcursor'      => 'progressbar.gif',
         'scenario'        => '1',
         'cursortopmargin' => '-38'
      ), $atts) );

      $cursor = "'.$waitcursor.'";

      if( $waitcursor == 'NONE' || $waitcursor == 'none' || $waitcursor == 'None' )
         $frame1 = '';
      else
      if( strpos( $cursor, "https" ) )
      {  $frame1 = '<div id="ACSWaitCursor" style="display: inline-block; width: 100%; margin-left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="'.$waitcursor.'"/> 
                    </div>';
      }
      else
      {  $frame1 = '<div id="ACSWaitCursor" style="display: inline-block; width: 100%; margin-left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="https://www.secureclub.net/images/activeclub/'.$waitcursor.'"/> 
                    </div>';
      }

      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      if( strlen( $fcridcart ) == 0 && strlen( $fcridclub ) == 0 )
      {  $fcridcart = "$fcrid";
         $fcridclub = "$fcrid";
      }
      else
      if( strlen( $fcridcart ) > 0 && strlen( $fcridclub ) == 0 )
      {  $fcridclub = "$fcrid";
      }
      else
      if( strlen( $fcridcart ) == 0 && strlen( $fcridclub ) > 0 )
      {  $fcridcart = "$fcrid";
      }

      $urlparamcart = 'WCRSHOPID='.$fcridcart.'&WCRIPADSHOPID='.$fcridcart.'';
      $urlparamclub = 'WCRSHOPID='.$fcridclub.'&WCRIPADSHOPID='.$fcridclub.'';
      
      $worker   = 'ACSHost="'.$server.'"';
      $primary  = 'ACSHost="'.$server.'" ACSScrollPoint="'.$scrollpoint.'" ACSBottomMargin="'.$bottommargin.'"';
      $master   = 'ACSHost="'.$server.'" ACSMasterFrame="1" ACSScrollPoint="'.$scrollpoint.'" ACSBottomMargin="'.$bottommargin.'"';

      if( $usesession == 'YES' || $usesession == 'Yes' || $usesession == 'yes' )
      {  $primary  = $primary.' ACSSession='.ACSGetSession(0).'';
         $master   = $master.' ACSSession='.ACSGetSession(0).'';
      }   

      $filter   = $_GET['Filter'];
      if( strlen( $filter ) == 0 )
      {  $filter = $_GET['filter'];
         if( strlen( $filter ) == 0 )
            $filter = $_GET['FILTER'];
      }
      $inrid   = $_GET['Inrid'];
      if( strlen( $inrid ) == 0 )
      {  $inrid = $_GET['inrid'];
         if( strlen( $inrid ) == 0 )
         {  $inrid = $_GET['INRID'];
            if( strlen( $inrid ) == 0 )
               $inrid = $_GET['InrId'];
         }
      }
      $pkrid   = $_GET['Pkrid'];
      if( strlen( $pkrid ) == 0 )
      {  $pkrid = $_GET['pkrid'];
         if( strlen( $pkrid ) == 0 )
         {  $pkrid = $_GET['PKRID'];
            if( strlen( $pkrid ) == 0 )
               $pkrid = $_GET['PkrId'];
         }
      }
      $sourcecode = $_GET['Sourcecode'];
      if( strlen( $sourcecode ) == 0 )
      {  $sourcecode = $_GET['sourcecode'];
         if( strlen( $sourcecode ) == 0 )
            $sourcecode = $_GET['SOURCECODE'];
      }
      if( strlen( $filter ) > 0 )
         $urlparamcart = $urlparamcart.'&FILTER='.$filter.'';
      else
      if( strlen( $inrid ) > 0 )
         $urlparamcart = $urlparamcart.'&INRID='.$inrid.'&PKRID=NONE';
      else
      if( strlen( $pkrid ) > 0 )
         $urlparamcart = $urlparamcart.'&PKRID='.$pkrid.'&INRID=NONE';

      if( strlen( $sourcecode ) > 0 )
         $urlparamcart = $urlparamcart.'&SOURCECODE='.$sourcecode.'';

      if( $scenario == '1' )
      {  $frame2 = '<div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                    <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                    </div>';
      }
      else 
      if( $scenario == '2' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div> ';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div> ';
         }
      }
      else 
      if( $scenario == '3' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '4' ) 
      {  $frame2 = '<div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                    <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                    </div>
                  
                    <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                    <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                    </div>';
      }
      else 
      if( $scenario == '5' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$master.'></iframe>
                       </div>
 
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>

                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$master.'></iframe>
                       </div>
 
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>

                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '6' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '7' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '8' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }

      return $frame1.$frame2;
   }

/*====================================================================*/
/*  ACS ShortCode to embed a Vimeo video                              */
/*====================================================================*/
   add_shortcode( 'ACSVimeo', 'ACSVimeoFrame' );
   function ACSVimeoFrame( $atts )
   {
      extract(shortcode_atts(array(
      'id' => "",
      'width' => "9999",
      'height' => "360"
      ), $atts));

      if( $width == '9999' )
         $iframe = '<iframe style="margin-top: 1px;" src="https://player.vimeo.com/video/'.$id.'?byline=false&portrait=false&title=false" frameborder="2" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
      else
         $iframe = '<iframe style="margin-top: 1px;" src="https://player.vimeo.com/video/'.$id.'?byline=false&portrait=false&title=false" width="'.$width.'" height="'.$height.'" frameborder="2" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
      
      /*$iframe = '<iframe style="margin-top: -45px;" src="https://player.vimeo.com/video/'.$id.'?byline=false&portrait=false&title=false" width="'.$width.'" height="'.$height.'" frameborder="2" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';*/

      /* <iframe src="https://player.vimeo.com/video/277403177" width="640" height="360" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe> */
   
      return $iframe;
   }

/*====================================================================*/
/*  ACS ShortCode to embed a YouTube video using HTTPS                */
/*====================================================================*/
   add_shortcode( 'ACSUTube', 'ACSUTubeFrame' );
   function ACSUTubeFrame( $atts )
   {
      extract(shortcode_atts(array(
      'id' => "",
      ), $atts));

      $iframe = '<iframe src="https://youtube.com/embed/'.$id.'"></iframe>';
      
      return $iframe;
   }

/*====================================================================*/
/*  ACS ShortCode for Reset Password frame - single page frame        */
/*====================================================================*/
   add_shortcode( 'ACSResetPassword', 'ACSResetPasswordShortCode' );
   function ACSResetPasswordShortCode( $atts )
   {  extract(shortcode_atts( array(
         'server'          => 'TEST',
         'dbname'          => 'demodb_3',
         'fcrid'           => 'FC0000001',
         'waitcursor'      => 'progressbar.gif',
         'bottommargin'    => '0',
         'cursortopmargin' => '-38'
      ), $atts) );

      $cursor = "'.$waitcursor.'";

      if( $waitcursor == 'NONE' || $waitcursor == 'none' || $waitcursor == 'None' )
         $frame1 = '';
      else
      if( strpos( $cursor, "https" ) )
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="'.$waitcursor.'"/> 
                    </div>';
      }
      else
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="https://www.secureclub.net/images/activeclub/'.$waitcursor.'"/> 
                    </div>';
      }
      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      $urlparam = '?WCRSHOPID='.$fcrid.'&WCRIPADSHOPID='.$fcrid.'';
      $primary  = 'ACSHost="'.$server.'" ACSBottomMargin="'.$bottommargin.'"';
      
      $reset = $_GET['Reset'];
      if( strlen( $reset ) == 0 )
      {  $reset = $_GET['reset'];
         if( strlen( $reset ) == 0 )
            $reset = $_GET['RESET'];
      }
      $chkword = $_GET['Chkword'];
      if( strlen( $chkword ) == 0 )
      {  $chkword = $_GET['chkword'];
         if( strlen( $chkword ) == 0 )
            $chkword = $_GET['CHKWORD'];
      }
      if( strlen( $reset ) > 0 && strlen( $chkword ) > 0 )
         $urlparam = $urlparam.'&RESET='.$reset.'&CHKWORD='.$chkword.'';
      
      $frame2 = '<div id="ResetPasswordDiv" class="ResetPasswordFrameDiv" style="visibility: visible;">
                <iframe id="ResetPassword" class="ResetPasswordFrame" src="'.$server.'/'.$dbname.'/ResetPassword.aspx'.$urlparam.'" '.$primary.'></iframe>
                </div>';

      return $frame1.$frame2;
   }

/*====================================================================*/
/*  ACS ShortCode for Forgot Password frame - single page frame       */
/*====================================================================*/
   add_shortcode( 'ACSForgotPassword', 'ACSForgotPasswordShortCode' );
   function ACSForgotPasswordShortCode( $atts )
   {  extract(shortcode_atts( array(
         'server'          => 'TEST',
         'dbname'          => 'demodb_3',
         'fcrid'           => 'FC0000001',
         'waitcursor'      => 'progressbar.gif',
         'bottommargin'    => '0',
         'cursortopmargin' => '-38'
      ), $atts) );

      $cursor = "'.$waitcursor.'";

      if( $waitcursor == 'NONE' || $waitcursor == 'none' || $waitcursor == 'None' )
         $frame1 = '';
      else
      if( strpos( $cursor, "https" ) )
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="'.$waitcursor.'"/> 
                    </div>';
      }
      else
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="https://www.secureclub.net/images/activeclub/'.$waitcursor.'"/> 
                    </div>';
      }
      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      $urlparam = '?WCRSHOPID='.$fcrid.'&WCRIPADSHOPID='.$fcrid.'';
      $primary  = 'ACSHost="'.$server.'" ACSBottomMargin="'.$bottommargin.'"';
      
      $frame2 = '<div id="ForgotPasswordDiv" class="ForgotPasswordFrameDiv" style="visibility: visible;">
                <iframe id="ForgotPassword" class="ForgotPasswordFrame" src="'.$server.'/'.$dbname.'/ForgotPassword.aspx'.$urlparam.'" '.$primary.'></iframe>
                </div>';

      return $frame1.$frame2;
   }

/*====================================================================*/
/*  ACS ShortCode for Unsubscribe frame - single page frame           */
/*====================================================================*/
   add_shortcode( 'ACSUnsubscribe', 'ACSUnsubscribeShortCode' );
   function ACSUnsubscribeShortCode( $atts )
   {  extract(shortcode_atts( array(
         'server'          => 'TEST',
         'dbname'          => 'demodb_3',
         'fcrid'           => 'FC0000001',
         'waitcursor'      => 'progressbar.gif',
         'bottommargin'    => '0',
         'cursortopmargin' => '-38'
      ), $atts) );

      $cursor = "'.$waitcursor.'";

      if( $waitcursor == 'NONE' || $waitcursor == 'none' || $waitcursor == 'None' )
         $frame1 = '';
      else
      if( strpos( $cursor, "https" ) )
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="'.$waitcursor.'"/> 
                    </div>';
      }
      else
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="https://www.secureclub.net/images/activeclub/'.$waitcursor.'"/> 
                    </div>';
      }
      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      $urlparam = '?WCRSHOPID='.$fcrid.'&WCRIPADSHOPID='.$fcrid.'';
      $primary  = 'ACSHost="'.$server.'" ACSBottomMargin="'.$bottommargin.'"';
      
      $unsubscribe = $_GET['Unsubscribe'];
      if( strlen( $unsubscribe ) == 0 )
      {  $unsubscribe = $_GET['unsubscribe'];
         if( strlen( $unsubscribe ) == 0 )
            $unsubscribe = $_GET['UNSUBSCRIBE'];
      }
      $chkword = $_GET['Chkword'];
      if( strlen( $chkword ) == 0 )
      {  $chkword = $_GET['chkword'];
         if( strlen( $chkword ) == 0 )
            $chkword = $_GET['CHKWORD'];
      }
      if( strlen( $unsubscribe ) > 0 && strlen( $chkword ) > 0 )
         $urlparam = $urlparam.'&UNSUBSCRIBE='.$unsubscribe.'&CHKWORD='.$chkword.'';
      
      $frame2 = '<div id="UnsubscribeDiv" class="UnsubscribeFrameDiv" style="visibility: visible;">
                <iframe id="Unsubscribe" class="UnsubscribeFrame" src="'.$server.'/'.$dbname.'/Unsubscribe.aspx'.$urlparam.'" '.$primary.'></iframe>
                </div>';

      return $frame1.$frame2;
   }

/*====================================================================*/
/*  ACS ShortCode for Newsletter Hook frame - embed on page frame     */
/*====================================================================*/
   add_shortcode( 'ACSNewsletterHook', 'ACSNewsletterHookShortCode' );
   function ACSNewsletterHookShortCode( $atts )
   {  extract(shortcode_atts( array(
         'server'          => 'TEST',
         'dbname'          => 'demodb_3',
         'fcrid'           => 'FC0000001',
      ), $atts) );

      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      $urlparam = '?WCRSHOPID='.$fcrid.'&WCRIPADSHOPID='.$fcrid.'';
      $primary  = 'ACSHost="'.$server.'"';

      $frame = '<div id="NewsletterHookDiv" class="NewsletterHookFrameDiv" style="visibility: visible;">
                <iframe id="NewsletterHook" class="NewsletterHookFrame" src="'.$server.'/'.$dbname.'/NewsletterHook.aspx'.$urlparam.'" '.$primary.'></iframe>
                </div>';

      return $frame;
   }

/*====================================================================*/
/*  ACS ShortCode for Newsletter frame - single page frame           */
/*====================================================================*/
   add_shortcode( 'ACSNewsletter', 'ACSNewsletterShortCode' );
   function ACSNewsletterShortCode( $atts )
   {  extract(shortcode_atts( array(
         'server'          => 'TEST',
         'dbname'          => 'demodb_3',
         'fcrid'           => 'FC0000001',
         'waitcursor'      => 'progressbar.gif',
         'bottommargin'    => '0',
         'cursortopmargin' => '-38'
      ), $atts) );

      $cursor = "'.$waitcursor.'";

      if( $waitcursor == 'NONE' || $waitcursor == 'none' || $waitcursor == 'None' )
         $frame1 = '';
      else
      if( strpos( $cursor, "https" ) )
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="'.$waitcursor.'"/> 
                    </div>';
      }
      else
      {  $frame1 = '<div id="ACSWaitCursor" style="position: fixed; display: inline-block; left: 45%; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="https://www.secureclub.net/images/activeclub/'.$waitcursor.'"/> 
                    </div>';
      }
      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      $urlparam = '?WCRSHOPID='.$fcrid.'&WCRIPADSHOPID='.$fcrid.'';
      $primary  = 'ACSHost="'.$server.'" ACSBottomMargin="'.$bottommargin.'"';
      
      $email = $_GET['Email'];
      if( strlen( $email ) == 0 )
      {  $email = $_GET['email'];
         if( strlen( $email ) == 0 )
            $email = $_GET['EMAIL'];
      }
      if( strlen( $email ) > 0 )
         $urlparam = $urlparam.'&EMAIL='.$email.'';
      
      $frame2 = '<div id="NewsletterDiv" class="NewsletterFrameDiv" style="visibility: visible;">
                <iframe id="Newsletter" class="NewsletterFrame" src="'.$server.'/'.$dbname.'/Newsletter.aspx'.$urlparam.'" '.$primary.'></iframe>
                </div>';

      return $frame1.$frame2;
   }

/*====================================================================*/
/*  ACS frame version 2 scenarios ShortCode                           */
/*====================================================================*/
   add_shortcode( 'ACSiFrame2', 'ACSiFrameShortCode2' );
   function ACSiFrameShortCode2( $atts )
   {  
    
    global $wpdb;
      
    //database
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
    $active = $wpdb->get_results($sql, ARRAY_A);
    
    $sdb_name         = $active[0]['db_name'];
    $scart_server     = $active[0]['server'];
    $sfcrid           = $active[0]['fcrid'];
    $sfcridclub       = $active[0]['fcridclub'];
    $sscrollpoint     = $active[0]['scrollpoint'];
    $susesession      = $active[0]['usesession'];
    $sbottommargin    = $active[0]['bottommargin'];
    $swaitcursor      = $active[0]['waitcursor'];
    $sscenario        = $active[0]['scenario'];
    $scursortopmargin = $active[0]['cursortopmargin'];        
        
    extract(shortcode_atts( array(
         'server'          => $scart_server,
         'dbname'          => $sdb_name,
         'fcrid'           => $sfcrid,
         'fcridcart'       => '',
         'fcridclub'       => $sfcridclub,
         'scrollpoint'     => $sscrollpoint,
         'usesession'      => $susesession,
         'menu'            => 'Yes',
         'bottommargin'    => $sbottommargin,
         'waitcursor'      => $swaitcursor,
         'scenario'        => $sscenario,
         'cursortopmargin' => $scursortopmargin,
         'nocatalog'       => 'No'
      ), $atts) );

      $cursor = "'.$waitcursor.'";

      if( $waitcursor == 'NONE' || $waitcursor == 'none' || $waitcursor == 'None' )
         $frame1 = '';
      else
      if( strpos( $cursor, "https" ) )
      {  $frame1 = '<div id="ACSWaitCursor" style="display: block; margin-left: auto; ; margin-right: auto; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="'.$waitcursor.'"/> 
                    </div>';
      }
      else
      {  $frame1 = '<div id="ACSWaitCursor" style="display: block; margin-left: auto; ; margin-right: auto; margin-top: '.$cursortopmargin.'px; z-index: 99;">
                    <img src="https://www.secureclub.net/images/activeclub/'.$waitcursor.'"/> 
                    </div>';
      }

      if( $server == 'CA' || $server == 'ca' )
         $server = 'https://www.secureclubcartca.net';
      else
      if( $server == 'WA' || $server == 'wa' )
         $server = 'https://www.secureclubcartwa.net';
      else
      if( $server == 'TX' || $server == 'tx' )
         $server = 'https://www.secureclubcarttx.net';
      else
      if( $server == 'VA' || $server == 'va' )
         $server = 'https://www.secureclubcartva.net';
      else
      if( $server == 'TEST' || $server == 'test' )
         $server = 'https://www.secureclubcarttest.net';
      else
         $server = 'https://www.secureclubcarttest.net';

      if( strlen( $fcridcart ) == 0 && strlen( $fcridclub ) == 0 )
      {  $fcridcart = "$fcrid";
         $fcridclub = "$fcrid";
      }
      else
      if( strlen( $fcridcart ) > 0 && strlen( $fcridclub ) == 0 )
      {  $fcridclub = "$fcrid";
      }
      else
      if( strlen( $fcridcart ) == 0 && strlen( $fcridclub ) > 0 )
      {  $fcridcart = "$fcrid";
      }

      if( $scenario == '9' ) 
      {  $urlparamcart = 'WCRSHOPID='.$fcridcart.'&WCRIPADSHOPID='.$fcridcart.'&LOADCATALOG='.$nocatalog.'' . '&GUESTKEY=' . ACSGetGuestKey();
         $urlparamclub = 'WCRSHOPID='.$fcridclub.'&WCRIPADSHOPID='.$fcridclub.'&LOADCATALOG='.$nocatalog.'' . '&GUESTKEY=' . ACSGetGuestKey();
      }
      else
      {  $urlparamcart = 'WCRSHOPID='.$fcridcart.'&WCRIPADSHOPID='.$fcridcart.'';
         $urlparamclub = 'WCRSHOPID='.$fcridclub.'&WCRIPADSHOPID='.$fcridclub.'';
      }
      $worker   = 'ACSHost="'.$server.'"';
      $primary  = 'ACSHost="'.$server.'" ACSScrollPoint="'.$scrollpoint.'" ACSBottomMargin="'.$bottommargin.'"';
      $master   = 'ACSHost="'.$server.'" ACSMasterFrame="1" ACSScrollPoint="'.$scrollpoint.'" ACSBottomMargin="'.$bottommargin.'"';

      if( $usesession == 'YES' || $usesession == 'Yes' || $usesession == 'yes' )
      {  $primary  = $primary.' ACSSession='.ACSGetSession(0).'';
         $master   = $master.' ACSSession='.ACSGetSession(0).'';
      }   

      $filter   = $_GET['Filter'];
      if( strlen( $filter ) == 0 )
      {  $filter = $_GET['filter'];
         if( strlen( $filter ) == 0 )
            $filter = $_GET['FILTER'];
      }
      $inrid   = $_GET['Inrid'];
      if( strlen( $inrid ) == 0 )
      {  $inrid = $_GET['inrid'];
         if( strlen( $inrid ) == 0 )
         {  $inrid = $_GET['INRID'];
            if( strlen( $inrid ) == 0 )
               $inrid = $_GET['InrId'];
         }
      }
      $pkrid   = $_GET['Pkrid'];
      if( strlen( $pkrid ) == 0 )
      {  $pkrid = $_GET['pkrid'];
         if( strlen( $pkrid ) == 0 )
         {  $pkrid = $_GET['PKRID'];
            if( strlen( $pkrid ) == 0 )
               $pkrid = $_GET['PkrId'];
         }
      }
      $sourcecode = $_GET['Sourcecode'];
      if( strlen( $sourcecode ) == 0 )
      {  $sourcecode = $_GET['sourcecode'];
         if( strlen( $sourcecode ) == 0 )
            $sourcecode = $_GET['SOURCECODE'];
      }
      if( strlen( $filter ) > 0 )
         $urlparamcart = $urlparamcart.'&FILTER='.$filter.'';
      else
      if( strlen( $inrid ) > 0 )
         $urlparamcart = $urlparamcart.'&INRID='.$inrid.'&PKRID=NONE';
      else
      if( strlen( $pkrid ) > 0 )
         $urlparamcart = $urlparamcart.'&PKRID='.$pkrid.'&INRID=NONE';

      if( strlen( $sourcecode ) > 0 )
         $urlparamcart = $urlparamcart.'&SOURCECODE='.$sourcecode.'';

      if( $scenario == '1' )
      {  $frame2 = '<div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                    <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                    </div>';
      }
      else 
      if( $scenario == '2' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div> ';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div> ';
         }
      }
      else 
      if( $scenario == '3' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '4' ) 
      {  $frame2 = '<div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                    <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                    </div>
                  
                    <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                    <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                    </div>';
      }
      else 
      if( $scenario == '5' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$master.'></iframe>
                       </div>
 
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>

                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$master.'></iframe>
                       </div>
 
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>

                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '6' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                       <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$primary.'></iframe>
                       </div>
 
                       <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                       <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '7' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '8' ) 
      {  if( $menu == 'YES' || $menu == 'yes' || $menu == 'Yes' )
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="CatalogMenuDiv" class="MenuFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogMenu" class="MenuFrame" src="'.$server.'/'.$dbname.'/catalogmenu.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                       
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
         else
         {  $frame2 = '<div id="CatalogBasketDiv" class="BasketFrameDiv" style="visibility: hidden;">
                       <iframe id="CatalogBasket" class="BasketFrame" src="'.$server.'/'.$dbname.'/catalogbasket.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div> 
                     
                       <div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                       <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamclub.'" '.$worker.'></iframe>
                       </div>
                     
                       <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                       <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$master.'></iframe>
                       </div>

                       <div id="SelectionDiv" class="SelectionFrameDiv" style="visibility: hidden;">
                       <iframe id="Selection" class="SelectionFrame" src="'.$server.'/'.$dbname.'/selection2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                       </div>';
         }
      }
      else 
      if( $scenario == '9' ) 
      {  $frame2 = '<div id="CatalogMessageDiv" class="MsgFrameDiv" style="display: none;">
                    <iframe id="CatalogMessage" class="MsgFrame" src="'.$server.'/'.$dbname.'/catalogmessage.aspx?'.$urlparamcart.'" '.$worker.'></iframe>
                    </div>
                    
                    <div id="CatalogDiv" style="visibility: hidden;" class="CatalogFrameDiv">
                    <iframe id="Catalog" class="CatalogFrame" src="'.$server.'/'.$dbname.'/catalog2.aspx?'.$urlparamcart.'" '.$master.'></iframe>
                    </div>
 
                    <div id="ManageDiv" class="ManageFrameDiv" style="visibility: hidden;">
                    <iframe id="Manage" class="ManageFrame" src="'.$server.'/'.$dbname.'/manage2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                    </div>

                    <div id="RegisterDiv" class="RegisterFrameDiv" style="visibility: hidden;">
                    <iframe id="Register" class="RegisterFrame" src="'.$server.'/'.$dbname.'/register2.aspx?'.$urlparamclub.'" '.$primary.'></iframe>
                    </div>';
      }

      return $frame1.$frame2;
   }

/*====================================================================*/
/*  ACS Finish                                                        */
/*====================================================================*/
 
?>