<?php
function frontend_scripts() {
    wp_register_style('activeclubsolutions_style', plugins_url('css/style.css', __FILE__));
    wp_enqueue_style( 'activeclubsolutions_style'); 
    wp_register_script('activeclubsolutions_admin_script', 'https://code.jquery.com/jquery-3.1.1.min.js','', '', true);
    //wp_enqueue_script( 'activeclubsolutions_admin_script');
    wp_register_script('activeclubsolutions_admin_script1', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js' ,'', '', true);
    wp_enqueue_script( 'activeclubsolutions_admin_script1');
    wp_register_script('activeclubsolutions_admin_script2', plugins_url('js/custom.js', __FILE__) ,'', '', true);
    wp_enqueue_script( 'activeclubsolutions_admin_script2');
    wp_register_script('activeclubsolutions_admin_script4', plugins_url('js/jquery_easing.js', __FILE__) ,'', '', true);
    wp_enqueue_script( 'activeclubsolutions_admin_script4');
    wp_register_script('activeclubsolutions_admin_script5', 'https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js','', '', true);
    wp_enqueue_script( 'activeclubsolutions_admin_script5');
    wp_register_script('activeclubsolutions_admin_script6', 'https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js','', '', true);
    wp_enqueue_script( 'activeclubsolutions_admin_script6');
}
add_action('wp_enqueue_scripts', 'frontend_scripts', 10);


function sessi_start() {
    if (!session_id())
    session_start();
}
add_action('init','sessi_start', 1);


//All products
function AllProductLists(){
    session_start();
    ob_start();
    global $wpdb;
    
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
    $dbdetails = $wpdb->get_results($sql, ARRAY_A);
    
    $cid = $dbdetails[0]['category_id'];
    
    //session check for sorting
    if(isset($_SESSION['sid']) && !empty($_SESSION['sid'])) {
        $sort_id = $_SESSION['sid'];
    }
    
    //API
    //database
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
    $active = $wpdb->get_results($sql, ARRAY_A);
    
    $service_url = $active[0]['service_url'];
    $db_name     = $active[0]['db_name'];
    $db_username = $active[0]['db_username'];
    $db_password = $active[0]['db_password'];
    $fcrid       = $active[0]['fcrid'];
    
    //Soap api get UpdateBasketInfo
    //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
    $soapUrl = $service_url;
               
    $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
    <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Header>
        <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
          <DatabaseName>'.$db_name.'</DatabaseName>
          <Username>'.$db_username.'</Username>
          <Password>'.$db_password.'</Password>
        </AuthorizationHeader>
      </soap:Header>
      <soap:Body>
        <GetCartConfigurationRecord xmlns="https://secureclub.net/webservices/">
          <fcrId>'.$fcrid.'</fcrId>
        </GetCartConfigurationRecord>
      </soap:Body>
    </soap:Envelope>';
    
    $headers = array(
    "POST /webservices/customerservice.asmx HTTP/1.1",
    //"Host: ".$service_host,
    "Content-Type: text/xml; charset=utf-8",
    "Content-Length: ".strlen($xml_post_string)
    ); 
    
    $url = $soapUrl;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    
    $response = curl_exec($ch); 
    curl_close($ch);
    
    $response1 = str_replace("<soap:Body>","",$response);
    $response2 = str_replace("</soap:Body>","",$response1);
    
    $parser = simplexml_load_string($response2);
    //echo '<pre>'; print_r($parser);
    
    $sorting_result = $parser->GetCartConfigurationRecordResponse->GetCartConfigurationRecordResult->CartConfigurationRecord; 
    $sorting_result_count = $parser->GetCartConfigurationRecordResponse->GetCartConfigurationRecordResult->ResponseStatus->StatusRecordCount;
    
    $field = $sorting_result->OrderByField;
    //$field_lower = strtolower($field);
    //$direction  = $sorting_result->OrderByDirection;
    $_SESSION['fields']  = (string) strtolower($field);
    $_SESSION['direction']  = (string) $sorting_result->OrderByDirection;
    
    $field_lower = $_SESSION['fields'];
    $direction  = $_SESSION['direction'];
    
    if($sorting_result_count > 0){
        
        $table_name = $wpdb->prefix . 'active8_shop';
        $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price,catalog_text_line,allocation_id,allocation_msg,allocation_price FROM ".$table_name;
        if($cid != 0){ 
            $sql.= " WHERE (category_1=".$cid." or category_2=".$cid." or category_3=".$cid." or category_4=".$cid." or category_5=".$cid.")";
        }
        if($sort_id == 1){ //a-z
            $sql.= " ORDER BY title ASC";
        }elseif($sort_id == 2){ //z-a
            $sql.= " ORDER BY title DESC";
        }elseif($sort_id == 3){ //Highest to Lowest Price
            $sql.= " ORDER BY price DESC";
        }elseif($sort_id == 4){ //Lowest to Highest Price
            $sql.= " ORDER BY price ASC";
        }elseif($sort_id == 5){ //Top seller
            $sql.= " ORDER BY total_sales DESC";
        }else{
            $sql .= " ORDER BY ".$field_lower." ".$direction."";
        }
        
        //echo $sql;
        
    }else{
        
        //create default value for field and direction
        $field_lower = 'title';
        $direction = 'ASC';
        
        $table_name = $wpdb->prefix . 'active8_shop';
        $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price,catalog_text_line,allocation_id,allocation_msg,allocation_price FROM ".$table_name;
        if($cid != 0){ 
            $sql.= " WHERE (category_1=".$cid." or category_2=".$cid." or category_3=".$cid." or category_4=".$cid." or category_5=".$cid.")";
        }
        if($sort_id == 1){ //a-z
            $sql.= " ORDER BY title ASC";
        }elseif($sort_id == 2){ //z-a
            $sql.= " ORDER BY title DESC";
        }elseif($sort_id == 3){ //Highest to Lowest Price
            $sql.= " ORDER BY price DESC";
        }elseif($sort_id == 4){ //Lowest to Highest Price
            $sql.= " ORDER BY price ASC";
        }elseif($sort_id == 5){ //Top seller
            $sql.= " ORDER BY total_sales DESC";
        }else{
            $sql .= " ORDER BY ".$field_lower." ".$direction."";
        }

    }

    $all_products = $wpdb->get_results($sql, ARRAY_A);
    $total_product = $wpdb->num_rows;    
                
    include_once('includes/active_inventory_list.php');
    return ob_get_clean();
}
add_shortcode('acs-shop', 'AllProductLists');


//Product detail page.
function ProductDetails(){
    ob_start();
    global $wpdb;
    
    //Get slug from clean url. Function in activ8-commerce.php. Changed query string into clean url.
    $slug = get_query_var( 'slug' );
    
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
    $dbdetails = $wpdb->get_results($sql, ARRAY_A);
    
    $table_name = $wpdb->prefix . 'active8_shop';
    $sql = "SELECT * FROM ".$table_name." WHERE slug='".$slug."' ORDER BY id ASC";
    $product_details = $wpdb->get_results($sql, ARRAY_A);
                   
    include_once('includes/active_inventory_details.php');
    return ob_get_clean();
}
add_shortcode('acs-product-details', 'ProductDetails');


//Product allocations page.
function ProductAllocationDetails(){
    ob_start();
    global $wpdb;
    
    //Get customer_id from clean url. Function in activ8-commerce.php. Changed query string into clean url.
    $customer_id = get_query_var( 'customerid' );
    
    //API
    //database
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
    $active = $wpdb->get_results($sql, ARRAY_A);
    
    $service_url = $active[0]['service_url'];
    $db_name     = $active[0]['db_name'];
    $db_username = $active[0]['db_username'];
    $db_password = $active[0]['db_password'];
    $fcrid       = $active[0]['fcrid'];
    
    //Soap api get UpdateBasketInfo
    //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
    $soapUrl = $service_url;
               
    $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
    <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Header>
        <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
          <DatabaseName>'.$db_name.'</DatabaseName>
          <Username>'.$db_username.'</Username>
          <Password>'.$db_password.'</Password>
        </AuthorizationHeader>
      </soap:Header>
      <soap:Body>
        <GetAllocationsAvailableToCustomer xmlns="https://secureclub.net/webservices/">
          <InventoryQuery>
            <FrameConfigId>'.$fcrid.'</FrameConfigId>
            <CustomerId>'.$customer_id.'</CustomerId>
          </InventoryQuery>
        </GetAllocationsAvailableToCustomer>
      </soap:Body>
    </soap:Envelope>';
    
    $headers = array(
    "POST /webservices/customerservice.asmx HTTP/1.1",
    //"Host: ".$service_host,
    "Content-Type: text/xml; charset=utf-8",
    "Content-Length: ".strlen($xml_post_string)
    ); 
    
    $url = $soapUrl;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    
    $response = curl_exec($ch); 
    curl_close($ch);
    
    $response1 = str_replace("<soap:Body>","",$response);
    $response2 = str_replace("</soap:Body>","",$response1);
    
    $parser = simplexml_load_string($response2);
    //echo '<pre>'; print_r($parser);
    
    $allocation_result = $parser->GetAllocationsAvailableToCustomerResponse->GetAllocationsAvailableToCustomerResult->Allocations->AllocationDetail; 
    $allocation_result_count = $parser->GetAllocationsAvailableToCustomerResponse->GetAllocationsAvailableToCustomerResult->Allocations->AllocationDetail->ProductItemsSize;
    
    //foreach($allocation_result as $Item){
        
        //echo '<pre>'; print_r($Item);
        
    //}

    include_once('includes/active_allocation_details.php');
    return ob_get_clean();
}
add_shortcode('acs-allocation-details', 'ProductAllocationDetails');


//Prodcut with categories.
function InventoryListWithCategories(){     
    ob_start();
    session_start();
    global $wpdb;
    //Get category id from clean url. Function in activ8-commerce.php. Changed query string into clean url.
    $cid = get_query_var( 'id' );
    

    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
    $dbdetails = $wpdb->get_results($sql, ARRAY_A);
    
    //getting category description
    $table_cname = $wpdb->prefix . 'active8_category';
    $sql = "SELECT id,description FROM ".$table_cname." WHERE category_id=".$cid." ORDER BY id ASC";
    $cat_details = $wpdb->get_results($sql, ARRAY_A);
    
    //session check for sorting
    if(isset($_SESSION['sid']) && !empty($_SESSION['sid'])) {
        $sort_id = $_SESSION['sid'];
    }
    
    //API
    //database
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
    $active = $wpdb->get_results($sql, ARRAY_A);
    
    $service_url = $active[0]['service_url'];
    $db_name     = $active[0]['db_name'];
    $db_username = $active[0]['db_username'];
    $db_password = $active[0]['db_password'];
    $fcrid       = $active[0]['fcrid'];
    
    //Soap api get UpdateBasketInfo
    //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
    $soapUrl = $service_url;
               
    $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
    <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Header>
        <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
          <DatabaseName>'.$db_name.'</DatabaseName>
          <Username>'.$db_username.'</Username>
          <Password>'.$db_password.'</Password>
        </AuthorizationHeader>
      </soap:Header>
      <soap:Body>
        <GetCartConfigurationRecord xmlns="https://secureclub.net/webservices/">
          <fcrId>'.$fcrid.'</fcrId>
        </GetCartConfigurationRecord>
      </soap:Body>
    </soap:Envelope>';
    
    $headers = array(
    "POST /webservices/customerservice.asmx HTTP/1.1",
    //"Host: ".$service_host,
    "Content-Type: text/xml; charset=utf-8",
    "Content-Length: ".strlen($xml_post_string)
    ); 
    
    $url = $soapUrl;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    
    $response = curl_exec($ch); 
    curl_close($ch);
    
    $response1 = str_replace("<soap:Body>","",$response);
    $response2 = str_replace("</soap:Body>","",$response1);
    
    $parser = simplexml_load_string($response2);
    //echo '<pre>'; print_r($parser);
    
    $sorting_result = $parser->GetCartConfigurationRecordResponse->GetCartConfigurationRecordResult->CartConfigurationRecord; 
    $sorting_result_count = $parser->GetCartConfigurationRecordResponse->GetCartConfigurationRecordResult->ResponseStatus->StatusRecordCount;
    
    $field = $sorting_result->OrderByField;
    //$field_lower = strtolower($field);
    //$direction  = $sorting_result->OrderByDirection;
    $_SESSION['fields']  = (string) strtolower($field);
    $_SESSION['direction']  = (string) $sorting_result->OrderByDirection;
    
    $field_lower = $_SESSION['fields'];
    $direction  = $_SESSION['direction'];
    
    if($sorting_result_count > 0){
        
        $table_name = $wpdb->prefix . 'active8_shop';
        $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price,catalog_text_line FROM ".$table_name." WHERE (category_1=".$cid." or category_2=".$cid." or category_3=".$cid." or category_4=".$cid." or category_5=".$cid.")";
        
        if($sort_id == 1){ //a-z
            $sql.= " ORDER BY title ASC";
        }elseif($sort_id == 2){ //z-a
            $sql.= " ORDER BY title DESC";
        }elseif($sort_id == 3){ //Highest to Lowest Price
            $sql.= " ORDER BY price DESC";
        }elseif($sort_id == 4){ //Lowest to Highest Price
            $sql.= " ORDER BY price ASC";
        }elseif($sort_id == 5){ //Top seller
            $sql.= " ORDER BY total_sales DESC";
        }else{
            $sql .= " ORDER BY ".$field_lower." ".$direction."";
        }
        
        //echo $sql;
        
    }else{
    
        $table_name = $wpdb->prefix . 'active8_shop';
        $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price,catalog_text_line FROM ".$table_name." WHERE (category_1=".$cid." or category_2=".$cid." or category_3=".$cid." or category_4=".$cid." or category_5=".$cid.")";
        
        if($sort_id == 1){ //a-z
            $sql.= " ORDER BY title ASC";
        }elseif($sort_id == 2){ //z-a
            $sql.= " ORDER BY title DESC";
        }elseif($sort_id == 3){ //Highest to Lowest Price
            $sql.= " ORDER BY price DESC";
        }elseif($sort_id == 4){ //Lowest to Highest Price
            $sql.= " ORDER BY price ASC";
        }elseif($sort_id == 5){ //Top seller
            $sql.= " ORDER BY total_sales DESC";
        }else{
            $sql.= " ORDER BY title ASC";
        }
        
        //echo $sql;
    }
    
    $all_products = $wpdb->get_results($sql, ARRAY_A);
    $total_product = $wpdb->num_rows;
               
    include_once('includes/active_category_inventory_list.php');
    return ob_get_clean();           
}
add_shortcode('acs-category-shop', 'InventoryListWithCategories');


//Search product ajax
function customize_search_product(){
    session_start();
    global $wpdb;
    
    if($_POST['result'] == 'search'){
        
        $title = $_POST['title'];
        $catid = $_POST['catid'];
        $sid   = $_POST['sid'];
        
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
        $dbdetails = $wpdb->get_results($sql, ARRAY_A);
                
        if($title != ''){
            $table_name1 = $wpdb->prefix . 'active8_shop';
            $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price from ".$table_name1." WHERE title LIKE '%$title%'";
            
            if($catid != 0)
            $sql.=" and (category_1=".$catid." or category_2=".$catid." or category_3=".$catid." or category_4=".$catid." or category_5=".$catid.")";
            
            //$sql.=" ORDER BY id ASC";
            if($sid == 1){ //a-z
                $sql.= " ORDER BY title ASC";
            }elseif($sid == 2){ //z-a
                $sql.= " ORDER BY title DESC";
            }elseif($sid == 3){ //Highest to Lowest Price
                $sql.= " ORDER BY price DESC";
            }elseif($sid == 4){ //Lowest to Highest Price
                $sql.= " ORDER BY price ASC";
            }elseif($sid == 5){ //Top seller
                $sql.= " ORDER BY total_sales DESC";
            }else{
                $sql .= " ORDER BY ".$_SESSION['fields']." ".$_SESSION['direction']."";
            }
            $results = $wpdb->get_results($sql, ARRAY_A);
            $product_count = $wpdb->num_rows;
            
        }else{
            $table_name1 = $wpdb->prefix . 'active8_shop';
            $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price from ".$table_name1;
            
            if($catid != 0)
            $sql.=" WHERE (category_1=".$catid." or category_2=".$catid." or category_3=".$catid." or category_4=".$catid." or category_5=".$catid.")";
            
            //$sql.=" ORDER BY id ASC";
            if($sid == 1){ //a-z
                $sql.= " ORDER BY title ASC";
            }elseif($sid == 2){ //z-a
                $sql.= " ORDER BY title DESC";
            }elseif($sid == 3){ //Highest to Lowest Price
                $sql.= " ORDER BY price DESC";
            }elseif($sid == 4){ //Lowest to Highest Price
                $sql.= " ORDER BY price ASC";
            }elseif($sid == 5){ //Top seller
                $sql.= " ORDER BY total_sales DESC";
            }else{
                $sql .= " ORDER BY ".$_SESSION['fields']." ".$_SESSION['direction']."";
            }
            $results = $wpdb->get_results($sql, ARRAY_A);
            $product_count = $wpdb->num_rows;
        }
                                                                                                          
        //Populating search using ajax.
        $output ='';
        if($product_count > 0){

            foreach($results as $result){ 
                $output .='<li class="product" style="">
                <div class="cd-single-item product-image">
                	<a href="'.get_bloginfo('url').'/product/'.$result['slug'].'"><img src="'.$result['image_full'].'" alt="Preview Image" /></a>
                </div>
                <div class="product-info">
                	<div class="product-name">
                		<a href="'.get_bloginfo('url').'/product/'.$result['slug'].'">'.$result['title'].'</a>
                	</div>
                	<div class="product-availablity">'.$result['stock'].'</div>
                	<div class="product-price">$'.$result['price'].'</div>
                	<form class="cd-customization list" method="post">
                		<span class="CatalogElementQuantityLabel normal">QTY</span>
                		<input id="inventory-'.$result['stock_id'].'" name="inventory" value="1" type="number" min="1" max="99" maxlength="2" class="CatalogElementGridInputField normal inventory" tabindex="1">
          		        <button type="button" id="add-to-cart-'.$result['stock_id'].'" data-operation="Add" data-flying="'.$dbdetails[0]['flying_animation'].'" data-allocations="0" onclick="addUpdateCart(';
                                  $output .= "'".$result['stock_id']."', 'Add', '', ''";
                                  $output .= ');"';
                           if($result['stock'] == "Only 0 left in stock" || $result['stock'] == "Sold Out"): 
                                $output .= ' class="add-to-cart disabled" disabled'; 
                            else: 
                                $output .= ' class="add-to-cart"';
                           endif;                           
                           $output .= '>Add to Cart</button>      
                	 </form>'; 
                $output .='</div></li>'; 
            }
        }else{
            $output .= '<div class="no-product">No Products Found!</div>';
        }                
        
        echo $output.'==='.$product_count;
    }
    exit();
}
add_action( 'wp_ajax_customize_search_product','customize_search_product');
add_action( 'wp_ajax_nopriv_customize_search_product','customize_search_product');


//Sorting product ajax
function customize_sort_product(){
    session_start(); 
    global $wpdb;
    
    if($_POST['result'] == 'sort'){
        
        $title = $_POST['title'];
        $sid = $_POST['sid'];
        $catid = $_POST['catid'];
        
        $_SESSION['sid'] = $sid; //storing sort id in session.
        
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
        $dbdetails = $wpdb->get_results($sql, ARRAY_A);
                
        if($title != ''){
            $table_name1 = $wpdb->prefix . 'active8_shop';
            $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price from ".$table_name1." WHERE title LIKE '%$title%'";
            
            if($catid != 0)
            $sql.=" and (category_1=".$catid." or category_2=".$catid." or category_3=".$catid." or category_4=".$catid." or category_5=".$catid.")";
            
            //$sql.=" ORDER BY id ASC";
            if($sid == 1){ //a-z
                $sql .= " ORDER BY title ASC";
            }elseif($sid == 2){ //z-a
                $sql .= " ORDER BY title DESC";
            }elseif($sid == 3){ //Highest to Lowest Price
                $sql .= " ORDER BY price DESC";
            }elseif($sid == 4){ //Lowest to Highest Price
                $sql .= " ORDER BY price ASC";
            }elseif($sid == 5){ //Top seller
                $sql .= " ORDER BY total_sales DESC";
            }else{
                $sql .= " ORDER BY ".$_SESSION['fields']." ".$_SESSION['direction']."";
            }
            
            $results = $wpdb->get_results($sql, ARRAY_A);
            $product_count = $wpdb->num_rows;
            
        }else{
            $table_name1 = $wpdb->prefix . 'active8_shop';
            $sql = "SELECT product_id,stock_id,title,slug,image_full,stock,price from ".$table_name1."";
            
            if($catid != 0)
            $sql.=" WHERE (category_1=".$catid." or category_2=".$catid." or category_3=".$catid." or category_4=".$catid." or category_5=".$catid.")";
            
            //$sql.=" ORDER BY id ASC";
            if($sid == 1){ //a-z
                $sql.= " ORDER BY title ASC";
            }elseif($sid == 2){ //z-a
                $sql.= " ORDER BY title DESC";
            }elseif($sid == 3){ //Highest to Lowest Price
                $sql.= " ORDER BY price DESC";
            }elseif($sid == 4){ //Lowest to Highest Price
                $sql.= " ORDER BY price ASC";
            }elseif($sid == 5){ //Top seller
                $sql.= " ORDER BY total_sales DESC";
            }else{
                $sql .= " ORDER BY ".$_SESSION['fields']." ".$_SESSION['direction']."";
            }
    
            $results = $wpdb->get_results($sql, ARRAY_A);
            $product_count = $wpdb->num_rows;
            
        }
                                                                                                          
        //Populating sort using ajax.
        $output ='';
        if($product_count > 0){

            foreach($results as $result){ 
                $output .='<li class="product" style="">
                <div class="cd-single-item product-image">
                	<a href="'.get_bloginfo('url').'/product/'.$result['slug'].'"><img src="'.$result['image_full'].'" alt="Preview Image" /></a>
                </div>
                <div class="product-info">
                	<div class="product-name">
                		<a href="'.get_bloginfo('url').'/product/'.$result['slug'].'">'.$result['title'].'</a>
                	</div>
                	<div class="product-availablity">'.$result['stock'].'</div>
                	<div class="product-price">$'.$result['price'].'</div>
                	<form class="cd-customization list" method="post">
                		<span class="CatalogElementQuantityLabel normal">QTY</span>
                		<input id="inventory-'.$result['stock_id'].'" name="inventory" value="1" type="number" min="1" max="99" maxlength="2" class="CatalogElementGridInputField normal inventory" tabindex="1">
          		        <button type="button" id="add-to-cart-'.$result['stock_id'].'" data-operation="Add" data-flying="'.$dbdetails[0]['flying_animation'].'" data-allocations="0" onclick="addUpdateCart(';
                                  $output .= "'".$result['stock_id']."', 'Add', '', ''";
                                  $output .= ');"';
                           if($result['stock'] == "Only 0 left in stock" || $result['stock'] == "Sold Out"): 
                                $output .= ' class="add-to-cart disabled" disabled'; 
                            else: 
                                $output .= ' class="add-to-cart"';
                           endif;                           
                           $output .= '>Add to Cart</button>      
                	 </form>'; 
                $output .='</div></li>'; 
            }
        }else{
            $output .= '<div class="no-product">No Products Found!</div>';
        }                
        
        echo $output.'==='.$product_count;
    }
    exit();
}
add_action( 'wp_ajax_customize_sort_product','customize_sort_product');
add_action( 'wp_ajax_nopriv_customize_sort_product','customize_sort_product');


//Adding SHOP menu item in selected area. And display category under shop menu.      
/*add_filter('wp_nav_menu_items','add_custom_in_menu', 10, 2);
function add_custom_in_menu( $items, $args )
{    
	//echo '<pre>'; print_r($args);
	global $wpdb;
    //database
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
    $dbdetails = $wpdb->get_results($sql, ARRAY_A);
    
    $table_name1 = $wpdb->prefix . 'active8_category';
    $sql = "SELECT * FROM ".$table_name1." WHERE parent_id=0 ORDER BY id ASC";
    $parent_category_list = $wpdb->get_results($sql, ARRAY_A);
    
    $menu_position = $dbdetails[0]['shop_menu_position'] - 1;

    if( $args->menu->taxonomy == 'nav_menu' )
    {
        
        $arry_result = '<li id="menu-item" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children"><a href="'.get_bloginfo('url').'/acs-shop/">Shop</a><span class="icon"></span>
                        <ul class="sub-menu">';
                            foreach($parent_category_list as $list){
                                $arry_result .= '<li id="" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children"><a href="'.get_bloginfo('url').'/product-category/'.$list['category_id'].'">'.$list['category_name'].'</a>';
                                
                                //sub child category list
                                $sql = "SELECT * FROM ".$table_name1." WHERE parent_id=".$list['category_id']." ORDER BY id ASC";
                                $child_category_list = $wpdb->get_results($sql, ARRAY_A);
                                $child_category_count = $wpdb->num_rows;
                                
                                if($child_category_count > 0){
                                    $arry_result .= '<span class="icon"></span><ul class="sub-menu">';                                        
                                        foreach($child_category_list as $lists){
                                            $arry_result .= '<li id="" class="menu-item menu-item-type-custom menu-item-object-custom"><a href="'.get_bloginfo('url').'/product-category/'.$lists['category_id'].'">'.$lists['category_name'].'</a></li>';
                                        }
                                    $arry_result .= '</ul>';
                                }
                                $arry_result .= '</li>';
                            }                                
        $arry_result .= '</ul></li>';
        
        $new_item       = array( $arry_result );
        $items          = preg_replace( '/<\/li>\s<li/', '</li>,<li',  $items );
        

        $array_items    = explode( ',', $items );
        array_splice( $array_items, $menu_position, 0, $new_item ); // $menu_position, splice in at position 2
        $items          = implode( '', $array_items );
    }
    return $items;
}*/


//Basket update ajax.
function customize_basketupdate_info(){
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
    
    if($_POST['result'] == 'basket'){

        $qty = $_POST['qty'];
        $invid = $_POST['invid'];
        $operation = $_POST['operation'];
        
        //Allocation usage
        if($_POST['allocation_id'] != ''){
            $allocationid = $_POST['allocation_id'];
            $above_allocation = $_POST['above_allocation'];
        }else{
            $allocationid = '';
            $above_allocation ='';
        }
        
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
        $active = $wpdb->get_results($sql, ARRAY_A);
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        $fcrid       = $active[0]['fcrid'];
        
        //Soap api get UpdateBasketInfo
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
        
        //Allocation usage
        if(isset($allocationid) and $allocationid != ''){
            
            $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
            <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
              <soap:Header>
                <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
                  <DatabaseName>'.$db_name.'</DatabaseName>
                  <Username>'.$db_username.'</Username>
                  <Password>'.$db_password.'</Password>
                </AuthorizationHeader>
              </soap:Header>
              <soap:Body>
                <UpdateBasketInfo xmlns="https://secureclub.net/webservices/">
                  <UpdateBasketRequest>
                    <Operation>'.$operation.'</Operation>
                    <SessionId>'.$session_id.'</SessionId>
                    <FrameConfigId>'.$fcrid.'</FrameConfigId>
                    <GuestKey>'.$guest_id.'</GuestKey>
                    <InventoryId>'.$invid.'</InventoryId>
                    <Quantity>'.$qty.'</Quantity>
                    <AllocationId>'.$allocationid.'</AllocationId>
                    <AboveAllocationQuantity>'.$above_allocation.'</AboveAllocationQuantity>
                  </UpdateBasketRequest>     
                </UpdateBasketInfo>
              </soap:Body>
            </soap:Envelope>';
            
        }else{
                   
            $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
            <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
              <soap:Header>
                <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
                  <DatabaseName>'.$db_name.'</DatabaseName>
                  <Username>'.$db_username.'</Username>
                  <Password>'.$db_password.'</Password>
                </AuthorizationHeader>
              </soap:Header>
              <soap:Body>
                <UpdateBasketInfo xmlns="https://secureclub.net/webservices/">
                  <UpdateBasketRequest>
                    <Operation>'.$operation.'</Operation>
                    <SessionId>'.$session_id.'</SessionId>
                    <FrameConfigId>'.$fcrid.'</FrameConfigId>
                    <GuestKey>'.$guest_id.'</GuestKey>
                    <InventoryId>'.$invid.'</InventoryId>
                    <Quantity>'.$qty.'</Quantity>
                  </UpdateBasketRequest>     
                </UpdateBasketInfo>
              </soap:Body>
            </soap:Envelope>';
        }
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser);
        
        //Get total basket count from API.
        $basket_count = $parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->ResponseStatus->StatusRecordCount;
        $basket_status = $parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->ResponseStatus->StatusCode;
        $basket_status_desc = $parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->ResponseStatus->StatusDescription;
        $basket_subtotal = $parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->Subtotal;
        
        $basket_wishlist_count = $parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->WishListArraySize;
        //$basket_wishlist = $parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->WishListArray->WishListInventory;
        
        $total_qty = $output = '';
         
        if($basket_count > 0){
            
            foreach($parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->InventoryArray->BasketInventory as $Item){
                 //echo '<pre>'; print_r($Item);
                 //Allocation- Checking [AllocationId] is empty 
                 if($Item->AllocationId == '' ){
                    $allo_record = '0';
                 }else{
                    $allo_record = '1';
                 }
                 $output .='<div class="cart-section-info">
                	<form class="cd-customization" method="post">
                	    <input  type="hidden" class="abve-allocation-'.$Item->InventoryId.'" value="'.$Item->AboveAllocationQuantity.'" />
                		<input  type="hidden" id="allocation-'.$Item->InventoryId.'" value="'.$Item->AllocationId.'"/>
                		<input id="inventory-'.$Item->InventoryId.'" name="inventory" onchange="getQuantity(';
                        $output .= "'".$Item->InventoryId."', ".$Item->Quantity."";
                         $output .= ')" value="'.$Item->Quantity.'" type="number" min="1" max="99" maxlength="2" class="CatalogElementGridInputField normal inventory" tabindex="1">
                         <span class="cart-load small-loader-'.$Item->InventoryId.'" style="display: none;"><img src="'.plugins_url('activ8-commerce/front/img/load.gif').'" alt="Loading..." /></span>
                	</form>
                	<div class="cart-added-img">
                		<img src="'.$Item->ImageURL.$Item->ImageName.'" alt="Preview image">
                	</div> 
                	<div class="price-sect-cart">
                		<div class="cart-added-product-name">
                			<h4><a href="javascript:void(0)">'.$Item->Name.'</a></h4>
                			<a href="javascript:void(0)" class="cart-added-remove" id="cart-remove-'.$Item->InventoryId.'" data-operation="Remove" data-allocations="'.$allo_record.'" onclick="addUpdateCart(';
                             $output .= "'".$Item->InventoryId."', 'Remove', '', ''";
                                  $output .= ')" >Remove</a>';
                		$output .= '</div>
                		<div class="cart-added-product-price">$'.$Item->UnitPrice.'</div>
                		<div class="cart-added-total-price">$'.$Item->Price.'</div>
                	</div>													 
                   </div>';
            $total_qty += $Item->Quantity;
            }
        }
        
        //Wishlist
        $wishlist_output = '';
        
        if($basket_wishlist_count > 0){
            foreach($parser->UpdateBasketInfoResponse->UpdateBasketInfoResult->WishListArray->WishListInventory as $Item){ //echo '<pre>'; print_r($Item);
                $wishlist_output .='<div class="cart-section-info">
                    <form class="cd-customization list" method="post">
                	    <!--<input  type="hidden" class="abve-allocation-'.$Item->InventoryId.'" value="'.$Item->AboveAllocationQuantity.'" />
                		<input  type="hidden" id="allocation-'.$Item->InventoryId.'" value="'.$Item->AllocationId.'"/>
                		<input  type="hidden" id="wishid-'.$Item->InventoryId.'" value="'.$Item->Id.'"/>-->
                	</form>
                	<div class="cart-added-img">
                		<img src="'.$Item->ImageURL.$Item->ImageName.'" alt="Preview image">
                		<span class="cart-load wish-loader-'.$Item->Id.'" style="display: none;"><img src="'.plugins_url('activ8-commerce/front/img/load.gif').'" alt="Loading..." /></span>
                	</div> 
                	<div class="price-sect-cart">
                		<div class="cart-added-product-name">
                			<h4><a href="javascript:void(0)">'.$Item->Name.'</a></h4>
                			<a href="javascript:void(0)" class="cart-added-remove" id="cart-remove-'.$Item->InventoryId.'" data-operation="Remove" data-allocations="'.$allo_record.'" onclick="RemoveWishlistProduct(';
                             $wishlist_output .= "'".$Item->InventoryId."', '".$Item->AllocationId."', '".$Item->Id."'";
                                  $wishlist_output .= ')" >Remove</a>';
                		$wishlist_output .= '</div>
                		<div class="cart-added-product-price">'.$Item->Quantity.'</div>
                		<div class="cart-added-product-price">$'.$Item->UnitPrice.'</div>
                		<div class="cart-added-total-price">$'.$Item->Price.'</div>
                	</div>													 
                   </div>';
            }       
        }
        
        echo $output.'==='.$basket_count.'==='.$basket_subtotal.'==='.$total_qty.'==='.$basket_status.'==='.$basket_status_desc.'==='.$basket_wishlist_count.'==='.$wishlist_output;
    }
    exit();
}
add_action( 'wp_ajax_customize_basketupdate_info','customize_basketupdate_info');
add_action( 'wp_ajax_nopriv_customize_basketupdate_info','customize_basketupdate_info');


//Slide Cart header
function SlideCartList(){
    ob_start();
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
        
    //database
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
    $active = $wpdb->get_results($sql, ARRAY_A);
    
    $service_url = $active[0]['service_url'];
    $db_name     = $active[0]['db_name'];
    $db_username = $active[0]['db_username'];
    $db_password = $active[0]['db_password'];
    $fcrid       = $active[0]['fcrid'];
    
    //Soap api get BasketInfo
    //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
    $soapUrl = $service_url;
               
    $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
    <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Header>
        <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
          <DatabaseName>'.$db_name.'</DatabaseName>
          <Username>'.$db_username.'</Username>
          <Password>'.$db_password.'</Password>
        </AuthorizationHeader>
      </soap:Header>
      <soap:Body>
        <GetBasketInfo xmlns="https://secureclub.net/webservices/">
          <BasketQuery>
            <SessionId>'.$session_id.'</SessionId>
            <FrameConfigId>'.$fcrid.'</FrameConfigId>
            <GuestKey>'.$guest_id.'</GuestKey>
          </BasketQuery>
        </GetBasketInfo>
      </soap:Body>
    </soap:Envelope>';
    
    $headers = array(
    "POST /webservices/customerservice.asmx HTTP/1.1",
    //"Host: ".$service_host,
    "Content-Type: text/xml; charset=utf-8",
    "Content-Length: ".strlen($xml_post_string)
    ); 
    
    $url = $soapUrl;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    
    $response = curl_exec($ch); 
    curl_close($ch);
    
    $response1 = str_replace("<soap:Body>","",$response);
    $response2 = str_replace("</soap:Body>","",$response1);
    
    $parser = simplexml_load_string($response2);
    //echo '<pre>'; print_r($parser); 
    
    //Get total basket count from API.
    $basket_count = $parser->GetBasketInfoResponse->GetBasketInfoResult->ResponseStatus->StatusRecordCount;
    $basket_subtotal = $parser->GetBasketInfoResponse->GetBasketInfoResult->Subtotal;
    $basket_inventory_list  = $parser->GetBasketInfoResponse->GetBasketInfoResult->InventoryArray->BasketInventory;
    $basket_text            = $parser->GetBasketInfoResponse->GetBasketInfoResult->BasketText;
    $basket_login_status    = $parser->GetBasketInfoResponse->GetBasketInfoResult->IsLoggedIn;
    $basket_myaccount_url   = $parser->GetBasketInfoResponse->GetBasketInfoResult->SignInRedirectURL;
	
    $basket_total_count = 0;
	if (is_array($basket_inventory_list) || is_object($basket_inventory_list))
	{
		foreach($basket_inventory_list as $Item){
			$basket_total_count += $Item->Quantity;
		}
	}
    $basket_tot_qty = $basket_total_count;
    
    include('includes/active_slide_cart_list.php');
    return ob_get_clean(); 
}
add_shortcode('acs-cart', 'SlideCartList');


//Ajax getbasket info, when click on IFRAME "Update Shopping Cart" button.
function customize_getbasket_info(){
    //ob_start();
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
    
    if($_POST['result'] == 'getbasket'){
        
        //customer_id usef for login purpose.
        $customerid = $_POST['custid'];
        
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
        $active = $wpdb->get_results($sql, ARRAY_A);
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        $fcrid       = $active[0]['fcrid'];
        
        //Soap api get BasketInfo
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
        
        if(isset($customerid) and $customerid != ''){
            
            $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
            <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
              <soap:Header>
                <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
                  <DatabaseName>'.$db_name.'</DatabaseName>
                  <Username>'.$db_username.'</Username>
                  <Password>'.$db_password.'</Password>
                </AuthorizationHeader>
              </soap:Header>
              <soap:Body>
                <GetBasketInfo xmlns="https://secureclub.net/webservices/">
                  <BasketQuery>
                    <SessionId>'.$session_id.'</SessionId>
                    <FrameConfigId>'.$fcrid.'</FrameConfigId>
                    <GuestKey>'.$guest_id.'</GuestKey>
                    <CustomerId>'.$customerid.'</CustomerId>
                  </BasketQuery>
                </GetBasketInfo>
              </soap:Body>
            </soap:Envelope>';
        
        }else{
            
            $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
            <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
              <soap:Header>
                <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
                  <DatabaseName>'.$db_name.'</DatabaseName>
                  <Username>'.$db_username.'</Username>
                  <Password>'.$db_password.'</Password>
                </AuthorizationHeader>
              </soap:Header>
              <soap:Body>
                <GetBasketInfo xmlns="https://secureclub.net/webservices/">
                  <BasketQuery>
                    <SessionId>'.$session_id.'</SessionId>
                    <FrameConfigId>'.$fcrid.'</FrameConfigId>
                    <GuestKey>'.$guest_id.'</GuestKey>
                  </BasketQuery>
                </GetBasketInfo>
              </soap:Body>
            </soap:Envelope>';
        }
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser); 
        
        //Get total basket count from API.
        $basket_count = $parser->GetBasketInfoResponse->GetBasketInfoResult->ResponseStatus->StatusRecordCount;
        $basket_subtotal = $parser->GetBasketInfoResponse->GetBasketInfoResult->Subtotal;
        $basket_login_status    = $parser->GetBasketInfoResponse->GetBasketInfoResult->IsLoggedIn;
        $basket_myaccount_url   = $parser->GetBasketInfoResponse->GetBasketInfoResult->SignInRedirectURL;
        
        $basket_wishlist_count = $parser->GetBasketInfoResponse->GetBasketInfoResult->WishListArraySize;
        //$basket_wishlist = $parser->GetBasketInfoResponse->GetBasketInfoResult->WishListArray->WishListInventory;
        
        
        $total_qty = $output = '';
         
        if($basket_count > 0){                               
            foreach($parser->GetBasketInfoResponse->GetBasketInfoResult->InventoryArray->BasketInventory as $Item){ //echo '<pre>'; print_r($Item);
                 
                 //Allocation- Checking [AllocationId] is empty 
                 if($Item->AllocationId == '' ){
                    $allo_record = '0';
                 }else{
                    $allo_record = '1';
                 }
                 $output .='<div class="cart-section-info">
                	<form class="cd-customization" method="post">
                	    <input  type="hidden" class="abve-allocation-'.$Item->InventoryId.'" value="'.$Item->AboveAllocationQuantity.'" />
                		<input  type="hidden" id="allocation-'.$Item->InventoryId.'" value="'.$Item->AllocationId.'"/>
                		<input id="inventory-'.$Item->InventoryId.'" name="inventory" onchange="getQuantity(';
                        $output .= "'".$Item->InventoryId."', ".$Item->Quantity."";
                         $output .= ')" value="'.$Item->Quantity.'" type="number" min="1" max="99" maxlength="2" class="CatalogElementGridInputField normal inventory" tabindex="1">
                         <span class="cart-load small-loader-'.$Item->InventoryId.'" style="display: none;"><img src="'.plugins_url('activ8-commerce/front/img/load.gif').'" alt="Loading..." /></span>
                	</form>
                	<div class="cart-added-img">
                		<img src="'.$Item->ImageURL.$Item->ImageName.'" alt="Preview image">
                	</div> 
                	<div class="price-sect-cart">
                		<div class="cart-added-product-name">
                			<h4><a href="javascript:void(0)">'.$Item->Name.'</a></h4>
                			<a href="javascript:void(0)" class="cart-added-remove" id="cart-remove-'.$Item->InventoryId.'" data-operation="Remove" data-allocations="'.$allo_record.'" onclick="addUpdateCart(';
                             $output .= "'".$Item->InventoryId."', 'Remove', '', ''";
                                  $output .= ')" >Remove</a>';
                		$output .= '</div>
                		<div class="cart-added-product-price">$'.$Item->UnitPrice.'</div>
                		<div class="cart-added-total-price">$'.$Item->Price.'</div>
                	</div>													 
                   </div>';
            $total_qty += $Item->Quantity;
            }
        }
        
        //Wishlist
        $wishlist_output = '';
        
        if($basket_wishlist_count > 0){
            foreach($parser->GetBasketInfoResponse->GetBasketInfoResult->WishListArray->WishListInventory as $Item){ //echo '<pre>'; print_r($Item);
                $wishlist_output .='<div class="cart-section-info">
                    <form class="cd-customization list" method="post">
                	    <!--<input  type="hidden" class="abve-allocation-'.$Item->InventoryId.'" value="'.$Item->AboveAllocationQuantity.'" />
                		<input  type="hidden" id="allocation-'.$Item->InventoryId.'" value="'.$Item->AllocationId.'"/>
                		<input  type="hidden" id="wishid-'.$Item->InventoryId.'" value="'.$Item->Id.'"/>-->
                	</form>
                	<div class="cart-added-img">
                		<img src="'.$Item->ImageURL.$Item->ImageName.'" alt="Preview image">
                		<span class="cart-load wish-loader-'.$Item->Id.'" style="display: none;"><img src="'.plugins_url('activ8-commerce/front/img/load.gif').'" alt="Loading..." /></span>
                	</div> 
                	<div class="price-sect-cart">
                		<div class="cart-added-product-name">
                			<h4><a href="javascript:void(0)">'.$Item->Name.'</a></h4>
                			<a href="javascript:void(0)" class="cart-added-remove" id="cart-remove-'.$Item->InventoryId.'" data-operation="Remove" data-allocations="'.$allo_record.'" onclick="RemoveWishlistProduct(';
                             $wishlist_output .= "'".$Item->InventoryId."', '".$Item->AllocationId."', '".$Item->Id."'";
                                  $wishlist_output .= ')" >Remove</a>';
                		$wishlist_output .= '</div> 
                		<div class="cart-added-product-price">'.$Item->Quantity.'</div>
                		<div class="cart-added-product-price">$'.$Item->UnitPrice.'</div>
                		<div class="cart-added-total-price">$'.$Item->Price.'</div>
                	</div>													 
                   </div>';
            }       
        }
        
        echo $output.'==='.$basket_count.'==='.$basket_subtotal.'==='.$total_qty.'==='.$basket_login_status.'==='.$basket_myaccount_url.'==='.$basket_wishlist_count.'==='.$wishlist_output;
    }
    exit;
    //include_once('includes/active_slide_cart_list.php');
    //return ob_get_clean(); 
}
add_action( 'wp_ajax_customize_getbasket_info','customize_getbasket_info');
add_action( 'wp_ajax_nopriv_customize_getbasket_info','customize_getbasket_info');


//Ajax logout basket info, when click on sign-out button.
function customize_logout_basket_info(){
    //ob_start();
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
    
    if($_POST['result'] == 'logout'){    
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
        $active = $wpdb->get_results($sql, ARRAY_A);
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        $fcrid       = $active[0]['fcrid'];
        
        //Soap api get BasketInfo
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
                   
        $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
        <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
          <soap:Header>
            <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
              <DatabaseName>'.$db_name.'</DatabaseName>
              <Username>'.$db_username.'</Username>
              <Password>'.$db_password.'</Password>
            </AuthorizationHeader>
          </soap:Header>
          <soap:Body>
            <SignOutRequest xmlns="https://secureclub.net/webservices/">
              <BasketQuery>
                <SessionId>'.$session_id.'</SessionId>
                <FrameConfigId>'.$fcrid.'</FrameConfigId>
                <GuestKey>'.$guest_id.'</GuestKey>
              </BasketQuery>
            </SignOutRequest>
          </soap:Body>
        </soap:Envelope>';
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser); 
        
        //Get total basket count from API.
        $basket_count = $parser->SignOutRequestResponse->SignOutRequestResult->ResponseStatus->StatusRecordCount;
        $basket_subtotal = $parser->SignOutRequestResponse->SignOutRequestResult->Subtotal;
        $basket_login_status    = $parser->SignOutRequestResponse->SignOutRequestResult->IsLoggedIn;
        $basket_myaccount_url   = $parser->SignOutRequestResponse->SignOutRequestResult->SignInRedirectURL;
        
        $total_qty = 0;
        
        /*$total_qty = $output = '';
         
        if($basket_count > 0){                               
            foreach($parser->GetBasketInfoResponse->GetBasketInfoResult->InventoryArray->BasketInventory as $Item){
                 //echo '<pre>'; print_r($Item);
                 $output .='<div class="cart-section-info">
                	<form class="cd-customization" method="post">
                		<input id="inventory-'.$Item->InventoryId.'" name="inventory" onchange="getQuantity(';
                        $output .= "'".$Item->InventoryId."', ".$Item->Quantity."";
                         $output .= ')" value="'.$Item->Quantity.'" type="number" min="1" max="99" maxlength="2" class="CatalogElementGridInputField normal inventory" tabindex="1">
                         <span class="cart-load small-loader-'.$Item->InventoryId.'" style="display: none;"><img src="'.plugins_url('activ8-commerce/front/img/load.gif').'" alt="Loading..." /></span>
                	</form>
                	<div class="cart-added-img">
                		<img src="'.$Item->ImageURL.$Item->ImageName.'" alt="Preview image">
                	</div> 
                	<div class="price-sect-cart">
                		<div class="cart-added-product-name">
                			<a href="javascript:void(0)">'.$Item->Name.'</a>
                			<a href="javascript:void(0)" class="cart-added-remove" id="cart-remove-'.$Item->InventoryId.'" data-operation="Remove" data-allocations="0" onclick="addUpdateCart(';
                             $output .= "'".$Item->InventoryId."', 'Remove', '', ''";
                                  $output .= ')" >Remove</a>';
                		$output .= '</div>
                		<div class="cart-added-product-price">$'.$Item->UnitPrice.'</div>
                		<div class="cart-added-total-price">$'.$Item->Price.'</div>
                	</div>													 
                   </div>';
            $total_qty += $Item->Quantity;
            }
        }*/                                                                                                          
        echo $basket_count.'==='.$basket_subtotal.'==='.$total_qty.'==='.$basket_login_status.'==='.$basket_myaccount_url;
    }
    exit;
    //include_once('includes/active_slide_cart_list.php');
    //return ob_get_clean(); 
}
add_action( 'wp_ajax_customize_logout_basket_info','customize_logout_basket_info');
add_action( 'wp_ajax_nopriv_customize_logout_basket_info','customize_logout_basket_info');


/**************** Google Analytics starts ******************************************************/

function customize_remove_items(){
    //ob_start();
    global $wpdb;
    
    $id = $_POST['productid'];
    $name = $_POST['productname'];
    $price = $_POST['productprice'];
    $table_name = $wpdb->prefix . 'active8_removed_cart_data';
    $wpdb->insert($table_name, array(
    'productid' => $id,
    'productname' => $name,
    'productprice' => $price,
     'status' => '1',
));

}
add_action( 'wp_ajax_customize_remove_items','customize_remove_items');
add_action( 'wp_ajax_nopriv_customize_remove_items','customize_remove_items');

function checkout_process_cron(){
    //ob_start();
    global $wpdb;
    
    $id = $_POST['productid'];
    $name = $_POST['productname'];
    $price = $_POST['productprice'];
    $category = $_POST['productcategory'];
    $qty = $_POST['productqty'];
    $step = $_POST['step'];
    $table_name = $wpdb->prefix . 'active8_checkout_data';
    $wpdb->insert($table_name, array(
    'productid' => $id,
    'productname' => $name,
    'productprice' => $price,
    'productcategory' => $category,
    'productqty' => $qty,
    'step' => $step,
     'status' => '1',
));

}
add_action( 'wp_ajax_checkout_process_cron','checkout_process_cron');
add_action( 'wp_ajax_nopriv_checkout_process_cron','checkout_process_cron');

function purchase_items_cron(){
    //ob_start();
    global $wpdb;
    
    $id = $_POST['productid'];
    $name = $_POST['productname'];
    $price = $_POST['productprice'];
    $category = $_POST['productcategory'];
    $qty = $_POST['productqty'];
    $orderid = $_POST['orderid'];
    $total = $_POST['total'];
    $tax = $_POST['tax'];
    $ship = $_POST['ship'];
    $cpn = $_POST['cpn'];
    
    $table_name = $wpdb->prefix . 'active8_purchase_data';
    $wpdb->insert($table_name, array(
    'productid' => $id,
    'productname' => $name,
    'productprice' => $price,
    'productcategory' => $category,
    'productqty' => $qty,
    'orderid' => $orderid,
    'total' => $total,
    'tax' => $tax,
    'ship' => $ship,
    'cpn' => $cpn,
     'status' => '1',
));

}
add_action( 'wp_ajax_purchase_items_cron','purchase_items_cron');
add_action( 'wp_ajax_nopriv_purchase_items_cron','purchase_items_cron');

function remove_cron_cart_items() {
        ob_start();
        global $wpdb;
        
        $table_names = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_names." ORDER BY id ASC";
        $dbdetails = $wpdb->get_results($sql, ARRAY_A);
        
        $table_name = $wpdb->prefix . 'active8_removed_cart_data';
        $wpdb->delete($table_name, array( 'status' => '2' ) );

        $sql = "SELECT * FROM ".$table_name." where status='1' ORDER BY id ASC";
        $remove_items = $wpdb->get_results($sql);
        if(!empty($remove_items)) {
         include_once('includes/active_cron_remove_cart_items.php');
        }
        foreach ($remove_items as $details) {
            $ids = $details->id;
        $wpdb->query($wpdb->prepare("UPDATE $table_name SET status='2' WHERE id=$ids"));
        }
        //include_once('includes/active_checkout_process.php');
        return ob_get_clean();
}
add_shortcode('remove-cron-cart-items', 'remove_cron_cart_items');

function checkout_process_cron_items() {
        ob_start();
        global $wpdb;
        
        $table_names = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_names." ORDER BY id ASC";
        $dbdetails = $wpdb->get_results($sql, ARRAY_A);
        
        $table_name = $wpdb->prefix . 'active8_checkout_data';
        $wpdb->delete($table_name, array( 'status' => '2' ) );

        $sql = "SELECT * FROM ".$table_name." where status='1' ORDER BY id ASC";
        $checkout_items = $wpdb->get_results($sql);
       if(!empty($checkout_items)) {
        include_once('includes/active_checkout_cron.php');
       }
        foreach ($checkout_items as $details) {
            $ids = $details->id;
        $wpdb->query($wpdb->prepare("UPDATE $table_name SET status='2' WHERE id=$ids"));
        }
        return ob_get_clean();
}
add_shortcode('checkout-process-cron-items', 'checkout_process_cron_items');

function purchase_cron_items() {
        ob_start();
        global $wpdb;
        
        $table_names = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_names." ORDER BY id ASC";
        $dbdetails = $wpdb->get_results($sql, ARRAY_A);
        
        $table_name = $wpdb->prefix . 'active8_purchase_data';
        $wpdb->delete($table_name, array( 'status' => '2' ) );

        $sql = "SELECT * FROM ".$table_name." where status='1' ORDER BY id ASC";
        $purchase_items = $wpdb->get_results($sql);
       if(!empty($purchase_items)) {
        include_once('includes/active_checkout_process.php');
       }
        foreach ($purchase_items as $details) {
            $ids = $details->id;
        $wpdb->query($wpdb->prepare("UPDATE $table_name SET status='2' WHERE id=$ids"));
        }
        return ob_get_clean();
}
add_shortcode('purchase-cron-items', 'purchase_cron_items');

/*******************************End**********************************************************************/


//Ajax Slide Cart Detail into cart page
function call_cart_detaillist(){
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
    
    if($_POST['result'] == 'cartview'){
        
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
        $active = $wpdb->get_results($sql, ARRAY_A); 
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        $fcrid       = $active[0]['fcrid'];
        
        //Soap api get SetFrameStateToShowCart
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
                   
        $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
        <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
          <soap:Header>
            <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
              <DatabaseName>'.$db_name.'</DatabaseName>
              <Username>'.$db_username.'</Username>
              <Password>'.$db_password.'</Password>
            </AuthorizationHeader>
          </soap:Header>
          <soap:Body>
            <SetFrameStateToShowCart xmlns="https://secureclub.net/webservices/">
              <BasketQuery>
                <SessionId>'.$session_id.'</SessionId>
                <FrameConfigId>'.$fcrid.'</FrameConfigId>
                <GuestKey>'.$guest_id.'</GuestKey>
              </BasketQuery>
            </SetFrameStateToShowCart>
          </soap:Body>
        </soap:Envelope>';
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser); 
        
        $cart_view = $parser->SetFrameStateToShowCartResponse->SetFrameStateToShowCartResult->ResponseStatus->StatusRecordCount;
        echo $cart_view;
    }

    exit(); 
}
add_action( 'wp_ajax_call_cart_detaillist','call_cart_detaillist');
add_action( 'wp_ajax_nopriv_call_cart_detaillist','call_cart_detaillist');


//Ajax Slide Checkout Detail for the cart page.
function call_checkout_detaillist(){
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
    
    if($_POST['result'] == 'checkoutview'){
        
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
        $active = $wpdb->get_results($sql, ARRAY_A); 
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        $fcrid       = $active[0]['fcrid'];
        
        //Soap api get SetFrameStateToShowCheckout
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
                   
        $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
        <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
          <soap:Header>
            <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
              <DatabaseName>'.$db_name.'</DatabaseName>
              <Username>'.$db_username.'</Username>
              <Password>'.$db_password.'</Password>
            </AuthorizationHeader>
          </soap:Header>
          <soap:Body>
            <SetFrameStateToShowCheckout xmlns="https://secureclub.net/webservices/">
              <BasketQuery>
                <SessionId>'.$session_id.'</SessionId>
                <FrameConfigId>'.$fcrid.'</FrameConfigId>
                <GuestKey>'.$guest_id.'</GuestKey>
              </BasketQuery>
            </SetFrameStateToShowCheckout>
          </soap:Body>
        </soap:Envelope>';
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser); 
        
        $checkout_view = $parser->SetFrameStateToShowCheckoutResponse->SetFrameStateToShowCheckoutResult->ResponseStatus->StatusRecordCount;
        echo $checkout_view;
    }

    exit(); 
}
add_action( 'wp_ajax_call_checkout_detaillist','call_checkout_detaillist');
add_action( 'wp_ajax_nopriv_call_checkout_detaillist','call_checkout_detaillist');


//Ajax delete Wishlist product from slide cart.
function call_remove_wishlist_product(){
    global $wpdb;
    
    $guest_id = do_shortcode('[guestid]'); //guestid shortcode used from ACSSource.php
    $session_id = do_shortcode('[sessionid]'); //sessionid shortcode used from ACSSource.php
    
    if($_POST['result'] == 'removewishlist'){
        
        $wishid = $_POST['wishid'];
        $invid = $_POST['invid'];
        $allocation_id = $_POST['allocation_id'];
        
        //db
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * FROM ".$table_name." ORDER BY id ASC";
        $active = $wpdb->get_results($sql, ARRAY_A); 
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        $fcrid       = $active[0]['fcrid'];
        
        //Soap api get SetFrameStateToShowCheckout
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
                   
        $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
        <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
          <soap:Header>
            <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
              <DatabaseName>'.$db_name.'</DatabaseName>
              <Username>'.$db_username.'</Username>
              <Password>'.$db_password.'</Password>
            </AuthorizationHeader>
          </soap:Header>
          <soap:Body>
            <RemoveWish xmlns="https://secureclub.net/webservices/">
              <RemoveWishRequest>
                <SessionId>'.$session_id.'</SessionId>
                <FrameConfigId>'.$fcrid.'</FrameConfigId>
                <GuestKey>'.$guest_id.'</GuestKey>
                <AllocationId>'.$allocation_id.'</AllocationId>
                <Id>'.$wishid.'</Id>
                <InventoryId>'.$invid.'</InventoryId>
              </RemoveWishRequest>
            </RemoveWish>
          </soap:Body>
        </soap:Envelope>';
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser); 
        
        $wishlist_view = $parser->RemoveWishResponse->RemoveWishResult->ResponseStatus->StatusDescription;
        echo $wishlist_view;
    }

    exit(); 
}
add_action( 'wp_ajax_call_remove_wishlist_product','call_remove_wishlist_product');
add_action( 'wp_ajax_nopriv_call_remove_wishlist_product','call_remove_wishlist_product');