<?php
/*
Plugin Name: Activ8 Commerce
Description: Displaying product inventory list, product category list, cart list and more. Displaying cart icons by using the shortcodes [acs-cart].
Author: Activ8 Commerce
Version: 1.1.9
*/

//This action is used for clean url, changing from query string.
//$slug = get_post_field( 'post_name', $post_id );
add_action('init', function(){
    add_rewrite_rule( 
      '^product/([^/]+)([/]?)(.*)', 
      'index.php?pagename=product&slug=$matches[1]', 
      'top'
    );
    
    add_rewrite_rule( 
      '^product-category/([^/]+)([/]?)(.*)', 
      'index.php?pagename=product-category&id=$matches[1]',
      'top'
    );
    
    add_rewrite_rule( 
      '^acs-allocations/([^/]+)([/]?)(.*)', 
      'index.php?pagename=acs-allocations&customerid=$matches[1]',
      'top'
    );
});
    
add_filter('query_vars', function( $vars ){
    $vars[] = 'product'; 
    $vars[] = 'slug';
    $vars[] = 'product-category'; 
    $vars[] = 'id';
    $vars[] = 'acs-allocations'; 
    $vars[] = 'customerid';
    return $vars;
});

//Creating new custom page for shop, product details and product categories.
register_activation_hook( __FILE__, 'active8plugin_activate' );
function active8plugin_activate() {
    
    $shop_post = get_page_by_title('Activ8 Shop', OBJECT, 'page');
    $product_post = get_page_by_title('Activ8 Product Detail', OBJECT, 'page');
    $category_post = get_page_by_title('Activ8 Product Category', OBJECT, 'page');
    $cart_detail = get_page_by_title('Activ8 Cart', OBJECT, 'page');
    $cronjobs_update = get_page_by_title('Activ8 Cron Job Run', OBJECT, 'page');
    $allocation_update = get_page_by_title('Activ8 Allocations Detail', OBJECT, 'page');
    
    $spost = array(     
             'post_content'   => '[acs-shop]', 
             'post_title'     => 'Activ8 Shop', 
             'post_status'    => 'publish', 
             'post_type'      => 'page',
             'post_name'      => 'acs-shop'
    );
    
    $ppost = array(     
             'post_content'   => '[acs-product-details]', 
             'post_title'     => 'Activ8 Product Detail', 
             'post_status'    => 'publish', 
             'post_type'      => 'page',
             'post_name'      => 'product'
    );
    
    $cpost = array(     
             'post_content'   => '[acs-category-shop]', 
             'post_title'     => 'Activ8 Product Category', 
             'post_status'    => 'publish', 
             'post_type'      => 'page',
             'post_name'      => 'product-category'
    );
        
    $cartpost = array(     
             'post_content'   => '[ACSScript][ACSiFrame2][remove-cron-cart-items][checkout-process-cron-items][purchase-cron-items]', 
             'post_title'     => 'Activ8 Cart', 
             'post_status'    => 'publish', 
             'post_type'      => 'page',
             'post_name'      => 'acs-cart'
    );
    
    $cronpost = array(     
             'post_content'   => '[acs-cron-job-run-category-product]', 
             'post_title'     => 'Activ8 Cron Job Run',
             'post_status'    => 'publish', 
             'post_type'      => 'page',
             'post_name'      => 'cron-job-run'
    );
    
    $allocationpost = array(     
             'post_content'   => '[acs-allocation-details]', 
             'post_title'     => 'Activ8 Allocations Detail',
             'post_status'    => 'publish', 
             'post_type'      => 'page',
             'post_name'      => 'acs-allocations'
    );
    
    if((!(array)$shop_post) and (!(array)$product_post) and (!(array)$category_post) and (!(array)$cart_detail) and (!(array)$cronjobs_update) and (!(array)$allocation_update)){
        wp_insert_post( $spost ); // creates shop page
        wp_insert_post( $ppost ); // creates product details page
        wp_insert_post( $cpost ); // creates product category page
        wp_insert_post( $cartpost ); // creates cart page
        wp_insert_post( $cronpost ); //creates cron jobs update page
        wp_insert_post( $allocationpost ); //creates allocations page
    }
}

include_once('admin/activeclubsolutions_admin.php');
include_once('front/activeclubsolutions_main.php');
include_once('front/ACSSource.php');

//define( 'WP_MAX_MEMORY_LIMIT', '512M' );

//Adding Setting to plugin page.
function my_plugin_settings_link($links) { 
  $settings_link = '<a href="admin.php?page=acs_commerce">Settings</a>'; 
  array_push($links, $settings_link); 
  return $links; 
}
$plugin = plugin_basename(__FILE__); 
add_filter("plugin_action_links_$plugin", 'my_plugin_settings_link');


//Creating Database Tables
function activeclubsolutions_activation(){
	global $wpdb;   
    /*activeclubsolutions*/
    $table_name = $wpdb->prefix . "active8_settings";
	$sql = "DROP TABLE IF EXISTS ". $table_name ."; 
			CREATE TABLE IF NOT EXISTS ". $table_name ." (                
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `service_url` text NOT NULL,
                  `db_name` text NOT NULL,
                  `db_username` text NOT NULL,
                  `db_password` text NOT NULL,
                  `fcrid` varchar(30) NOT NULL,
                  `shop_menu_position` int(11) NOT NULL DEFAULT '2',
                  `category_id` int(11) NOT NULL DEFAULT '0',
                  `fcridclub` varchar(25) DEFAULT NULL,
                  `waitcursor` text,
                  `bottommargin` int(11) DEFAULT NULL,
                  `scrollpoint` int(11) NOT NULL DEFAULT '0',
                  `cursortopmargin` int(11) DEFAULT NULL,
                  `usesession` text,
                  `server` text,
                  `scenario` int(11) DEFAULT NULL,
                  `img_width` text,
                  `img_height` text,
                  `flying_animation` int(11) NOT NULL DEFAULT '1',
                  `sorting` int(11) NOT NULL DEFAULT '1',
                  `ga_api_key` text,
                `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				 UNIQUE KEY `id` (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
	";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql);
    
    
    //Creating category
    $table_name1 = $wpdb->prefix . "active8_category";
	$sql1 = "DROP TABLE IF EXISTS ". $table_name1 ."; 
			CREATE TABLE IF NOT EXISTS ". $table_name1 ." (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `fcrid` varchar(30) NOT NULL,
                `category_id` int(11) NOT NULL,
                `parent_id` int(11) NOT NULL,
                `category_name` text NOT NULL,
                `description` text DEFAULT NULL,
                `createupdate_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				 UNIQUE KEY `id` (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
	";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql1);
    
    
    //Creating Products.
    $table_name2 = $wpdb->prefix . "active8_shop";
	$sql2 = "DROP TABLE IF EXISTS ". $table_name2 ."; 
			CREATE TABLE IF NOT EXISTS ". $table_name2 ." (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fcrid` varchar(30) NOT NULL,
              `product_id` varchar(30) NOT NULL,
              `title` text NOT NULL,
              `slug` text,
              `description` text,
              `notes` text,
              `image_full` text,
              `image_thumb` text,
              `price` decimal(14,2) DEFAULT NULL,
              `stock` text,
              `sku_number` varchar(50) DEFAULT NULL,
              `stock_id` varchar(30) DEFAULT NULL,
              `on_hand` int(11) DEFAULT NULL,
              `allocated` int(11) DEFAULT NULL,
              `on_order` int(11) DEFAULT NULL,
              `available` int(11) DEFAULT NULL,
              `attribute1` varchar(30) DEFAULT NULL,
              `attribute2` varchar(30) DEFAULT NULL,
              `attribute3` varchar(30) DEFAULT NULL,
              `attribute4` varchar(30) DEFAULT NULL,
              `attribute5` varchar(30) DEFAULT NULL,
              `attribute6` varchar(30) DEFAULT NULL,
              `attribute7` varchar(30) DEFAULT NULL,
              `attribute8` varchar(30) DEFAULT NULL,
              `attribute9` varchar(30) DEFAULT NULL,
              `attribute10` varchar(30) DEFAULT NULL,
              `type` text,
              `sub_type` text,
              `taxable` text,
              `number_packaging` text,
              `is_alcohol` text,
              `no_of_bottles` int(11) DEFAULT NULL,
              `volume_of_alcohol` decimal(14,2) DEFAULT NULL,
              `alcohol_packaging` text,
              `liters_of_alcohol` decimal(14,2) DEFAULT NULL,
              `brand` text,
              `catalog_club_price` decimal(14,2) DEFAULT NULL,
              `catalog_text_line` text,
              `catalog_club_discount_text` text,
              `cogs_price` decimal(14,2) DEFAULT NULL,
              `weight` varchar(30) DEFAULT NULL,
              `wholesale_price` decimal(14,2) DEFAULT NULL,
              `vintage` int(11) DEFAULT NULL,
              `wine_type` text,
              `varietal` text,
              `harvest_date` varchar(30) DEFAULT NULL,
              `clonal_selection` text,
              `cases_produced` text,
              `appellation` text,
              `award1honor` text,
              `award1desc` text,
              `award2honor` text,
              `award2desc` text,
              `award3honor` text,
              `award3desc` text,
              `award4honor` text,
              `award4desc` text,
              `award5honor` text,
              `award5desc` text,
              `award6honor` text,
              `award6desc` text,
              `award7honor` text,
              `award7desc` text,
              `varietal1comppercent` int(11) DEFAULT NULL,
              `varietal1compdesc` text,
              `varietal2comppercent` int(11) DEFAULT NULL,
              `varietal2compdesc` text,
              `varietal3comppercent` int(11) DEFAULT NULL,
              `varietal3compdesc` text,
              `varietal4comppercent` int(11) DEFAULT NULL,
              `varietal4compdesc` text,
              `varietal5comppercent` int(11) DEFAULT NULL,
              `varietal5compdesc` text,
              `varietal6comppercent` int(11) DEFAULT NULL,
              `varietal6compdesc` text,
              `varietal7comppercent` int(11) DEFAULT NULL,
              `varietal7compdesc` text,
              `varietal8comppercent` int(11) DEFAULT NULL,
              `varietal8compdesc` text,
              `varietal9comppercent` int(11) DEFAULT NULL,
              `varietal9compdesc` text,
              `category_1` int(11) DEFAULT NULL,
              `category_name_1` text,
              `category_2` int(11) DEFAULT NULL,
              `category_name_2` text,
              `category_3` int(11) DEFAULT NULL,
              `category_name_3` text,
              `category_4` int(11) DEFAULT NULL,
              `category_name_4` text,
              `category_5` int(11) DEFAULT NULL,
              `category_name_5` text,
              `total_sales` decimal(14,2) DEFAULT NULL,
              `allocation_id` varchar(30) DEFAULT NULL,
              `allocation_msg` text,
              `allocation_price` decimal(14,2) DEFAULT NULL,
              `allocation_min` int(11) DEFAULT NULL,
              `allocation_max` int(11) DEFAULT NULL,
              `allocation_purchased` int(11) DEFAULT NULL,
              `allocation_above` int(11) DEFAULT NULL,
              `membership_status` text,
              `createupdate_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		       UNIQUE KEY `id` (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
	";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql2);
    
    
    //Reomved cart items cron job run
	$table_name3 = $wpdb->prefix . "active8_removed_cart_data";
	$sql3 = "DROP TABLE IF EXISTS ". $table_name3 ."; 
			CREATE TABLE IF NOT EXISTS ". $table_name3 ." (
                `id` int(10) NOT NULL,
                `productid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productprice` int(10) NOT NULL,
                `status` int(10) NOT NULL,
                `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				 UNIQUE KEY `id` (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
	";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql3);
	
	
	//Checkout process cron job run
	$table_name4 = $wpdb->prefix . "active8_checkout_data";
	$sql4 = "DROP TABLE IF EXISTS ". $table_name4 ."; 
			CREATE TABLE IF NOT EXISTS ". $table_name4 ." (
                `id` int(10) NOT NULL,
                `productid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productprice` int(10) NOT NULL,
                `productcategory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productqty` int(10) NOT NULL,
                `step` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `status` int(10) NOT NULL,
                `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				 UNIQUE KEY `id` (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
	";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql4);
	
	
	//Purchase items cron job run
	$table_name5 = $wpdb->prefix . "active8_purchase_data";
	$sql5 = "DROP TABLE IF EXISTS ". $table_name5 ."; 
			CREATE TABLE IF NOT EXISTS ". $table_name5 ." (
                `id` int(10) NOT NULL,
                `productid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productprice` int(10) NOT NULL,
                `productcategory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `productqty` int(10) NOT NULL,
                `orderid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `total` int(10) NOT NULL,
                `tax` int(10) NOT NULL,
                `ship` int(10) NOT NULL,
                `cpn` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                `status` int(10) NOT NULL,
                `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				 UNIQUE KEY `id` (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
	";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql5); 
    
}
register_activation_hook( __FILE__, 'activeclubsolutions_activation' );