<?php
add_action('admin_menu', 'activeclubsolutions_menu');
function activeclubsolutions_menu() {
    $allowed_group = 'manage_options';
    add_menu_page(__('Activ8 Commerce','activeclubsolutions'), __('Activ8 Commerce','activeclubsolutions'), $allowed_group, 'acs_commerce', 'customize_activeclubsolutions_structure', plugins_url('activ8-commerce/admin/images/cart.png'));
    add_submenu_page("acs_commerce", "Settings", "Settings", $allowed_group, 'acs_commerce', "customize_activeclubsolutions_structure");
    //add_submenu_page("acs_commerce", "Category", "Category", $allowed_group, "acs_category", 'customize_category');
    add_submenu_page("acs_commerce", "Help", "Help", $allowed_group, "acs_help", 'customize_help');        
}
function activeclubsolutions_admin_scripts_styles($hook){
    if(($hook != 'toplevel_page_acs_commerce') and ($hook != 'activ8-commerce_page_acs_help')) { 
        return;
    }
    wp_register_style('activeclubsolutions_admin_style', plugins_url('css/website.css', __FILE__));
    wp_enqueue_style( 'activeclubsolutions_admin_style');
    wp_register_style('activeclubsolutions_admin_style1', plugins_url('bootstrap/bootstrap.min.css', __FILE__));
    wp_enqueue_style( 'activeclubsolutions_admin_style1');
    wp_register_style('activeclubsolutions_admin_style2', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/css/bootstrap-select.min.css');
    wp_enqueue_style( 'activeclubsolutions_admin_style2');
    wp_register_style('activeclubsolutions_admin_style3', 'https://netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css');
    wp_enqueue_style( 'activeclubsolutions_admin_style3');
    wp_register_script('activeclubsolutions_admin_script', plugins_url('bootstrap/bootstrap.min.js', __FILE__));
    wp_enqueue_script( 'activeclubsolutions_admin_script' );
    wp_register_script('activeclubsolutions_admin_script0', 'https://code.jquery.com/jquery-3.1.1.min.js');
    wp_enqueue_script( 'activeclubsolutions_admin_script0');
    wp_register_script('activeclubsolutions_admin_script1', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js');
    wp_enqueue_script( 'activeclubsolutions_admin_script1');
    wp_register_script('activeclubsolutions_admin_script2', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/js/bootstrap-select.min.js');
    wp_enqueue_script( 'activeclubsolutions_admin_script2');
    wp_register_script('activeclubsolutions_admin_script3', plugins_url('js/admin_custom.js', __FILE__));
    wp_enqueue_script( 'activeclubsolutions_admin_script3');
}
add_action('admin_enqueue_scripts','activeclubsolutions_admin_scripts_styles');


/*function acs_dashboard(){
  include_once('includes/acs_dashboard.php');
}*/

//Form Function start here
function customize_activeclubsolutions_structure(){

    global $wpdb;
	$table_name    = $wpdb->prefix . "active8_settings";
    $service_url   = trim($_POST['service_url']);
    $db_name       = trim($_POST['db_name']);
    $db_username   = trim($_POST['db_username']);
    $db_password   = trim($_POST['db_password']);
    $fcrid         = trim($_POST['fcrid']);
    $shop_menu_pos = trim($_POST['shop_menu_position']);
    $category_id   = trim($_POST['category_id']);
    $fcridclub     = trim($_POST['fcridclub']);
    $waitcursor    = trim($_POST['waitcursor']);
    $bottommargin  = trim($_POST['bottommargin']);
    $scrollpoint   = trim($_POST['scrollpoint']);
    $cursortopmargin  = trim($_POST['cursortopmargin']);
    $usesession    = 'yes'; //trim($_POST['usesession']);
    $server        = trim($_POST['server']);
    $scenario      = '9'; //trim($_POST['scenario']);
    $img_width     = trim($_POST['img_width']);
    $img_height    = trim($_POST['img_height']);
    $flying_animation    = trim($_POST['flying_animation']);
    $sorting       = trim($_POST['sorting']);
    $ga_api_key    = trim($_POST['ga_api_key']);
        
    //Database
    if((isset($_POST['save_active_details']))){	
		if(!empty($_POST['active_id'])){
                $id = $_POST['active_id'];
                $wpdb->update( $table_name, array( 
                    'service_url' => $service_url,
                    'db_name'     => $db_name,
                    'db_username' => $db_username,
                    'db_password' => $db_password,
                    'fcrid'       => $fcrid,
                ), 
                array( 'id' => $id )
                );                
                $result_message = "Successfully Updated";
                
		}elseif( $_POST['save_active_details'] == "Save" ){
		    if($db_name != "" ){
		        $wpdb->insert($table_name, array(
                    'service_url' => $service_url,
                    'db_name'     => $db_name,
                    'db_username' => $db_username,
                    'db_password' => $db_password,
                    'fcrid'       => $fcrid,                                                                                                   
                ) );		      		      
    			$result_message = "Successfully Added";
            }
		}
		$wpdb->query($sql); 
	}
    
    //Category
    if((isset($_POST['save_category_details'])) and ($_POST['save_category_details'] == 'Update')){	
		if(!empty($_POST['active_id'])){
                $id = $_POST['active_id'];
                $wpdb->update( $table_name, array(                                                             
                    'shop_menu_position' => $shop_menu_pos,
                    'category_id'        => $category_id,
                    'fcridclub'          => $fcridclub,
                    'waitcursor'         => $waitcursor,
                    'bottommargin'       => $bottommargin,
                    'scrollpoint'        => $scrollpoint,
                    'cursortopmargin'    => $cursortopmargin,
                    'usesession'         => $usesession,
                    'server'             => $server,
                    'scenario'           => $scenario,
                    'img_width'          => $img_width,
                    'img_height'         => $img_height,
                    'flying_animation'   => $flying_animation,
                    'sorting'            => $sorting,
                    'ga_api_key'         => $ga_api_key
                ), 
                array( 'id' => $id )
                );                
                $result_message = "Successfully Updated";
		}
		$wpdb->query($sql); 
	}         
    
    //List Active
    $table_name = $wpdb->prefix . 'active8_settings';
    $sql = "SELECT * from $table_name ORDER BY id ASC";
    $active = $wpdb->get_results($sql, ARRAY_A); 
    
    //List all category
    $table_name = $wpdb->prefix . 'active8_category';
    $sql = "SELECT * from $table_name ORDER BY id ASC";
    $category_list = $wpdb->get_results($sql, ARRAY_A); 
    $allcategory_count = $wpdb->num_rows;
    
    //List all product
    $table_name = $wpdb->prefix . 'active8_shop';
    $sql = "SELECT * from $table_name ORDER BY id ASC";
    $prouct_list = $wpdb->get_results($sql, ARRAY_A);
    $allproduct_count = $wpdb->num_rows;    
    
    include_once('includes/customize_activeclubsolutions_structure.php');
}

//Cronjob setup shortcode for every hour in cpanel.
add_shortcode('acs-cron-job-run-category-product', 'customize_category_product');

function customize_category_product(){
    global $wpdb;

    //if($_POST['result'] == 'refresh'){
    
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
        $active = $wpdb->get_results($sql, ARRAY_A);
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        
        //Soap api get categories
        
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
                   
        $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
        <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
          <soap:Header>
            <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
              <DatabaseName>'.$db_name.'</DatabaseName>
              <Username>'.$db_username.'</Username>
              <Password>'.$db_password.'</Password>
            </AuthorizationHeader>
          </soap:Header>
          <soap:Body>
            <GetCategories xmlns="https://secureclub.net/webservices/" />
          </soap:Body>
        </soap:Envelope>';
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser);
        
        //Get total caetgory count from API.
        $category_count = $parser->GetCategoriesResponse->GetCategoriesResult->ResponseStatus->StatusRecordCount;
        $subcategory_count = 0;
        foreach($parser->GetCategoriesResponse->GetCategoriesResult->Categories->ParentInventoryCategory as $Item){
            $subcategory_count += $Item->SubcategoriesSize;
        }
        $total_category = $subcategory_count + $category_count;
        
        //Category Table name.
        $table_name_1 = $wpdb->prefix . 'active8_category';
        
        if($total_category > 0){
            
            //Deleting all records (TRUNCATE)
            $wpdb->query("TRUNCATE TABLE ".$table_name_1."");
            
            foreach($parser->GetCategoriesResponse->GetCategoriesResult->Categories->ParentInventoryCategory as $Item){//echo '<pre>'; print_r($Item);
                $cid = (int)$Item->Id;
                
                $wpdb->insert($table_name_1, array(
                    'fcrid'         => $active[0]['fcrid'],
                    'category_id'   => $cid,
                    'parent_id'     => '0',
                    'category_name' => trim($Item->Category), 
                    'description'   => trim($Item->Description)
                ));
                //echo $wpdb->last_query;
                
                //subcategory
                foreach($Item->Subcategories->InventoryCategory as $subItem){
                    $scid = (int)$subItem->Id;
                    
                    $wpdb->insert( $table_name_1, array(
                        'fcrid'         => $active[0]['fcrid'], 
                        'category_id'   => $scid,
                        'parent_id'     => $cid,
                        'category_name' => trim($subItem->Category),
                        'description'   => trim($subItem->Description)
                    ));
                    //echo $wpdb->last_query;
                }	                                        	      		                                                                                
            }
                        
            //All Category Lists from table.
            $sql = "SELECT * FROM ".$table_name_1." WHERE fcrid = '".$active[0]['fcrid']."'";
            $all_records = $wpdb->get_results($sql, ARRAY_A);
            $allcategory_count = $wpdb->num_rows;
            
            if($allcategory_count == $total_category){
                $total_cat = $total_category;
            }
        }
        
        //Proudct count function
        $total_product = customize_products();                                        
        
        //Populating dropdown options under category using ajax.
        $cat ='';
        if($allcategory_count > 0){
                $cat .= "<option value='0'>All Products</option>";
            foreach($all_records as $category){
                $cat .= "<option value='".$category['category_id']."'";
                      if($category['category_id'] == $_POST['cid']): $cat .="selected='selected'"; endif;
                $cat .= ">".$category['category_name']."</option>";
            }
        }                
        
        echo $total_cat.'==='.$total_product.'==='.$cat;
    //}
    exit();

}
add_action( 'wp_ajax_customize_category_product','customize_category_product');
add_action( 'wp_ajax_nopriv_customize_category_product','customize_category_product');


//Product API
function customize_products(){
    global $wpdb;
    
    //if($refresh == 'refresh'){
    
        //database
        $table_name = $wpdb->prefix . 'active8_settings';
        $sql = "SELECT * from $table_name ORDER BY TRIM(id) ASC";
        $active = $wpdb->get_results($sql, ARRAY_A);
        
        $service_url = $active[0]['service_url'];
        $db_name     = $active[0]['db_name'];
        $db_username = $active[0]['db_username'];
        $db_password = $active[0]['db_password'];
        
        //Soap api get products
        
        //$soapUrl = "http://www.secureclubtest.net/webservices/customerservice.asmx";
        $soapUrl = $service_url;
                   
        $xml_post_string = '<?xml version="1.0" encoding="utf-8"?>
        <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
          <soap:Header>
            <AuthorizationHeader xmlns="https://secureclub.net/webservices/">
              <DatabaseName>'.$db_name.'</DatabaseName>
              <Username>'.$db_username.'</Username>
              <Password>'.$db_password.'</Password>
            </AuthorizationHeader>
          </soap:Header>
          <soap:Body>
            <GetAllProducts xmlns="https://secureclub.net/webservices/">
              <FrameConfigId>'.$active[0]['fcrid'].'</FrameConfigId>
            </GetAllProducts>
          </soap:Body>
        </soap:Envelope>';
        
        $headers = array(
        "POST /webservices/customerservice.asmx HTTP/1.1",
        //"Host: ".$service_host,
        "Content-Type: text/xml; charset=utf-8",
        "Content-Length: ".strlen($xml_post_string)
        ); 
        
        $url = $soapUrl;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($ch); 
        curl_close($ch);
        
        $response1 = str_replace("<soap:Body>","",$response);
        $response2 = str_replace("</soap:Body>","",$response1);
        
        $parser = simplexml_load_string($response2);
        //echo '<pre>'; print_r($parser);
        
        //Get total product count from API.
        $total_product = $parser->GetAllProductsResponse->GetAllProductsResult->ResponseStatus->StatusRecordCount;
        
        //Product table name.
        $table_name_1 = $wpdb->prefix . 'active8_shop';
        
        if($total_product > 0){
            
            //Deleting all records (TRUNCATE)
            $wpdb->query("TRUNCATE TABLE ".$table_name_1."");
            
            foreach($parser->GetAllProductsResponse->GetAllProductsResult->InventoryItems->InventoryDetail as $Item){
                //echo '<pre>'; print_r($Item);
                
                if($Item->ImageName != ''){
                    $image_full = $Item->ImageURL.$Item->ImageName;
                }else{
                    $image_full = plugin_dir_url( __DIR__ ).'admin/images/image-not-found.png';
                }
                
                $image_thumb = $Item->ImageURL.$Item->ThumbImageName;
                
		        $wpdb->insert($table_name_1, array(
                    'fcrid'                       => trim($active[0]['fcrid']),
                    'product_id'                  => trim($Item->InventoryId),
                    'title'                       => trim($Item->Name),
                    'slug'                        => trim($Item->KeywordSlug),
                    'description'                 => trim($Item->Description),
                    'notes'                       => trim($Item->Notes),
                    'image_full'                  => $image_full,
                    'image_thumb'                 => $image_thumb,
                    'price'                       => trim($Item->Price),
                    'stock'                       => trim($Item->StockDisplay),
                    'sku_number'                  => trim($Item->SkuNumber),
                    'stock_id'                    => trim($Item->StockId),
                    'on_hand'                     => trim($Item->Onhand),
                    'allocated'                   => trim($Item->Allocated),
                    'on_order'                    => trim($Item->Onorder),
                    'available'                   => trim($Item->Available),
                    'attribute1'                  => trim($Item->Attribute1),
                    'attribute2'                  => trim($Item->Attribute2),
                    'attribute3'                  => trim($Item->Attribute3),
                    'attribute4'                  => trim($Item->Attribute4),
                    'attribute5'                  => trim($Item->Attribute5),
                    'attribute6'                  => trim($Item->Attribute6),
                    'attribute7'                  => trim($Item->Attribute7),
                    'attribute8'                  => trim($Item->Attribute8),
                    'attribute9'                  => trim($Item->Attribute9),
                    'attribute10'                 => trim($Item->Attribute10),
                    'type'                        => trim($Item->Type),
                    'sub_type'                    => trim($Item->Subtype),
                    'taxable'                     => trim($Item->Taxable),
                    'number_packaging'            => trim($Item->NumOfPackages),
                    'is_alcohol'                  => trim($Item->IsAlcohol),
                    'no_of_bottles'               => trim($Item->NoOfBottles),
                    'volume_of_alcohol'           => trim($Item->VolumeOfAlcohol),
                    'alcohol_packaging'           => trim($Item->AlcoholPackaging),
                    'liters_of_alcohol'           => trim($Item->LitersOfAlcohol),
                    'brand'                       => trim($Item->Brand),
                    'catalog_club_price'          => trim($Item->CatalogClubPrice),
                    'catalog_text_line'           => trim($Item->CatalogTextLine),
                    'catalog_club_discount_text'  => trim($Item->CatalogClubDiscountText),
                    'cogs_price'                  => trim($Item->CogsPrice),
                    'weight'                      => trim($Item->Weight),
                    'wholesale_price'             => trim($Item->WholesalePrice),
                    'vintage'                     => trim($Item->Vintage),
                    'wine_type'                   => trim($Item->WineType),
                    'varietal'                    => trim($Item->Varietal),
                    'harvest_date'                => trim($Item->HarvestDate),
                    'clonal_selection'            => trim($Item->ClonalSelection),
                    'cases_produced'              => trim($Item->CasesProduced),
                    'appellation'                 => trim($Item->Appellation),
                    'award1honor'                 => trim($Item->Award1Honor),
                    'award1desc'                  => trim($Item->Award1Desc),
                    'award2honor'                 => trim($Item->Award2Honor),
                    'award2desc'                  => trim($Item->Award2Desc),
                    'award3honor'                 => trim($Item->Award3Honor),
                    'award3desc'                  => trim($Item->Award3Desc),
                    'award4honor'                 => trim($Item->Award4Honor),
                    'award4desc'                  => trim($Item->Award4Desc),
                    'award5honor'                 => trim($Item->Award5Honor),
                    'award5desc'                  => trim($Item->Award5Desc),
                    'award6honor'                 => trim($Item->Award6Honor),
                    'award6desc'                  => trim($Item->Award6Desc),
                    'award7honor'                 => trim($Item->Award7Honor),
                    'award7desc'                  => trim($Item->Award7Desc),
                    'varietal1comppercent'        => trim($Item->Varietal1CompPercent),
                    'varietal1compdesc'           => trim($Item->Varietal1CompDesc),
                    'varietal2comppercent'        => trim($Item->Varietal2CompPercent),
                    'varietal2compdesc'           => trim($Item->Varietal2CompDesc),
                    'varietal3comppercent'        => trim($Item->Varietal3CompPercent),
                    'varietal3compdesc'           => trim($Item->Varietal3CompDesc),
                    'varietal4comppercent'        => trim($Item->Varietal4CompPercent),
                    'varietal4compdesc'           => trim($Item->Varietal4CompDesc),
                    'varietal5comppercent'        => trim($Item->Varietal5CompPercent),
                    'varietal5compdesc'           => trim($Item->Varietal5CompDesc),
                    'varietal6comppercent'        => trim($Item->Varietal6CompPercent),
                    'varietal6compdesc'           => trim($Item->Varietal6CompDesc),
                    'varietal7comppercent'        => trim($Item->Varietal7CompPercent),
                    'varietal7compdesc'           => trim($Item->Varietal7CompDesc),
                    'varietal8comppercent'        => trim($Item->Varietal8CompPercent),
                    'varietal8compdesc'           => trim($Item->Varietal8CompDesc),
                    'varietal9comppercent'        => trim($Item->Varietal9CompPercent),
                    'varietal9compdesc'           => trim($Item->Varietal9CompDesc),
                    'category_1'                  => trim($Item->CategoryId1),
                    'category_name_1'             => trim($Item->CategoryName1),
                    'category_2'                  => trim($Item->CategoryId2),
                    'category_name_2'             => trim($Item->CategoryName2),
                    'category_3'                  => trim($Item->CategoryId3),
                    'category_name_3'             => trim($Item->CategoryName3),
                    'category_4'                  => trim($Item->CategoryId4),
                    'category_name_4'             => trim($Item->CategoryName4),
                    'category_5'                  => trim($Item->CategoryId5),
                    'category_name_5'             => trim($Item->CategoryName5),
                    'total_sales'                 => trim($Item->TotalSales),
                    'allocation_id'               => trim($Item->AllocationId),
                    'allocation_msg'              => trim($Item->AllocationCartMessage),
                    'allocation_price'            => trim($Item->AllocationPrice),
                    'allocation_min'              => trim($Item->AllocationMinimum),
                    'allocation_max'              => trim($Item->AllocationMaximum),
                    'allocation_purchased'        => trim($Item->AllocationPurchased),
                    'allocation_above'            => trim($Item->AboveAllocationQuantity),
                    'membership_status'           => trim($Item->MemberOnly),
                ));
                //echo $wpdb->last_query;                                                                        	      		                                                                                
            }
            
            //Get total number of record inserted
            $sql = "SELECT * FROM ".$table_name_1." WHERE fcrid = '".$active[0]['fcrid']."'";
            $wpdb->get_results($sql, ARRAY_A);
            $allproduct_count = $wpdb->num_rows;
            
            if($allproduct_count == $total_product){
                return $total_product;
            }
        }         
    //}
    exit();
}
add_action( 'wp_ajax_customize_products','customize_products');
add_action( 'wp_ajax_nopriv_customize_products','customize_products');

//Help
function customize_help(){
    include_once('includes/help.php');
}


//Adding custom menu metabox 
function custom_add_menu_meta_box( $object ) {
	add_meta_box( 'custom-menu-metabox', __( 'Activ8 Commerce Categories' ), 'custom_menu_meta_box', 'nav-menus', 'side', 'default' );
	return $object;
}
add_filter( 'nav_menu_meta_box_object', 'custom_add_menu_meta_box', 10, 1);

function custom_menu_meta_box(){
	global $nav_menu_selected_id, $wpdb;
	$walker = new Walker_Nav_Menu_Checklist();
    
    $table_name1 = $wpdb->prefix . 'active8_category';
    $sql = "SELECT * FROM ".$table_name1." ORDER BY id ASC";
    $parent_category_list = $wpdb->get_results($sql);
    
    //echo '<pre>'; print_r($parent_category_list);                            
    
    /* set values to required item properties */
    foreach ( $parent_category_list as &$author ) {
        //echo '<pre>'; print_r($author);
    	$author->classes = array();
    	$author->type = 'custom';
    	$author->object_id = $author->id;
    	$author->title = $author->category_name;
    	$author->object = 'custom';
    	$author->url = get_bloginfo('url').'/product-category/'.( $author->category_id ); 
    	$author->attr_title = $author->category_name;
    	//if( $author->has_cap( 'edit_users' ) ){
    		//$admins[] = $author;
    	//}
    }                       
    //$removed_args = array( 'action', 'customlink-tab', 'edit-menu-item', 'menu-item', 'page-tab', '_wpnonce' );
     
    include_once('includes/custom-menu.php');
}