// JavaScript Document
jQuery(function($) { // start jquery
    
/**************** move screen reader button to top of page *****************/
if($('#wp-ada-compliance-accessibility-widget-showtools-screenreader').length !== 0){  
if($("body a:contains('Skip'):first").length !== 0){          
$("body a:contains('Skip'):first").after($('#wp-ada-compliance-accessibility-widget-showtools-screenreader').detach());  
} 
else if($("a[class*=skip]").length !== 0){          
$('a[class*=skip]').after($('#wp-ada-compliance-accessibility-widget-showtools-screenreader').detach());  
}           
}
/***********************************************************************
overall widget funtions i.e.. show/hide etc
***********************************************************************/
var adadialogstateVal = false;

// correct toolbar size issue in mac opera  
if (navigator.userAgent.indexOf('Mac OS X') != -1 && navigator.userAgent.indexOf("OPR") != -1) {
  $(".wp-ada-compliance-accessibility-widget-toolbar").css("height","65px");
}   

// hide widget based on cookie value
if(wp_ada_compliance_getCookie('wp-ada-hide-accessibility-widget')==='1'){
$('.wp-ada-compliance-accessibility-widget-hide').text(wpadaVariables.show); 
   $('.wp-ada-compliance-accessibility-widget-hide').data('state', 'show'); 
if(wpadaVariables.option === 'bottom' || wpadaVariables.option === 'top'){    
$('.wp-ada-compliance-accessibility-widget').css('right','-50px'); 
}else  if(wpadaVariables.option === 'left'){
    $('.wp-ada-compliance-accessibility-widget').css('left','-50px'); 
}
}	
// show accessibility options on Ctr-M
$(document).keydown(function(e) {
if (e.keyCode === 77 && e.ctrlKey) {
wp_ada_complianceOpenCloseWidget(0);
} 
});  
	
// show accessibility tools on Ctr-Q
$(document).keydown(function(e) {
if (e.keyCode === 81 && e.ctrlKey) {
wp_ada_complianceOpenCloseWidgetTools(0);
} 
});  	

// show widget 
$(document).on("click", '.wp-ada-compliance-accessibility-widget-button', function(event) {
wp_ada_complianceOpenCloseWidget(0);
return false;
});

// close widget if clicked outside
$(document).click(function() {
    if ($('.wp-ada-compliance-accessibility-widget-content:hover').length == 0) {
$('.wp-ada-compliance-accessibility-widget-content').hide();
$('.wp-ada-compliance-accessibility-widget-content').data("hidden",true);
    
   }
}); 
	
	// close widget if close button clicked
$(document).on("click", '.wp-ada-compliance-accessibility-widget-close', function() {
wp_ada_complianceOpenCloseWidget(0);
    return false;
});	
    	
    
// close widget on esc
$(document).keydown(function(e) {
if (e.keyCode === 27) {
wp_ada_complianceOpenCloseWidget(1);
}
    
// trap keyboard inside toolbar
if (e.shiftKey && e.keyCode === 9 && $('.wp-ada-compliance-accessibility-widget-content').find('a:first').is(":focus")) {
$('.wp-ada-compliance-accessibility-widget-content').find('a:last').focus();
return false;
}  	
else if (!e.shiftKey && e.keyCode === 9 
         && (($( ".wp-ada-compliance-accessibility-widget-protectedbylink" ).length && $('.wp-ada-compliance-accessibility-widget-content').find('a:last').is(":focus")) 
             || ( !$( ".wp-ada-compliance-accessibility-widget-protectedbylink" ).length && $('.wp-ada-compliance-accessibility-widget-content').find('button:last').is(":focus")))) {
$('.wp-ada-compliance-accessibility-widget-close').focus();
  return false;
}   

}); 

// hide widget button
$(document).on("click", '.wp-ada-compliance-accessibility-widget-hide', function() {
   
var showhideVal = '';
showhideVal = $('.wp-ada-compliance-accessibility-widget-hide').data("state");
//console.log(showhideVal);
if(showhideVal === 'hide'){
    
document.cookie = "wp-ada-hide-accessibility-widget=1; path=/;";
$('.wp-ada-compliance-accessibility-widget-hide').text(wpadaVariables.show); 
$('.wp-ada-compliance-accessibility-widget-hide').data('state', 'show');
$('.wp-ada-compliance-accessibility-widget-content').hide();

if(wpadaVariables.option === 'bottom' || wpadaVariables.option === 'top'){
$('.wp-ada-compliance-accessibility-widget').css('right','-50px');
}
if(wpadaVariables.option === 'left' ){
$('.wp-ada-compliance-accessibility-widget').css('left','-50px');
}    
    
}
else  if(showhideVal === 'show'){
      
document.cookie = "wp-ada-hide-accessibility-widget=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;";
$('.wp-ada-compliance-accessibility-widget-hide').text(wpadaVariables.hide);
$('.wp-ada-compliance-accessibility-widget-hide').data('state', 'hide');
//console.log(showhideVal);
if(wpadaVariables.option === 'bottom' || wpadaVariables.option === 'top'){
$('.wp-ada-compliance-accessibility-widget').css('right','10px');
}
if(wpadaVariables.option === 'left' ){
$('.wp-ada-compliance-accessibility-widget').css('left','10px');
}
} 
return false;
});     

// animate hide button
$(document).on("touchstart", '.wp-ada-compliance-accessibility-widget-button', function() {    
$('.wp-ada-compliance-accessibility-widget-hide').show();
});

   
$(document).on("mouseover", '.wp-ada-compliance-accessibility-widget-button', function() {
$('.wp-ada-compliance-accessibility-widget-hide').show();
}); 
$(document).on("mouseover", '.wp-ada-compliance-accessibility-widget-hide', function() {
$('.wp-ada-compliance-accessibility-widget-hide').show();
});     
$(document).on("mouseout", '.wp-ada-compliance-accessibility-widget-button', function() {
$('.wp-ada-compliance-accessibility-widget-hide').hide();
});  
$(document).on("mouseout", '.wp-ada-compliance-accessibility-widget-hide', function() {
$('.wp-ada-compliance-accessibility-widget-hide').hide();
}); 


	// close alert
$(document).on("click", '.wp-ada-compliance-accessibility-alert-close', function() {
$('.wp-ada-compliance-widget-alerts').hide();
$('.wp-ada-compliance-accessibility-widget-statmentlink').focus();
    return false;
});    
    
// show statement
$(document).on("click", '.wp-ada-compliance-accessibility-widget-statmentlink', function() {
$('.wp-ada-compliance-accessibility-widget-accessible-text').hide();

    if($('.wp-ada-compliance-accessibility-widget-statement').is(":visible")){
       
       $('.wp-ada-compliance-accessibility-widget-statmentlink').focus();
       $('.wp-ada-compliance-accessibility-widget-statement').hide();
    }else{
       $('.wp-ada-compliance-accessibility-widget-statement').show();
       $('.wp-ada-compliance-accessibility-alert-close').focus();
       wp_ada_compliance_widget_trapFocus(document.getElementById('wp-ada-compliance-accessibility-widget-statement'));

    }
return false;
});  

// show accessible website text
$(document).on("click", '.wp-ada-compliance-accessibility-widget-accessiblesite-accessible', function(e) {


$('.wp-ada-compliance-accessibility-widget-statement').hide();
$('.wp-ada-compliance-accessibility-widget-accessible-text').toggle();
return false;
}); 

// function to open close widget
function wp_ada_complianceOpenCloseWidget(closeonly){

adadialogstateVal = $('.wp-ada-compliance-accessibility-widget-content').data("hidden");

if(adadialogstateVal === true && closeonly !== 1){
$('.wp-ada-compliance-accessibility-widget-content').show();
        $('.wp-ada-compliance-accessibility-widget-accessible-text').hide();

$('.wp-ada-compliance-accessibility-widget-content').data("hidden",false);
$('.wp-ada-compliance-accessibility-widget-close').focus();
   // $('.wp-ada-compliance-accessibility-widget-content').draggable();
}
if(adadialogstateVal === false || closeonly === 1){
    
if(!$('.wp-ada-compliance-accessibility-widget-content').is(":visible")){
    return;
}    
$('.wp-ada-compliance-accessibility-widget-content').hide();
    $('.wp-ada-compliance-accessibility-widget-accessible-text').hide();
//$('.wp-ada-compliance-accessibility-widget-committed-text').hide();
$('.wp-ada-compliance-accessibility-widget-content').data("hidden",true);
 $('.wp-ada-compliance-accessibility-widget-button').focus();
}    
}
	


/************************************************************************
// toolbar features and show/hide
**************************************************************************/
// show tools based on cookie value
 wp_ada_compliance_set_toolbar_states();  
    
// display toolbar
$(document).on("click", '.wp-ada-compliance-accessibility-widget-showtools', function() {
wp_ada_complianceOpenCloseWidgetTools(0);
});
    // goto toolbar
$(document).on("click", '#wp-ada-compliance-accessibility-widget-showtools-screenreader', function() {
if($("#wp-ada-compliance-accessibility-widget-showtools").length === 1) {
$('#wp-ada-compliance-accessibility-widget-button').focus();
    return false;
}
});
    
    // goto screen reader link
$(document).on("click", '#wp-ada-compliance-accessibility-widget-showtools-returnto-screenreader', function() {
if($("#wp-ada-compliance-accessibility-widget-showtools-screenreader").length === 1) {
$('#wp-ada-compliance-accessibility-widget-showtools-screenreader').focus();
}
});
    
// hide toolbar
$(document).on("click", '.wp-ada-compliance-accessibility-widget-toolbarclose', function() {

wp_ada_complianceOpenCloseWidgetTools(1);
	//var returnid = event.target.id;
    if($("#wp-ada-compliance-accessibility-widget-showtools").length === 1) {
	$('#wp-ada-compliance-accessibility-widget-button').focus();
	}
	else if($("#wp-ada-compliance-accessibility-widget-shortcode-showtools").length === 1) {
	$('#wp-ada-compliance-accessibility-widget-shortcode-showtools').focus();
	}
    else if($(".wp-ada-compliance-accessibility-widget-showtools").length === 2) {
       
	$('.wp-ada-compliance-accessibility-widget-showtools a:first').focus();
	}
     
return false;
}); 
	
// function to open close widget tools
function wp_ada_complianceOpenCloseWidgetTools(closeonly){
if(!$('.wp-ada-compliance-accessibility-widget-toolbar').is(':visible') && closeonly !== 1){
$('.wp-ada-compliance-accessibility-widget-toolbar').show();
if(closeonly !== 2){
wp_ada_complianceOpenCloseWidget(1); 
$('.wp-ada-compliance-accessibility-widget-toolbarclose').focus();
}
document.cookie = "wp-ada-show-accessibility-tools=1; path=/;";	
}
else if($('.wp-ada-compliance-accessibility-widget-toolbar').is(':visible') || closeonly === 1){
$('.wp-ada-compliance-accessibility-widget-toolbar').hide();
document.cookie = "wp-ada-show-accessibility-tools=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
}    
}	
    
// function to add adjustment class
function wp_ada_compliance_AddAdjustmentClass(state){
if(state === 1) {   
// add widget tool adjustments to body tag
 $( "body *" ).removeClass( "wp-ada-compliance-accessibility-widget-adjustments" );      
$( "body *" ).addClass( "wp-ada-compliance-accessibility-widget-adjustments" );
$( ".wp-ada-compliance-accessibility-widget, .wp-ada-compliance-accessibility-widget *, .wp-ada-compliance-accessibility-widget-toolbar a, .wp-ada-compliance-accessibility-widget-toolbar i, .wp-ada-compliance-accessibility-widget i, #wpadminbar *" ).removeClass( "wp-ada-compliance-accessibility-widget-adjustments" );
 
}else{
 $( "body *" ).removeClass( "wp-ada-compliance-accessibility-widget-adjustments" );   
}
}

// adjust font size
$(document).on("click", '.wp-ada-compliance-accessibility-widget-textsize', function() {
var newfontsize = '';
var curfontsize = 15;
wp_ada_compliance_AddAdjustmentClass(1);
curfontsize = parseInt($('.wp-ada-compliance-accessibility-widget-textsize').attr('data-fontsize'));    
newfontsize = curfontsize+3;  
var fontsizeinc = (newfontsize-15)/3;  
if(newfontsize > '27') {
 
wp_ada_reset_fontsize();
}else{
 document.cookie = "wp-ada-accessibility-tools-fontsize="+newfontsize+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-textsize').attr('data-fontsize',newfontsize);  
$(".wp-ada-compliance-accessibility-widget-adjustments").each( function () {
    var $this = $(this);
    if (parseInt($this.css("fontSize")) < newfontsize) {
        $this.css('font-size', newfontsize+'px');  
    } 
   
});
  //  $('.wp-ada-compliance-accessibility-widget-adjustments').css('font-size', newfontsize+'px');
	$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
	$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-tools-progress2-dot').detach();
	for(var x = fontsizeinc; x < 4; x++ ){
	$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');
	}
    $( ".wp-ada-compliance-accessibility-widget-textsize" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}  
    return false;
}); 
         // reset font size
function wp_ada_reset_fontsize(){   
 document.cookie = "wp-ada-accessibility-tools-fontsize=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-textsize').attr('data-fontsize','15'); 
    $('.wp-ada-compliance-accessibility-widget-adjustments').css('font-size', '');
    $('.wp-ada-compliance-accessibility-widget-textsize').blur();
	$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-tools-progress-dot').detach();
	$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-tools-progress2-dot').detach();
    $( ".wp-ada-compliance-accessibility-widget-textsize" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}

// big cursor
$(document).on("click", '.wp-ada-compliance-accessibility-widget-bigcursor', function() {
wp_ada_compliance_AddAdjustmentClass(1);
var bigcursorstate = $('.wp-ada-compliance-accessibility-widget-bigcursor').attr('data-bigcursor');   
if(bigcursorstate === '1') {
 wp_ada_reset_bigcursor();

}else{
    bigcursorstate = '1';
 document.cookie = "wp-ada-accessibility-tools-bigcursor="+bigcursorstate+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-bigcursor').attr('data-bigcursor',bigcursorstate);  
        $( "html" ).addClass( "wp-ada-bigcursor" );
    $( ".wp-ada-compliance-accessibility-widget-bigcursor" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
} 
    return false;
}); 
     // reset bigcursor
function wp_ada_reset_bigcursor(){    
 document.cookie = "wp-ada-accessibility-tools-bigcursor=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-bigcursor').attr('data-bigcursor','0'); 
 $( "html" ).removeClass( "wp-ada-bigcursor" );
    $('.wp-ada-compliance-accessibility-widget-bigcursor').blur();
$( ".wp-ada-compliance-accessibility-widget-bigcursor" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}  
    
// adjust letter spacing
$(document).on("click", '.wp-ada-compliance-accessibility-widget-textspacing', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var newtextspacing = '';
var curtextspacing = 1;
curtextspacing = parseInt($('.wp-ada-compliance-accessibility-widget-textspacing').attr('data-textspacing'));    
newtextspacing = curtextspacing+2;   
var textspacinginc = (newtextspacing-1)/2;  	
if(newtextspacing > 7) {
 wp_ada_reset_textspacing();

}else{
 document.cookie = "wp-ada-accessibility-tools-textspacing="+newtextspacing+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-textspacing').attr('data-textspacing',newtextspacing); 
		$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
    $('.wp-ada-compliance-accessibility-widget-adjustments').css('letter-spacing', newtextspacing+'px');
    $( ".wp-ada-compliance-accessibility-widget-textspacing" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
	$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-tools-progress2-dot').detach();
	for(var x = textspacinginc; x < 3; x++ ){
	$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');
	}
}  
    return false;
});  
     // reset textspacing
function wp_ada_reset_textspacing(){    
 document.cookie = "wp-ada-accessibility-tools-textspacing=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-textspacing').attr('data-textspacing','1'); 
    $('.wp-ada-compliance-accessibility-widget-adjustments').css('letter-spacing', '');
	$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-tools-progress-dot').detach();
	$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-tools-progress2-dot').detach();
    $('.wp-ada-compliance-accessibility-widget-textspacing').blur();
    $( ".wp-ada-compliance-accessibility-widget-textspacing" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}    
    
// adjust font family
$(document).on("click", '.wp-ada-compliance-accessibility-widget-fontfamily', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var fontfamilies  = ['auto','Arial,serif', '"Georgia",serif', '"opendyslexicregular",serif'];    
    
var newfontfamily = parseInt($('.wp-ada-compliance-accessibility-widget-fontfamily').attr('data-fontfamily'));    
newfontfamily = newfontfamily+1;  

if(newfontfamily > 3) {
wp_ada_reset_fontfamily();  
}else{
 document.cookie = "wp-ada-accessibility-tools-fontfamily="+newfontfamily+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-fontfamily').attr('data-fontfamily',newfontfamily);  
    $('body').css('font-family', fontfamilies[newfontfamily]);  
    $(".wp-ada-compliance-accessibility-widget-adjustments").each( function () {
    var $this = $(this);
    $this.css('font-family', fontfamilies[newfontfamily]);   
});
	$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
	$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-tools-progress2-dot').detach();
	for(var x = newfontfamily; x < 3; x++ ){
	$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');
	}
    $( ".wp-ada-compliance-accessibility-widget-fontfamily" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}  
    return false;
}); 
     // reset fontfamily
function wp_ada_reset_fontfamily(){    
 document.cookie = "wp-ada-accessibility-tools-fontfamily=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-fontfamily').attr('data-fontfamily','0'); 
    $('body').css('font-family', '');
     $(".wp-ada-compliance-accessibility-widget-adjustments").each( function () {
    var $this = $(this);
    $this.css('font-family', '');   
});
    $('.wp-ada-compliance-accessibility-widget-fontfamily').blur();
	$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-tools-progress-dot').detach();
	$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-tools-progress2-dot').detach();
    $( ".wp-ada-compliance-accessibility-widget-fontfamily" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}    

//  highlight links
$(document).on("click", '.wp-ada-compliance-accessibility-widget-highlightlinks', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var highlightlinks = $('.wp-ada-compliance-accessibility-widget-highlightlinks').attr('data-highlightlinks');    
if(highlightlinks === '1') {
  
wp_ada_reset_highlightlinks();
}else{
    highlightlinks = '1';
 document.cookie = "wp-ada-accessibility-tools-highlightlinks="+highlightlinks+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-highlightlinks').attr('data-highlightlinks',highlightlinks);  
    $( "html" ).addClass( "wp-ada-highlightlinks" );
    $( ".wp-ada-compliance-accessibility-widget-highlightlinks" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
      
} 
    return false;
}); 
     // reset highlightlinks
function wp_ada_reset_highlightlinks(){    
 document.cookie = "wp-ada-accessibility-tools-highlightlinks=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-highlightlinks').attr('data-highlightlinks','0'); 
 $( "html" ).removeClass( "wp-ada-highlightlinks" );
    $('.wp-ada-compliance-accessibility-widget-highlightlinks').blur();
$( ".wp-ada-compliance-accessibility-widget-highlightlinks" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
    return false;
} 
	
	//  highlight headings
$(document).on("click", '.wp-ada-compliance-accessibility-widget-highlightheadings', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var highlightheadings = $('.wp-ada-compliance-accessibility-widget-highlightheadings').attr('data-highlightheadings');    
if(highlightheadings === '1') {
wp_ada_reset_highlightheadings();
}else{
    highlightheadings = '1';
 document.cookie = "wp-ada-accessibility-tools-highlightheadings="+highlightheadings+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-highlightheadings').attr('data-highlightheadings',highlightheadings);  
    $( "html" ).addClass( "wp-ada-highlightheadings" );
    $( ".wp-ada-compliance-accessibility-widget-highlightheadings" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
      
}  
    return false;
}); 
     // reset highlightheadings
function wp_ada_reset_highlightheadings(){    
 document.cookie = "wp-ada-accessibility-tools-highlightheadings=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-highlightheadings').attr('data-highlightheadings','0'); 
 $( "html" ).removeClass( "wp-ada-highlightheadings" );
    $('.wp-ada-compliance-accessibility-widget-highlightheadings').blur();
$( ".wp-ada-compliance-accessibility-widget-highlightheadings" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
}    
    
//show tool tips
var wpaddatooltips;    
$(document).on("click", '.wp-ada-compliance-accessibility-widget-tooltips', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
wpaddatooltips = $('.wp-ada-compliance-accessibility-widget-tooltips').attr('data-tooltips');    
if(wpaddatooltips === '1') {
 wp_ada_reset_tooltips();

}else{
    wpaddatooltips = '1';
 document.cookie = "wp-ada-accessibility-tools-tooltips="+wpaddatooltips+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-tooltips').attr('data-tooltips',wpaddatooltips);  
    $( "html" ).addClass( "wp-ada-tooltips" );
    $( ".wp-ada-compliance-accessibility-widget-tooltips" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
    
}  
    return false;
}); 
     // reset tooltips
function wp_ada_reset_tooltips(){    
 document.cookie = "wp-ada-accessibility-tools-tooltips=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-tooltips').attr('data-tooltips','0'); 
 $( "html" ).removeClass( "wp-ada-tooltips" );
    $('.wp-ada-compliance-accessibility-widget-tooltips').blur();
$( ".wp-ada-compliance-accessibility-widget-tooltips" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );
    $('#wp-ada-tooltips').hide(); 
}
    // add focus outline for keyboardnav
$(document).on("click", '.wp-ada-compliance-accessibility-widget-keyboardnav', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var keyboardnav = $('.wp-ada-compliance-accessibility-widget-keyboardnav').attr('data-keyboardnav');    
if(keyboardnav === '1') {
wp_ada_reset_keyboardnav();
}else{
    keyboardnav = '1';
 document.cookie = "wp-ada-accessibility-tools-keyboardnav="+keyboardnav+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-keyboardnav').attr('data-keyboardnav',keyboardnav);  
    $( "html" ).addClass( "wp-ada-keyboardnav" );
    $( ".wp-ada-compliance-accessibility-widget-keyboardnav" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
      
} 
    return false;
}); 
     // reset keyboardnav
function wp_ada_reset_keyboardnav(){
document.cookie = "wp-ada-accessibility-tools-keyboardnav=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-keyboardnav').attr('data-keyboardnav','0'); 
 $( "html" ).removeClass( "wp-ada-keyboardnav" );
    $('.wp-ada-compliance-accessibility-widget-keyboardnav').blur();
$( ".wp-ada-compliance-accessibility-widget-keyboardnav" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
}    
    

    // stop animations
$(document).on("click", '.wp-ada-compliance-accessibility-widget-stopanimations', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var stopanimations = $('.wp-ada-compliance-accessibility-widget-stopanimations').attr('data-stopanimations');    
if(stopanimations === '1') {
wp_ada_reset_stopanimations();
}else{
    stopanimations = '1';
 document.cookie = "wp-ada-accessibility-tools-stopanimations="+stopanimations+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-stopanimations').attr('data-stopanimations',stopanimations);  
    $( "html" ).addClass( "wp-ada-stopanimations" );
    document.querySelectorAll('video').forEach(vid => vid.pause());
    document.querySelectorAll('audio').forEach(aud => aud.pause());
    
    var wp_ada_stopAllYouTubeVideos = () => { 
  var iframes = document.querySelectorAll('iframe');
  Array.prototype.forEach.call(iframes, iframe => { 
    iframe.contentWindow.postMessage(JSON.stringify({ event: 'command', 
  func: 'stopVideo' }), '*');
 });
}
wp_ada_stopAllYouTubeVideos(); 
    
    $( ".wp-ada-compliance-accessibility-widget-stopanimations" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
      
}  
    return false;
}); 
       
     // reset stop animations
function wp_ada_reset_stopanimations(){
   document.cookie = "wp-ada-accessibility-tools-stopanimations=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-stopanimations').attr('data-stopanimations','0'); 
 $( "html" ).removeClass( "wp-ada-stopanimations" );
    $('.wp-ada-compliance-accessibility-widget-stopanimations').blur();
$( ".wp-ada-compliance-accessibility-widget-stopanimations" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );  
}

    // color contrast
$(document).on("click", '.wp-ada-compliance-accessibility-widget-contrast', function() {
    wp_ada_compliance_AddAdjustmentClass(1);
var curcontrast = parseInt($('.wp-ada-compliance-accessibility-widget-contrast').attr('data-contrast'));  

var newcontrast = curcontrast+1;

if(newcontrast > '4') {
wp_ada_reset_color_contrast();
}else{
document.cookie = "wp-ada-accessibility-tools-contrast="+newcontrast+"; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-contrast').attr('data-contrast', newcontrast);  
$( "html" ).removeClass( "wp-ada-colorcontrast"+curcontrast );
$( "html" ).addClass( "wp-ada-colorcontrast"+newcontrast );
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
$( ".wp-ada-compliance-accessibility-widget-contrast" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" ); 
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-tools-progress2-dot').detach();
for(var x = newcontrast; x < 4; x++ ){
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');
}  
}
return false;
}); 
    
 // reset color contrast   
function wp_ada_reset_color_contrast(){
document.cookie = "wp-ada-accessibility-tools-contrast=; expires=Thu, 18 Dec 2013 12:00:00 UTC; path=/;"; 
$('.wp-ada-compliance-accessibility-widget-contrast').attr('data-contrast','0');
$( "html" ).removeClass( "wp-ada-colorcontrast1" );
$( "html" ).removeClass( "wp-ada-colorcontrast2" );
$( "html" ).removeClass( "wp-ada-colorcontrast3" );
$( "html" ).removeClass( "wp-ada-colorcontrast4" );
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-tools-progress-dot').detach();
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-tools-progress2-dot').detach();
$('.wp-ada-compliance-accessibility-widget-contrast').blur();
$( ".wp-ada-compliance-accessibility-widget-contrast" ).removeClass( "wp-ada-compliance-accessibility-widget-tool-active" );   
}
    // reset all
$(document).on("click", '.wp-ada-compliance-accessibility-widget-resetall', function() {
wp_ada_reset_color_contrast();
wp_ada_reset_stopanimations();
wp_ada_reset_keyboardnav();
wp_ada_reset_tooltips();
wp_ada_reset_highlightlinks();
wp_ada_reset_highlightheadings();
wp_ada_reset_fontfamily();
wp_ada_reset_textspacing();
wp_ada_reset_bigcursor();
wp_ada_reset_fontsize();
wp_ada_compliance_AddAdjustmentClass(0);
$('.wp-ada-compliance-accessibility-widget-resetall').blur();
return false;
});
    
	// trap keyboard inside toolbar
$(document).keydown(function(e) {  
if (e.shiftKey && e.keyCode === 9 && $('.wp-ada-compliance-accessibility-widget-toolbar').children().first().is(":focus")) {
$('.wp-ada-compliance-accessibility-widget-resetall').focus();
return false;
}  	
else if (!e.shiftKey && e.keyCode === 9 && $('.wp-ada-compliance-accessibility-widget-toolbar').children().last().is(":focus")) {
  $('.wp-ada-compliance-accessibility-widget-toolbar').find(':first').focus(); 
  return false;
}   

}); 
	
    
// set toolbar states upon page load
function wp_ada_compliance_set_toolbar_states(){
  

    
// show / hide toolbar
if(wp_ada_compliance_getCookie('wp-ada-show-accessibility-tools')==='1'){
wp_ada_complianceOpenCloseWidgetTools(2);
}

var x;
var y;
    
// set font size
var newfontsize = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-fontsize');
if(newfontsize > 0){
    wp_ada_compliance_AddAdjustmentClass(1);
    $(".wp-ada-compliance-accessibility-widget-adjustments").each( function () {
    var $this = $(this);
    if (parseInt($this.css("fontSize")) < newfontsize) {
        $this.css('font-size', newfontsize+'px');  
    } 
});
//$( ".wp-ada-compliance-accessibility-widget-adjustments" ).css('font-size', newfontsize+'px');
$('.wp-ada-compliance-accessibility-widget-textsize').attr('data-fontsize',newfontsize); 
var fontsizeincrement = (newfontsize-15)/3;	
for (x = 1; x <= fontsizeincrement; x++) {
$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
}
for (y = x; y <= 4; y++) {
$('.wp-ada-compliance-accessibility-widget-textsize .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');	
}	
$( ".wp-ada-compliance-accessibility-widget-textsize" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );    
}
    
// set letter spacing
var newtextspacing = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-textspacing');
if(newtextspacing !==''){
    wp_ada_compliance_AddAdjustmentClass(1);
$( ".wp-ada-compliance-accessibility-widget-adjustments" ).css('letter-spacing', newtextspacing+'px');
$('.wp-ada-compliance-accessibility-widget-textspacing').attr('data-textspacing',newtextspacing); 
var textspacingincrement = (newtextspacing-1)/2;	
for (x = 1; x <= textspacingincrement; x++) {
$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
}	
for (y = x; y <= 3; y++) {
$('.wp-ada-compliance-accessibility-widget-textspacing .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');	
}	
$( ".wp-ada-compliance-accessibility-widget-textspacing" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );    
}   

// adjust font family
var newfontfamily = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-fontfamily');
var fontfamilies  = ['auto','Arial,serif', '"Georgia",serif', '"opendyslexicregular",serif'];     

if(newfontfamily !==''){
    wp_ada_compliance_AddAdjustmentClass(1);
$('body').css('font-family', fontfamilies[newfontfamily]);
 $(".wp-ada-compliance-accessibility-widget-adjustments").each( function () {
    var $this = $(this);
    $this.css('font-family', fontfamilies[newfontfamily]);   
});    
$('.wp-ada-compliance-accessibility-widget-fontfamily').attr('data-fontfamily',newfontfamily); 
var fontfamilyincrement = newfontfamily;	
for (x = 1; x <= fontfamilyincrement; x++) {
$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
}	
for (y = x; y <= 3; y++) {
$('.wp-ada-compliance-accessibility-widget-fontfamily .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');	
}
$( ".wp-ada-compliance-accessibility-widget-fontfamily" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );    
}  

// set big cursor
var bigcursor = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-bigcursor');
	
if(bigcursor === '1'){
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-bigcursor" );  
$('.wp-ada-compliance-accessibility-widget-bigcursor').attr('data-bigcursor',bigcursor); 
$( ".wp-ada-compliance-accessibility-widget-bigcursor" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );    
}
    
// display tool tips  
wpaddatooltips = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-tooltips');
if(wpaddatooltips === '1'){  
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-tooltips" );  
$('.wp-ada-compliance-accessibility-widget-tooltips').attr('data-tooltips',wpaddatooltips); 
$( ".wp-ada-compliance-accessibility-widget-tooltips" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}
 
    
// display link highlights
var highlightlinks = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-highlightlinks');
if(highlightlinks === '1'){   
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-highlightlinks" );  
$('.wp-ada-compliance-accessibility-widget-highlightlinks').attr('data-highlightlinks',highlightlinks); 
$( ".wp-ada-compliance-accessibility-widget-highlightlinks" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}
	
	// display heading highlights
var highlightheadings = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-highlightheadings');
if(highlightheadings === '1'){   
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-highlightheadings" );  
$('.wp-ada-compliance-accessibility-widget-highlightheadings').attr('data-highlightheadings',highlightheadings); 
$( ".wp-ada-compliance-accessibility-widget-highlightheadings" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}
    
    // add focus outline for keyboardnav
var keyboardnav = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-keyboardnav');
if(keyboardnav === '1'){   
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-keyboardnav" );  
$('.wp-ada-compliance-accessibility-widget-keyboardnav').attr('data-keyboardnav',keyboardnav); 
$( ".wp-ada-compliance-accessibility-widget-keyboardnav" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}

    // stop animations
var stopanimations = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-stopanimations');
if(stopanimations === '1'){   
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-stopanimations" );  
    
    setTimeout(() => {
      document.querySelectorAll('video').forEach(vid => vid.pause());
    document.querySelectorAll('audio').forEach(aud => aud.pause());
    
    var wp_ada_stopAllYouTubeVideos = () => { 
  var iframes = document.querySelectorAll('iframe');
  Array.prototype.forEach.call(iframes, iframe => { 
    iframe.contentWindow.postMessage(JSON.stringify({ event: 'command', 
  func: 'stopVideo' }), '*');
 });
}
wp_ada_stopAllYouTubeVideos(); 
        }, 2000);
$('.wp-ada-compliance-accessibility-widget-stopanimations').attr('data-stopanimations',stopanimations); 
$( ".wp-ada-compliance-accessibility-widget-stopanimations" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}

    // set contrast
var contrast = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-contrast');
if(contrast !== ''){   
    wp_ada_compliance_AddAdjustmentClass(1);
$( "html" ).addClass( "wp-ada-colorcontrast"+contrast );  
$('.wp-ada-compliance-accessibility-widget-contrast').attr('data-contrast',contrast); 

for (var x = 1; x <= contrast; x++) {
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-progress').append('<span class="wp-ada-tools-progress-dot"></span>');
}	
for (var y = x; y <= 4; y++) {
$('.wp-ada-compliance-accessibility-widget-contrast .wp-ada-progress').append('<span class="wp-ada-tools-progress2-dot"></span>');	
}
$( ".wp-ada-compliance-accessibility-widget-contrast" ).addClass( "wp-ada-compliance-accessibility-widget-tool-active" );
}

}
     

/*************************************************
supporting functions
**************************************************/     
  // if enabled display tool tips 
 $('body').append('<div id="wp-ada-tooltips" class="wp-ada-compliance-accessibility-widget-adjustments"></div>');  
$(  "img" ).on("mouseover keydown",
  function(event) {
    var wpaddatooltips = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-tooltips');
      var alttext;
    if($(this).attr('alt') !== ''){
        alttext = $(this).attr('alt');
    }
     
    if(wpaddatooltips === '1' && alttext !== '' && alttext !== undefined){   		
	 var top = 50;
    var left = 200;	
		
			if(event.type === 'mouseover')
    {
      top = event.pageY;
    left = event.pageX;
    }

 $('#wp-ada-tooltips').delay(5).fadeIn( 400 );
$("#wp-ada-tooltips").html(alttext);
$("#wp-ada-tooltips").css({
        position: "absolute",
        top:  top + "px",
        left:  left + "px"
    }); 
  
        // move back onto screen
if($(this).position().left < 1){
 $('#wp-ada-tooltips').css('transform','translateX(-100%)');
} 
//if($(this).position().top < 1){
//$('#wp-ada-tooltips').css('transform','translateY(-100%)');
//}  
  }
}
);
    $("img").on("mouseout blur",
  function() {
    if(wpaddatooltips === '1'){   
     $('#wp-ada-tooltips').hide();   
  }
}
); 
$(  "[aria-label]" ).on("mouseover keydown",
  function(event) {
    var wpaddatooltips = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-tooltips');
   
    var alttext;
 if(!$(this).hasClass('wp-ada-compliance-accessibility-widget-toolbar') && !$(this).hasClass('wp-ada-compliance-toolbtn') && !$(this).hasClass('wp-ada-compliance-accessibility-widget-content')){
   if($(this).attr('aria-label') !== '') {
		  alttext = $(this).attr('aria-label');
	  }
 }
     
    if(wpaddatooltips === '1' && alttext !== '' && alttext !== undefined){   		
	 var top = 50;
    var left = 200;	
		
			if(event.type === 'mouseover')
    {
      top = event.pageY;
    left = event.pageX;
    }

 $('#wp-ada-tooltips').delay(5).fadeIn( 400 );
$("#wp-ada-tooltips").html(alttext);
$("#wp-ada-tooltips").css({
        position: "absolute",
        top:  top + "px",
        left:  left + "px"
    }); 
      
        // move back onto screen
if($(this).position().left < 1){
 $('#wp-ada-tooltips').css('transform','translateX(-100%)');
} 
//if($(this).position().top < 1){
//$('#wp-ada-tooltips').css('transform','translateY(-100%)');
//}        

}
}
);
$("[aria-label]").on("mouseout blur",
  function() {
    if(wpaddatooltips === '1'){   
     $('#wp-ada-tooltips').hide();   
  }
}
);     
   // handle titles 
$("[title]").on("mouseover keydown", function(event) {
     var wpaddatooltips = wp_ada_compliance_getCookie('wp-ada-accessibility-tools-tooltips');
   
    var alttext;

   if($(this).attr('title') !== '') {
		  alttext = $(this).attr('title');
	  }

    if(wpaddatooltips === '1' && alttext !== '' && alttext !== undefined){   		
	 var top = 50;
    var left = 200;	
        
		// Store it in a temporary attribute
        $(this).attr("tmp_title", alttext);
         $(this).attr("title","");
        
			if(event.type === 'mouseover')
    {
      top = event.pageY;
    left = event.pageX;
    }

 $('#wp-ada-tooltips').delay(5).fadeIn( 400 );
$("#wp-ada-tooltips").html(alttext);
$("#wp-ada-tooltips").css({
        position: "absolute",
        top:  top + "px",
        left:  left + "px"
    }); 
          // move back onto screen
if($(this).position().left < 1){
 $('#wp-ada-tooltips').css('transform','translateX(-100%)');
} 
//if($(this).position().top < 1){
//$('#wp-ada-tooltips').css('transform','translateY(-100%)');
//}  
  }
}  
);

$("[title]").on("mouseout blur",
  function() {
    if(wpaddatooltips === '1'){   
        if($(this).attr("tmp_title") != ''){
           
        $(this).attr("title", $(this).attr("tmp_title"));  
            $(this).removeAttr("tmp_title");
    }
     $('#wp-ada-tooltips').hide();   
  }
}
); 
     
// get cookie       
function wp_ada_compliance_getCookie(cname) {
var name = cname + "=";
var ca = document.cookie.split(';');
for(var i = 0; i <ca.length; i++) {
var c = ca[i];
while (c.charAt(0)===' ') {
c = c.substring(1);
}
if (c.indexOf(name) === 0) {
return c.substring(name.length,c.length);
}
}
return "";
}    

// display toolbar tooltips
 $('body').append('<div id="wp-ada-tool-tooltips" class="wp-ada-compliance-accessibility-widget-adjustments"></div>');
$(  ".wp-ada-compliance-toolbtn" ).on("mouseover keydown",
  function(event) {
   
    var alttext = $(this).attr('aria-label');
    var top = 50;
    var left = 200;
	
    if(alttext !== '' && alttext !== undefined && alttext !== 'close'){   
	if(event.type === 'mouseover')
    {
    top = event.pageY-45;
   left = event.pageX+20;
    }
 if( !/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
 // some code..
 $('#wp-ada-tool-tooltips').delay(10).fadeIn(400);
$("#wp-ada-tool-tooltips").html(alttext);
$("#wp-ada-tool-tooltips").css({
        position: "absolute",
        top:  top + "px",
        left:  left + "px"
    });   
// $('#wp-ada-tool-tooltips').css('transform','translateX(-80%)');
    }
    }
}
);  
$(this).on("mouseout blur",
  function() {
 $('#wp-ada-tool-tooltips').hide();
}
);
    
// make widget draggable
    /*
$.fn.draggable = function(){
    var $this = this,
    ns = 'draggable_'+(Math.random()+'').replace('.',''),
    mm = 'mousemove.'+ns,
    mu = 'mouseup.'+ns,
    $w = $(window),
    isFixed = ($this.css('position') === 'fixed'),
    adjX = 0, adjY = 0;

    $this.mousedown(function(ev){
        var pos = $this.offset();
        if (isFixed) {
            adjX = $w.scrollLeft(); adjY = $w.scrollTop();
        }
        var ox = (ev.pageX - pos.left), oy = (ev.pageY - pos.top);
        $this.data(ns,{ x : ox, y: oy });
        $w.on(mm, function(ev){
            ev.preventDefault();
            ev.stopPropagation();
            if (isFixed) {
                adjX = $w.scrollLeft(); adjY = $w.scrollTop();
            }
            var offset = $this.data(ns); 
           $this.css('bottom',''); 
            //var bottom = ev.pageY - adjY - offset.y + $this.outerHeight();
            $this.css({left: ev.pageX - adjX - offset.x, top: ev.pageY - adjY - offset.y});
            $this.css('height', $this.outerHeight()); 
           
        });
        $w.on(mu, function(){
            $w.off(mm + ' ' + mu).removeData(ns);
        });
    });

    return this;
}; */

// trap focus
function wp_ada_compliance_widget_trapFocus(element) {
    var focusableEls = element.querySelectorAll('a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled])'),
        firstFocusableEl = focusableEls[0];  
        lastFocusableEl = focusableEls[focusableEls.length - 1];
        KEYCODE_TAB = 9;

    element.addEventListener('keydown', function(e) {
        var isTabPressed = (e.key === 'Tab' || e.keyCode === KEYCODE_TAB);

        if (!isTabPressed) { 
            return; 
        }

        if ( e.shiftKey ) /* shift + tab */ {
            if (document.activeElement === firstFocusableEl) {
                lastFocusableEl.focus();
                e.preventDefault();
            }
        } else /* tab */ {
            if (document.activeElement === lastFocusableEl) {
                firstFocusableEl.focus();
                e.preventDefault();
            }
        }

    });
}


}); // end jquery ready