<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/**********************************************
// create accessibility tool shortcode
**********************************************/
function wp_ada_compliance_accessibility_tools_shortcode_func( $atts ) {
    
    
	$atts = shortcode_atts( array(
		'icon' => 'fa-universal-access',
		'text' => '',
		'class' => '',
		'alttext' => __('Show Accessibility Tool Bar', 'wp-ada-compliance'),
	), $atts, 'wp-ada-access-tools' );
	
		// sanitize input
	foreach($atts as $key => $value){
		if(isset($atts[$key]))
		$atts[$key] = sanitize_text_field($value);
	}
	if(stristr($atts['icon'],'fa-')){
	$shortcode = '<button id="wp-ada-compliance-accessibility-widget-shortcode-showtools" class="wp-ada-compliance-accessibility-widget-showtools '.esc_attr($atts['class']).'" title="'.esc_attr($atts['alttext']).'"><i class="fa '.esc_attr($atts['icon']).'" aria-hidden="true"></i> '.esc_attr($atts['text']).'</button>';
	}
	elseif(stristr($atts['icon'],'http')){
	$shortcode = '<a href-="#" id="wp-ada-compliance-accessibility-widget-shortcode-showtools" class="wp-ada-compliance-accessibility-widget-showtools '.esc_attr($atts['class']).'" title="'.esc_attr($atts['alttext']).'" role="button"><img src="'.esc_url($atts['icon']).'" '.esc_attr($atts['text']).'</a>';
	}

	$shortcode .= wp_ada_compliance_display_widget_toolbar();
	return $shortcode;
	
}
if(get_option('wp_ada_compliance_use_accessibility_widget_shortcode','false') == 'true'){
    
add_shortcode( 'wp-ada-access-tools', 'wp_ada_compliance_accessibility_tools_shortcode_func' );
}

/**********************************************
// enabled accessibility widget
**********************************************/
// add to footer page
add_action('wp_footer', 'wp_ada_compliance_add_accessibility_widget');

function wp_ada_compliance_add_accessibility_widget(){
    
    
    // enforce license
$license_status_check = get_option('wp_ada_compliance_license_status_check','unchecked');    
if($license_status_check == '1'){
 echo '<!--'.__('WP ADA Compliance License is Invalid','wp-ada-compliance').'-->';   
    return;
}
$license_expire_date = get_option('wp_ada_compliance_license_expire_date',''); 
if(($license_expire_date == '' or strtotime($license_expire_date) < time())){    
  $widget = '<!--'.__('WP ADA Compliance License is Expired','wp-ada-compliance').'-->';     
}
else{    
  $widget = '<!--'.__('Protected by WP ADA Compliance','wp-ada-compliance').'-->'; 
}
  
$use_accessibility_widget = get_option('wp_ada_compliance_use_accessibility_widget','false');
if($use_accessibility_widget != 'false'){	
    
    // display screen reader link
$widget .= '<a href="#" id="wp-ada-compliance-accessibility-widget-showtools-screenreader" class="screen-reader-text"> '.__('Accessibility Tools','wp-ada-compliance').'</a>';
    
$widget .= '<div class="wp-ada-compliance-accessibility-widget" >
<a href="#" class="wp-ada-compliance-accessibility-widget-hide" data-state="hide" role="button">'.__('hide','wp-ada-compliance').'</a>
    <a href="#" class="wp-ada-compliance-accessibility-widget-button" id="wp-ada-compliance-accessibility-widget-button" aria-label="'.__('Open or Close the Accessibility Menu','wp-ada-compliance').'" role="button">';

$widget .='<i class="fas fa-universal-access" aria-hidden="true"></i>';
$widget .='</a><div class="wp-ada-compliance-accessibility-widget-content" role="dialog" id="wp-ada-compliance-dialog1" aria-modal="true" aria-label="'.__('Accessibility Menu, Use CTRL+M to open or close the Accessibility Menu. ','wp-ada-compliance').'" data-hidden="true">';
	$widget .= '<a href="#" class="wp-ada-compliance-accessibility-widget-close" aria-label="close" role="button">X</a>';
    $widget .= '<h2 id="wp-ada-compliance-dialog1-title" >'.__('Accessibility (CTRL+M)','wp-ada-compliance').'</h2>'; 
	
 $widget .= '<div class="wp-ada-compliance-accessibility-widget-links">';

        // display committment status statements
  /*  $widget .= '<p class="wp-ada-compliance-accessibility-widget-committed-text wp-ada-compliance-widget-alerts" role="alert">';
    $widget .= '<a href="#" class="wp-ada-compliance-accessibility-alert-close" aria-hidden="true" role="button">X</a>';
   $widget .= __('The owner of this website is committed to accessibility and digital inclusion. Steps are being taken to correct issues and to conform with WCAG 2.1 AA Web Accessibility standards. Automatic and manual testing is ongoing.','wp-ada-compliance');  
$widget .= '</p>'; 
$widget .= '<p class="wp-ada-compliance-accessibility-widget-accessible-text wp-ada-compliance-widget-alerts" role="alert">';
    $widget .= '<a href="#" class="wp-ada-compliance-accessibility-alert-close" aria-hidden="true" role="button">X</a>';
 $widget .= __('The owner of this website is committed to accessibility and digital inclusion. This website has completed the automated testing process and conforms with most WCAG 2.1 AA Web Accessibility standards. Manual testing may still be ongoing, routine automated testing continues, new and updated content is evaluated for issues.','wp-ada-compliance');  
$widget .= '</p>';      */
    
    // display accessibility statement
    $use_accessibility_widget_statement = get_option('wp_ada_compliance_use_accessibility_widget_statement',__('The accessibility of our website is taken very seriously. We strive to meet WCAG 2.1 AA Web Accessibility standards by routinely evaluating our website using automated evaluation tools and manual testing when required. As content changes we review and correct issues and are responsive to our users needs. If you encounter issues with our website, please report them so they may be corrected in a timely manner.','wp-ada-compliance'));   
    if($use_accessibility_widget_statement != ""){   
    $widget .= '<p id="wp-ada-compliance-accessibility-widget-statement" class="wp-ada-compliance-accessibility-widget-statement wp-ada-compliance-widget-alerts" role="dialog"><a href="#" class="wp-ada-compliance-accessibility-alert-close" role="button" aria-label="'.__('Close','wp-ada-compliance').'">X</a>'.strip_tags($use_accessibility_widget_statement,'<a><br><span><p>').'</p>';
    }
     $widget .= '<button id="wp-ada-compliance-accessibility-widget-showtools-returnto-screenreader" class="screen-reader-text">';
    $widget .= __('Return to top of page','wp-ada-compliance');
    $widget .= '</button>';  
    
    
if($use_accessibility_widget == 'true' or $use_accessibility_widget == 'nobadge') {
    $widget .= '<div class="wp-ada-compliance-toolbtn-div">';
    $widget .= wp_ada_compliance_display_widget_tools();
    
   
     $widget.= '<a href="#" id="wp-ada-compliance-accessibility-widget-showtools" class="wp-ada-compliance-accessibility-widget-showtools wp-ada-compliance-toolbtn" aria-label="'.__('Dock Toolbar at Bottom of Page','wp-ada-compliance').'" role="button"><i class="fas fa-tools" aria-hidden="true"></i></a>';
    
    $widget .= '</div>';
 }   
    
    if($use_accessibility_widget_statement != ""){       
 $widget .= '<p class="wp-ada-compliance-accessibility-widget-bottombuttons"><button class="wp-ada-compliance-accessibility-widget-statmentlink" title="'.__('opens a dialog','wp-ada-compliance').'"><i class="fas fa-universal-access" aria-hidden="true"></i> ';
    $widget .= __('Our Commitment','wp-ada-compliance');
    $widget .= '</button>';
    $widget .= '</p>';  
    }
    
    // display accessibility report link
    $use_accessibility_widget_form_url = get_option('wp_ada_compliance_use_accessibility_widget_form',''); 
    if($use_accessibility_widget_form_url != ""){
    $widget .= '<p class="wp-ada-compliance-accessibility-widget-bottombuttons"><button onkeypress="location.href=\''.esc_url($use_accessibility_widget_form_url).'\'" onclick="location.href=\''.esc_url($use_accessibility_widget_form_url).'\'" class="wp-ada-compliance-accessibility-widget-report"><i class="fas fa-envelope" aria-hidden="true"></i> ';
    $widget .= __('Report a Problem','wp-ada-compliance');
    $widget .= '</button>';
        $widget .= '</p>';
    }

if($use_accessibility_widget == 'badgeonly') {
$widget .= '<p class="wp-ada-compliance-accessibility-widget-bottombuttons">';
$widget.= '<button id="wp-ada-compliance-accessibility-widget-showtools" class="wp-ada-compliance-accessibility-widget-showtools" aria-label="'.__('Show Accessibility Tool bar','wp-ada-compliance').'"><i class="fas fa-cog" aria-hidden="true"></i> '.__('Accessibility Tools','wp-ada-compliance').'</button>';
$widget .= '</p>'; 
}
if($use_accessibility_widget == 'true' or $use_accessibility_widget == 'badgeonly') {
  // display badge 
$widget .= '<p class="wp-ada-compliance-badge">';
$widget .= '<img src="';
$widget .= plugin_dir_url( __FILE__ ).'committed.png';
$widget .= '" alt="';
$widget .= __('Committed','wp-ada-compliance');    
$widget .= '" width="125" height="122">';
$widget .= '</p>';  
}
    
$widget .= '</div>'; 
    
// get logo image    
$license_expire_date = get_option('wp_ada_compliance_license_expire_date','');   
    $use_logo = get_option('wp_ada_compliance_accessibility_widget_use_logo','false'); 
    $report_logo_url = get_option('wp_ada_compliance_report_logo_url',''); 
if(($license_expire_date == '' or strtotime($license_expire_date) > time()) and $use_logo != 'false'){    
 $image_id  = get_option( 'wp_ada_compliance_report_logo');
if( intval( $image_id ) > 0 ) {
// Change with the image size you want to use
$image = wp_get_attachment_image( $image_id, 'full', false);
}
}     
  
       $widget .= '<p class="wp-ada-compliance-accessibility-widget-protectedby">';
     
     if(isset($image)) {
         if($report_logo_url != '') $widget .= '<a href="'.esc_url($report_logo_url).'" class="wp-ada-compliance-accessibility-widget-protectedbylink">';
         $widget .= $image;
         if($report_logo_url != '') $widget .= '</a>';
     }else{
     
     $widget .= '<a href="https://www.alumnionlineservices.com/php-scripts/wp-ada-compliance-check/" class="wp-ada-compliance-accessibility-widget-protectedbylink">';
    $widget .= __('Protected by:','wp-ada-compliance');
    $widget .= '<br>';
           $widget .= __('WP ADA Compliance Check','wp-ada-compliance');
    $widget .= '</a>';
     }
     $widget .= '</p>';
   
      $widget .= '</div>';
    $widget .= '</div>';
 
    $widget .= wp_ada_compliance_display_widget_toolbar();
}

echo $widget;
}
/*********************************************
display toolbar
********************************************/
function wp_ada_compliance_display_widget_toolbar(){
  
$toolbar = '<div class="wp-ada-compliance-accessibility-widget-toolbar" role="dialog" id="wp-ada-compliance-dialog2" aria-modal="true" aria-label="'.__('Accessibility Toolbar, use CTRL-Q to open or close the toolbar.','wp-ada-compliance').'" data-hidden="true">';
  $toolbar .= '<a href="#" class="wp-ada-compliance-accessibility-widget-toolbarclose" aria-label="close" role="button">X</a>';   
	$toolbar .= '<span class="wp-ada-compliance-accessibility-widget-tools-hotkey">'.__('Hot Key: CTRL-Q','wp-ada-compliance').'</span>';         
$toolbar .= wp_ada_compliance_display_widget_tools();

$toolbar .= '</div>';
    
    return $toolbar;
}

/*********************************************
display tools
********************************************/
function wp_ada_compliance_display_widget_tools(){
  
$tools = '<a href="#" class="wp-ada-compliance-accessibility-widget-textspacing wp-ada-compliance-toolbtn" data-textspacing="1" aria-label="'.__('Increase Text Spacing','wp-ada-compliance').'" role="button"><i class="fas fa-text-width" aria-hidden="true"></i><span class="wp-ada-progress"></span></a>';
    
$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-textsize wp-ada-compliance-toolbtn" data-fontsize="15" aria-label="'.__('Increase Text Size','wp-ada-compliance').'" role="button"><i class="fas fa-text-height" aria-hidden="true"></i><span class="wp-ada-progress"></span></a>';
    
$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-fontfamily wp-ada-compliance-toolbtn" data-fontfamily="0" aria-label="'.__('Change Font','wp-ada-compliance').'" role="button"><i class="fas fa-font" aria-hidden="true"></i><span class="wp-ada-progress"></span></a>';
    
$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-bigcursor wp-ada-compliance-toolbtn" data-bigcursor="0" aria-label="'.__('Display Big Cursor','wp-ada-compliance').'" role="button"><i class="fas fa-mouse-pointer" aria-hidden="true"></i></a>';

$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-tooltips wp-ada-compliance-toolbtn" data-tooltips="0" aria-label="'.__('Display Tool Tips','wp-ada-compliance').'" role="button"><i class="fas fa-comment-dots" aria-hidden="true"></i></a>';

$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-contrast wp-ada-compliance-toolbtn" data-contrast="0" aria-label="'.__('Adjust Contrast','wp-ada-compliance').'" role="button"><i class="fas fa-adjust" aria-hidden="true"></i><span class="wp-ada-progress"></span></a>';

$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-highlightlinks wp-ada-compliance-toolbtn" data-highlightlinks="0" aria-label="'.__('Highlight Links & Buttons','wp-ada-compliance').'" role="button"><i class="fas fa-link" aria-hidden="true"></i></a>';
	
$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-highlightheadings wp-ada-compliance-toolbtn" data-highlightheadings="0" aria-label="'.__('Highlight Page Headings','wp-ada-compliance').'" role="button"><i class="fas fa-heading" aria-hidden="true"></i></a>';	

$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-keyboardnav wp-ada-compliance-toolbtn" data-keyboardnav="0" aria-label="'.__('Enable Keyboard Navigation','wp-ada-compliance').'" role="button"><i class="fas fa-keyboard" aria-hidden="true"></i></a>';
    
$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-stopanimations wp-ada-compliance-toolbtn" data-stopanimations="0" aria-label="'.__('Stop Animations','wp-ada-compliance').'" role="button"><i class="fas fa-spinner" aria-hidden="true"></i></a>';

$tools .= '<a href="#" class="wp-ada-compliance-accessibility-widget-resetall wp-ada-compliance-toolbtn" data-resetall="0" aria-label="'.__('Reset All','wp-ada-compliance').'" role="button"><i class="fas fa-sync-alt" aria-hidden="true"></i></a>';

return $tools;
}

?>