<?php 
/*
define all compliance maual checks
/********************************/

// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;


/********************************/

$wp_ada_compliance_manual_def[0]['DisplayError'] = __('F1: Failure of Success Criterion 1.3.2 due to changing the meaning of content by positioning information with CSS.','wp-ada-compliance');
$wp_ada_compliance_manual_def[0]['Reference'] = __('WCAG 2.1 (Level A) - 1.3.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[0]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#meaningful-sequence';
$wp_ada_compliance_manual_def[0]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F1.html';

/********************************/

$wp_ada_compliance_manual_def[1]['DisplayError'] = __('F7: Failure of Success Criterion 2.2.2 due to an object or applet, such as Java or Flash, that has blinking content without a mechanism to pause the content that blinks for more than five seconds.','wp-ada-compliance');
$wp_ada_compliance_manual_def[1]['Reference'] = __('WCAG 2.1 (Level A) - 2.2.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[1]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#pause-stop-hide';
$wp_ada_compliance_manual_def[1]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F7.html';

/********************************/

$wp_ada_compliance_manual_def[2]['DisplayError'] = __('F8: Failure of Success Criterion 1.2.2 due to captions omitting some dialogue or important sound effects.','wp-ada-compliance');
$wp_ada_compliance_manual_def[2]['Reference'] = __('WCAG 2.1 (Level A) - 1.2.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[2]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#captions-prerecorded';
$wp_ada_compliance_manual_def[2]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F8.html';

/********************************/

$wp_ada_compliance_manual_def[5]['DisplayError'] = __('F10: Failure of Success Criterion 2.1.2 and Conformance Requirement 5 due to combining multiple content formats in a way that traps users inside one format type.','wp-ada-compliance');
$wp_ada_compliance_manual_def[5]['Reference'] = __('WCAG 2.1 (Level A) - 2.1.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[5]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#no-keyboard-trap';
$wp_ada_compliance_manual_def[5]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F10.html';

/********************************/

$wp_ada_compliance_manual_def[8]['DisplayError'] = __('F13: Failure of Success Criterion 1.1.1 and 1.4.1 due to having a text alternative that does not include information that is conveyed by color differences in the image.','wp-ada-compliance');
$wp_ada_compliance_manual_def[8]['Reference'] = __('WCAG 2.1 (Level A) - 1.1.1','wp-ada-compliance');
$wp_ada_compliance_manual_def[8]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#non-text-content';
$wp_ada_compliance_manual_def[8]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F13.html';

/********************************/

$wp_ada_compliance_manual_def[9]['DisplayError'] = __('F14: Failure of Success Criterion 1.3.3 due to identifying content only by its shape or location.','wp-ada-compliance');
$wp_ada_compliance_manual_def[9]['Reference'] = __('WCAG 2.1 (Level A) - 1.3.3','wp-ada-compliance');
$wp_ada_compliance_manual_def[9]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#sensory-characteristics';
$wp_ada_compliance_manual_def[9]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F14.html';

/********************************/

$wp_ada_compliance_manual_def[10]['DisplayError'] = __('F16: Failure of Success Criterion 2.2.2 due to including scrolling content where movement is not essential to the activity without also including a mechanism to pause and restart the content.','wp-ada-compliance');
$wp_ada_compliance_manual_def[10]['Reference'] = __('WCAG 2.1 (Level A) - 2.2.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[10]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#pause-stop-hide';
$wp_ada_compliance_manual_def[10]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F16.html';

/********************************/

$wp_ada_compliance_manual_def[10]['DisplayError'] = __('F24: Failure of Success Criterion 1.4.3, 1.4.6 and 1.4.8 due to specifying foreground colors without specifying background colors or vice versa','wp-ada-compliance');
$wp_ada_compliance_manual_def[10]['Reference'] = __('WCAG 2.1 (Level A) - 1.4.3','wp-ada-compliance');
$wp_ada_compliance_manual_def[10]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#contrast-minimum';
$wp_ada_compliance_manual_def[10]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F24.html';

/********************************/

$wp_ada_compliance_manual_def[12]['DisplayError'] = __('F26: Failure of Success Criterion 1.3.3 due to using a graphical symbol alone to convey information','wp-ada-compliance');
$wp_ada_compliance_manual_def[12]['Reference'] = __('WCAG 2.1 (Level A) - 1.3.3','wp-ada-compliance');
$wp_ada_compliance_manual_def[12]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#sensory-characteristics';
$wp_ada_compliance_manual_def[12]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F26.html';

/********************************/

$wp_ada_compliance_manual_def[13]['DisplayError'] = __('F31: Failure of Success Criterion 3.2.4 due to using two different labels for the same function on different Web pages within a set of Web pages.','wp-ada-compliance','wp-ada-compliance');
$wp_ada_compliance_manual_def[13]['Reference'] = __('WCAG 2.1 (Level AA) - 3.2.4','wp-ada-compliance');
$wp_ada_compliance_manual_def[13]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#consistent-identification';
$wp_ada_compliance_manual_def[13]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F31.html';

/********************************/

$wp_ada_compliance_manual_def[14]['DisplayError'] = __('F49: Failure of Success Criterion 1.3.2 due to using an HTML layout table that does not make sense when linearized.','wp-ada-compliance');
$wp_ada_compliance_manual_def[14]['Reference'] = __('WCAG 2.1 (Level A) - 1.3.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[14]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#meaningful-sequence';
$wp_ada_compliance_manual_def[14]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F49.html';

/********************************/

$wp_ada_compliance_manual_def[15]['DisplayError'] = __('F58: Failure of Success Criterion 2.2.1 due to using server-side techniques to automatically redirect pages after a time-out','wp-ada-compliance');
$wp_ada_compliance_manual_def[15]['Reference'] = __('WCAG 2.1 (Level A) - 2.2.1','wp-ada-compliance');
$wp_ada_compliance_manual_def[15]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#timing-adjustable';
$wp_ada_compliance_manual_def[15]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F58.html';

/********************************/

$wp_ada_compliance_manual_def[17]['DisplayError'] = __('F63: Failure of Success Criterion 2.4.4 due to providing link context only in content that is not related to the link.','wp-ada-compliance');
$wp_ada_compliance_manual_def[17]['Reference'] = __('WCAG 2.1 (Level A) - 2.4.4','wp-ada-compliance');
$wp_ada_compliance_manual_def[17]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#link-purpose-in-context';
$wp_ada_compliance_manual_def[17]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F63.html';

/********************************/

$wp_ada_compliance_manual_def[18]['DisplayError'] = __('F66: Failure of Success Criterion 3.2.3 due to presenting navigation links in a different relative order on different pages.','wp-ada-compliance');
$wp_ada_compliance_manual_def[18]['Reference'] = __('WCAG 2.1 (Level AA) - 3.2.3','wp-ada-compliance');
$wp_ada_compliance_manual_def[18]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#consistent-navigation';
$wp_ada_compliance_manual_def[18]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F66.html';

/********************************/

$wp_ada_compliance_manual_def[19]['DisplayError'] = __('F67: Failure of Success Criterion 1.1.1 and 1.2.1 due to providing long descriptions for non-text content that does not serve the same purpose or does not present the same information.','wp-ada-compliance');
$wp_ada_compliance_manual_def[19]['Reference'] = __('WCAG 2.1 (Level A) - 1.1.1','wp-ada-compliance');
$wp_ada_compliance_manual_def[19]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#non-text-content';
$wp_ada_compliance_manual_def[19]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F67.html';

/********************************/

$wp_ada_compliance_manual_def[20]['DisplayError'] = __('F69: Failure of Success Criterion 1.4.4 when resizing visually rendered text up to 200 percent causes the text, image or controls to be clipped, truncated or obscured.','wp-ada-compliance');
$wp_ada_compliance_manual_def[20]['Reference'] = __('WCAG 2.1 (Level A) - 1.4.4','wp-ada-compliance');
$wp_ada_compliance_manual_def[20]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#resize-text';
$wp_ada_compliance_manual_def[20]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F69.html';

/********************************/

$wp_ada_compliance_manual_def[21]['DisplayError'] = __('F70: Failure of Success Criterion 4.1.1 due to incorrect use of start and end tags or attribute markup. Verify that elements have complete start and end tags, are nested according to their specifications, do not contain duplicate attributes, and any IDs are unique, except where the specifications allow these features. Use the free html validator plugin to identify and correct these errors. HTML validator links are also included on the page/post list as well as the Wordpress editor screen.','wp-ada-compliance');
$wp_ada_compliance_manual_def[21]['Reference'] = __('WCAG 2.1 (Level A) - 4.1.1','wp-ada-compliance');
$wp_ada_compliance_manual_def[21]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#parsing';
$wp_ada_compliance_manual_def[21]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F70.html';

/********************************/

$wp_ada_compliance_manual_def[22]['DisplayError'] = __('F71: Failure of Success Criterion 1.1.1 due to using text look-alikes to represent text without providing a text alternative.','wp-ada-compliance');
$wp_ada_compliance_manual_def[22]['Reference'] = __('WCAG 2.1 (Level A) - 1.1.1','wp-ada-compliance');
$wp_ada_compliance_manual_def[22]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#non-text-content';
$wp_ada_compliance_manual_def[22]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F71.html';

/********************************/

$wp_ada_compliance_manual_def[23]['DisplayError'] = __('F74: Failure of Success Criterion 1.2.2 and 1.2.8 due to not labeling a synchronized media alternative to text as an alternative','wp-ada-compliance');
$wp_ada_compliance_manual_def[23]['Reference'] = __('WCAG 2.1 (Level A) - 1.2.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[23]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#captions-prerecorded';
$wp_ada_compliance_manual_def[23]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F74.html';

/********************************/

$wp_ada_compliance_manual_def[24]['DisplayError'] = __('F75: Failure of Success Criterion 1.2.2 by providing synchronized media without captions when the synchronized media presents more information than is presented on the page.','wp-ada-compliance');
$wp_ada_compliance_manual_def[24]['Reference'] = __('WCAG 2.1 (Level A) - 1.2.2','wp-ada-compliance');
$wp_ada_compliance_manual_def[24]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#captions-prerecorded';
$wp_ada_compliance_manual_def[24]['ReadMore'] = 'https://www.w3.org/TR/WCAG20-TECHS/F75.html';

/********************************/

$wp_ada_compliance_manual_def[25]['DisplayError'] = __('Broken links are a common problem on websites. While not specifically identified as a violation, broken links loosely violate principle 2 - Operable and may result in content on your website not being evaluated for accessibility by the WP ADA Compliance plugin. Consider installing a link check plugin to monitor and correct broken links.','wp-ada-compliance');
$wp_ada_compliance_manual_def[25]['Reference'] = __('WCAG 2.1 (Level A)','wp-ada-compliance');
$wp_ada_compliance_manual_def[25]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#principle2';
$wp_ada_compliance_manual_def[25]['ReadMore'] = '';

/********************************/

$wp_ada_compliance_manual_def[26]['DisplayError'] = __('The visual presentation of text and images of text has a contrast ratio of at least 4.5:1, except for the following: Large Text: Large-scale text and images of large-scale text have a contrast ratio of at least 3:1; Incidental: Text or images of text that are part of an inactive user interface component, that are pure decoration, that are not visible to anyone, or that are part of a picture that contains significant other visual content, have no contrast requirement. Logotypes: Text that is part of a logo or brand name has no contrast requirement. Choose "Evaluate with Wave" under the Web Accessibility tab and then click on the "Contrast" tab.','wp-ada-compliance');
$wp_ada_compliance_manual_def[26]['Reference'] = __('WCAG 2.1 (Level A) - 1.4.3','wp-ada-compliance');
$wp_ada_compliance_manual_def[26]['ReferenceURL'] = 'https://www.w3.org/WAI/WCAG21/quickref/#contrast-minimum';
$wp_ada_compliance_manual_def[26]['ReadMore'] = '';
?>