<?php 
/*
functions to process content scanning of post archives
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************
validate archives content 
*********************************************************/
function wp_ada_compliance_post_archive_validation($limit, $postid=0) {
	global $wpdb;
          

if (!current_user_can( "edit_pages" )) return 1;

	
if ( defined( 'DOING_CRON' )) {
     $query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype LIKE %s and cronflag = %d and ignre = %d LIMIT %d'; 
 $results = $wpdb->get_results( $wpdb->prepare($query, 'theme', '%_archive', 0, 0, $limit), ARRAY_A ); 
}
elseif($postid!=0){   
     $query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype LIKE %s and  ignre = %d and id = %d'; 
 $results = $wpdb->get_results( $wpdb->prepare($query, 'theme', '%_archive', 0, $postid), ARRAY_A );  
}else{
  $query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype LIKE %s and scanflag = %d and ignre = %d LIMIT %d';
    $results = $wpdb->get_results( $wpdb->prepare($query, 'theme', '%_archive', 0, 0, $limit), ARRAY_A );
}


if($results){
foreach ( $results as $row ) {
			
    $archiveurl =$row['link'];

	// get content and validate pages	
	$content = wp_ada_compliance_check_deep_scan_support($row['link']);

	if ($content != "" and strlen($content) > 10 ) {
	// clear error message
	if(!isset($_SESSION['my_ada_notices'])) $_SESSION['my_ada_notices'] = "";

	// create array to pass post info to complete checks	
 $postinfo['postid'] = $row['id']; 
	$postinfo['title'] = wp_ada_compliance_get_page_title_from_content($content);
        $postinfo['posttitle'] = $postinfo['title']; 
	$postinfo['type'] = 'theme';
	$postinfo['taxonomy'] = '';	
	$postinfo['scantype'] = $row['themetype'];	
	$postinfo['wpget'] = 1;
	$postinfo['content'] = $content;
        
              // update post title in links table
   $postinfo['posttitle'] = wp_ada_compliance_update_link_title($archiveurl, $postinfo['content']);   

	wp_ada_remove_corrected_theme_errors($postinfo['scantype'], $postinfo['postid'], 1);	

        
		// gather css files urls
	 wp_ada_compliance_locate_css_links($postinfo['content'],$archiveurl);	

	 // locate other, non wordpress files
	 wp_ada_compliance_locate_urls($postinfo['content']);    


        
    // check html validation
    wp_ada_compliance_check_html_validation_errors($archiveurl, $postinfo['postid'], $postinfo['title']); 

	// complete all other content validations	
	wp_ada_compliance_validate_post($postinfo);		

	wp_ada_remove_corrected_theme_errors($postinfo['scantype'], $postinfo['postid'], 2);	


	}
	// update scan status
wp_ada_compliance_set_scan_flag($archiveurl);		
    

	}
	}
}

?>