<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;


/***************************************************
// locate css links
****************************************************/
function wp_ada_compliance_locate_css_links($content){
global $wpdb;	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
		
// clear css option and return
if($scan_external_sources == '' or !in_array('css', $scan_external_sources)) {
	$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s', 'css'));	
	return 0;
}
	
// import method	
if(preg_match_all('#url\((\"|\')?([^)"\']+)(\"|\')?\)#', $content, $matches)){
  foreach($matches[2] as $url){

	  if(strstr($url,'ver=')) {
		  $urlparts = explode('ver=',$url);
		  $url =  rtrim($urlparts[0],'?');
	  }

	  
	  if(!stristr($url, 'http') and !stristr($url, '//') and $url != "") {
          $url = esc_url_raw(wp_ada_compliance_rel2abs($url, get_site_url())); 
      }
	  
     if(stristr($url, '.css') 
       ){
       
     wp_ada_compliance_save_css_link_record((string)$url); 
        
    } //else{
     // wp_ada_compliance_update_locate_flag((string)$url);   
   // }
	  
 }
}		
	
$dom = new DOMDocument;
libxml_use_internal_errors(true);
$dom->loadHTML($content);	
	
	
// link method	
$xml = simplexml_import_dom($dom); // just to make xpath more simple
$linksOrStyles = $xml->xpath('//*[@rel="stylesheet" or @media="all" or @media="screen"]');     

foreach ($linksOrStyles as $linkOrStyleSimpleXMLElementObj)
{
    if ($linkOrStyleSimpleXMLElementObj->xpath('@href') != false) {
    $scan_url = $linkOrStyleSimpleXMLElementObj['href']; 

	if(!stristr($scan_url, 'http') and !stristr($scan_url, '//') and $scan_url != "") $scan_url = esc_url_raw(wp_ada_compliance_rel2abs($scan_url, get_site_url()));
		
	if(strstr($scan_url,'ver=')) {
		  $urlparts = explode('ver=',$scan_url);
		  $scan_url =  rtrim($urlparts[0],'?');
	  }
		
	     if(stristr($scan_url, '.css')){
    
             wp_ada_compliance_save_css_link_record((string)$scan_url); 
        
    }// else{
     // wp_ada_compliance_update_locate_flag((string)$scan_url);   
   // }
	}
}

	
}

/***************************************************
// locate css links inside css files
****************************************************/
function wp_ada_compliance_rescan_css_links($cssvalue){
	
$content = wp_ada_compliance_check_deep_scan_support($cssvalue);

 if($content != "" and strlen($content) > 10){	

// import method	
if(preg_match_all('#url\((\"|\')?([^)"\']+)(\"|\')?\)#', $content, $matches)){
  foreach($matches[2] as $url){
	  
	  	  if(strstr($url,'ver=')) {
		  $urlparts = explode('ver=',$url);
		  $url =  rtrim($urlparts[0],'?');
	  }
	  
	  if(!stristr($url, 'http') and !stristr($url, '//') and $url != "") $url = esc_url_raw(wp_ada_compliance_rel2abs($url, get_site_url()));
      
	  if(stristr($url, '.css') 
       ){
        wp_ada_compliance_save_css_link_record((string)$url); 
	}
  }
}	 
	 
// link method		 
$dom = new DOMDocument;
libxml_use_internal_errors(true);
$dom->loadHTML($content);	
	 
$xml = simplexml_import_dom($dom); // just to make xpath more simple
$linksOrStyles = $xml->xpath('//*[@rel="stylesheet" or @media="all" or @media="screen"]');     

	// print_r($linksOrStyles);
	 
foreach ($linksOrStyles as $linkOrStyleSimpleXMLElementObj)
{
    if ($linkOrStyleSimpleXMLElementObj->xpath('@href') != false) {
   $scan_url =  $linkOrStyleSimpleXMLElementObj['href']; 
	
	if(!stristr($scan_url, 'http') and !stristr($scan_url, '//') and $scan_url != "") $scan_url = esc_url_raw(wp_ada_compliance_rel2abs($scan_url, get_site_url()));
		
			  if(strstr($scan_url,'ver=')) {
		  $urlparts = explode('ver=',$scan_url);
		  $scan_url =  rtrim($urlparts[0],'?');
	  }	
		
	  if(stristr($scan_url, '.css')){
	
        wp_ada_compliance_save_css_link_record((string)$scan_url); 
	}

	}
}

}
}


/*******************************************************************
// validate css files
*******************************************************************/
function wp_ada_compliance_validate_css($limit, $postid=0) {
    global $wpdb; 
    
 if (!defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) )  return 1; 
    
$scan_external_domains = get_option('wp_ada_compliance_scan_external_domains','false');	
    
// check if css is being scanned	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(!is_array($scan_external_sources) or !in_array('css', $scan_external_sources)) return 1;
						

if ( defined( 'DOING_CRON' )) {
  $wp_ada_compliance_css_files = $wpdb->get_results( $wpdb->prepare( 'SELECT link,id FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and cronflag = %d and ignre = %d LIMIT %d', 'css', 0, 0, $limit ), ARRAY_A );  
}
if($postid !=0){    
 $wp_ada_compliance_css_files = $wpdb->get_results( $wpdb->prepare( 'SELECT link,id FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and ignre = %d and id = %d', 'css', 0, $postid ), ARRAY_A ); 
    
}
else{
  $wp_ada_compliance_css_files = $wpdb->get_results( $wpdb->prepare( 'SELECT link,id FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and scanflag = %d and ignre = %d LIMIT %d', 'css', 0, 0,$limit ), ARRAY_A );
}
	
	
foreach($wp_ada_compliance_css_files as $row => $rows){

$cssvalue = $rows['link'];
$postinfo['postid'] = $rows['id'];    
$postinfo['type'] = 'css';
$postinfo['excerpt'] = '';	
$postinfo['content'] = '';
$postinfo['title'] = basename($rows['link']);
$postinfo['taxonomy'] = '';
$postinfo['wpget'] = 1;    
     
// only scan internal domains
if($scan_external_domains == 'true' or stristr($cssvalue,$_SERVER['SERVER_NAME'])){    

if(!strstr($cssvalue,"/wp-ada-compliance/")){
// if not disabled, try to pull content from wpget
	
if(!strstr($cssvalue,'?')) $cssSCANvalue = $cssvalue.'?ver='.rand();
else $cssSCANvalue = $cssvalue.'&ver='.rand();

 $remotecontent = wp_ada_compliance_check_deep_scan_support($cssSCANvalue);
	//$postinfo['externalsrc'] = 'css|'.$cssvalue;				
	$postinfo['content'] = $remotecontent;
	$postinfo['scantype'] = basename($cssvalue).' id: '.$postinfo['postid'];	
	
	   if($postinfo['content'] != "" and strlen($postinfo['content']) > 10){

		wp_ada_compliance_remove_corrected_css('css', $postinfo['postid'], 1); 
           
		wp_ada_compliance_validate_post($postinfo); 
           
		wp_ada_compliance_remove_corrected_css('css', $postinfo['postid'], 2);
           
           	// update purge flag
	    wp_ada_compliance_set_link_purge_flag($cssvalue);
           
  
	  }	      

}
}
      // update purge flag
    wp_ada_compliance_set_scan_flag($cssvalue);		
    

}	
}

/*********************************************************
remove corrected error
*******************************************************/
function wp_ada_compliance_remove_corrected_css($type, $postid, $pre=1) {
global $wpdb;
	
if($pre == 1){
// set record flag before validating content	
$wpdb->query($wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET recordcheck = %d WHERE type = %s and postid = %d ', 0, $type, $postid) );
}elseif($pre == 2){
// after validation is complete remove previous errors that were not found
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and postid = %d and recordcheck = %d', $type, $postid, 0) );
}
}
/*********************************************************
convert relative urls to absolute
*******************************************************/
function wp_ada_compliance_rel2abs($url, $base)
{
  // Return base if no url
    if( ! $url) return $base;    

    // Return if already absolute URL
    if(parse_url($url, PHP_URL_SCHEME) != '') return $url;
    
		    // Urls only containing query or anchor
//if($url[0] == '#' || $url[0] == '?') return $base.$url;
    if($url[0] == '#' || $url[0] == '?') {
		$base = preg_replace('/\?.*/', '', $base);
		return $base.$url;
	}
	
    
    $base = rtrim($base, '#');  
    
    // Parse base URL and convert to local variables: $scheme, $host, $path
    extract(parse_url($base));

    // If no path, use /
    if( ! isset($path)) $path = '/';
 
    // Remove non-directory element from path
    $path = preg_replace('#/[^/]*$#', '', $path);
 
    // Destroy path if relative url points to root
    if($url[0] == '/') $path = '';
    
    // Dirty absolute URL
    $abs = "$host$path/$url";
 
    // Replace '//' or '/./' or '/foo/../' with '/'
    $re = array('#(/\.?/)#', '#/(?!\.\.)[^/]+/\.\./#','(\.\.\/)');
    for($n = 1; $n > 0; $abs = preg_replace($re, '/', $abs, -1, $n)) {}
    
    // Absolute URL is ready!
    return $scheme.'://'.$abs;
}
/**********************************************
//check if post is on ignore list
**********************************************/
function wp_ada_compliance_check_ignore_setting($postid, $type, $themetype = ''){
 $wp_ada_compliance_ignored_posts = get_option('wp_ada_compliance_posts_to_ignore',array());	    
    
if(is_array($wp_ada_compliance_ignored_posts) and count($wp_ada_compliance_ignored_posts) > 0){
    
foreach($wp_ada_compliance_ignored_posts as $post => $value){	
$parts = explode('|',$value);
if(count($parts) == 3){
if($themetype == ''){
if($parts[0] == $type and $parts[1] == $postid) return 1;  
} else {

if($parts[0] == $type and $parts[1] == $postid and $parts[2] == str_replace(' ','',$themetype)) return 1;   

}
}
   
}
} return 0;
}
/**********************************************
//save link
**********************************************/
function wp_ada_compliance_save_link_record($link, $type) {
global $wpdb;

// ignore css and html if not tracked	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
    if(!is_array($scan_external_sources)) $scan_external_sources = array();

$postid = '';
    
$link = rtrim($link, '#');    
  
// ignore search links other than the theme 
if(stristr($link,'?s')) return 1; 
  
// check if link has already be saved	
$data = wp_ada_compliance_get_link_data($link); 
if($data['type'] != 1 and $data['type'] !='link' and $data['type'] !='pdf' and $data['type'] !='iframe' ) {
	$type = $data['type'];  
	$tax = $data['tax'];
    $themetype = $data['themetype'];
    $postid = $data['postid'];
}
if($data['type'] =='pdf'){
     $postid = $data['linkid']; 
}

// update ignore status for posts and terms not being monitored   
if($type == 'link' and !in_array('linked',$scan_external_sources))	$ignore = 1;
elseif($type == 'iframe' and !in_array('iframe',$scan_external_sources))	$ignore = 1;    
elseif($type == 'pdf' and !in_array('pdf',$scan_external_sources))	$ignore = 1;    
else $ignore = 0;  

    
// if blog home scans are disabled, don't re-enable when finding the link
if($type == 'theme'){
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page"));
if((!is_array($theme_scan_items) or !in_array('Blog Home',$theme_scan_items)) and rtrim($link, '/') == get_site_url()) {
    $ignore = 1; 
}
}
   


// set locate flag
$locaterecord = 1;

// dont save redirected or broken links
$response = wp_ada_compliance_checkRedirectedURLs($link);	
if($response['response_code'] != '200' and !stristr($link,'gthjyduudk') and !stristr($link,'010000000000000000000000000000')) { 
$ignore = 1;
$purge = 0;
} 
else $purge = 1;
    
// enfore ignored content setting
if($ignore == 0 and wp_ada_compliance_check_ignore_setting($postid, $type)) $ignore = 1;  
// ignore excluded paths
if(wp_ada_compliance_check_excluded_list($link)) $ignore = 1; 
    
if($response['last-modified'] == '1969-12-31 18:00:00' or $response['last-modified'] == '1970-01-01 00:00:00') $response['last-modified'] = '0000-00-00 00:00:00'; 

if($type == 'pdf')    
$attachmentid = attachment_url_to_postid($link);
else $attachmentid = '';    
    
if($data['type'] == 1){  
    
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (link, type, postid, taxonomy, cronflag, scanflag, themetype, purgeflag, ignre, locateflag, linkstatus, modifieddate, attachmentid, filesize) values(%s, %s, %d, %s, %d, %d, %s, %d, %d, %d, %s,%s,%d, %d)', $link, $type, '', '',0,0, '', $purge, $ignore, $locaterecord,$response['response_code'],$response['last-modified'],$attachmentid,$response['filesize']));	
} 
else{    

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set type = %s, ignre = %d, locateflag = %d, linkstatus = %s, modifieddate = %s, link = %s, attachmentid = %d, filesize = %d WHERE link = %s or link = %s', $type, $ignore, $locaterecord, $response['response_code'], $response['last-modified'], $link, $attachmentid, $response['filesize'],  $link, rtrim($link, '/')));

}

}
/**********************************************
// get link data
**********************************************/
function wp_ada_compliance_get_link_data($link) {
global $wpdb;   
 $data['type'] = 1; 
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where link = %s or link = %s limit 1', $link, $link.'/'), ARRAY_A );

foreach($results as $rows => $row){	
	$data['type'] = $row['type'];
   	$data['tax'] = $row['taxonomy'];
    $data['themetype'] = $row['themetype'];
    $data['postid'] = $row['postid'];
    $data['linkid'] = $row['id'];
	return $data;
}
return $data;
}
/**********************************************
//save term
**********************************************/
function wp_ada_compliance_save_term_record($link, $type, $postid, $tax) {

global $wpdb;

// ignore terms not tracked 	
$termstracked = get_option('wp_ada_compliance_terms',array('category'));	
if(!is_array($termstracked)) $termstracked = array();       
    

// ignore certain types
$ignore_these_items = array();	
$ignore_these_items[] = 'acf-field';
$ignore_these_items[] = 'acf-field-group';	
$ignore_these_items[] = 'accordions';	
$ignore_these_items[] = 'component';	
$ignore_these_items[] = 'nav_menu_item';
$ignore_these_items[] = 'oembed_cache';
$ignore_these_items[] = 'wp_block';
$ignore_these_items[] = 'nav_menu';	
if(in_array($tax, $ignore_these_items))	return 1; 	
	
	
$link = rtrim($link, '#');    

// update ignore status for posts and terms not being monitored   
if($type == 'term' and !in_array($tax,$termstracked))  $ignore = 1;
else $ignore = 0;  
    
// ignore excluded paths
if(wp_ada_compliance_check_excluded_list($link)) $ignore = 1; 
   
// enfore ignored content setting
if($ignore == 0 and wp_ada_compliance_check_ignore_setting($postid, $type)) $ignore = 1;    

// set locate flag
$locaterecord = 1;
$response_code = '';
$purge = 0;	
	
if(wp_ada_compliance_check_term($postid, $tax)){   
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (link, type, postid, taxonomy, cronflag, scanflag, purgeflag, ignre, locateflag, linkstatus) values(%s, %s, %d, %s, %d, %d, %d, %d, %d, %s)', $link, $type, $postid, $tax,0,0, $purge, $ignore, $locaterecord,$response_code));	
} 
else{    
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set type = %s, ignre = %d, locateflag = %d, linkstatus = %s, link = %s WHERE postid = %d and taxonomy = %s and type = %s', $type, $ignore, $locaterecord, $response_code, $link, $postid, $tax, $type));	    
}

}

/**********************************************
// check if term link exists
**********************************************/
function wp_ada_compliance_check_term($postid, $tax) {
global $wpdb;   
 
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT type, taxonomy FROM '.$wpdb->prefix.'wp_ada_compliance_links where postid = %d and taxonomy = %s limit 1', $postid, $tax), ARRAY_A );

foreach($results as $rows => $row){	
   return 0;
	
}
return 1;
}

/**********************************************
//save posts type links
**********************************************/
function wp_ada_compliance_save_post_link_record($link, $postid, $type) {
global $wpdb;

  // ignore posts not tracked
$posttypes = get_option('wp_ada_compliance_posttypes',array('page','post'));	
if(!is_array($posttypes )) $posttypes = array();
    
// ignore certain types
$ignore_these_items = array();	
$ignore_these_items[] = 'acf-field';
$ignore_these_items[] = 'acf-field-group';	
$ignore_these_items[] = 'accordions';	
$ignore_these_items[] = 'component';	
$ignore_these_items[] = 'nav_menu_item';
$ignore_these_items[] = 'oembed_cache';
$ignore_these_items[] = 'wp_block';
$ignore_these_items[] = 'nav_menu';	
if(in_array($type, $ignore_these_items))	return 1; 	
	
$link = rtrim($link, '#');   

// set ignore status 
if(!in_array($type,$posttypes)) $ignore = 1;	
else $ignore = 0;  

// ignore excluded paths
if(wp_ada_compliance_check_excluded_list($link)) $ignore = 1; 
   
// enfore ignored content setting
if($ignore == 0 and wp_ada_compliance_check_ignore_setting($postid, $type)) $ignore = 1;
    
// set locate flag
$locaterecord = 1;
$response_code = '';
$purge = 0;	
// get modified date 
$moddate = get_the_modified_date('Y-m-d H:i:s', $postid);

// check if link exists here
if(wp_ada_compliance_link_record_check($link)){
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (link, type, postid, taxonomy, cronflag, scanflag, themetype, purgeflag, ignre, locateflag, linkstatus, modifieddate) values(%s, %s, %d, %s, %d, %d, %s, %d, %d, %d, %s, %s)', $link, $type, $postid, '',0,0, '', $purge, $ignore, $locaterecord,$response_code, $moddate));	
} 
else{    
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set postid = %d, type = %s, ignre = %d, locateflag = %d, linkstatus = %s, link = %s, modifieddate = %s WHERE type = %s and postid = %d or link = %s', $postid, $type, $ignore, $locaterecord, $response_code, $link, $moddate, $type, $postid, $link));    
}
}
/**********************************************
save theme links
***********************************************/
function wp_ada_compliance_save_theme_links($link, $type, $postid, $themetype){
global $wpdb;  
    
if($themetype == '') return;

// remove pound from end of link
$link = rtrim($link, '#');   
    
// default default flags   
$ignore = 1;  
$locaterecord = 1;
$response_code = '';
$purge = 0;	 
    
// enforce post types on archive links
if(strstr($themetype,'_archive')){ 
$posttypes = get_option('wp_ada_compliance_posttypes',array('page','post'));  
    if(!is_array($posttypes )) $posttypes = array();
$themetype_check = str_replace('_archive','',$themetype); 
if(in_array($themetype_check,$posttypes))  $ignore = 0;
}    
else{	
// enforce theme file settings
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array("Blog Home","404 Page","Search Page"));
if(!is_array($theme_scan_items)) $theme_scan_items = array();    
if(in_array($themetype,$theme_scan_items)) $ignore = 0; 
}  
    
// ignore excluded paths
if(wp_ada_compliance_check_excluded_list($link)) $ignore = 1; 
	

// process author pages
if($themetype == "Author Page"){
$results = $wpdb->get_results($wpdb->prepare('SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype = %s and postid = %d', 'theme', $themetype, $postid), ARRAY_A );  
   
if(is_array($results) and count($results) == 0){
 
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (link, type, postid, cronflag, scanflag, themetype, purgeflag, ignre, locateflag, linkstatus) values(%s, %s, %d, %d, %d, %s, %d, %d, %d, %s)', $link, $type, $postid,0,0, $themetype, $purge, $ignore, $locaterecord,$response_code));	
} 
  
else{ 
foreach($results as $rows => $row){	
// enfore ignored content setting
if($ignore == 0 and wp_ada_compliance_check_ignore_setting($row['id'], 'theme', 'Author Page')) $ignore = 1; 

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set type = %s, ignre = %d, locateflag = %d, linkstatus = %s, link = %s WHERE themetype = %s and postid = %d', $type, $ignore, $locaterecord, $response_code, $link, $themetype, $postid));	    
}     
}
    
}  
// process archives
elseif(strstr($themetype,'_archive')){ 
$results = $wpdb->get_results($wpdb->prepare('SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype = %s', 'theme', $themetype), ARRAY_A );  
   
if(is_array($results) and count($results) == 0){
 
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (link, type, postid, cronflag, scanflag, themetype, purgeflag, ignre, locateflag, linkstatus) values(%s, %s, %d, %d, %d, %s, %d, %d, %d, %s)', $link, $type, $postid,0,0, $themetype, $purge, $ignore, $locaterecord,$response_code));	
} 
  
else{ 
foreach($results as $rows => $row){	
// enfore ignored content setting
if($ignore == 0 and wp_ada_compliance_check_ignore_setting($row['id'], 'theme', 'Author Page')) $ignore = 1; 

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set type = %s, ignre = %d, locateflag = %d, linkstatus = %s, link = %s WHERE themetype = %s', $type, $ignore, $locaterecord, $response_code, $link, $themetype));	    
}     
}
}
// process other theme types
else{
$results = $wpdb->get_results($wpdb->prepare('SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype = %s ', 'theme', $themetype), ARRAY_A );
    
if(is_array($results) and count($results) == 0){
   
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (link, type, postid, cronflag, scanflag, themetype, purgeflag, ignre, locateflag, linkstatus) values(%s, %s, %d, %d, %d, %s, %d, %d, %d, %s)', $link, $type, $postid, 0,0, $themetype, $purge, $ignore, $locaterecord,$response_code));	
} 
else{   
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set type = %s, ignre = %d, locateflag = %d, linkstatus = %s, link = %s WHERE themetype = %s', $type, $ignore, $locaterecord, $response_code, $link, $themetype));	    
}     
    
}

}
/**********************************************
//save link
**********************************************/
function wp_ada_compliance_save_css_link_record($link) {
global $wpdb;
	
if($link == "") return 1; 	

// ignore built in css files	
if(strstr($link,"/wp-ada-compliance/")) return 1; 	
    
// enforce external domain settings 
$scan_external_domains = get_option('wp_ada_compliance_scan_external_domains','false');
if($scan_external_domains == 'false' and !stristr($link,get_site_url())) $ignore = 1;
	
$link = rtrim($link, '#');    

// ignore css and html if not tracked	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(!in_array('css',$scan_external_sources))	$ignore = 1;	
else $ignore = 0;  

// ignore excluded paths
if(wp_ada_compliance_check_excluded_list($link)) $ignore = 1; 
	
   
// enfore ignored content setting
if($ignore == 0 and wp_ada_compliance_check_ignore_setting(0, 'css')) $ignore = 1;    

    
// set locate flag
$locaterecord = 1;
$response_code = '';
$purge = 0;	
    $title = basename($link);

// check if link exists here
if(wp_ada_compliance_link_record_check($link)){
$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance_links (posttitle, link, type, postid, taxonomy, cronflag, scanflag, themetype, purgeflag, ignre, locateflag, linkstatus) values(%s, %s, %s, %d, %s, %d, %d, %s, %d, %d, %d, %s)', $title, $link, 'css', '', '',0,0, '', $purge, $ignore, $locaterecord,$response_code));	
} 
else{    

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set posttitle = %s, type = %s, ignre = %d, locateflag = %d, linkstatus = %s, link = %s WHERE link = %s or link = %s', $title, 'css',  $ignore, $locaterecord, $response_code, $link, $link, rtrim($link, '/')));	    
}

// scan css file for links    
wp_ada_compliance_rescan_css_links($link);
}

/**********************************************
// check if scan is complete
**********************************************/
function wp_ada_compliance_check_complete_status($cron=0) {
global $wpdb;   
	if ( !defined( 'DOING_CRON' ) or $cron == 0) {    
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT count(id) as count FROM '.$wpdb->prefix.'wp_ada_compliance_links where scanflag = %d and ignre = %d', 0, 0 ), ARRAY_A );
} else{
        
  $results = $wpdb->get_results( $wpdb->prepare( 'SELECT count(id) as count FROM '.$wpdb->prefix.'wp_ada_compliance_links where cronflag = %d and ignre = %d', 0, 0 ), ARRAY_A );  

}

foreach($results as $rows => $row){	

	return $row['count'];
}

}
/**********************************************
// check for existing link record
**********************************************/
function wp_ada_compliance_link_record_check($link) {
global $wpdb;   

    // check if link is a post and already saved 
$id = url_to_postid($link); 
if($id != 0){
 $results = $wpdb->get_results( $wpdb->prepare( 'SELECT type FROM '.$wpdb->prefix.'wp_ada_compliance_links where postid = %d and type != %s', $id, 'term' ), ARRAY_A );
foreach($results as $rows => $row){	
    return 0;
}
}
  // check if link is alraedy saved  
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT type FROM '.$wpdb->prefix.'wp_ada_compliance_links where link = %s limit 1', $link ), ARRAY_A );

foreach($results as $rows => $row){	

	return 0;
}
return 1;
}

/**********************************************
// get link data
**********************************************/
function wp_ada_compliance_check_for_link_record($parts){
 global $wpdb;  
	
	if($parts[0] == 'iframe' or $parts[0] == 'widget') return 1;

if($parts[0] == 'link' or $parts[0] == 'iframe' or $parts[0] == 'theme' or $parts[0] == 'css' or $parts[0] == 'pdf')  {
 $results = $wpdb->get_results( $wpdb->prepare( 'SELECT type FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and id = %d', $parts[0], $parts[1] ), ARRAY_A );
    
}
else{
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT type FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and postid = %d', $parts[0], $parts[1] ), ARRAY_A );
}
foreach($results as $rows => $row){	

    return 1;
}
    return 0;
}

/**********************************************
// check ignore status
**********************************************/
function wp_ada_compliance_link_ignore_status($link) {
global $wpdb;   
  
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT ignre FROM '.$wpdb->prefix.'wp_ada_compliance_links where link = %s', $link ), ARRAY_A );

foreach($results as $rows => $row){	
	return $row['ignre'];
}
return 0;
}

/**********************************************
// get link 
**********************************************/
function wp_ada_compliance_link_get_link($id) {
global $wpdb;   
 
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT link FROM '.$wpdb->prefix.'wp_ada_compliance_links where id = %d', $id ), ARRAY_A );

foreach($results as $rows => $row){	
echo $row['link'];
}

}

/**********************************************
// get link id
**********************************************/
function wp_ada_compliance_get_linkid_by_url($link) {
global $wpdb;   
 
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT id FROM '.$wpdb->prefix.'wp_ada_compliance_links where link = %s', $link ), ARRAY_A );

foreach($results as $rows => $row){	
return $row['id'];
}

}

/**********************************************
// retrieve link using id
**********************************************/
function wp_ada_compliance_retrieve_link($id, $type, $themetype = '') {
global $wpdb;   
  
if($type=='link' or $type=='iframe' or $type=='pdf' or $type=='css'){
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT link FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and id = %d', $type, $id ), ARRAY_A );
}
elseif($themetype != ''){

$results = $wpdb->get_results( $wpdb->prepare( 'SELECT link FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and themetype = %s and id = %d', $type, $themetype, $id ), ARRAY_A );    
}
else	{
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT link FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and postid = %d', $type, $id ), ARRAY_A );
}
	
foreach($results as $rows => $row){	
	return $row['link'];
}

}
/**********************************************
// set purge flag
**********************************************/
function wp_ada_compliance_set_link_purge_flag($link = '') {
global $wpdb;   

if($link == ''){
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set purgeflag = %d where type = %s or type = %s or type = %s or type = %s', 1, 'link', 'iframe','css','pdf'));   
}
else{
$link = rtrim($link, '/');       
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set purgeflag = %d where link = %s', 0, $link));
}
}
/**********************************************
// set locate flag to purge css and html content when no longer found
**********************************************/
function  wp_ada_compliance_set_locate_flag($type=1) {
global $wpdb;  

if($type == 1){ // set locate for css and links
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set locateflag = %d where type=%s or type=%s or type = %s or type = %s', 0, 'iframe', 'css', 'link', 'pdf'));  
}
else{// set locate for inventory links
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set locateflag = %d where type != %s and type != %s and type != %s and type != %s', 0, 'iframe','css', 'link', 'pdf')); 
}

}
/**********************************************
// update locate flag 
**********************************************/
function  wp_ada_compliance_update_locate_flag($link) {
global $wpdb;  

 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set locateflag = %d where link = %s', 1, $link));   

}
/**********************************************
// set scan flag
**********************************************/
function wp_ada_compliance_set_scan_flag($link = '') {
global $wpdb;   

if ( !defined( 'DOING_CRON' )) { // MANUAL    
if($link == ''){
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set scanflag = %d', 0));   
}
else{
//$link = rtrim($link, '/');       
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set scanflag = %d where link = %s', 1, $link));
}
}
else{ // CRONS
if($link == ''){
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set cronflag = %d', 0));   
}
else{
//$link = rtrim($link, '/');       
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set cronflag = %d where link = %s', 1, $link));
}
}     

}
/**********************************************
//set ignore flag
**********************************************/
function wp_ada_compliance_set_ignore_flag($id, $direction) {
global $wpdb;   

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d where id = %d',$direction, $id)); 
}

/**********************************************
//purge links
**********************************************/
function wp_ada_compliance_purge_links($type = 1) {
global $wpdb;   
   
  if($type == 1){  
    // remove link and css files not found anymore
 $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links where locateflag = %d and (type = %s or type = %s or type = %s or type = %s)', 0, 'css', 'link', 'pdf', 'iframe')); 
      
    // ignore the others
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d where purgeflag = %d and type != %s and type != %s and type != %s and type != %s',1, 1, 'css', 'link', 'pdf','iframe'));       
  }
  else{
 // remove inventory links
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links where locateflag = %d and type = %s and type = %s and type = %s and type = %s', 0 , 'css', 'link', 'pdf', 'iframe'));  
      
    // ignore the others
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d where purgeflag = %d and type != %s and type != %s and type != %s and type != %s',1, 1, 'css', 'link', 'pdf', 'iframe'));        
}
  
    // purge errors when matching link doesn't exist
$wpdb->query("DELETE FROM ".$wpdb->prefix."wp_ada_compliance WHERE NOT EXISTS(SELECT NULL FROM ".$wpdb->prefix."wp_ada_compliance_links WHERE ".$wpdb->prefix."wp_ada_compliance_links.id = ".$wpdb->prefix."wp_ada_compliance.postid or ".$wpdb->prefix."wp_ada_compliance_links.postid = ".$wpdb->prefix."wp_ada_compliance.postid)");

}

/**************************************************
locate pages/urls not in wordpress
***************************************************/
function wp_ada_compliance_locate_urls($content, $parenturl = ""){
    
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));

    
    
// enforce dont crawl
 $crawl_status = get_option('wp_ada_compliance_crawl_status','1');
    if($crawl_status == 0){
    return; 
}

// remove admin bar when logged in 
$content = wp_ada_compliance_remove_webadmin_bar($content);  
// remove ignored blocks on content
$content = wp_ada_compliance_remove_ignore_content_blocks($content);
	
$dom = str_get_html($content);
    
    // save iframes
if(is_array($scan_external_sources) and in_array('iframe', $scan_external_sources)){   
 
$elements = $dom->find('iframe');

foreach ($elements as $link) {
   

     $url = esc_url_raw($link->getAttribute('src'));

    if($url !=''){
         // remove fragment #xxx
    $urlparts = parse_url($url);
    if(isset($urlparts['fragment'])) 
         $url = str_replace('#'.$urlparts['fragment'],"",$url);
    
    // remove trailing ampersand
    $url = rtrim($url,'&');
    $url = rtrim($url, '#'); 
    
    // remove parameters ?var=
    //$wp_ada_compliance_include_params = get_option('wp_ada_compliance_include_params','true');  
   // if(isset($urlparts['query']) and $wp_ada_compliance_include_params == 'true') 
     //   $url = str_replace('?'.$urlparts['query'],"",$url);
    
	// remove cron parameter
	if(isset($urlparts['query']) and strstr("","?doing_wp_cron="))
	$url = str_replace('?'.$urlparts['query'],"",$url);
	
    // convert to absolute
    if(!stristr($url, 'http') and !stristr($url, '//') and $url != "") {
        if($parenturl == "") $parenturl = get_site_url();
        else {
            $urlparts = parse_url($parenturl);
            if(isset($urlparts['query'])) $parenturl = str_replace('?'.$urlparts['query'],"",$parenturl);
        }
        $url = wp_ada_compliance_rel2abs($url, $parenturl); 
    }

     if(stristr($url, get_site_url()) and strpos($url, get_site_url()) == 0 
       and wp_ada_compliance_link_record_check($url) == 1 
       and !wp_ada_compliance_checkExcludedFiles($url)){
      
        if(wp_ada_compliance_endsWith($url, '.pdf') ) $type = 'pdf';
         else $type = 'iframe';
     
     wp_ada_compliance_save_link_record((string)$url, $type); 
        
        
    } else{
      wp_ada_compliance_update_locate_flag((string)$url);   
   }
}
}
}    
    
    
// save links    
if(is_array($scan_external_sources) and in_array('linked', $scan_external_sources)){   
 
$elements = $dom->find('a');

foreach ($elements as $link) {
   

     $url = esc_url_raw($link->getAttribute('href'));

    if($url !=''){
         // remove fragment #xxx
    $urlparts = parse_url($url);
    if(isset($urlparts['fragment'])) 
         $url = str_replace('#'.$urlparts['fragment'],"",$url);
    
    // remove trailing ampersand
    $url = rtrim($url,'&');
    $url = rtrim($url, '#'); 
    
    // remove parameters ?var=
    //$wp_ada_compliance_include_params = get_option('wp_ada_compliance_include_params','true');  
   // if(isset($urlparts['query']) and $wp_ada_compliance_include_params == 'true') 
     //   $url = str_replace('?'.$urlparts['query'],"",$url);
    
	// remove cron parameter
	if(isset($urlparts['query']) and strstr("","?doing_wp_cron="))
	$url = str_replace('?'.$urlparts['query'],"",$url);
	
    // convert to absolute
    if(!stristr($url, 'http') and !stristr($url, '//') and $url != "") {
        if($parenturl == "") $parenturl = get_site_url();
        else {
            $urlparts = parse_url($parenturl);
            if(isset($urlparts['query'])) $parenturl = str_replace('?'.$urlparts['query'],"",$parenturl);
        }
        $url = wp_ada_compliance_rel2abs($url, $parenturl); 
    }

     if(stristr($url, get_site_url()) and strpos($url, get_site_url()) == 0 
       and wp_ada_compliance_link_record_check($url) == 1 
       and !wp_ada_compliance_checkExcludedFiles($url)){
      
        if(wp_ada_compliance_endsWith($url, '.pdf') ) $type = 'pdf';
         else $type = 'link';
     
     wp_ada_compliance_save_link_record((string)$url, $type); 
        
        
    } else{
      wp_ada_compliance_update_locate_flag((string)$url);   
   }
}
}
}

}

/********************************************************************
check excluded files before continuing
********************************************************************/
function wp_ada_compliance_checkExcludedFiles($url, $curl = 0){

if($url == "") return 1; 
	
// skip some extensions links
$skipfiles = array('rss', 'xltx', 'jpg', 'jpeg', 'png', 'gif', 'mov', 'avi', 'mpg', '3gp', '3g2', 'midi', 'mid', 'doc', 'dot', 'ppt', 'odt', 'pptx', 'docx', 'pps', 'ppsx', 'xls', 'xlsx', 'key', 'mp3', 'ogg', 'wma', 'm4a', 'wav', 'mp4', 'm4v', 'webm', 'ogv', 'wmv', 'flv', 'svg','css','csv');
 $fileextension = substr(strrchr($url,'.'),1);
 if(in_array(strtolower($fileextension),$skipfiles)) {
    return 1;
 }

// skip known invalid links
$invalidlinks = array('mailto:','ftp:','tel:','javascript:','alert(','/wp-admin/','/wp-login.php?action=logout');
foreach($invalidlinks  as $key => $value){    
 if(stristr($url,$value)) {
return 1;
 } 
}  
  
// check if valid url    
if (!preg_match( '/^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/i' ,$url)){
  return 1;  
} 
 
return 0;
}

/********************************************************************
check if link is broken or redirected before continuing
********************************************************************/
function wp_ada_compliance_checkRedirectedURLs($url){
   $responseheaders = array();

// get args from login routine
$args = wp_ada_compliance_process_login($url, 5);
    
$response = wp_remote_head($url, $args);	
if ( is_array( $response ) and !is_wp_error( $response )) {
$header = $response['headers']; // array of http header lines
if($header['content-type'] != "" and !strstr($header['content-type'],'text/html') and !strstr($header['content-type'],'application/pdf')) {
return 1;
}
} 
else return 1;
    
if(isset($header)){  
$filesize = $header['content-length'];
$responseheaders['last-modified'] =  date("Y-m-d H:i:s", strtotime($header['last-modified']));
}
else {
    $filesize = '';
    $responseheaders['last-modified'] = '0000-00-00 00:00:00';
}
   
$responseheaders['filesize'] = sanitize_text_field($filesize);     
$responseheaders['last-modified'] = sanitize_text_field($responseheaders['last-modified']);    
    
$sizelimit = get_option('wp_ada_compliance_file_size_limit','25'); // 25 mb
if($filesize > ($sizelimit*1048576)) {
$responseheaders['response_code'] = 'FILE SIZE LIMIT EXCEEDED';
}
else $responseheaders['response_code'] = sanitize_text_field(wp_remote_retrieve_response_code($response));	

return $responseheaders;
}

/********************************************************
deep scan links
*********************************************************/
function wp_ada_compliance_scan_ada_compliance_html_deep_scan($limit, $postid=0) {
	global $wpdb, $wp_ada_compliance_error;
    
	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(!is_array($scan_external_sources) or !in_array('linked', $scan_external_sources)) return;
    
if ( defined( 'DOING_CRON' )){ 
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where (type = %s or type = %s) and cronflag = %d and ignre = %d LIMIT %d';
$results = $wpdb->get_results( $wpdb->prepare($query, 'link', 'iframe',0, 0, $limit), ARRAY_A );    

}
elseif($postid == 0){
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where (type = %s or type = %s) and scanflag = %d and ignre = %d LIMIT %d';
$results = $wpdb->get_results( $wpdb->prepare($query, 'link', 'iframe', 0, 0, $limit), ARRAY_A );
} else{
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where (type = %s or type = %s) and ignre = %d and id = %d';  
$results = $wpdb->get_results( $wpdb->prepare($query, 'link', 'iframe', 0, $postid), ARRAY_A );
}

if($results){
foreach ( $results as $row ) {

			$postinfo['excerpt'] = '';
			$postinfo['postid'] = $row['id'];
			$postinfo['title'] = 'unknown';
           $postinfo['posttitle'] = '';
			$postinfo['type'] = $row['type'];
		    $postinfo['scantype'] = 'fullscan';	
			$postinfo['taxonomy'] = '';
	        $postinfo['wpget'] = 1;
           $postinfo['modifieddate'] = $row['modifieddate'];
   
            // try to pull content from wpget
         $scan_url = $row['link'];
    $postinfo['link'] = $scan_url;
	     
			$remotecontent = wp_ada_compliance_check_deep_scan_support($scan_url);
				
			$postinfo['content'] = $remotecontent;
						
		
	     if($postinfo['content'] != "" and strlen($postinfo['content']) > 10){
             
                                        // update post title in links table
$postinfo['posttitle'] = wp_ada_compliance_update_link_title($scan_url, $postinfo['content']);   
             
             $title = wp_ada_compliance_get_page_title_from_content($postinfo['content']);
            if($title != '')$postinfo['title'] = $title;
            
		
			// set record check flag on previous error records
			wp_ada_compliance_remove_corrected_html($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 1);
			 

             
                     // check html validation
    wp_ada_compliance_check_html_validation_errors($scan_url, $postinfo['postid'], $postinfo['title']);  
			 
			 // gather css files urls
			  wp_ada_compliance_locate_css_links($postinfo['content']);
             
             // locate other, non wordpress files
              wp_ada_compliance_locate_urls($postinfo['content'],$scan_url);
					
			// scan content database content
			wp_ada_compliance_validate_post($postinfo);
             

					
			// remove records that have been corrected
			wp_ada_compliance_remove_corrected_html($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 2);
			 
			 			 // update purge flag
			 wp_ada_compliance_set_link_purge_flag($scan_url);
             
           
             
		 }
		 if($postinfo['content'] == ""){
				// remove all records, invalid link
			wp_ada_compliance_remove_corrected_html($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 3); 
		 }


// update scan status
wp_ada_compliance_set_scan_flag($scan_url);
}
}
}

/********************************************************
inventory and check pdf on upload
*********************************************************/
function wp_ada_compliance_validate_pdf_upload($post_id, $post_type = ''){
      // save pdf links
if(get_post_mime_type($post_id) == 'application/pdf') {
$post_id = (int)$post_id;
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));     
$pdfurl = wp_get_attachment_url($post_id);
if($pdfurl != '')  $pdfurl = esc_url_raw($pdfurl);
if(in_array('pdf',$scan_external_sources))  {
wp_ada_compliance_save_link_record($pdfurl, 'pdf');   
}

// validate 
$linkid = wp_ada_compliance_get_pdf_linkid($post_id);    
wp_ada_compliance_scan_ada_compliance_pdf_deep_scan(1, $linkid);    
    
$_SESSION['my_ada_notices'] = wp_ada_compliance_get_error_list_for_post($post_id,  'pdf');
}     
}

/**********************************************
// get pdf link id
**********************************************/
function wp_ada_compliance_get_pdf_linkid($post_id) {
global $wpdb;   

$results = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where attachmentid = %d ', $post_id), ARRAY_A );

foreach($results as $rows => $row){	
    return $row['id'];
}

}
/********************************************************
deep scan pdfs
*********************************************************/
function wp_ada_compliance_scan_ada_compliance_pdf_deep_scan($limit, $postid=0) {
	global $wpdb, $wp_ada_compliance_error;
	
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(!is_array($scan_external_sources) or !in_array('pdf', $scan_external_sources)) return;
    
if ( defined( 'DOING_CRON' )){ 
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and cronflag = %d and ignre = %d LIMIT %d';
$results = $wpdb->get_results( $wpdb->prepare($query, 'pdf', 0, 0, $limit), ARRAY_A );    

}
elseif($postid == 0){
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and scanflag = %d and ignre = %d LIMIT %d';
$results = $wpdb->get_results( $wpdb->prepare($query, 'pdf', 0, 0, $limit), ARRAY_A );
} else{
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and ignre = %d and id = %d';  
$results = $wpdb->get_results( $wpdb->prepare($query, 'pdf', 0, $postid), ARRAY_A );
}

if($results){
foreach ( $results as $row ) {

			$postinfo['excerpt'] = '';
			$postinfo['postid'] = $row['id'];
			$postinfo['title'] = basename($row['link']);
            if($postinfo['title'] == '') $postinfo['title'] = 'unknown';
			$postinfo['type'] = $row['type'];
		    $postinfo['scantype'] = 'fullscan';	
			$postinfo['taxonomy'] = '';
	        $postinfo['wpget'] = 1;
           $postinfo['modifieddate'] = $row['modifieddate'];
    $postinfo['link']  = $row['link'];
    $postinfo['attachmentid']  = $row['attachmentid'];

    			$remotecontent = wp_ada_compliance_check_deep_scan_support($postinfo['link'], 'pdf');
				
			$postinfo['content'] = $remotecontent;
				
    
    	    if($postinfo['content'] != "" and strlen($postinfo['content']) > 10){
		
			// set record check flag on previous error records
			wp_ada_compliance_remove_corrected_html($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 1);

			// scan 
			wp_ada_compliance_validate_post($postinfo);
             	
			// remove records that have been corrected
			wp_ada_compliance_remove_corrected_html($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 2);
                
			 // update purge flag
			 wp_ada_compliance_set_link_purge_flag($postinfo['link']);
                
                  // update locate url
             wp_ada_compliance_update_locate_flag($postinfo['link']);
             
		 }
}
		


// update scan status
wp_ada_compliance_set_scan_flag($postinfo['link']);
}
}

/*********************************************************
remove corrected error
*******************************************************/
function wp_ada_compliance_remove_corrected_html($scantype, $postid, $type, $pre=1) {
global $wpdb;
	
if($pre == 1){
// set record flag before validating content	
$wpdb->query($wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET recordcheck = %d WHERE type = %s  and postid = %d and scantype= %s', 0, $type,$postid, $scantype) );
}elseif($pre == 2){
// after validation is complete remove previous errors that were not found
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and postid = %d and scantype= %s and recordcheck = %d', $type,$postid,$scantype, 0) );
}
elseif($pre == 3){
// remove all errors
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and postid = %d and scantype= %s', $type,$postid,$scantype) );
}
}

/*********************************************************
update link status
*******************************************************/
function wp_ada_compliance_update_link_status($url, $status, $filesize) {
global $wpdb;
if($status == '') $status = 'UNK';
$wpdb->query($wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links SET linkstatus = %s, ignre = %d, filesize = %d WHERE link = %s', $status, 1, $filesize, $url) );

}
?>