<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*
functions to support content filtering before display or posting to database
*/
/**********************************************
// modify full page content using php buffering
**********************************************/
function wp_ada_compliance_callback($buffer) {	
	global $post;
  
// add compatibilty with beaver builder
if ( class_exists( 'FLBuilderModel' ) && FLBuilderModel::is_builder_active() ) {
    return $buffer;
}
    
    // add compatibility for DVI editor
if(isset($_GET['et_fb'])){
return $buffer;
}
    
    
// correct issues with footer not loading when fatal error occurs
//$wp_ada_compliance_logged_in_skip_filter_content = get_option('wp_ada_compliance_logged_in_skip_filter_content','true');
//if($wp_ada_compliance_logged_in_skip_filter_content == 'true' and is_user_logged_in()) return $buffer;   

// enforce content filter settings	
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return $buffer;
	
// skip non html files
if(function_exists('finfo_open')) {
$finfo = new finfo(FILEINFO_MIME);
if(!strstr($finfo->buffer($buffer),'text/html')) {
	return $buffer;
}
} else return $buffer;

// return if in shutdown	(corrects issue with login page)
//if(current_filter() !=	"shutdown") return $buffer;
	
// skip non html files
if(!stristr($buffer, "<html")) {
return $buffer;	
}

// check for page exclusion
if(wp_ada_compliance_check_for_page_exclusions($_SERVER['REQUEST_URI'])) return $buffer;	

$buffer = wp_ada_compliance_change_the_content($buffer);	   
    
return trim($buffer);
}

function wp_ada_compliance_buffer_start() { 

// start filtering
ob_start("wp_ada_compliance_callback"); 
}
function wp_ada_compliance_buffer_end() { 
	if (ob_get_length() > 0) ob_end_flush(); 
}

/**************************************************
// remove nav menus and blocks of user defined code
***************************************************/
function wp_ada_compliance_remove_ignore_content_blocks($content) {
$code_block_ids = get_option('wp_ada_compliance_ignore_code_blocks',array());
if(!is_array($code_block_ids) or count($code_block_ids) == 0) return $content;    
	
	if($content == '')	return $content;
    
// ignore excluded paths
foreach($code_block_ids as $excluded_key => $excluded_value){
   
$dom = str_get_html($content);     
    
$code = $dom->find('*[id='.$excluded_value.']');
foreach ($code as $element) {
   $element->outertext = ''; 
}  
     
 $content = $dom->save();
}
    
 return $content;
}

/**********************************************
// remove web admin bar before validation
**********************************************/
function wp_ada_compliance_remove_webadmin_bar($content) {
$enable_secure_site_scans = get_option('wp_ada_compliance_enable_secure_site_scans','false');

if($enable_secure_site_scans == 'false' or $content == '') return $content;
   
$dom = str_get_html($content);     
    
$toolbar = $dom->find('div[id=wpadminbar]');
foreach ($toolbar as $element) {
   $element->outertext = ''; 
}  
     
 $content = $dom->save();
    
 return $content;
}

/**********************************************
// modify content before output to screen
**********************************************/
function wp_ada_compliance_change_the_content( $content) {
global $post, $wp_query;
    
// enforce content filter settings	
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return $content;	

	// if content empty or inside admin area don't filter
if($content == "" or wp_ada_compliance_check_is_admin()) return $content;
	
// if not php 5.4 or greater mb_convert not supported return content
if(!function_exists('mb_convert_encoding') or !version_compare(phpversion(), '5.4')) return $content;

// correct issues with encoding when website is using non utf-8	
$content = mb_convert_encoding($content, 'HTML-ENTITIES', "UTF-8");	

// does content have closing body tag?
$bodytag_found_in = strstr($content,'</body>');
    
$dom = str_get_html($content);
 
/****************************************************************
// if scanning content add marker to detect which pages to filter
****************************************************************/
if(isset($_SERVER['HTTP_USER_AGENT']) and $_SERVER['HTTP_USER_AGENT'] == 'WP ADA COMPLIANCE CRAWLER' ){
$dom = wp_ada_compliance_add_scanner_marker($dom); 

if(!is_null($dom)){
$content = $dom->save();
}
$bodytag_found_out = strstr($content,'</body>');    
if(!$bodytag_found_in and $bodytag_found_out) $content = str_replace("</body>","",$content);

return $content;
} 

/********************************************
filter content using dom
********************************************/
    // link unlinked email addresses	
$dom = wp_ada_compliance_link_email_addresses_dom($dom);
    
//convert title attributes to aria labels	
$dom = wp_ada_compliance_convert_link_title_attributes_to_aria_labels($dom);
	
// convert links titles on font awesome icon to aria-label
$dom = wp_ada_compliance_filter_font_awesome_link_title_attributes($dom);	
    
// strip empty heading and link tags
$dom = wp_ada_compliance_remove_empty_tags_dom($dom); 

// convert role-presentation class to role="presentation"
$dom = wp_ada_compliance_filter_presentation_tables($dom);

// remove invalid alt text such as image of, photo of	
$dom = wp_ada_compliance_remove_invalid_img_alt_text( $dom );	

// add title attribute to know iframe content
$dom = wp_ada_compliance_add_title_to_iframe($dom);	

// remove links from images that are linked to self	
$dom = wp_ada_compliance_remove_img_linked_to_self($dom);

// correct advanced wp columns alt text
$dom = wp_ada_compliance_correct_advanced_wp_columns($dom);		
 
    
// remove target attributes	
$striptarget = get_option('wp_ada_compliance_striptarget','addcsshover');
if($striptarget == 'remove')
$dom = wp_ada_compliance_remove_target_attributes($dom, $content);
else{
$dom = wp_ada_compliance_strip_target_attributes($dom, $content);	
}
    
    // add in page link icon - removed
//$dom = wp_ada_compliance_add_in_page_link_icon($dom);      
	
//remove redundant alt text	
// must be after remove target attributes or it will strip aria-labels and titles that are used to set opens in a new window
$dom = wp_ada_compliance_remove_redundant_alttext($dom);		
	
// correct emulating links	
$dom = wp_ada_compliance_correct_emulating_links($dom);			
    
// remove empty tables    
$dom = wp_ada_compliance_remove_empty_tables($dom); 
    
// correct elementor read more links
$dom = wp_ada_compliance_elementor_read_more($dom);  
    
        // add missing event handlers
$dom = wp_ada_compliance_correct_event_handlers($dom);
    
// remove autoplay with dom
$dom = wp_ada_compliance_filter_autoplay_av_tags_dom($dom); 
    
   // remove outline none from buttons and anchers    
$dom = wp_ada_compliance_correct_visual_focus_removed($dom, $content); 
    
       // filter Visual Forms Pro labels   
$dom = wp_ada_compliance_correct_VFP_labels($dom); 
   
// correct issues in gravity forms    
$dom = wp_ada_compliance_correct_GravityForms_labels($dom);    
    
    // correct adjacent identical links caused but elementor icon widgets
$dom = wp_ada_compliance_correct_elementor_icon_boxes($dom);    
    
    // correct adjacent identical links caused but elementor image widget
$dom = wp_ada_compliance_correct_elementor_image_boxes($dom);  
	
    // add external document icon to links (must be after elemter icon and images)
$dom = wp_ada_compliance_add_external_doc_icon($dom);  	
	
// correct elementor toggles
$dom = wp_ada_compliance_correct_elementor_toggles($dom);	
  
// correct elementor post widgets
$dom = wp_ada_compliance_correct_elementor_post_widget($dom);
	
// add aria-hidden to font awesome icons	
$dom = wp_ada_compliance_hide_empty_font_awesome_icons($dom);	
    
// correct elementor icons
//$dom = wp_ada_compliance_correct_elementor_icons($dom);
    
// correct ambiguous link text by inserting aria-label with post title	
// must be run after title tags have been converted to aria-label
// not enough benefit for the resources it would take?? maybe look at again later and include term conversions
//$dom = wp_ada_compliance_correct_ambiguous_anchor_tag($dom);	
    
//add language attribute
$dom = wp_ada_compliance_add_lang_attribute($dom); 
    
// add aria labeles to known wp forms
$dom = wp_ada_compliance_label_wp_form_landmarks($dom);  
    
// mark landmarks    
$dom = wp_ada_compliance_correct_landmarks($dom);  
    
// add focus to skip link targets    
$dom = wp_ada_compliance_allow_focus_on_skip_link_ids($dom);    
    
//add skip link (HAS TO BE DONE LAST OR WILL BREAK OTHER FILTERS)
$dom = wp_ada_compliance_add_skip_links( $dom );    

if(!is_null($dom)){
$content = $dom->save();
    
// was closing body tag added?    
$bodytag_found_out = strstr($content,'</body>');    
}
	
/*****************************************	
filter content using regular expressions
********************************************/
// change justified text
$content = wp_ada_compliance_change_justified_text($content);	
	
// convert absolute font sizes	
$content = wp_ada_compliance_change_fontsize($content);

//strip empty anchors and headings	
//$content = wp_ada_compliance_remove_empty_tags_regx( $content );	
	
// remove autoplay attributes from audio or video
//$content = wp_ada_compliance_filter_autoplay_av_tags($content);
    
 
// add protected by    
//$content  .= '<!--'.__('Protected by WP ADA Compliance','wp-ada-compliance').'-->';     

// remove closing body tag if it was added
if(!$bodytag_found_in and $bodytag_found_out) $content = str_replace("</body>","",$content);
    
return $content;
}

/**********************************************
// add scanner marker
**********************************************/
function wp_ada_compliance_add_scanner_marker( $dom) {

$html = $dom->find('html');

foreach ($html as $htmlcode) {	
$htmlcode->setAttribute('data-wp-ada-scanner', 'true');	
}
return $dom;
}

/**********************************************
// add lang attribute to html tag
**********************************************/
function wp_ada_compliance_add_lang_attribute( $dom, $bypass=1) {
if(current_filter() !=	"shutdown" and $bypass == 1) return $dom;
$addlang = get_option('wp_ada_compliance_add_lang_attribute','true');
$langcode = get_option('wp_ada_compliance_language_code','en');	
if($addlang == 'false' or $langcode == "") return $dom;

$html = $dom->find('html');

foreach ($html as $htmlcode) {	
	if (!strstr($htmlcode->getAttribute('class'),'adatemp') and $htmlcode->getAttribute('lang') == "" and $htmlcode->getAttribute('xml:lang') == "")
	$htmlcode->setAttribute('lang', esc_attr($langcode));
	}	
		
	return $dom;
}
/**********************************************
// add skip links
**********************************************/
function wp_ada_compliance_add_skip_links( $dom, $bypass=0) {
if($bypass == 0){
if(current_filter() !=	"shutdown") return $dom;

if(strstr($_SERVER['REQUEST_URI'],'wp-login.php'))   return $dom;
}

$skip_links = get_option('wp_ada_compliance_skip_links',array());	
	
if(!is_array($skip_links) or count($skip_links) < 1) return $dom;
 
$skiplinks = '';   
$targetarray = array();    
 
// check for existing main skip link
$firstlink = $dom->find('a',0);
if((stristr($firstlink->innertext,'skip to content') or stristr($firstlink->innertext,'skip to main content'))){
$firstlink->setAttribute('class', 'wp-ada-compliance-skip-link');	
$skiplinks = $firstlink->outertext;
	$firstlink->outertext = '';
    
}
    
foreach($skip_links as $link){ 

$linkarray = explode('=',$link);
  
$body = $dom->find('body',0);    
if(!stristr($skiplinks,$linkarray[0])
  and (!stristr($linkarray[0],'skip to content') 
       and !stristr($linkarray[0],'skip to main content') 
	   or (!stristr($skiplinks,'skip to content') and !stristr($skiplinks,'skip to main content')))){	
$skiplinks .= '<a href="'.esc_attr($linkarray[1]).'" class="wp-ada-compliance-skip-link">'.esc_attr($linkarray[0]).'</a>';

}
}
$body->innertext = $skiplinks.$body->innertext;

    
return $dom;

}

/****************************************************************
add focus to skip link ids
****************************************************************/
function wp_ada_compliance_allow_focus_on_skip_link_ids($dom){

$skip_links = get_option('wp_ada_compliance_skip_links',array());	
	
if(!is_array($skip_links) or count($skip_links) < 1) return $dom;
    
foreach($skip_links as $link){ 

$linkarray = explode('=',$link);
 
if(substr($linkarray[1],0,1) == '#'){    
$elements = $dom->find('[id='.ltrim($linkarray[1],'#').']');
foreach ($elements as $element) {
 $element->setAttribute('tabindex','-1');
} 
}
}
    return $dom;
}

/**********************************************
// add aria-labels to known wordpress forms 
**********************************************/
function wp_ada_compliance_label_wp_form_landmarks($dom) {
$wpformlabels = get_option('wp_ada_compliance_add_wpform_labels','true');	
	
if($wpformlabels == 'false') return $dom;    
    
$elements[] = 'form[id=commentform]';
$elements[] = 'form[id=searchform],form[data-wpadaid=searchform],form[class=elementor-search-form]';    
    
foreach ($elements as $element) {    
$tag = $dom->find($element);
foreach ($tag as $item) {
   
   if(stristr($element,'commentform') and $item->getAttribute('aria-label') == '' 
      and $item->getAttribute('aria-labelledby') == '' 
      and $item->getAttribute('aria-describedby') == '') {
      $item->setAttribute('aria-label', __('Comments','wp-ada-compliance')); 
   } 
    
   elseif(stristr($element,'search') and $item->getAttribute('aria-label') == '' 
      and $item->getAttribute('aria-labelledby') == '' 
      and $item->getAttribute('aria-describedby') == '') {
      $item->setAttribute('aria-label', __('Website Search','wp-ada-compliance'));
   } 

}
}
  return $dom;  
}
/**********************************************
add filter id to search form
***********************************************/
function wp_ada_compliance_filter_search_form( $form ) {
$wpformlabels = get_option('wp_ada_compliance_add_wpform_labels','true');	
if($wpformlabels == 'false') return $form;        
    
return str_replace('<form','<form data-wpadaid="searchform"', $form);
}
add_filter( 'get_search_form', 'wp_ada_compliance_filter_search_form' );

/**********************************************
// add ids to landmarks
**********************************************/
function  wp_ada_compliance_add_missing_ids_to_landmarks($dom) {
$tags = array('nav, [role=navigation]','main,[role=main]','aside, [role=complementary]', 'form, [role=form]','footer, [role=contentinfo]','header,[role=banner]');   

foreach($tags as $key => $value){    
$elements = $dom->find($value);
$counter = 1;
foreach ($elements as $element) {
    
if(!$element->hasAttribute('id') and $element->hasAttribute('class')){
	if($element->hasAttribute('role'))
	$id = 'landmark_'.$element->tag.'_'.$element->getAttribute('role').'_'.str_replace(' ','-',$element->getAttribute('class').'_'.$counter); 
	else
   $id = 'landmark_'.$element->tag.'_'.str_replace(' ','-',$element->getAttribute('class').'_'.$counter); 
  $element->setAttribute('id', $id);
}
$counter++;    
}
}
return $dom;
}

/**********************************************
// correct landmarks
**********************************************/
function wp_ada_compliance_correct_landmarks($dom) {

$elements[] = 'form';
$elements[] = 'aside';
$elements[] = 'main';
$elements[] = 'nav';
$elements[] = 'footer';
$elements[] = 'header';
   
$dom = wp_ada_compliance_add_missing_ids_to_landmarks($dom);  
   
// format: element|id or class|role|label = header|elementor-31278|banner|primary header
$landmark_options = get_option('wp_ada_compliance_landmarks',array());

if(!is_array($landmark_options) or count($landmark_options) < 1) return $dom;
   
   
   
foreach($landmark_options as $landmark){    

$landmarkarray = explode('|',$landmark);
if(count($landmarkarray) == 4){
$searchelement = '';      
   
if($landmarkarray[0] != 'form' and ($landmarkarray[2] == 'search' or $landmarkarray[2] == 'form'))  
$searchelement = $landmarkarray[0].'[id='.$landmarkarray[1].'] form';
else{
if($landmarkarray[0] != 'nav' and $landmarkarray[2] == 'navigation')    
$searchelement = $landmarkarray[0].'[id='.$landmarkarray[1].'] nav,';  
   
$searchelement .= $landmarkarray[0].'[id='.$landmarkarray[1].']';
}
   
$tag = $dom->find($searchelement);
foreach ($tag as $element) {

// don't update non form tags if is search
if($landmarkarray[2] == 'search'){
if($element->tag == 'form'){    

// set role    
if(!in_array($landmarkarray[0],$elements) and $element->getAttribute('role') == '' and !in_array($element->tag,$elements))
$element->setAttribute('role', $landmarkarray[2]);

// set aria label    
if($landmarkarray[3] != '')
$element->setAttribute('aria-label', $landmarkarray[3]);    

}
}
elseif($landmarkarray[2] == 'navigation'){
if($element->tag == 'nav' or $element->getAttribute('role') == 'navigation'){

// set role    
if(!in_array($landmarkarray[0],$elements) and $element->getAttribute('role') == '' and !in_array($element->tag,$elements))
$element->setAttribute('role', $landmarkarray[2]);

// set aria label    
if($landmarkarray[3] != '')
$element->setAttribute('aria-label', $landmarkarray[3]);  

}
}
elseif($landmarkarray[2] == 'form' and $landmarkarray[0] != 'form'){
if($element->tag == 'form'){  
   
// set role    
if(!in_array($landmarkarray[0],$elements) and $element->getAttribute('role') == '' and !in_array($element->tag,$elements))
$element->setAttribute('role', $landmarkarray[2]);

// set aria label    
if($landmarkarray[3] != '')
$element->setAttribute('aria-label', $landmarkarray[3]);  
   
// remove any parent roles
$dom = wp_ada_compliance_remove_role_on_div($dom, $landmarkarray);    

}
}
else{
   
   // set role        
if($landmarkarray[2] != '' and !in_array($landmarkarray[0],$elements) and $element->getAttribute('role') == '')
$element->setAttribute('role', $landmarkarray[2]);

// set aria label      
if($landmarkarray[3] != '')
$element->setAttribute('aria-label', $landmarkarray[3]);
}

}  
}
}

return $dom;

}


/**********************************************
// remove parent landmark role
**********************************************/
function wp_ada_compliance_remove_role_on_div($dom, $landmarkarray) { 
    
$searchelement = $landmarkarray[0].'[id='.$landmarkarray[1].']';
    
$tag = $dom->find($searchelement);
foreach ($tag as $element) {
 if($element->getAttribute('role') == $landmarkarray[2]){    
 $element->removeAttribute('role');
 }
}

return $dom;

}
/**********************************************
// add skip links
**********************************************
function wp_ada_compliance_add_skip_links( $dom) {	
if(current_filter() !=	"shutdown") return $dom;

if(strstr($_SERVER['REQUEST_URI'],'wp-login.php'))   return $dom;

$skip_link_id = get_option('wp_ada_compliance_skip_link_id','');	
	
if($skip_link_id == "") return $dom;

$anchor = $dom->find('a',0);
if (stristr($anchor->plaintext, 'skip') 
    and !stristr($anchor->plaintext, 'Skip to toolbar')) return $dom;

$body = $dom->find('body',0);
$skiplinktext = __('Skip to main content','wp-ada-compliance');	

$skiplink = '<a href="#'.esc_attr($skip_link_id).'" class="wp-ada-compliance-skip-link">'.$skiplinktext.'</a>';

$body->innertext = $skiplink.$body->innertext;	
	
return $dom;

}*/


/**********************************************
// modify title before saving
**********************************************/
function wp_ada_compliance_strip_html_from_title_when_saving( $content ) {
if(!is_array($content)) return $content;
	
$striphtml = get_option('wp_ada_compliance_strip_html_from_title','false');
if($striphtml == 'false') return $content;
		

$allowedhtml = get_option('wp_ada_compliance_strip_html_allowed_tags','<br>');	
	
$content['post_title'] = strip_tags($content['post_title'],$allowedhtml);
	
	return $content;
	
}

/**********************************************
// link unlinked email address anchors
**********************************************/
function wp_ada_compliance_link_email_addresses_dom($dom){

//if(current_filter() !=	"shutdown") return $dom;	
	
$link_email_addresses = get_option('wp_ada_compliance_link_email_addresses','true');

if($link_email_addresses == 'false') return $dom;
	
$tags = array('p','h1','h2','h3','h4','h5','h6','td', 'li','blockquote','address','dd','pre');
foreach($tags as $value){	
$tag = $dom->find($value);
foreach ($tag as $element) {
    
if(preg_match('/[\!#\$%&\'\*\+-\/=\?^_`\{\|\}~,;\@\[\]\.\w-]+@([\w-]+\.)+[\w-]+/',$element->plaintext, $matches)){

if(wp_ada_compliance_StartWith($matches[0])){
$code = preg_replace( '/<a.*?<\/a>(*SKIP)(*F)|[\!#\$%&\'\*\+-\/=\?^_`\{\|\}~,;\@\[\]\.\w-]+@([\w-]+\.)+[\w-]+/i', '<a href="mailto:$0">$0</a>', $element->innertext); 

    
// ignore if code includes certain values
if(!strstr($code,'<form') and !strstr($code,'value=') and !strstr($code,'<img')) 
    $element->innertext = $code;
   } 
}
}
}
if(!is_null($dom)){
$content = $dom->save();  
 $dom = str_get_html($content);   
}    
    
return $dom;
}

/**********************************************
// check if string starts with alphanumeric
**********************************************/
function wp_ada_compliance_StartWith($str) {
if(strrpos($str, "&nbsp;")) return false;
return  ctype_alnum ($str[0]);

}

/**********************************************
// convert justified text
**********************************************/
function wp_ada_compliance_change_justified_text($content){

if($content == "") return $content;
	
$changejustifiedtext = get_option('wp_ada_compliance_changejustifiedtext','left');

if($changejustifiedtext == 'false') return $content;	

$content = preg_replace( '/(text-)?align:\s?justify/i', 'text-align: '.esc_attr($changejustifiedtext), $content );	
	
return $content;
}


/**********************************************
// convert absolute font sizes to %
**********************************************/
function wp_ada_compliance_change_fontsize($content){
if($content == "") return $content;
	
$changefontsize = get_option('wp_ada_compliance_changefontsize','percent');	

if($changefontsize == 'false') return $content;

if($changefontsize == 'percent'){
$fonts['0pt'] = "0%";
$fonts['0px'] = "0%";	
	
for($i=.5; $i <= 200; $i = $i + .5){
$fonts[$i.'pt']= round($i/12*100)."%";	 	
}
	
for($i=.5; $i <= 200; $i = $i + .5){
$fonts[$i.'px']= round($i/16*100)."%";	 	
}	
}
else{
$fonts['0pt'] = "0em";
$fonts['0px'] = "0em";	
	
for($i=.5; $i <= 200; $i = $i + .5){
$fonts[$i.'pt']= ($i/12)."em";	 	
}	
for($i=.5; $i <= 200; $i = $i + .5){
$fonts[$i.'px']= ($i/16)."em";	 	
}		
}
	
foreach($fonts as $key => $value){	
	$content = preg_replace( '#font\-size:\s?'.$key.';*#i', 'font-size: '.$value.';', $content );	
	$content = preg_replace('#(font:\s?[\w\s\d*\s]*\s)('.$key.')#i', "$1 $value", $content);
}


// strip the rest	
$content = preg_replace( '#font\-size:\s?([\d*\.?\d*]+)pt;*#i', '', $content );	
$content = preg_replace( '#font\-size:\s?([\d*\.?\d*]+)px;*#i', '', $content );	
	


return $content;
}
    
    
/**********************************************
// remove target blank attributes
**********************************************/
function wp_ada_compliance_remove_target_attributes($dom, $content) {
$striptarget = get_option('wp_ada_compliance_striptarget','addcsshover');
    
if($striptarget != 'remove' or !stristr($content,'target')) return $dom;
   
$links = $dom->find('a');
foreach ($links as $link) {

if(isset($link) 
   and !stristr($link->innertext,"new window")  
   and !stristr($link->innertext,"new tab")){
   //and (!stristr($link->getAttribute('title'),"new tab") 
   // and !stristr($link->getAttribute('aria-label'),"new tab"))
  // and (!stristr($link->getAttribute('title'),"new window") 
    //and !stristr($link->getAttribute('aria-label'),"new window"))) {
	// remove target attribute
	if($link->getAttribute('target') == "_blank") $link->removeAttribute('target');
    
       if(stristr($link->getAttribute('aria-label'),"new window") or stristr($link->getAttribute('aria-label'),"new tab")) {
        $link->removeAttribute('aria-label');    
       }
    
          if(stristr($link->getAttribute('title'),"new window") or stristr($link->getAttribute('title'),"new tab")) {
        $link->removeAttribute('title');    
       }
	}
}
	
return $dom;
}

/**********************************************
// remove target attributes	
**********************************************/
function wp_ada_compliance_strip_target_attributes( $dom,$content ) {

if(!stristr($content,'target')) return $dom;    
    
/******** modify content set to open a new window *************************/	
$striptarget = get_option('wp_ada_compliance_striptarget','addcsshover');
    
if($striptarget == 'false') {
   
// remove any spans that have been added by mistake    
$spans = $dom->find('span.wp_ada_hidden');
foreach ($spans as $span) { 
$span->outertext = '';
}

return $dom;
}    
    
	
$links = $dom->find('a');
foreach ($links as $link) {
$hasimage = 0;

    
    $imagealtiscompliant = 0;
	// check embeded image for compliance
	$nodes = $link->children();
		foreach ($nodes as $node) {
			if($node->tag == "img" or $node->tag == "i") {
				if(stristr($node->getAttribute('title'),"new window") 
                   or stristr($node->getAttribute('alt'),"new window") 
				   or stristr($node->getAttribute('aria-label'),"new window")
				   or stristr($node->getAttribute('title'),"new tab") 
                    or (stristr($node->getAttribute('alt'),"new window") 
				   or stristr($node->getAttribute('aria-label'),"new tab"))){
				$imagealtiscompliant = 1;
				}
			}
			}
    
		if(isset($link) 
	   and (($link->getAttribute('target') == "_blank" 
	   or stristr($link->getAttribute('onclick'),"window.open"))) 
	   and !stristr(strip_tags($link->innertext),"new window") 
		and !stristr($link->getAttribute('title'),"new tab") 
       and !stristr($link->getAttribute('aria-label'),"new tab")
	   and !stristr($link->getAttribute('title'),"new window") 
           and !stristr($link->getAttribute('aria-label'),"new window")
          and $imagealtiscompliant != 1
	   ) {
		
            // correct add to any icons
        if(strstr($link->getAttribute('class'),'a2a_button') ){
            $link->setAttribute('aria-label', $link->getAttribute('title'));            
            $link->setAttribute("title", __('opens in a new window','wp-ada-compliance'));
        }   
            
		$nodes = $link->children;
		foreach ($nodes as $node) {
			
			if($node->tag == "img" or $node->tag == "svg" and !strstr($link->getAttribute('class'),'a2a_button')) {
				$hasimage = 1;
				$currentalt = "";
				$currentclass = $link->getAttribute('class');
				$link->setAttribute('class', esc_attr($currentclass).' adaNewWindowInfo');	
				
				if($link->getAttribute('aria-label') !="" 
           and !stristr($link->getAttribute('aria-label'),"new window") and !stristr($link->getAttribute('aria-label'),"new tab"))  $currentalt = $link->getAttribute('aria-label');
				elseif(trim($link->plaintext) != "") $currentalt = trim($link->plaintext);	
				elseif($node->getAttribute('alt') != "") $currentalt = $node->getAttribute('alt');	
				$alt = $currentalt." ".__('opens in a new window','wp-ada-compliance');			
				$link->setAttribute("aria-label", esc_html($alt));
					
				$link->innertext = '<span class="wp_ada_hidden">'.__(' opens in a new window', 'wp-ada-compliance').'</span>' . $link->innertext;
			}
		}
		// if no image was found
		if($hasimage==0){
			// add (opens in a new window) to link text
		if($striptarget == 'append' and !strstr($link->getAttribute('class'),'a2a_button')) {
		if($link->getAttribute('aria-label') !="" 
           and !stristr($link->getAttribute('aria-label'),"new window") and !stristr($link->getAttribute('aria-label'),"new tab")) {
			$arialabel = $link->getAttribute('aria-label');
			$link->setAttribute("aria-label", esc_html($arialabel).__(' opens in a new window', 'wp-ada-compliance'));
		}	
		//$newtext = __(' (opens in a new window)','wp-ada-compliance');
		$link->innertext = $link->innertext .__(' (opens in a new window)', 'wp-ada-compliance');	
			
		$currentclass = $link->getAttribute('class');
		$link->setAttribute('class', esc_attr($currentclass).' adaNewWindowInfo');	
       // if($link->hasAttribute('title'))  $link->removeAttribute('title'); 
		}
			// add icon to link
		elseif($striptarget == 'addicon' and !strstr($link->getAttribute('class'),'a2a_button')) {	
		if($link->getAttribute('aria-label') !="" 
           and !stristr($link->getAttribute('aria-label'),"new window") and !stristr($link->getAttribute('aria-label'),"new tab")) {
			$arialabel = $link->getAttribute('aria-label');
			$link->setAttribute("aria-label", esc_attr($arialabel).__(' opens in a new window', 'wp-ada-compliance'));
		}
		$currentclass = $link->getAttribute('class');
		$link->setAttribute('class', esc_attr($currentclass).' adaNewWindowInfo');	
		$link->innertext = $link->innertext. '<i class="fas fa-external-link-alt" aria-hidden="true"></i>';			
		$link->innertext = $link->innertext. '<span class="wp_ada_hidden">'.__(' opens in a new window', 'wp-ada-compliance').'</span>';
            // if($link->hasAttribute('title')) $link->removeAttribute('title');
		}
			// add hover message
		elseif($striptarget == 'addcsshover' and !strstr($link->getAttribute('class'),'a2a_button')) {
			
		if($link->getAttribute('aria-label') !=""
           and !stristr($link->getAttribute('aria-label'),"new window") and !stristr($link->getAttribute('aria-label'),"new tab")) {
			$arialabel = $link->getAttribute('aria-label');
			$link->setAttribute("aria-label", esc_html($arialabel).__(' opens in a new window', 'wp-ada-compliance'));
		}
        //if($link->hasAttribute('title')) $link->removeAttribute('title');
		$link->innertext = '<span class="wp_ada_hidden">'.__(' opens in a new window', 'wp-ada-compliance').'</span>' . $link->innertext;
			$currentclass = $link->getAttribute('class');
		$link->setAttribute('class', esc_attr($currentclass).' adaNewWindowInfo');
		}
            	// add title 
		elseif($striptarget == 'addtitle' and !strstr($link->getAttribute('class'),'a2a_button')) {
			
		if(!stristr($link->getAttribute('title'),"new window") and !stristr($link->getAttribute('title'),"new tab")) {
			$current_title = $link->getAttribute('title');
			$link->setAttribute("title", esc_html($current_title).__(' opens in a new window', 'wp-ada-compliance'));
		}
		
		}
		}
	}
}

/******** end modify content set to open a new window *************************/
	
	return $dom;
}

/*****************************************************
// add external document icon to links
******************************************************/
function wp_ada_compliance_add_external_doc_icon($dom) {
$wp_ada_compliance_correctlinks= get_option('wp_ada_compliance_correct_non_html_links','titleonly'); 
    
if($wp_ada_compliance_correctlinks == 'false') {
   
// remove any spans that have been added by mistake    
$spans = $dom->find('span.wp-ada-external');
foreach ($spans as $span) { 
$span->outertext = '';
}

return $dom;
}
    
    
$types = array();
$types[] = 'PDF/.pdf';
$types[] = 'WORD/.doc';
$types[] = 'WORD/.dot'; 
$types[] = 'EXCEL/.xls'; 
$types[] = 'RTF/.rtf'; 
$types[] = 'TEXT/.txt';
$types[] = 'CSV/.csv'; 
$types[] = 'ODT/.odt'; 
$types[] = 'RSS/.rss';  
$types[] = 'XML/.xml';  
$types[] = 'POWERPOINT/.ppt';   
$types[] = 'IMAGE/.jpg';
    $types[] = 'IMAGE/.jpeg';
$types[] = 'IMAGE/.png';
$types[] = 'IMAGE/.gif';  
$types[] = 'IMAGE/.svg';
$types[] = 'AUDIO/.mp3'; 
$types[] = 'VIDEO/.avi';
$types[] = 'VIDEO/.mov';
$types[] = 'VIDEO/.wmv'; 
$types[] = 'VIDEO/.flv';
$types[] = 'VIDEO/.mp4';
$types[] = 'VIDEO/.mkv';
$types[] = 'VIDEO/.avchd';    
        $types[] = 'EMAIL/mailto:';
    $types[] = 'PHONE/tel:';
    
$links = $dom->find('a');
foreach ($links as $link) {
foreach($types as $key => $value){
    
$parts = explode('/',$value);
    
$imagealtiscompliant = 0;
// check embeded image for compliance
$nodes = $link->children();
foreach ($nodes as $node) {

if($node->tag == "img" or $node->tag == "i") {
if(stristr($node->getAttribute('alt'),$parts[0])
or stristr($node->getAttribute('title'),$parts[0])
or stristr($node->getAttribute('aria-label'),$parts[0])
){
$imagealtiscompliant = 1;
}
}

}
if(stristr($link->getAttribute('href'), $parts[1])
and !stristr($link->plaintext,$parts[0]) 
and !stristr($link->getAttribute('title'),$parts[0]) 
and !stristr($link->getAttribute('aria-label'),$parts[0]) 
and $imagealtiscompliant == 0
) {
       
// start correction
if($wp_ada_compliance_correctlinks == 'addtitle') {  
$current_title = $link->getAttribute('title');
if($parts[0] == 'EMAIL')  $link->setAttribute("title", esc_html($current_title).__(' create new email', 'wp-ada-compliance'));   
elseif($parts[0] == 'PHONE') $link->setAttribute("title", esc_html($current_title).__(' opens phone dialer', 'wp-ada-compliance'));    
else $link->setAttribute("title", esc_html($current_title).__(' opens ', 'wp-ada-compliance').' '.esc_attr($parts[0]).' '.__(' file ', 'wp-ada-compliance'));
}
elseif($wp_ada_compliance_correctlinks == 'titleonly') {  
$currentclass = $link->getAttribute('class');
$link->setAttribute('class', esc_attr($currentclass).' wp-ada-external-popup');
if($parts[0] == 'EMAIL') $link->innertext .= '<span class="wp-ada-external">'.__('create new email', 'wp-ada-compliance').'</span>';
elseif($parts[0] == 'PHONE') $link->innertext .= '<span class="wp-ada-external">'.__('opens phone dialer', 'wp-ada-compliance').'</span>';
else $link->innertext .= '<span class="wp-ada-external">'.__('opens ', 'wp-ada-compliance').' '.esc_attr($parts[0]).' '.__(' file ', 'wp-ada-compliance').'</span>';
}elseif($wp_ada_compliance_correctlinks == 'iconandtitle') {
if($parts[0] == 'PDF') $icon = 'far fa-file-pdf';
elseif($parts[0] == 'RSS') $icon = 'far fa-file-code';
elseif($parts[0] == 'WORD') $icon = 'far fa-file-word';
elseif($parts[0] == 'EXCEL') $icon = 'far fa-file-excel';
elseif($parts[0] == 'VIDEO') $icon = 'far fa-file-video';
elseif($parts[0] == 'AUDIO') $icon = 'far fa-file-audio';
elseif($parts[0] == 'IMAGE') $icon = 'far fa-file-image';
elseif($parts[0] == 'POWERPOINT') $icon = 'far fa-file-powerpoint';    
elseif($parts[0] == 'CSV') $icon = 'fas fa-file-csv';
elseif($parts[0] == 'XML') $icon = 'far fa-file-code';
elseif($parts[0] == 'EMAIL') $icon = 'far fa-envelope';
elseif($parts[0] == 'PHONE') $icon = 'fas fa-mobile-alt';
else $icon = 'far fa-file-alt';

if($parts[0] == 'EMAIL') $link->innertext = $link->innertext. '<i class="'.$icon.' wp-ada-external" title = "'.__('create new email', 'wp-ada-compliance').'"></i>';
elseif($parts[0] == 'PHONE') $link->innertext = $link->innertext. '<i class="'.$icon.' wp-ada-external" title = "'.__('opens phone dialer', 'wp-ada-compliance').'"></i>';    
else $link->innertext = $link->innertext. '<i class="'.$icon.' wp-ada-external" title = "'.__('opens ', 'wp-ada-compliance').' '.esc_attr($parts[0]).' '.__('file','wp-ada-compliance').'"></i>';	
}
}
}
}    
    
return $dom;    
}

/*****************************************************
// add in page link icon - removed 
******************************************************
function wp_ada_compliance_add_in_page_link_icon($dom) {
$wp_ada_compliance_correctlinks= get_option('wp_ada_compliance_correct_link_to_in_page_content','titleonly'); 
if($wp_ada_compliance_correctlinks == 'false') return $dom;
    
$links = $dom->find('a');
foreach ($links as $link) {
 
$imagealtiscompliant = 0;
// check embeded image for compliance
$nodes = $link->children();
foreach ($nodes as $node) {

if($node->tag == "img" or $node->tag == "i") {
if(stristr($node->getAttribute('alt'), __('in page link','wp-ada-compliance'))
or stristr($node->getAttribute('title'), __('in page link','wp-ada-compliance'))
or stristr($node->getAttribute('aria-label'),__('in page link','wp-ada-compliance')) 
){
$imagealtiscompliant = 1;
}
}

}
if(substr($link->getAttribute('href'), 0, 1) == '#' 
and strlen($link->getAttribute('href')) > 1
and !stristr($link->plaintext, __('skip','wp-ada-compliance')) 
and !stristr($link->getAttribute('class'), __('skip-link','wp-ada-compliance'))
and !stristr($link->getAttribute('class'), __('screen-reader-text','wp-ada-compliance')) 
and !stristr($link->plaintext, __('in page link','wp-ada-compliance')) 
and !stristr($link->getAttribute('title'), __('in page link','wp-ada-compliance')) 
and !stristr($link->getAttribute('aria-label'), __('in page link','wp-ada-compliance')) 
and $imagealtiscompliant == 0
) {
       
// start correction
if($wp_ada_compliance_correctlinks == 'titleonly') {  
$currentclass = $link->getAttribute('class');
$link->setAttribute('class', esc_attr($currentclass).' wp-ada-external-popup');
$link->innertext .= '<span class="wp-ada-external wp-ada-inpagelink">'.' '.__('opens in page link or tab', 'wp-ada-compliance').'</span>';
}elseif($wp_ada_compliance_correctlinks == 'iconandtitle') {
$icon = 'fas fa-level-down-alt';

$link->innertext = $link->innertext. '<i class="'.$icon.' wp-ada-external wp-ada-inpagelink" title = "'.__('opens in page link or tab','wp-ada-compliance').'"></i>';	
}
}
}    
    
return $dom;    
}*/


/*****************************************************
// replace ambiguous anchor text in video shortcode
******************************************************/
function wp_ada_compliance_video_handler($html) {
    $edit_embed_code = get_option('wp_ada_compliance_edit_embed_code','true');
    if($edit_embed_code == 'true') {
	$text = __('View Video','wp-ada-compliance');
	$pattern = '/<a href=("|\')+(.*?)("|\')+[^>]*>(.*?)<\/a>/i';
	$replacement = '<a href="$2">'.esc_attr($text).'</a>';
	$html =  preg_replace($pattern, $replacement, $html, -1 );
    }
	
	return $html;
}
/*****************************************************
// replace ambiguous anchor text in audio shortcode
******************************************************/
function wp_ada_compliance_audio_handler($html) {
     $edit_embed_code = get_option('wp_ada_compliance_edit_embed_code','true');
    if($edit_embed_code == 'true') {
	$text = __('Listen to Audio','wp-ada-compliance');
	$pattern = '/<a href=("|\')+(.*?)("|\')+[^>]*>(.*?)<\/a>/i';
	$replacement = '<a href="$2">'.esc_attr($text).'</a>';
	$html =  preg_replace($pattern, $replacement, $html, -1 );
    }
	return $html;
}
/*****************************************************
// replace embed shortcode to support title attribute
******************************************************
function wp_ada_compliance_embed_handler_html($html, $url, $attributes, $post_id ) {
	$edit_embed_code = get_option('wp_ada_compliance_edit_embed_code','true');
	
	if($edit_embed_code == 'false') return $html;

	 // Bail if this isn't an iframe
    if ( strpos( $html, '<iframe' ) === false ) {
        return $html;
    }
    // Bail if the attributes already contain a title
    if ( array_key_exists( 'title', $attributes ) ) {
        $title = $attributes['title'];
    }else{
	$title = "";
    // Define the title for the iframe, depending on the source content
    // List is based on supported Video and Audio providers at https://codex.wordpress.org/Embeds
    $url = parse_url( $url );
	
    switch ( str_replace( 'www.', '', $url['host'] ) ) {
			
       // media 
		case 'cloudup.com': 
		case 'facebook.com':
		case 'flickr.com':
		case 'imgur.com':
		case 'instagram.com':	
		case 'issuu.com':
		case 'kickstarter.com': 
		case 'meetup.com':
		case 'mixcloud.com':
		case 'photobucket.com':	
		case 'reddit.com':	
		case 'speakerdeck.com':
		case 'scribd.com':	
		case 'slideshare.net':	
		case 'smugmug.com': 
		case 'tumbler.com':
		case 'twitter.com': 	
		case 'wordpress.org':	
  	    $title = __( 'Media in iframe on: ', 'wp-ada-compliance' );
        $title .= $url['host'];
        break;
			
		// polls 
		case 'polldaddy.com':
			
	    $title = __( 'Poll or Survey in iframe on: ', 'wp-ada-compliance' );
        $title .= $url['host'];
        break;	
			
// Video 
        case 'animoto.com':
        case 'blip.com':
        case 'collegehumor.com':
        case 'dailymotion.com':
        case 'funnyordie.com':
        case 'hulu.com':
        case 'ted.com':
        case 'videopress.com':
        case 'vimeo.com':
        case 'vine.com':
        case 'wordpress.tv':
        case 'youtube.com':
             $title = __( 'Video in iframe on:', 'wp-ada-compliance' );
            $title .= $url['host'];
            break;
       // Audio
    
        case 'mixcloud.com':
        case 'reverbnation.com':
        case 'soundcloud.com':
        case 'spotify.com':
            $title = __( 'Audio in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
            break;
       //Handle any other URLs here, via further code
       
        default:
            $title = apply_filters( 'wp_ada_compliance_embed_handler_html', $title, $url );
            break;
    }
	}
	if($title == "") $title = 'Audio/Video Player';
    // Add title to iframe, depending on the oembed provider
    $html = str_replace( '></iframe>', ' title="' . esc_attr($title) . '"></iframe>', $html );
    // Return
    return $html;
}*/
/*****************************************************
// add title to iframes with known embed types such as youtube
******************************************************/
function wp_ada_compliance_add_title_to_iframe($dom) {
$edit_embed_code = get_option('wp_ada_compliance_edit_embed_code','true');
if($edit_embed_code == 'false') return $dom;

$iframes = $dom->find('iframe');
	
foreach ($iframes as $iframe) {
	if($iframe->getAttribute('title') == "")	{
  
	$title = "";
    // Define the title for the iframe, depending on the source content
    // List is based on supported Video and Audio providers at https://codex.wordpress.org/Embeds

    $url = parse_url($iframe->getAttribute('src'));
		
	if(is_array($url) and array_key_exists('host',$url)) {

    switch ( str_replace( 'www.', '', $url['host'] ) ) {
			
        /* media */
		case 'cloudup.com': 
		case 'facebook.com':
		case 'flickr.com':
		case 'imgur.com':
		case 'instagram.com':	
		case 'issuu.com':
		case 'kickstarter.com': 
		case 'meetup.com':
		case 'mixcloud.com':
		case 'photobucket.com':	
		case 'reddit.com':	
		case 'speakerdeck.com':
		case 'scribd.com':	
		case 'slideshare.net':	
		case 'smugmug.com': 
		case 'tumbler.com':
		case 'twitter.com': 	
		case 'wordpress.org':	
	    $title = __( 'Media in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
        break;
			
		/* polls * */
		case 'polldaddy.com':
			
	    $title = __( 'Poll or Survey in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
        break;	
			
							/* google maps * */
		case 'google.com':
		if(array_key_exists('path',$url) and stristr($url['path'],'maps/embed')){	
	    $title = __( 'Map in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
        break;	
		}
			
		/*** Video */
        case 'animoto.com':
        case 'blip.com':
        case 'collegehumor.com':
        case 'dailymotion.com':
        case 'funnyordie.com':
        case 'hulu.com':
        case 'ted.com':
        case 'videopress.com':
        case 'vimeo.com':
        case 'vine.com':
        case 'wordpress.tv':
            case 'youtu.be':
        case 'youtube.com':
            $title = __( 'Video in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
            break;
			
				/*** calendar */
        case 'calendar.google.com':
            $title = __( 'Calendar in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
            break;
			
							/*** google tag manager */
        case 'googletagmanager.com':
            $title = __( 'Google Tag Manager in iframe', 'wp-ada-compliance' );
            break;	
			
        /**
         * Audio
         */
        case 'mixcloud.com':
        case 'reverbnation.com':
        case 'soundcloud.com':
        case 'spotify.com':
            $title = __( 'Audio in iframe on: ', 'wp-ada-compliance' );
            $title .= $url['host'];
            break;
        /**
         * Handle any other URLs here, via further code
         */
        default:
        $title = "";
            break;
    }
	}
            if(is_array($url) and array_key_exists('path',$url)) {
            if(stristr($url['path'],'.wav')) $title = __( 'Audio Player', 'wp-ada-compliance' );  
        elseif(stristr($url['path'],'.mp3')) $title = __( 'Audio Player', 'wp-ada-compliance' );
        elseif(stristr($url['path'],'.mp4')) $title = __( 'Video Player', 'wp-ada-compliance' ); 
        }
	
		if($title != "") $iframe->setAttribute('title', esc_attr($title));
	}
}

			

    // Return
    return $dom;
}
/**********************************************
// remove title attributes from links (menu links)
**********************************************
function wp_ada_compliance_remove_title_attributes($content) {
	
$strip_redundant_alt_txt = get_option('wp_ada_compliance_strip_redundant_alt_txt','true');	
if($strip_redundant_alt_txt == 'false' or $content == "") 	return $content;	

// if not php 5.4 or greater mb_convert not supported return content
if(!function_exists('mb_convert_encoding') or !version_compare(phpversion(), '5.4')) return $content;

// correct issues with encoding when website is using non utf-8	
$content = mb_convert_encoding($content, 'HTML-ENTITIES', "UTF-8");	

$dom = str_get_html($content); 
	
// redundant title text
$links = $dom->find('a');
foreach ($links as $link) {
   
	if($link->getAttribute('title') != ""){
      if (isset($link) and 
		  wp_ada_compliance_compare_strings($link->plaintext,$link->getAttribute('title'))) {
		$link->removeAttribute('title');		
		
	   		}
		}
}	
// filter link titles attributes
$dom = wp_ada_compliance_filter_link_title_attributes($dom, $content);	

if(!is_null($dom)){	
$content = $dom->save();
}
	
return $content;	

}*/
/**********************************************
// remove redundant alt text other
**********************************************/
function wp_ada_compliance_remove_redundant_alttext($dom) {
$strip_redundant_alt_txt = get_option('wp_ada_compliance_strip_redundant_alt_txt','true');	
if($strip_redundant_alt_txt == 'false') return $dom;		
	
/******** remove redundant title tags *************************/		
// redundant title text
$links = $dom->find('a');
foreach ($links as $link) {
     
// correct add to any icons
if(strstr($link->getAttribute('class'),'a2a_button') and $link->getAttribute('title') != __('opens in a new window','wp-ada-compliance') ){
$link->setAttribute('aria-label', $link->getAttribute('title'));
$link->removeAttribute('title');
}     
	
// remove title/arial-label that are redundant
$attributes = array('title','aria-label');    
foreach($attributes as $value)  {     
    
if($link->getAttribute($value) != ""){   
if (wp_ada_compliance_compare_strings($link->innertext, $link->getAttribute($value))) {
$link->removeAttribute ($value);	
}
}
}
}

// redundant title tags from links wrapping images with alt text that is the same
$links = $dom->find('a');
foreach ($links as $link) {
if($link->getAttribute('title') != "" or $link->getAttribute('aria-label') != ""){
$images = $link->find('img');
foreach ($images as $image) {
if($image->getAttribute('alt') != ""){
$attributes = array('title','aria-label');    
foreach($attributes as $value)  {  
if (wp_ada_compliance_compare_strings($link->getAttribute($value),$image->getAttribute('alt'))) {
$link->removeAttribute($value);	
}
}
}
}
}
}
	
// remove titles and aria-labels on images when they are the same as the alt text
$images = $dom->find('img');
foreach ($images as $image) {
if (isset($image) ){
$attributes = array('title','aria-label');    
foreach($attributes as $value)    
if(wp_ada_compliance_compare_strings($image->getAttribute($value),$image->getAttribute('alt'))) { 
$image->removeAttribute($value);	
}
}
}
    	
/******** remove redundant alt text on image inside anchor *************************/
$links = $dom->find('a');
foreach ($links as $link) {

$images = $link->find('img');
foreach ($images as $image) {
if($image->getAttribute('alt') != ""){
if (isset($link) and isset($image)) {
    
$attributes = array('alt','title','aria-label');     
    
foreach($attributes as $value)    
if(wp_ada_compliance_compare_strings($link->innertext, $image->getAttribute($value))) {
$image->setAttribute($value, '');		
}
    
}
}
}
}
    
/******** remove redundant alt text on image with parent that includes the same text *************************/
$images = $dom->find('img');
foreach ($images as $image) {


$attributes = array('alt','title','aria-label');  
foreach($attributes as $value){
    
    
// check if enclosed in an anchor
if(is_object($image->parent()) and $image->parent()->tag == 'a'){ 
$parentanchor = 1;
} else $parentanchor = 0;

// check parent tag  
if(is_object($image->parent()) and $image->parent()->tag != 'a'){   
    $parent = $image->parent();
}
elseif(is_object($image->parent()->parent())){  
    $parent = $image->parent()->parent();

}    

if(is_object($parent) and $parentanchor != '1'){  

$parentstext = $parent->plaintext; 
if($parentstext != '' and $image->getAttribute($value) != ""){    
if(wp_ada_compliance_compare_strings($parentstext, $image->getAttribute($value))){
$image->setAttribute($value, '');
$image->setAttribute('alt', '');    
}   
}
 
if(is_object($parent->prev_sibling())){       
$prevelementtext = $parent->prev_sibling()->plaintext; 
if($prevelementtext != '' and $image->getAttribute($value) != ""){    
if(wp_ada_compliance_compare_strings($prevelementtext, $image->getAttribute($value))){
$image->setAttribute($value, '');
$image->setAttribute('alt', '');    
}   
}
}
 
if(is_object($parent->next_sibling())){       
$nextelementtext = $parent->next_sibling()->plaintext;
if($nextelementtext != '' and $image->getAttribute($value) != ""){    
if(wp_ada_compliance_compare_strings($nextelementtext, $image->getAttribute($value))){
$image->setAttribute($value, '');
$image->setAttribute('alt', '');    
}   
} 
}
    
}
}
}
    
/* NO LONGER NEEDED
remove redundant alt text in figure 

$anchor = "";	
$figures = $dom->find('figure');
foreach ($figures as $figure) {

    
$figurecaption = $figure->find('figcaption',0);
$image = $figure->find('img',0);
$anchor = $figure->find('a',0);
if(isset($figurecaption)){

$figcaptioncode = strip_tags($figurecaption->innertext);

if($anchor == "" and isset($image)){
$attributes = array('alt','title','aria-label'); 
    
foreach($attributes as $value)
if(wp_ada_compliance_compare_strings($figcaptioncode, $image->getAttribute($value)) and $image->getAttribute($value) != ""){
$image->setAttribute($value, '');
}

}
}
}	
	
//remove redundant alt text in div 
$figuredivs = $dom->find('div[class=wp-caption]');
foreach ($figuredivs as $figure) {

$figurecaption = $figure->find('p',0);
$anchor = $figure->find('a',0);
if($anchor == "" and isset($figurecaption) and stristr($figurecaption->getAttribute('class'),'wp-caption')){	
$image = $figure->find('img',0);
$figcaptioncode = $figurecaption->plaintext;

if($anchor == "" and isset($image)){
$attributes = array('alt','title','aria-label'); 
    
foreach($attributes as $value)
if(wp_ada_compliance_compare_strings($figcaptioncode, $image->getAttribute($value)) and $image->getAttribute($value) != ""){
$image->setAttribute($value, '');

}
}
}
}

	
//remove redundant alt text in dl tags
$figuredivs = $dom->find('dl');
foreach ($figuredivs as $figure) {


$figurecaption = $figure->find('dd',0);
$anchor = $figure->find('a',0);
if($anchor == "" and isset($figurecaption) 
and stristr($figurecaption->getAttribute('class'),'wp-caption-text')){	
$image = $figure->find('img',0);
$figcaptioncode = $figurecaption->plaintext;

if($anchor == "" and isset($image)){
$attributes = array('alt','title','aria-label'); 
    
foreach($attributes as $value)
if(wp_ada_compliance_compare_strings($figcaptioncode, $image->getAttribute($value)) and $image->getAttribute($value) != ""){
$image->setAttribute($value, '');

}
}
}
}
*/
	
return $dom;

}

/**********************************************
// correct advanced wp columns alt text
**********************************************/
function wp_ada_compliance_correct_advanced_wp_columns( $dom ) {
	
	if(  wp_ada_compliance_is_plugin_active( 'advanced-wp-columns/advanced-wp-columns.php' ) ){
		$images = $dom->find('img');
		foreach ($images as $image) {
		if($image->getAttribute('alt') == "" and strstr($image->getAttribute('src'), "advanced-wp-columns/assets/js/plugins/views/img/1x1-pixel.png"))	{
		$image->setAttribute('alt', '');
		}
		}
		
	}// end advanced wp columns check
	
return $dom;	
}


/**********************************************
// remove empty tags from content 
**********************************************/
function wp_ada_compliance_remove_empty_tags_dom( $dom ) {
$striptags = get_option('wp_ada_compliance_striptags','true');
if($striptags == 'false') return $dom;

	// strip empty heading tags
	for ($i = 1; $i <= 6; $i++) {
	$headings = $dom->find('h'.$i);
	foreach ($headings as $heading) {

		if (str_ireplace(array(' ','&nbsp;','-','_'),'',trim(htmlentities($heading->plaintext))) == "" or str_ireplace(array(' ','&nbsp;','-','_'),'',trim($heading->plaintext))== "") {
			$img = $heading->find('img',0);
			if(!isset($img) or $img->getAttribute('alt') == ""){ 
			$heading->outertext = $heading->innertext; 
		}
		}
	}
	}
	
	// strip empty links
	$links = $dom->find('a');

	foreach ($links as $link) {
	
		$i = $link->find('i',0);
		$span = $link->find('span',0);
		$img = $link->find('img',0);
        $svg = $link->find('svg',0);
		$input = $link->find('input',0);
		$button = $link->find('button',0);
        $div = $link->find('div',0);
		$style = $link->getAttribute('style');
        
		if(isset($i) and $i->getAttribute('class') != "") $class = $i->getAttribute('class');
		elseif(isset($span) and $span->getAttribute('class') != "") $class = $span->getAttribute('class');
		else $class = 'empty';
		
		// remove empty links with non empty
		if (!stristr($class, 'fa-')
            and  !stristr($link->getAttribute('class'), 'a2a_')
            and !stristr($class, 'a2a_')
			and !isset($img)
            and !isset($svg)
			and !isset($input)
			and !isset($button)
            and !isset($div)
            and (!isset($span) or $class == 'empty')
            and (!isset($i) or $class == 'empty')
             and (!strstr($style,'background-image: url(http'))
            and (!strstr($style,'background-image:url(http'))
			and $link->hasAttribute('href')
			 and $link->getAttribute('name') == ""
			and $link->getAttribute('id') == ""
			and $link->getAttribute('aria-label') == "" 
            and $link->getAttribute('aria-labelledby') == "" 
            and $link->getAttribute('aria-describedby') == "" 
			and $link->getAttribute('title') == "" 
			and str_ireplace(array(' ','&nbsp;','-','_'),'',trim($link->plaintext)) == "") {			
  
            
            $link->outertext = $link->innertext; 

		}
		
		
	}
			
return $dom;
}
/*************************************************************
// remove empty tags from content with regular expressions
*************************************************************
function wp_ada_compliance_remove_empty_tags_regx( $content ) {
$striptags = get_option('wp_ada_compliance_striptags','true');
if($striptags == 'false') return $content;

// replace tags without images
for ($i = 1; $i <= 6; $i++) {
	$content = preg_replace( '#<h'.$i.'(\s)*(class=("|\')(\w|\s)*("|\'))*>(\n|\s|\r)*(<\w*>(\s)*</\w*>)*(\s)*(&nbsp;|\s)*</h'.$i.'>#is', '', $content );	
	
	// replace tags with images inside
	//$content = preg_replace( '/<h'.$i.'(\s)*(class=("|\')(\w|\s)*("|\'))*>(\s|&nbsp;)*(<a(\s|\w|[[:punct:]])[^><]*>)*(\s|&nbsp;)*(<img(\s|\w|[[:punct:]])[^><]*(\/)*>(<\/img>)*(?!\w))(\s|&nbsp;)*(<\/a>)*(\s|&nbsp;)*<\/h'.$i.'>/is', '$7$10$15', $content);
	}

// strip empty anchor tags	
// matches empty links without an href with empty span inside
//$content = preg_replace( '#<a((?=[^>]*href=))((?![^>]*aria-label=))((?![^>]*title=))[^>]*>(\s|&nbsp;)*(<br\s*\/*>)*(\s|&nbsp;)*((<span(?!\/)[^>]+>){1}(<\/span>))*<\/a>#', '', $content);	
//$content = preg_replace( '#<a((?=[^>]*href=))((?![^>]*style=("|\')background-image:\s*url\())((?![^>]*aria-describedby=))((?![^>]*aria-labelledby=))((?![^>]*aria-label=))((?![^>]*title=))[^>]*>(\s|&nbsp;)*(<br\s*\/*>)*(\s|&nbsp;)*((<span(?!\/)[^>]+>){1}(<\/span>))*<\/a>#', '', $content);	
	
return $content;
}*/

/***********************************************************************************
// Filter read more links to include aria label with post title
**********************************************************************************/
function wp_ada_compliance_modify_read_more_link() {
	$wp_ada_compliance_modify_read_more_links = get_option('wp_ada_compliance_modify_readmore_links','true');
	
	if($wp_ada_compliance_modify_read_more_links != 'true') return;
	if(phpversion() > 5.4) {
	 $backtrace = debug_backtrace();
	if($key = array_search('rpwe_get_recent_posts', array_column($backtrace, 'function'))) return;
	}
	
	$linktext = get_option('wp_ada_compliance_read_more_link_text',' Read More &#187;');
    return ' <a class="more-link" aria-label="'.__('Read more about ', 'wp-ada-compliance').esc_html(strip_tags(get_the_title())).'" href="' . esc_url(get_permalink()) . '">'.esc_html($linktext).'</a>';
}
// Replaces the excerpt "Read More" text by a link
function wp_ada_compliance_new_excerpt_more($more) {
	
	$wp_ada_compliance_modify_read_more_links = get_option('wp_ada_compliance_modify_readmore_links','true');
	if($wp_ada_compliance_modify_read_more_links != 'true') return;
	
	if(phpversion() > 5.4) {
	 $backtrace = debug_backtrace();
	if($key = array_search('rpwe_get_recent_posts', array_column($backtrace, 'function'))) return;
	}
	
	$linktext = get_option('wp_ada_compliance_read_more_link_text',' Read More &#187;');
       global $post;
	return ' <a class="more-link" aria-label="'.__('Read more about ', 'wp-ada-compliance').esc_html(strip_tags(get_the_title($post->ID))).'" href="'. esc_url(get_permalink($post->ID)) . '">'.esc_html($linktext).'</a>';
}

/*******************************************************
// Replaces the "Read More" text in elementor posts
********************************************************/
function wp_ada_compliance_elementor_read_more($dom) {
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
if(!is_plugin_active('elementor/elementor.php')) return $dom;        
	
	$wp_ada_compliance_modify_read_more_links = get_option('wp_ada_compliance_modify_readmore_links','true');
	if($wp_ada_compliance_modify_read_more_links != 'true') return $dom;
	
	$linktext = get_option('wp_ada_compliance_read_more_link_text',' Read More &#187;');
    if($linktext == '')	return $dom;
	
    $links = $dom->find('a[class=elementor-post__read-more]');

    foreach ($links as $link) {
       $url = $link->getAttribute('href');
    $back_id = url_to_postid($url);
    if( $back_id > 0 ){
     $back_title = get_the_title( $back_id );
     $replacement = __('Read more about ', 'wp-ada-compliance').$back_title;
    
        $link->removeAttribute('aria-label');
      $link->setAttribute("aria-label", esc_html(strip_tags($replacement))); 	 
    }
    }
    return $dom;
}

/*******************************************************
// add aria-hidden to font awesome icons server side
********************************************************/
function wp_ada_compliance_hide_empty_font_awesome_icons($dom) {
	
$setting = get_option('wp_ada_compliance_hide_font_awesome_icons','true');
if($setting == 'false') return $dom;

$icons = $dom->find('i[class*=fa-]');

foreach ($icons as $icon) {
if($icon->getAttribute('aria-label') == '' and $icon->getAttribute('title') == '' and $icon->innertext == '' and $icon->getAttribute('aria-hidden') == ''){ 

$icon->setAttribute("aria-hidden", 'true');
}
}

return $dom;
}

/**************************************************************
// add aria hidden to font awesome icons using jqeury
***************************************************************/
add_action('wp_footer','wp_ada_compliance_hide_font_awesome_icons_script'); 
function wp_ada_compliance_hide_font_awesome_icons_script(){

$setting = get_option('wp_ada_compliance_hide_font_awesome_icons','true');
if($setting == 'false') return;
    
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return;      
 ?>
  <script>
if(jQuery){	  
jQuery(document).ready(function($){	
setTimeout(function(){	
$('i[class*=fa-]').each(function( ) {

	if(($(this).attr('title') === undefined || $(this).attr('title') === '')
	  && ($(this).attr('aria-label') === undefined || $(this).attr('aria-label') === '') && $(this).is(':empty')){
		$(this).attr('aria-hidden', 'true');
	}
});
}, 500);	
}); 
}
</script>
 <?php
}	


/***********************************************************************************
// remove autoplay attributes from audio and video embeds (FLAGGED FOR REMOVAL NO LONGER REQUIRED)
**********************************************************************************/
function wp_ada_compliance_filter_autoplay_av_tags($content, $run=0){
	$strip_autoplay = get_option('wp_ada_compliance_strip_autoplay','true');

	if($strip_autoplay == 'true' or $run == 1){
	
	$content= str_ireplace('autostart="true"', "", $content);	
	$content= str_ireplace(' controls autoplay', " controls", $content);		
	$content= str_ireplace("autostart='true'", "", $content);	
	$content= str_ireplace('&autoPlay=true', "", $content);
	$content= str_ireplace('&amp;autoPlay=true', "", $content);	
        $content= str_ireplace('autoplay="true"', "", $content);
        $content= str_ireplace("autoplay='true'", "", $content);

	$content= str_ireplace('autoPlay="autoplay"', "", $content);
		$content= str_ireplace('autoplay=""', "", $content);
		$content= str_ireplace("autoplay=''", "", $content);	
	$content= str_ireplace("autoPlay='autoplay'", "", $content);
		$content= str_ireplace('autoPlay="1"', "", $content);
	$content= str_ireplace("autoPlay='1'", "", $content);	
	
      // only use when displayinga  report. Can break websites when run as a filter. Using DOM instead
    if($run == 1){
        $content = preg_replace('/<param(\s)*name=(\'|")+(autoplay)(\'|")+(\/)*(\s)*value=(\'|")+(true)(\'|")+(\s*\/*>)(<\/param>)*/i','', $content);
        $content = preg_replace('/(<audio+.+)((\s)((\S)+=("|\')(\w|\s|-|_)*("|\'))*(\s))*(autoplay)+(((\s)*((\S)+=("|\')(\w|\s|-|_)*("|\'))*(\s)*)*>)/i','$1$11', $content);
		$content = preg_replace('/(<video+.+)((\s)((\S)+=("|\')(\w|\s|-|_)*("|\'))*(\s))*(autoplay)+(((\s)*((\S)+=("|\')(\w|\s|-|_)*("|\'))*(\s)*)*>)/i','$1$11', $content);
    }
	}
	
	return $content;
}

/***********************************************************************************
// remove autoplay using dom
**********************************************************************************/
function wp_ada_compliance_filter_autoplay_av_tags_dom($dom){
$strip_autoplay = get_option('wp_ada_compliance_strip_autoplay','true');
if($strip_autoplay == 'false')	return $dom;
	
$elements = $dom->find('audio,video, param');
	
foreach ($elements as $element) {
 if(!strstr($element->getAttribute('class'),'wp-ada-no-convert')){   
if($element->hasAttribute('autoplay'))
$element->removeAttribute('autoplay');
    
if($element->tag == 'param'){	    
if($element->getAttribute('name') == 'autoplay' and $element->getAttribute('value') == 'true') {
   $element->setAttribute('value', 'false');
}
}
}
}
	
	return $dom;
}
/***********************************************************************************
// convert links titles on font awesome icon to aria-label
**********************************************************************************/
function wp_ada_compliance_filter_font_awesome_link_title_attributes($dom){
$link_titles = get_option('wp_ada_compliance_link_titles_font_awesome','true');
$conversiontext = get_option('wp_ada_compliance_font_awesome_conversion_text','');
    
if($link_titles == 'false' or $conversiontext == "")	return $dom;
	
$links = $dom->find('a');
	
foreach ($links as $link) {
	
$elements = $link->find("*");
foreach ($elements as $i) {

if(isset($i) and trim($link->plaintext) == ''){
if($i->tag != 'img'){	
$titletext = $link->getAttribute('title');	
$class = $link->getAttribute('class');	
if($class == '') $class = 'empty';
if($titletext == "" and $link->getAttribute('aria-label') == "" and $i->getAttribute('class') != '' and !stristr($class,"no-title-convert") and $replacement = wp_ada_compliance_get_font_awesome_icons_alt_text($i->getAttribute('class'))){

$link->removeAttribute('aria-label');
$link->setAttribute("aria-label", esc_attr($replacement));
$i->setAttribute("title", esc_attr($replacement));     
}
}
 }
}
}
	
	return $dom;
}
/***********************************************************************************
// identify and choose the text for adding titles to various font-awesome icons
**********************************************************************************/
function wp_ada_compliance_get_font_awesome_icons_alt_text($class){

$icons = array();	

// over ride with user defined text
$conversiontext = get_option('wp_ada_compliance_font_awesome_conversion_text','');

if($conversiontext != ""){
$usericons = preg_split( '/\r\n|\r|\n/', $conversiontext);

foreach ($usericons as $value1) {
	$usericon = explode('=',$value1);
    $icons[$usericon[0]] = $usericon[1];	
}
}	

if(count($icons) > 0) {	
foreach ($icons as $key => $value) {

	if(stristr("$class",$key)) {
		return $value;
	}
}
}
    return 0;
}

/***********************************************************************************
// convert link titles to aria-label when empty
**********************************************************************************/
function wp_ada_compliance_convert_link_title_attributes_to_aria_labels($dom){
$link_titles = get_option('wp_ada_compliance_convert_link_titles','true');
if($link_titles == 'false')	return $dom;
    
// if title is on icon move it to link    
$icons = $dom->find('i[title]');
foreach ($icons as $icon) { 
  if(trim($icon->getAttribute('title')) != '' and $icon->parent()->tag == 'a'){
      if(trim($icon->parent()->getAttribute('title')) == '' 
         and trim($icon->parent()->getAttribute('aria-label'))  == ''
         and !stristr($icon->parent()->getAttribute('class'),"no-title-convert")){
          $icon->parent()->setAttribute('title', esc_attr($icon->getAttribute('title')));
      }
  }
}

// convert titles on links to aria-labels    
$links = $dom->find('a[title]');
foreach ($links as $link) {
	
$images = $link->find('img');
if(isset($images[0]) and $images[0]->getAttribute('alt') != "") $imgalt = $images[0]->getAttribute('alt');
else $imgalt = '';	

if($link->plaintext == '' and $imgalt == '' and $link->getAttribute('title') != '' and !stristr($link->getAttribute('class'),"no-title-convert")){

// move title to icon if present    
$icon = $link->find('i');
if(isset($icon[0])) $icon[0]->setAttribute("title", esc_attr($link->getAttribute('title')));   
    
// convert title on link to aria-label    
$link->setAttribute("aria-label", esc_attr($link->getAttribute('title'))); 
$link->removeAttribute('title');
    

}
}	
	
return $dom;
}

/***********************************************************************************
// convert link titles based on settings
**********************************************************************************
function wp_ada_compliance_filter_link_title_attributes($dom, $content){
$link_titles = get_option('wp_ada_compliance_link_titles','noconvert');
if($link_titles != 'redundant' and $link_titles != 'convert')	return $dom;
if(!stristr($content,'title')) return $dom;
    
// define site url	
$siteurl = esc_url_raw(get_site_url());	 
$site_url_patterns = array();	
$site_url_patterns[] =  '|'.$siteurl."|i";
$site_url_patterns[] = '|'.preg_replace('#^[^\/]*#', '', preg_replace('#((https://)|http://)*#i','',$siteurl))."|i";	
	
$links = $dom->find('a');
	
// store link text in an array
$linktext = array();	
$linkdestination = array();	
foreach ($links as $link) {
if ($link->plaintext != "") $linktext[] = strtolower(trim($link->plaintext));	
if ($link->plaintext != "") $linkdestination[] = preg_replace($site_url_patterns, '',$link->getAttribute('href'));			
}

if((isset($linktext) and is_array($linktext)) 
   and (isset($linkdestination) and is_array($linkdestination))){	

$hrefmatchfound = 0;
foreach ($links as $link) {
$titletext = $link->getAttribute('title'); 
	
if($titletext == "" or $link->getAttribute('aria-label') != "" or ($link->getAttribute('class') != "" and stristr($link->getAttribute('class'),"no-title-convert"))) goto loop_bottom;	

$linkmatch = array_keys($linktext, strtolower(trim($link->plaintext))); 
$destmatch = array_keys($linkdestination, preg_replace($site_url_patterns, '',$link->getAttribute('href')));		

if(sizeof($destmatch) < sizeof($linkmatch)){

$hrefmatchfound = 1; 
}

if ($link->plaintext != "") {

	if($link_titles == 'redundant')	{
	// redundant = filter only links with titles that have link text that is the same as other links on the page
	 if(sizeof($linkmatch) > 1 and $hrefmatchfound == 1){
		$link->removeAttribute('title');	
		$link->removeAttribute('aria-label');
		$link->setAttribute("aria-label", esc_attr($titletext)); 
		
	 }
	}
	elseif($link_titles == 'convert')	{
	// convert = all titles on links to aria-label unless no-title-convert class is found
	$link->removeAttribute('title');	
		$link->removeAttribute('aria-label');
		$link->setAttribute("aria-label", esc_attr($titletext)); 		
	}
}
loop_bottom:
}	
}	
	
return $dom;
}*/
/***********************************************************************************
// remove empty tables
**********************************************************************************/
function wp_ada_compliance_remove_empty_tables($dom){
$striptags = get_option('wp_ada_compliance_striptags','true');
if($striptags == 'false')	return $dom;

// filter tables
$tables = $dom->find('table');
	
foreach ($tables as $table) {
$trs = $table->find('tr');

//exclude ninja tables
if(count($trs) < 1 and $table->getAttribute("data-ninja_table_instance") == '') $table->outertext = '';     
}
		
	
return $dom;
}
/***********************************************************************************
// convert table tags based on settings
**********************************************************************************/
function wp_ada_compliance_filter_presentation_tables($dom){
$presentation_tables = get_option('wp_ada_compliance_presentation_tables','true');
if($presentation_tables == 'false')	return $dom;

// filter tables
$tables = $dom->find('table');
	
// store link text in an array
foreach ($tables as $table) {
$tablecode = $table->save();	
	
if (stristr($table->getAttribute('class'),'role-presentation') and !stristr($tablecode,"<th")) {
	if($table->getAttribute('role') != "presentation"){
		$table->removeAttribute('role');	
		$table->setAttribute("role", 'presentation'); 	
	}
}
}
	
// filter images
	/*
$images = $dom->find('img, svg');
	
// store link text in an array
foreach ($images as $image) {
	
if (stristr($image->getAttribute('class'),'role-presentation')) {
	if($image->getAttribute('role') != "presentation"){
		$image->removeAttribute('role');	
		$image->setAttribute("role", 'presentation'); 	
	}
}
}	*/
	
return $dom;
}

/***********************************************************
// remove invalid alt text such as image of or photo of
***********************************************************/
function wp_ada_compliance_remove_invalid_img_alt_text( $dom) {
	
//remove invalid alt text in captions 
$remove_invalid_img_alt_text = get_option('wp_ada_compliance_remove_invalid_img_alt_text','true');	
if($remove_invalid_img_alt_text == 'false') return $dom;	

$images = $dom->find('img');
	
foreach ($images as $image) {
		if($image->getAttribute('alt') != "")	{
		$orginalalt = trim($image->getAttribute('alt'));	
		if($image->parent()->tag != 'a' or !wp_ada_compliance_check_image_wrapped_in_anchor_simpledom($dom, $orginalalt)){	
		$orginalalt = str_ireplace(__('Infographic of ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('image of a ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('image of an ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('image of ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('graphic of a ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('graphic of an ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('graphic of ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('photo of a ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('photo of an ', 'wp-ada-compliance'), "", $orginalalt);		
		$orginalalt = str_ireplace(__('photo of ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('permalink of ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('permalink to ', 'wp-ada-compliance'), "", $orginalalt);	

		$image->setAttribute("alt", $orginalalt);	
		}
		}
	}
    
// correct invalid alt text in svg files
$svgs = $dom->find('svg');
foreach ($svgs as $svg) {
$titles = $svg->find('title');    
foreach ($titles as $title) {
    if($svg->parent()->tag != 'a'){
       $orginalalt = $title->innertext;
     
      $orginalalt = str_ireplace(__('Infographic of ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('image of a ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('image of an ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('image of ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('graphic of a ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('graphic of an ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('graphic of ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('photo of a ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('photo of an ', 'wp-ada-compliance'), "", $orginalalt);		
		$orginalalt = str_ireplace(__('photo of ', 'wp-ada-compliance'), "", $orginalalt);
		$orginalalt = str_ireplace(__('permalink of ', 'wp-ada-compliance'), "", $orginalalt);	
		$orginalalt = str_ireplace(__('permalink to ', 'wp-ada-compliance'), "", $orginalalt);	
		
        $title->innertext = $orginalalt;	  
    }
}
}

	
return $dom;
	
}

/********************************************************************/	
// check if image is wrapped in an anchor and linked to larger image
/********************************************************************/
function wp_ada_compliance_check_image_wrapped_in_anchor_simpledom($dom, $alt){
	
foreach ($dom->find('a') as $link) {

	foreach ($link->find('img') as $image) {
		$src=$image->getAttribute('src');
		$href = $link->getAttribute('href');
		$extension = substr($image->getAttribute('src'),-4,4);
		if($alt == $image->getAttribute('alt') and $extension != '' and stristr($href, $extension)) return 1;
	}

}
return 0;
}

/***********************************************************************************
// remove id and header tags from tables if non-compliant and scope tag is present NOT USED
**********************************************************************************
function wp_ada_compliance_error_check_filtering( $errortype, $postid, $object) {
	global $wpdb;
	
	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance where postid = %d and errorcode = %s and object = %s ',  $postid, $errortype, $object ), ARRAY_A );

	foreach ( $results as $result ) {
		foreach ( $result as $value ) {
			return $value;
		}
	}
}
/***********************************************************************************
// remove id and header tags from tables if non-compliant and scope tag is present NOT USED
**********************************************************************************
function wp_ada_compliance_remove_noncompliant_table_ids($dom) {
global $post;

// strip empty tags	
$striptableids = get_option('wp_ada_compliance_strip_noncompliant_table_ids','true');
if($striptableids != 'true') retrun $dom;
	
	
// validate tables		
$tables = $dom->find('table');
$k = 0;
foreach ($tables as $table) {	

$tablecode = $dom->save($table, LIBXML_NOEMPTYTAG);
	
		// check if table is in error report
		//if(wp_ada_compliance_error_check_filtering( 'missing_th_id', $post->ID, $tablecode)){	
			
       		if($table != "" and stristr($tablecode, "<th") and stristr($tablecode, "scope")){	
			
		// missing th id
		$rows = $table->find("tr");

		foreach ($rows as $row) {
			$cells = $row -> find('th');
  			foreach ($cells as $cell) {
				if ($cell->hasAttributes('scope') and $cell->hasAttributes('id')) { 
					$cell->removeAttribute('id'); //remove the attribute
					}
				}
			}
			
  			$cells = $row -> find('td');
  			foreach ($cells as $cell) {
				if ($cell->hasAttributes('headers')) { 
					$cell->removeAttribute('headers'); //remove the attribute	
					}
				}
			}// check if table has scope tags
		
	//} // end error check
} // end table foreach

return $dom;
}*/


/**********************************************
// check if content conversion should be ignored
**********************************************/
function wp_ada_compliance_ignored_content($content){
// ignore arrays
if(is_array($content)) return 1;		
// ignore empty fields
if($content == "") return 1;	
// ignore numeric data
//if(is_numeric($content)) return 1;	

// ignore array meta fields
if(preg_match('#(\["(\S*)"\])+#',$content)) return 1;
// ignore array meta fields
if(preg_match('#\S:\S:{((.*)+)}#',$content)) return 1;	
// ignore urls	
if(preg_match('#^((http[s]?|ftp):\/)?\/?([^:\/\s]+)((\/\w+)*\/)([\w\-\.]+[^\#?\s]+)(.*)?(\#[\w\-]+)?$#',$content)) return 1;	
	
return 0;
}

/**********************************************
// check if plugin is active
**********************************************/
function wp_ada_compliance_is_plugin_active( $plugin ) {
   
	$plugins = get_option( 'active_plugins', array() );
	if(in_array($plugin,$plugins)) return 1;
}


/********************************************************************	
remove images linked to self
********************************************************************/	
function wp_ada_compliance_remove_img_linked_to_self($dom){
	
// check if option is enabled
$wp_ada_compliance_remove_images_linked_to_self = get_option('wp_ada_compliance_remove_images_linked_to_self','false');
if($wp_ada_compliance_remove_images_linked_to_self == 'false') return $dom;	
  
    
if(count($dom->find('a img')) == 0) return $dom; 
    
$links = $dom->find('a');
    
foreach ($links as $link) {

$images = $link->find('img');
if(isset($images)){
foreach ($images as $image) {
	$baseSRC = basename ($image->getAttribute('src'));
	
if(isset($baseSRC)){
if(basename($link->getAttribute('href')) == $baseSRC){
	$link->outertext = $link->innertext; 

}
}
} // end image loop
}
} // end link loop

return $dom;
}

/********************************************************************/	
// correct tags with onclick used to emulate links
/********************************************************************/	
function wp_ada_compliance_correct_emulating_links($dom){
		
$wp_ada_compliance_correct_links = get_option('wp_ada_compliance_correct_emulating_links','true');
if($wp_ada_compliance_correct_links == 'false') return $dom;
	
	
$elements = $dom->find('*');
	
foreach ($elements as $element) {
	
	if(($element->getAttribute('onclick') or $element->getAttribute('ondblclick') 
		or $element->getAttribute('onmousedown') or $element->getAttribute('onmouseup')
		or $element->getAttribute('onkeypress') or $element->getAttribute('onkeydown') 
		or $element->getAttribute('onkeyup') or $element->getAttribute('onmouseover') 
		or $element->getAttribute('onmouseout') or $element->getAttribute('onmousemove')
		or $element->getAttribute('onfocus') or $element->getAttribute('onblur')) 
	   and $element->tag != 'a' 
	   and $element->tag != 'button' 
	   and $element->tag != 'input' 
	   and $element->tag != 'select' 
	   and $element->tag != 'textarea' 
	   and $element->tag != 'area' 
	   and $element->tag != 'datalist' 
	   and $element->tag != 'output' 
	   and (!$element->getAttribute('role')
	   or !$element->hasAttribute('tabindex'))
	  ){
		if($element->getAttribute('role') != 'link'){
			$element->setAttribute('role', 'link');
		}
		if(!$element->getAttribute('tabindex') or $element->getAttribute('tabindex') != '0'){
			$element->setAttribute('tabindex','0');
		}
		
		}
}

	return $dom;
} 

/********************************************************************/	
// correct event handlers without keyboard support
/********************************************************************/
function wp_ada_compliance_correct_event_handlers($dom){
		
$setting = get_option('wp_ada_compliance_correct_event_handlers','true');

if($setting == 'false') return $dom;

$elements = $dom->find('*');
	
foreach ($elements as $element) {    
    
if(!$element->getAttribute('onkeypress') and !$element->getAttribute('onkeydown')){
   
    if($element->getAttribute('onclick')){
        $element->setAttribute('onkeypress',$element->getAttribute('onclick'));
    }
    elseif($element->getAttribute('ondblclick')){
        $element->setAttribute('onkeypress',$element->getAttribute('ondblclick'));
    }
    elseif($element->getAttribute('onmousedown')){
        $element->setAttribute('onkeypress',$element->getAttribute('onmousedown'));
    }
    elseif($element->getAttribute('onmouseup')){
        $element->setAttribute('onkeypress',$element->getAttribute('onmouseup'));
    }
    elseif($element->getAttribute('onmouseup')){
        $element->setAttribute('onkeypress',$element->getAttribute('onmouseup'));
    }
}

}
	return $dom;
} 

/********************************************************************/	
// compare strings
/********************************************************************/	
function wp_ada_compliance_compare_strings($string1, $string2){
    // text to remove
	$removeText = array();
    $removeText[] = __('permalink of ', 'wp-ada-compliance');
	$removeText[] = __('permalink to ', 'wp-ada-compliance');
	$removeText[] = __('&nbsp;', 'wp-ada-compliance'); 
    
	$string1 = strtolower($string1);
    $string1 = str_ireplace($removeText, '',$string1);
    $string1 = strip_tags($string1);
    $string1 = trim($string1, " \t\n\r\0\x0B\xC2\xA0");
    $string1 = html_entity_decode($string1);
    
	$string2 = strtolower($string2);
    $string2 = str_ireplace($removeText, '',$string2);
    $string2 = strip_tags($string2);
    $string2 = trim($string2, " \t\n\r\0\x0B\xC2\xA0");
    $string2 = html_entity_decode($string2);

if($string1 == $string2) return 1;
else return 0;
    
}

/**********************************************
// remove outline none and 0
**********************************************/
function wp_ada_compliance_correct_visual_focus_removed($dom, $content){
	
$setting = get_option('wp_ada_compliance_correct_visual_focus','true');

if($setting == 'false' or (!stristr($content,'outline') and !stristr($content,'border'))) return $dom;	
    
$elements = $dom->find('a,input,button,textarea,select,iframe,area,details');
foreach ($elements as $element) {

if(isset($element) and (strstr($element->getAttribute('style'),'outline') or strstr($element->getAttribute('style'),'border'))){

$newcss = preg_replace('/outline:\s?(none|0);/i', '', $element->getAttribute('style'));
$newcss = preg_replace("/outline:\s?((thin|\dpx)\s?|(dotted)\s?|(#000|#000000|black|rgb\(0,0,0\))\s?){3};/i", '',  $newcss);
$newcss = preg_replace('/border:\s?((medium|thick|\dpx)\s?|(solid)\s?|(#000|#000000|black|rgb\(0,0,0\))\s?){3};/', '',  $newcss);	
if(preg_match('/outline-width:\s?(thin|\dpx)/i',$element->getAttribute('style'))
   and preg_match('/outline-style:\s?(dotted)/i',$element->getAttribute('style'))
   and preg_match('/outline-color:\s?(#000|black|rgb\(0,0,0\))/i',$element->getAttribute('style'))
){    
$newcss = preg_replace('/outline-width:\s?(thin|\dpx);/i', '',  $newcss);
$newcss = preg_replace('/outline-style:\s?(dotted);/i', '',  $newcss);
$newcss = preg_replace('/outline-color:\s?(#000|#000000|black|rgb\(0,0,0\));/i', '',  $newcss);
}
if(preg_match('/border-width:\s?(medium|thick|\dpx)/i',$element->getAttribute('style'))
   and preg_match('/border-style:\s?(solid)/i',$element->getAttribute('style'))
   and preg_match('/border-color:\s?(#000|black|rgb\(0,0,0\))/i',$element->getAttribute('style'))){
$newcss = preg_replace('/border-width:\s?(medium|thick|\dpx);/i', '',  $newcss);
$newcss = preg_replace('/border-style:\s?(solid);/i', '',  $newcss);
$newcss = preg_replace('/border-color:\s?(#000|#000000|black|rgb\(0,0,0\));/i', '',  $newcss);	
    }
 if(trim($newcss) == '') $element->removeAttribute('style');
else $element->setAttribute('style',$newcss);
}
}
	
return $dom;
}

/****************************************************************
correct missing form field ids when using VFP Visual Forms Pro
****************************************************************/
function wp_ada_compliance_correct_VFP_labels($dom){
   
$correct_vfb_labels = get_option('wp_ada_compliance_correct_vfb_labels','true');  
if($correct_vfb_labels == 'false') return $dom;   
    
$elements = $dom->find('label');
foreach ($elements as $element) {

if($element->hasAttribute('for') and stristr($element->parent()->parent()->getAttribute('class'),'vfb-fieldType-captcha')){
$element->setAttribute('tabindex','-1');
}
    
if($element->hasAttribute('for') and stristr($element->parent()->getAttribute('class'),'vfb-fieldType-radio')){
$orgtext = $element->innertext;
$element->outertext = '';
$element->parent()->innertext = '<fieldset><legend style="font-weight:bold; margin-bottom: 0px; border-bottom: 0px;">'.$orgtext.'</legend>'.$element->parent()->innertext.'</fieldset>';
}   
    
}        
    
return $dom;    
} 

/****************************************************************
correct missing form field ids when using Gravity Forms
****************************************************************/
function wp_ada_compliance_correct_GravityForms_labels($dom){
  
$correct_gravity_forms_labels = get_option('wp_ada_compliance_correct_gravity_forms_issues','true');  
if($correct_gravity_forms_labels == 'false') return $dom;   

$elements = $dom->find('label[class=gfield_label]');
foreach ($elements as $element) {

if($element->hasAttribute('for')){
    $id = $element->getAttribute('for');
    
    if($id != '') {
    $divs = $dom->find('div[id='.$id.']');
        foreach ($divs as $div) {
    if(strstr($div->getAttribute('class'),'ginput_recaptcha')){
         $element->setAttribute('tabindex','-1');
    }
    }
}   
}
}
    
return $dom;    
} 

/**************************************************************
// stop theme from over riding the default anchor behavior (known issues elementor and OceanWP)
***************************************************************/
add_action('wp_footer','wp_ada_compliance_correct_broken_anchor_links'); 
function wp_ada_compliance_correct_broken_anchor_links(){

$correct_link = get_option('wp_ada_compliance_correct_anchor_links','true');	
if($correct_link == 'false') return; 
    
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return;      
 ?>
  <script>
if(jQuery){		  
jQuery(document).ready(function($){	  
$('a[href*=#]:not([href=#])').on('click', function(event){ 
var wpada_selectedid = $(this).attr('href');	
//console.log(wpada_selectedid);
if(wpada_selectedid.indexOf("#") != '-1' && wpada_selectedid.indexOf("http") == '-1'){
event.stopPropagation();
//$("html").css("scroll-behavior",'smooth');
    window.location.hash = '';
window.location.hash = jQuery(this).attr('href');
} 
}); 
}); 
}
</script>
 <?php
}	

/*****************************************************************
// apply screen-reader-text attributes in elementor to icon links
****************************************************************
function wp_ada_compliance_correct_elementor_icons( $dom ) {
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );

if(!is_plugin_active('elementor/elementor.php')) return $dom;  

$correct_empty_anchor_tags = get_option('wp_ada_compliance_link_titles_font_awesome','true');
if($correct_empty_anchor_tags == 'false') return $dom;
  
$divs = $dom->find('div[data-screen-reader-text]');
foreach ($divs as $div) {
    $screenreadertext = $div->getAttribute('data-screen-reader-text');
    $links = $div->find('a');
    foreach ($links as $link) {
        if(strstr($link->getAttribute('class'),'elementor-icon') 
           and !$link->hasAttribute('aria-label') and !$link->hasAttribute('title'))
        $link->setAttribute('aria-label', esc_attr($screenreadertext));
    }
}
	
return $dom;
}*/

/********************************************************************/	
// correct ambiguous link text
/********************************************************************	
function wp_ada_compliance_correct_ambiguous_anchor_tag($dom){
	
// check if option is enabled
$correct_ambiguous_link_text = get_option('wp_ada_compliance_correct_ambiguous_link_text','true');
if($correct_ambiguous_link_text == 'false') return $dom;	
$wp_ada_link_titles = get_option('wp_ada_compliance_link_titles','noconvert');	
	
$links = $dom->find('a');
foreach ($links as $link) {
	
	// add aria-label to ambiguos links	 
	if($link->getAttribute('aria-label') != "") goto bottom;
		
	// remove punctuation
	$linktext = trim(preg_replace("#[[:punct:]]#", "", $link->nodeValue));

	if (($linktext != "") and (
		preg_match('|^'.__('continue reading','wp-ada-compliance').'(\s)*$|i',$linktext) 
		or preg_match('|^'.__('click here','wp-ada-compliance').'(\s)*$|i',$linktext) 
                or preg_match('|^'.__('download','wp-ada-compliance').'(\s)*$|i',$linktext) 
            or preg_match('|^'.__('pdf','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('Read More','wp-ada-compliance').'(\s)*$|i',$linktext) 
		or preg_match('|^'.__('Read More >','wp-ada-compliance').'(\s)*$|i',$linktext) 
		or preg_match('|^'.__('here','wp-ada-compliance').'(\s)*$|i',$linktext) 
		or preg_match('|^'.__('find out more','wp-ada-compliance').'(\s)*$|i',$linktext) 
		or preg_match('|^'.__('More...','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('More','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('Previous','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('Next','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('clicking here','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('website','wp-ada-compliance').'(\s)*$|i',$linktext)
		or preg_match('|^'.__('click for details','wp-ada-compliance').'(\s)*$|i',$linktext) 
		)) {
		
			$url = esc_url($link->getAttribute('href'));
			$post_id = url_to_postid($url);
		    $post_title = esc_html(get_the_title($post_id));
			if($post_id != 0 and $post_title != ""){
			$post_title = esc_html(get_the_title($post_id));
			$link->setAttribute("aria-label", $post_title);	
			}
		
		}
   
	bottom:
}

	return $dom;
}*/ 
?>
