<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*
Plugin - WP ADA Compliance Check
functions to process post scans
*/

/********************************************************
scan database content
*********************************************************/
function wp_ada_compliance_validate_ada_post_compliance( $post_id, $post='', $update='') {

if (!defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) ) return 1;
    
    
 // If this is just a revision, so we can ignore it.
 if ($update == false) return;    
    
$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));

$post_object = get_post( $post_id );
	
if(!is_object($post_object)) return;
	
$postinfo['type'] = $post_object->post_type;

// ignore certain post statuses - drafts & revisions 
$ignored_status = array("cus_sc_publish","tao_sc_publish","draft","auto-draft","revision","private");   
if (in_array($post_object->post_status,$ignored_status)){  
	
    
  // purge records for posts moved to ignored status
wp_ada_compliance_delete_draft_posts_by_id($post_id, $post_object->post_type);
    
if(strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance'))   
$_SESSION['wp_ada_notices_top'] = '<p class="notice notice-error">'.__('The status of this content does not allow it to be scanned. Publish your post to run a web accessibility scan of this content.', 'wp-ada-compliance').'</p>';    
    
return 1;
}

// ignore posts not being checked
if (!is_array($post_types) or !in_array($postinfo['type'], $post_types)) return 1;

	if($postinfo['type'] == 'attachment'){
	if(strstr($post_object ->post_mime_type,'image/')) {	
		$postinfo['content'] = get_post_meta($post_id, '_wp_attached_file', true); 
		$postinfo['postid'] = $post_id;
		$postinfo['title'] = $post_object->post_title;
        $postinfo['modifieddate'] = $post_object->post_modified;
		$postinfo['scantype'] = 'onsave';	
		$postinfo['taxonomy'] = '';
		$postinfo['wpget'] = ''; // when saving datbase scan only is conducted to reduce confusion	
     
	}
	else return 1;
	}
	else{
		$postinfo['excerpt'] = $post_object->post_excerpt;	
		$postinfo['content'] = $post_object->post_content;
		$postinfo['postid'] = $post_id;
		$postinfo['title'] = $post_object->post_title;
        $postinfo['modifieddate'] = $post_object->post_modified;
		$postinfo['scantype'] = 'onsave';	
		$postinfo['taxonomy'] = '';
		$postinfo['wpget'] = ''; // when saving database scan 
        
// render elementor content    
$postinfo['content'] = wp_ada_compliance_check_elementor_content($postinfo['content'],$postinfo['postid']);
        
// render beaver builder content    
$postinfo['content'] = wp_ada_compliance_check_beaver_builder_content($postinfo['content'],$postinfo['postid'], $postinfo['type']);
        
    // do shortcodes	
$postinfo['content']  = apply_filters('the_content', $postinfo['content']);  
	}
    
	// notify users of shopping cart
	if($postinfo['title'] == 'Cart' or $postinfo['title'] == 'Shopping Cart') {
       update_option('wp_ada_compliance_shopping_cart_found','true'); 
    }
    
  	
// set record check flag on previous error records
	wp_ada_compliance_remove_corrected_posts($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 1);
	
	// scan content 
	wp_ada_compliance_validate_post($postinfo);
	
	// remove records that have been corrected
	wp_ada_compliance_remove_corrected_posts($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 2);
    
   $_SESSION['my_ada_notices'] = wp_ada_compliance_get_error_list_for_post($postinfo['postid'],  $postinfo['type']);
		
}

/*************************************************************************************
deep scan during recheck
************************************************************************************/
function wp_ada_compliance_scan_ada_compliance_post_recheck_deep_scan($postid) {
	

	if (!defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) )  return 1;
    
    
    $post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));
    
  
    $post_object = get_post( $postid );
    if(!is_object($post_object)) {
        return;
    }
	
        // ignore posts not being checked
    if (!is_array($post_types) or !in_array($post_object->post_type, $post_types)) return 1;
    
    // set required php settings	
wp_ada_compliance_set_php_ini_Settings();
	
    // ignore drafts & revisions 
	$ignored_status = array("cus_sc_publish","tao_sc_publish","draft","auto-draft","revision","private");

	$postinfo['type'] = $post_object->post_type;
	$postinfo['excerpt'] = $post_object->post_excerpt;	
	$postinfo['postid'] = $postid;
	$postinfo['title'] = $post_object->post_title;
    $postinfo['posttitle'] = $postinfo['title'];
    $postinfo['modifieddate'] = $post_object->post_modified;
	$postinfo['taxonomy'] = '';
	$postinfo['scantype'] = 'fullscan';	
	$postinfo['wpget'] = 1;
				
	// if not disabled, try to pull content from wpget
	$scan_url = wp_ada_compliance_get_url_to_scan('post', $postinfo);
 
    
    // enforce basic scan
	//$wp_ada_compliance_deep_scan = get_option('wp_ada_compliance_deep_scan','deep');
	//if($wp_ada_compliance_deep_scan == 'basic'){
    // scan content database content
   // wp_ada_compliance_validate_ada_post_compliance($postinfo['postid']);
   // }else{
    
	$remotecontent = wp_ada_compliance_check_deep_scan_support($scan_url);
				
if($remotecontent == '' and $postinfo['type'] == 'attachment') $postinfo['content'] = get_post_meta($postinfo['postid'], '_wp_attached_file', true); 
else $postinfo['content'] = $remotecontent;

  if($postinfo['content'] != "" and strlen($postinfo['content']) > 10 and !in_array($post_object->post_status,$ignored_status)){ 
      
      // update post title in links table
$postinfo['posttitle'] = wp_ada_compliance_update_link_title($scan_url, $postinfo['content']);     
      
      
      	// set record check flag on previous error records
	wp_ada_compliance_remove_corrected_posts($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 1);
      
      
        // check html validation
    wp_ada_compliance_check_html_validation_errors($scan_url, $postinfo['postid'], $postinfo['title']);  
   
    // scan content 
	wp_ada_compliance_validate_post($postinfo);
      
  	// remove records that have been corrected
	wp_ada_compliance_remove_corrected_posts($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 2);
  }
    
    //}
    
	// restore error list
    if(current_filter() ==	"save_post" or current_filter() ==	"edit_attachment")
	$_SESSION['my_ada_notices'] = wp_ada_compliance_get_error_list_for_post($postinfo['postid'],  $postinfo['type']);
	else $_SESSION['my_ada_notices'] = '';
}


/********************************************************
deep scan posts
*********************************************************/
function wp_ada_compliance_scan_ada_compliance_post_deep_scan($limit) {
	global $wpdb, $wp_ada_compliance_error;
    
	
	// get post types to be scanned
	$posttypes = get_option('wp_ada_compliance_posttypes',array('page','post'));
	
	    // ignore drafts & revisions 
	$ignored_status = array("cus_sc_publish","tao_sc_publish","draft","auto-draft","revision","private");
	
	if(!is_array($posttypes)) return 1;
    
    $how_many = count($posttypes);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);
	
    $posttypes[] = 0;
$posttypes[] = 0;	
	// how many to scan each run	
	$posttypes[] = $limit;
	
if ( !defined( 'DOING_CRON' )) 
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type IN('.$format.') and scanflag = %d and ignre = %d LIMIT %d';
else
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type IN('.$format.') and cronflag = %d and ignre = %d LIMIT %d'; 
$results = $wpdb->get_results( $wpdb->prepare( $query, $posttypes), ARRAY_A );

foreach ( $results as $row ) {
	
	
	$post_object = get_post( $row['postid'] );
    $postinfo['excerpt'] = '';
    $postinfo['postid'] = $row['postid'];
    $postinfo['title'] = get_the_title($row['postid']);
    $postinfo['posttitle'] = $postinfo['title'];
    $postinfo['type'] = $row['type'];
    $postinfo['scantype'] = 'fullscan';	
    $postinfo['taxonomy'] = '';
    $postinfo['wpget'] = 1;
    $postinfo['modifieddate'] = $row['modifieddate'];
    $scan_url = $row['link'];
    
// try to pull content from wpget
$remotecontent = wp_ada_compliance_check_deep_scan_support($scan_url);

if($remotecontent == '' and $postinfo['type'] == 'attachment') $postinfo['content'] = get_post_meta($postinfo['postid'], '_wp_attached_file', true); 
else $postinfo['content'] = $remotecontent;
	
  if($postinfo['content'] != "" and strlen($postinfo['content']) > 10 and !in_array($post_object->post_status,$ignored_status)){ 
      
            // update post title in links table
$postinfo['posttitle'] = wp_ada_compliance_update_link_title($scan_url, $postinfo['content']);   
		
			// set record check flag on previous error records
			wp_ada_compliance_remove_corrected_posts($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 1);
			 

      
          // check html validation
    wp_ada_compliance_check_html_validation_errors($scan_url,$postinfo['postid'], $postinfo['title']); 
			 
			 // gather css files urls
			  wp_ada_compliance_locate_css_links($postinfo['content']);
             
             // locate other, non wordpress files
              wp_ada_compliance_locate_urls($postinfo['content'],$scan_url);
			
     // deep scan content
      wp_ada_compliance_validate_post($postinfo);	
	  
    // remove records that have been corrected
    wp_ada_compliance_remove_corrected_posts($postinfo['scantype'], $postinfo['postid'], $postinfo['type'], 2);

    }
    // update scan status
    wp_ada_compliance_set_scan_flag($scan_url);
    
}

}

/*********************************************************
remove corrected error
*******************************************************/
function wp_ada_compliance_remove_corrected_posts($scantype, $post_id, $type, $pre=1) {
global $wpdb;
	
	
if($pre == 1){
// set record flag before validating content	
// don't delete custm fields, they are not checked in elementor    
if (did_action( 'elementor/loaded' ) and \Elementor\Plugin::$instance->preview->is_preview_mode() ) {    
   $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d  and type = %s and recordcheck = %d and scantype = %s', $post_id, $type,0, $scantype) );
  }else{    
 
$wpdb->query($wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET recordcheck = %d WHERE postid = %d and type = %s and scantype = %s', 0, $post_id, $type, $scantype) );
}
}elseif($pre == 2){
// after validation is complete remove previous errors that were not found
 
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d  and type = %s and recordcheck = %d and scantype = %s', $post_id, $type,0, $scantype) );
}
}
?>