<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*
Plugin - WP ADA Compliance Check
functions to process content scanning of terms
*/
/********************************************************
validate term content when saved
*********************************************************/
function validate_ada_term_compliance( $term_id, $taxid, $taxonomy ) {
	global $wpdb;

	$terms = get_option('wp_ada_compliance_terms',array('category'));

	if ( !current_user_can( "edit_pages" )  or !is_array($terms) or !in_array($taxonomy, $terms)) return 1;
	
	$query = 'SELECT * FROM '.$wpdb->prefix.'term_taxonomy inner join '.$wpdb->prefix.'terms ON '.$wpdb->prefix.'term_taxonomy.term_id ='.$wpdb->prefix.'terms.term_id where '.$wpdb->prefix.'terms.term_id = %d and '.$wpdb->prefix.'term_taxonomy.taxonomy = %s';

	$results = $wpdb->get_results( $wpdb->prepare( $query, $term_id, $taxonomy ), ARRAY_A );

	foreach ( $results as $row ) {
	$postinfo['content'] = $row[ "description" ];
	$postinfo['postid'] = $row[ 'term_id' ];
	$postinfo['name'] = $row[ "name" ];
	$postinfo['taxonomy'] = $row[ "taxonomy" ];
	$postinfo['type'] = 'term';
	$postinfo['title'] = $row[ "name" ];	
	$postinfo['scantype'] = 'onsave';	
	$postinfo['wpget'] = '';
	
    // do shortcodes	
$postinfo['content']  = apply_filters('the_content', $postinfo['content']);  			
        
	// set record check flag on previous error records
	wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 1);
			
	// scan content (found in posts file)
	wp_ada_compliance_validate_post($postinfo);
					
	// remove records that have been corrected
	wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 2);
	
   $_SESSION['my_ada_notices'] = wp_ada_compliance_get_error_list_for_post($postinfo['postid'],  $postinfo['type']);
       
    }
    
    

}

/********************************************************
deep scan on recheck
*********************************************************/
function wp_ada_compliance_terms_recheck_deep_scan($term_id, $taxonomy) {
	global $wpdb, $wp_ada_compliance_error;

	
	$terms = get_option('wp_ada_compliance_terms',array('category'));
    
    if(is_numeric($taxonomy)) {
        $term = get_term( $term_id );
        $taxonomy = $term->taxonomy;
    }

	if ( !current_user_can( "edit_pages" )  or !is_array($terms) or !in_array($taxonomy, $terms)) return 1;
		
	$query = 'SELECT * FROM '.$wpdb->prefix.'term_taxonomy inner join '.$wpdb->prefix.'terms ON '.$wpdb->prefix.'term_taxonomy.term_id ='.$wpdb->prefix.'terms.term_id where '.$wpdb->prefix.'terms.term_id = %d and '.$wpdb->prefix.'term_taxonomy.taxonomy = %s';

	$results = $wpdb->get_results( $wpdb->prepare( $query, $term_id, $taxonomy ), ARRAY_A );

	foreach ( $results as $row ) {
	
	$postinfo['content'] = $row[ "description" ];
	$postinfo['postid'] = $row[ 'term_id' ];
	$postinfo['name'] = $row[ "name" ];
	$postinfo['taxonomy'] = $row[ "taxonomy" ];
	$postinfo['type'] = 'term';
	$postinfo['title'] = $row[ "name" ];
        $postinfo['posttitle'] = $postinfo['title'];
	$postinfo['scantype'] = 'fullscan';	
	$postinfo['wpget'] = 1;	
	
	$scan_url = wp_ada_compliance_get_url_to_scan('term', $postinfo);
	$remotecontent = wp_ada_compliance_check_deep_scan_support($scan_url);
		
	if($remotecontent != "" and strlen($remotecontent) > 10) {
		$postinfo['content'] = $remotecontent;	
        
              // update post title in links table
$postinfo['posttitle'] =  wp_ada_compliance_update_link_title($scan_url, $postinfo['content']);   

		// set record check flag on previous error records
		wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 1);
			
        
                // check html validation
    wp_ada_compliance_check_html_validation_errors($scan_url, $postinfo['postid'], $postinfo['title']); 

		// scan content (found in posts file)
		wp_ada_compliance_validate_post($postinfo);	
        

		// remove records that have been corrected
		wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 2);
        
          $_SESSION['my_ada_notices'] = wp_ada_compliance_get_error_list_for_post($postinfo['postid'],  $postinfo['type']);
	}
	}
	
}

/********************************************************
manual and cron auto scan of terms using deep scan
*********************************************************/
function scan_ada_compliance_terms_deep_scan($limit) {
	global $wpdb, $wp_ada_compliance_error;

	
	if ( !defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) ) return 1;

	// get terms to be scanned
	$terms = get_option('wp_ada_compliance_terms',array('category'));
	
	if(!is_array($terms)) return 1;
	
	$how_many = count($terms);
	$placeholders = array_fill(0, $how_many, '%s');
	$format = implode(', ', $placeholders);

    $terms[] = 'term';
    $terms[] = 0;
	$terms[] = 0;
	$terms[] = $limit;
		
	
if ( !defined( 'DOING_CRON' )) 
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where taxonomy IN('.$format.') and type  = %s  and scanflag = %d and ignre = %d LIMIT %d';
else
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where taxonomy IN('.$format.') and type  = %s  and cronflag = %d and ignre = %d LIMIT %d';    

	$results = $wpdb->get_results( $wpdb->prepare( $query, $terms ), ARRAY_A );

	foreach ( $results as $row ) {
    $TermObject = get_term_by( 'id', (int)$row[ 'postid' ], $row[ "taxonomy" ] );
	$postinfo['content'] = '';
	$postinfo['postid'] = $row[ 'postid' ];
	$postinfo['name'] = $TermObject->name;
	$postinfo['taxonomy'] = $row[ "taxonomy" ];
	$postinfo['type'] = 'term';
	$postinfo['scantype'] = 'fullscan';	
	$postinfo['title'] =$TermObject->name;
        $postinfo['posttitle'] = $postinfo['title'];
	$postinfo['wpget'] = 1;	
	
	$scan_url =  $row[ 'link' ];
                
	$remotecontent = wp_ada_compliance_check_deep_scan_support($scan_url);
		
	if($remotecontent != "" and strlen($remotecontent) > 10) {
		$postinfo['content'] = $remotecontent;	
        
              // update post title in links table
$postinfo['posttitle'] = wp_ada_compliance_update_link_title($scan_url, $postinfo['content']);   
		
		// set record check flag on previous error records
		wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 1);
		
		 // gather css files urls
		  wp_ada_compliance_locate_css_links($postinfo['content']);
        
         // locate other, non wordpress files
         wp_ada_compliance_locate_urls($postinfo['content'],$scan_url);
        
                // check html validation
    wp_ada_compliance_check_html_validation_errors($scan_url, $postinfo['postid'], $postinfo['title']); 
			

		// scan content (found in posts file)
		wp_ada_compliance_validate_post($postinfo);	
        
		// remove records that have been corrected
		wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 2);

	}
    
	// update scan status
   wp_ada_compliance_set_scan_flag($scan_url);	
	

	}
	
}

/********************************************************
manual and cron auto scan of terms 
*********************************************************/
function scan_ada_compliance_terms($offsetandlimit) {
	global $wpdb, $wp_ada_compliance_error;

	if ( !defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) ) return 1;

	// get terms to be scanned
	$terms = get_option('wp_ada_compliance_terms',array('category'));
	
	if(!is_array($terms)) return 1;
	
	$how_many = count($terms);
	$placeholders = array_fill(0, $how_many, '%s');
	$format = implode(', ', $placeholders);

		// how many to scan each run	
	$terms[] = $offsetandlimit['termlimit'];
	$terms[] = $offsetandlimit['termoffset'];
	
	$query = 'SELECT * FROM '.$wpdb->prefix.'term_taxonomy inner join '.$wpdb->prefix.'terms ON  '.$wpdb->prefix.'term_taxonomy.term_id = '.$wpdb->prefix.'terms.term_id where taxonomy IN('.$format.') LIMIT %d OFFSET %d';

	$results = $wpdb->get_results( $wpdb->prepare( $query, $terms ), ARRAY_A );

	foreach ( $results as $row ) {
	$postinfo['content'] = $row[ "description" ];
	$postinfo['postid'] = $row[ 'term_id' ];
	$postinfo['name'] = $row[ "name" ];
	$postinfo['taxonomy'] = $row[ "taxonomy" ];
	$postinfo['type'] = 'term';
	$postinfo['scantype'] = 'onsave';	
	$postinfo['wpget'] = '';
	$postinfo['title'] = $row[ "name" ];
	
	// correct issues before saving content 
	//wp_ada_compliance_change_content_before_saving($content);
			
	// set record check flag on previous error records
	wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 1);
			
	// scan content (found in posts file)
	wp_ada_compliance_validate_post($postinfo);	
					
	// remove records that have been corrected
	wp_ada_remove_corrected_terms($postinfo['scantype'], $postinfo['postid'], 2);

	
	}
	
}
	
/*********************************************************
remove corrected term errors
*******************************************************/
function wp_ada_remove_corrected_terms($scantype,$post_id, $pre=1) {
global $wpdb;
	

if($pre == 1){
	
// set record flag before validating content	
$wpdb->query($wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET recordcheck = %d WHERE postid = %d and type = %s and scantype = %s', 0, $post_id, 'term', $scantype) );
}elseif($pre == 2){
// after validation is complete remove previous errors that were not found
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d  and type = %s and recordcheck = %d and scantype = %s', $post_id, 'term', 0, $scantype) );
}
}
?>