<?php 
/*
Plugin - WP ADA Compliance Check
functions to process theme scans
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/*********************************************************
remove corrected theme error
*******************************************************/
function wp_ada_remove_corrected_theme_errors($scantype, $postid, $pre=1) {
global $wpdb;
	
if($pre == 1){
// set record flag before validating content	
$wpdb->query($wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET recordcheck = %d WHERE type = %s and scantype= %s and postid = %d', 0, 'theme', $scantype, $postid) );
}elseif($pre == 2){
// after validation is complete remove previous errors that were not found
$wpdb->query($wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and scantype = %s and recordcheck = %d and postid = %d', 'theme', $scantype, 0, $postid) );
}

}

/**********************************************************
complete theme checks
**********************************************************/
function wp_ada_compliance_theme_validation($limit, $postid=0){
global $wpdb;
     
	
// get theme files to be scanned
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page"));
if(!is_array($theme_scan_items) or count($theme_scan_items) < 1) return 1;
	
if ( defined( 'DOING_CRON' )) {
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and cronflag = %d and ignre = %d LIMIT %d'; 
    $results = $wpdb->get_results( $wpdb->prepare( $query, 'theme',0, 0, $limit), ARRAY_A ); 
}
elseif($postid != 0){

$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and ignre = %d and id = %d'; 
    $results = $wpdb->get_results( $wpdb->prepare( $query, 'theme', 0, $postid), ARRAY_A );
}
else{
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and scanflag = %d and ignre = %d LIMIT %d';
    $results = $wpdb->get_results( $wpdb->prepare( $query, 'theme',0, 0, $limit), ARRAY_A );
}

foreach ( $results as $row ) {

if(in_array($row['themetype'],$theme_scan_items) or strstr($row['themetype'],'_archive')){	
$scan_url = $row['link'];    

$content = wp_ada_compliance_check_deep_scan_support($scan_url);

if ($content != "" and strlen($content) > 10 ) {

	
// create array to pass post info to complete checks	
$postinfo['postid'] = $row['id']; 
$postinfo['title'] = wp_ada_compliance_get_page_title_from_content($content);
$postinfo['type'] = 'theme';	
$postinfo['taxonomy'] = '';	
$postinfo['scantype'] = $row['themetype'];	
$postinfo['wpget'] = 1;
$postinfo['content'] = $content;
    
// update post title in links table
$postinfo['title'] =  wp_ada_compliance_update_link_title($scan_url, $content, $postinfo['title']);         
	
wp_ada_remove_corrected_theme_errors($postinfo['scantype'], $postinfo['postid'], 1);	
	
// gather css files urls
 wp_ada_compliance_locate_css_links($postinfo['content']);	
    
 // locate other, non wordpress files
 wp_ada_compliance_locate_urls($postinfo['content'],$scan_url);    	
    
// check html validation
wp_ada_compliance_check_html_validation_errors($scan_url, $postinfo['postid'], $postinfo['title']); 
	
// complete all other content validations	
wp_ada_compliance_validate_post($postinfo);		

wp_ada_remove_corrected_theme_errors($postinfo['scantype'], $postinfo['postid'], 2);	
	


}
}
		
// update scan status
    if(isset($scan_url))
wp_ada_compliance_set_scan_flag($scan_url);	
}

}
/********************************************************************/	
// return page title
/********************************************************************/	
function wp_ada_compliance_get_page_title_from_content($content){
	
$dom = new DOMDocument;
libxml_use_internal_errors(true);
$dom->loadHTML($content);	

$titles = $dom->getElementsByTagName('title');
foreach ($titles as $title) {	
if($title->nodeValue != "") return $title->nodeValue;
	else "Return Untitled";
}
} 
?>