<?php 
/*
Plugin - WP ADA Compliance Check
includes all content checks and validations for the scan process and content publishing
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*******************************************************************
// all content is sent to this function to be checked for issues.
*******************************************************************/
function wp_ada_compliance_validate_post($postinfo) {
    
// skip check when importing records    
if(get_option('wp_ada_compliance_import_inprocess') == '1') return 1; 
    
    
// skip post if marked to be ignored	
$ignoredPosts = get_option('wp_ada_compliance_posts_to_ignore',array());
if(is_array($ignoredPosts)){
foreach($ignoredPosts as $post => $value){
// check if iframe is ignored
//if(array_key_exists('externalsrc',$postinfo)){
//$externalparts = explode('|',$postinfo['externalsrc']);
//}
$parts = explode('|',$value);
if(count($parts) == 3 ){	
if($parts[1] == '0' and $parts[0] == $postinfo['type'] and $parts[2] == $postinfo['scantype']) $ignored = 1;
elseif($parts[1] != '0' and $parts[1] == $postinfo['postid'] and $parts[0] == $postinfo['type']) $ignored = 1;
}
}
if(isset($ignored)){
if(isset($_GET[ 'scansingle' ])) {
$_SESSION['wp_ada_notices_top'] = '<p class="notice notice-error">'.__('The selected content was not scanned because it has been marked as ignored.', 'wp-ada-compliance').'</p>';	
}
return 1;
}
}

$content  = $postinfo['content']; 
    
// correct issues with encoding when website is using non utf-8
if(function_exists('mb_convert_encoding'))
$content = mb_convert_encoding($content, 'HTML-ENTITIES', "UTF-8");	
    
// remove admin bar when logged in 
if($postinfo['type'] != "pdf" )	    
$content = wp_ada_compliance_remove_webadmin_bar($content);  
	
// remove ignored blocks on content
if($postinfo['type'] != "pdf" )	    
$content = wp_ada_compliance_remove_ignore_content_blocks($content);  
    
// clear error message
if(!isset($_SESSION['my_ada_notices'])) $_SESSION['my_ada_notices'] = "";
	
/******************************	
 start validation	
*******************************/
// scan attachments
if($postinfo['type'] == "attachment" and strstr(get_post_mime_type($postinfo['postid']), 'image/')) {

// media library image missing alt text
wp_ada_compliance_validate_img_missing_alt_media($content, $postinfo);
	
//media library image with invalid alt text
wp_ada_compliance_validate_img_alt_invalid_media($content, $postinfo);	

}
    
    
// scan css
if($postinfo['type'] == "css"){
	
// look for absolute font size
wp_ada_compliance_validate_absolute_fontsize($postinfo['content'], $postinfo);	

// look for links without a visual cue
wp_ada_compliance_validate_link_without_visual_cue($content, $postinfo);
	
// look for foreground and background colors without enough contrast
wp_ada_compliance_validate_color_contrast_failure($content, $postinfo);		
	
// look for foreground colors without background colors or vice versa
		//REMOVED BECAUSE OF SO MANY FALSE POSITIVES
 //wp_ada_compliance_validate_foreground_color_violation($content, $postinfo);	
	
// look for background images inside css
wp_ada_compliance_validate_background_image($content, $postinfo);	
	
// validate blinking text
wp_ada_compliance_validate_blinking_text($content, $postinfo);	
	
// look for links and focus styles where visual focus indication has been removed.
wp_ada_compliance_validate_visual_focus_removed($content, $postinfo);
	
// look for content inserted using css
wp_ada_compliance_validate_css_content_insertion($content, $postinfo);	
	
// validate justified text
wp_ada_compliance_validate_text_justified($content, $postinfo);	

	
// look for content positioned with css
//wp_ada_compliance_validate_content_positioned_with_css($content, $postinfo); 	
		
}
elseif($postinfo['type'] == "pdf"){

 // check for untagged pdf documents    
wp_ada_compliance_untagged_document_checks($postinfo);      
}
// scan posts
else{ 
// check for untagged pdf documents       
if($postinfo['type'] == "attachment" and get_post_mime_type($postinfo['postid']) == 'application/pdf'){
  $url = esc_url_raw(wp_get_attachment_url($postinfo['postid']));
    wp_ada_compliance_save_link_record((string)$url, 'pdf'); 
$linkid = wp_ada_compliance_get_linkid_by_url($url);
if($linkid != '') wp_ada_compliance_scan_ada_compliance_pdf_deep_scan('',$linkid);
}

// specialty validations
// duplicate title check
wp_ada_compliance_validate_duplicate_title($postinfo);

// do content checks
if($postinfo['content'] != "" and ($postinfo['type'] != "attachment" or ($postinfo['type'] == "attachment" and $postinfo['content'] != get_post_meta($postinfo['postid'], '_wp_attached_file', true))))  {

 wp_ada_compliance_complete_content_validations($content, $postinfo);	
}

} // end else

// clear error message if not scanning on save	
if((isset($_GET['startscan']) or !array_key_exists('scantype',$postinfo) and !wp_ada_compliance_check_is_admin(1)) or ($postinfo['type'] == 'attachment' and !strstr($_SERVER['REQUEST_URI'],'wp-admin/post.php'))){ 
	$_SESSION['my_ada_notices'] = "";
}
}

/******************************	
content validations	
*******************************/
function wp_ada_compliance_complete_content_validations($content, $postinfo){

if($content == "") return ;
    
if(!isset($_SESSION['my_ada_notices'])) $_SESSION['my_ada_notices'] = "";    
	
// if scanning content from the database skip these checks	
if($postinfo['wpget'] != ""){ 		
	
// check for nav links
wp_ada_compliance_validate_skip_nav_links($content, $postinfo);
	
// validate missing laguage attributes in theme files
wp_ada_compliance_validate_missing_lang_attr($content, $postinfo);	
    
// unrequested popups
wp_ada_compliance_validate_popup_windows($content, $postinfo);
	
// validate that more than one way is available to locate a Web page 
wp_ada_compliance_validate_multiple_ways_failure($content, $postinfo);	
	
// validate missing landmarks
wp_ada_compliance_validate_missing_landmarks($content, $postinfo); 
    
// validate unlabeled landmarks    
wp_ada_compliance_validate_unlabeled_landmarks($content, $postinfo);    
    

}
    

    
// check for redundant alt text on images	
wp_ada_compliance_validate_redundant_alt_text($content,$postinfo);	
	
// check for redundant title attributes on links	
wp_ada_compliance_validate_redundant_title_tag($content, $postinfo);
		
// check for absolute font sizes
wp_ada_compliance_validate_absolute_fontsize($content, $postinfo);

// check for ambiguous ancor text
wp_ada_compliance_validate_ambiguous_anchor_tag($content, $postinfo);
	
// check for audio or video tags with autoplay
wp_ada_compliance_validate_av_tag_with_autoplay($content, $postinfo);

// check for audio, video or iframe video missing tracks	
wp_ada_compliance_validate_av_tags_missing_track($content, $postinfo);
    
// validate audio or video players from remote sources
wp_ada_compliance_validate_video_player_remote_source($content, $postinfo);     
	    
// missing alt text on embed tags
wp_ada_compliance_validate_embed_tag_used($content, $postinfo);

// check for empty anchor tag
wp_ada_compliance_validate_empty_anchor_tag($content, $postinfo);	

// check for empty heading tag
wp_ada_compliance_validate_empty_heading_tag($content, $postinfo);
	
// validate title tag in iframe
wp_ada_compliance_validate_iframe_missing_title($content, $postinfo);	
	
// validate alt text content
wp_ada_compliance_validate_img_alt_invalid($content, $postinfo);
	
// image missing alt text
wp_ada_compliance_validate_img_missing_alt($content, $postinfo);
	
// image empty alt text
wp_ada_compliance_validate_img_empty_alt($content, $postinfo);	
	
// target new window
wp_ada_compliance_validate_new_window_tag($content, $postinfo);
	
// validate object tags
wp_ada_compliance_validate_object_alt_missing($content, $postinfo);
	
// validate redundent link text
wp_ada_compliance_validate_redundant_anchor_text($content, $postinfo);
	
// validate tables missing th	
wp_ada_compliance_validate_missing_th($content, $postinfo);	
	
// validate tables missing th id	
wp_ada_compliance_validate_missing_th_id($content, $postinfo);
	
// validate tables missing data cells	
wp_ada_compliance_validate_missing_td($content, $postinfo);
	
// validate tables missing th scope	
wp_ada_compliance_validate_missing_th_scope($content, $postinfo);

// validate tables with header cells spanning multiple rows or columns for correct scope
	// not used at this time (not required and if required additional checks are needed )
//wp_ada_compliance_validate_missing_th_span_scope($content, $postinfo);	
	
// validate data tables marked as presentation 	
wp_ada_compliance_validate_data_table_marked_presentation($content, $postinfo);
	
// validate form fields for labels
wp_ada_compliance_validate_missing_form_label($content, $postinfo);
	
// image map hot spot missing alt text
wp_ada_compliance_validate_imagemap_missing_alt_text($content, $postinfo);	

// validate forms that submit automatically or trigger an unexpected context change
wp_ada_compliance_validate_context_change_form($content, $postinfo);	
	
// validate elments with onclick but not onkeypress
 wp_ada_compliance_validate_missing_onkeypress($content, $postinfo);	
	
// look for links without a visual cue
wp_ada_compliance_validate_link_without_visual_cue($content, $postinfo);
	
// validate fieldsets without legends
wp_ada_compliance_validate_fieldset_without_legend($content, $postinfo);
	
// validate fieldsets without legends
wp_ada_compliance_validate_nested_fieldset($content, $postinfo);
	
// validate lists with incorrect markup
wp_ada_compliance_validate_list_incorrect_markup($content, $postinfo);
	
// validate incorrect language markup
 wp_ada_compliance_validate_missing_lang_attr_part($content, $postinfo);	
	
//check for anchor tags with images misisng alt text
 //wp_ada_compliance_validate_missing_alt_text_anchor($content, $postinfo);	
	
// validate page structure, look for missing headings
wp_ada_compliance_validate_missing_headings($postinfo);	
	
//check for anchor tags linking images to them self
wp_ada_compliance_validate_img_linked_to_self($content, $postinfo);	
	
// validate tables with summary attributes that duplicate caption	
wp_ada_compliance_validate_redundant_table_summary($content, $postinfo);
	
// validate animated images
wp_ada_compliance_validate_animated_image($content, $postinfo);	
	
// look for foreground and background colors without enough contrast
wp_ada_compliance_validate_color_contrast_failure($content, $postinfo);	
	
// look for foreground colors without background colors or vice versa
		//REMOVED BECAUSE OF SO MANY FALSE POSITIVES
 //wp_ada_compliance_validate_foreground_color_violation($content, $postinfo);
	
//check missing page titles
wp_ada_compliance_validate_missing_title($content, $postinfo);	
	
// image empty alt text with title or non empty aria label attribute
wp_ada_compliance_validate_img_empty_alt_with_title($content, $postinfo);	
		
// look for background images inside css
wp_ada_compliance_validate_background_image($content, $postinfo);	
	
// validate blinking text
wp_ada_compliance_validate_blinking_text($content, $postinfo);
	
// validate incorrect use of line breaks to create whitespace
wp_ada_compliance_validate_incorrect_whitespace($content, $postinfo);
	
// look for links and focus styles where visual focus indication has been removed.
wp_ada_compliance_validate_visual_focus_removed($content, $postinfo);	
	
// look for tags with onclick used to emulate links
wp_ada_compliance_validate_emulating_links($content, $postinfo);	
	
// validate meta refresh attributes that reload the page or redirect to a new location after a timeout
wp_ada_compliance_validate_meta_refresh_use($content, $postinfo);
	
// validate page structure, look for headings that are not in order
wp_ada_compliance_validate_incorrect_heading_order($content, $postinfo);
	
// check for tab order changed using tabindex 
wp_ada_compliance_validate_tab_order_modified($content, $postinfo);
	
// validate justified text
wp_ada_compliance_validate_text_justified($content, $postinfo);	
	
// image with alt text marked presentation
wp_ada_compliance_validate_img_alt_marked_presentation($content, $postinfo);

// form fields not marked as required
wp_ada_compliance_validate_unmarked_required_fields($content, $postinfo);
	
// validate complex tables	
wp_ada_compliance_validate_complex_tables($content, $postinfo);
	
// validate nested tables	
wp_ada_compliance_validate_nested_tables($content, $postinfo);
	
// validate links without href but that include event handlers
wp_ada_compliance_validate_missing_href($content, $postinfo); 	
	
// look for headers referencing missing ids	
wp_ada_compliance_validate_missing_td_headers($content, $postinfo);	
	
//check for empty button tag	
wp_ada_compliance_validate_empty_button_tag($content, $postinfo);
	
//check for empty anchor tag	
wp_ada_compliance_validate_empty_href($content, $postinfo);	
    
// look for form labels without matching form field ids
wp_ada_compliance_validate_missing_form_fieldid($content, $postinfo);   
    
// links in content that are lot included in an anchor tag
wp_ada_compliance_validate_unlinked_anchors($content, $postinfo);   
    
// validate complex data tables	
wp_ada_compliance_validate_complex_data_tables($content, $postinfo);  
 
// elementor galleries    
wp_ada_compliance_validate_elementor_gallery($content, $postinfo);  
    
// look for elementor toc widgets
wp_ada_compliance_validate_elementor_toc($content, $postinfo); 
    
// look for elementor toggle or accordion
wp_ada_compliance_validate_elementor_toggles($content, $postinfo);
    
// adjacent identical links
wp_ada_compliance_validate_adjacent_identical_links($content, $postinfo);
    
// validate empty th cells
wp_ada_compliance_validate_empty_th($content, $postinfo);
    
// validate form controls groups without fieldsets 
wp_ada_compliance_validate_related_form_fields_not_grouped($content, $postinfo);
    
    // check for links to non html content
wp_ada_compliance_validate_link_to_non_html_content($content, $postinfo);    
    
//check for empty option tag	
wp_ada_compliance_validate_empty_option_tag($content, $postinfo);  
    
// look for links without enough contrast between the text around them
wp_ada_compliance_validate_link_color_contrast_failure($content, $postinfo);   
    
//check for aria attributes with missing or invalid ids
wp_ada_compliance_validate_aria_attribute_invalid_id($content, $postinfo);  
    
// look for elementor background videos
wp_ada_compliance_validate_elementor_background_video($content, $postinfo);
    
// look for form fields with with more than one label
wp_ada_compliance_validate_duplicate_form_field_id($content, $postinfo);  
    
// look for elementor image carousel set to autoplay
wp_ada_compliance_validate_elementor_carousel_autoplay($content, $postinfo); 
    
// validate duplicate alt text 
wp_ada_compliance_validate_img_duplicate_alt($content, $postinfo);   
    
// look for empty icons - removed not really required since FA is auto correcting in most cases. would only result in a lot of false positives. May add back checking other icon types in the future
//wp_ada_compliance_validate_empty_icon($content, $postinfo);    
    
    
// validate page structure, look for missing headings
//wp_ada_compliance_validate_missing_section_headings($content, $postinfo); 
    
    // check for anchors in the same page - removed can't refernce
//wp_ada_compliance_validate_link_to_in_page_content($content, $postinfo); 
	
// look for content positioned with css
//wp_ada_compliance_validate_content_positioned_with_css($content, $postinfo);		
	
// text look alikes in use -- COULD NOT RELIABLY BE IMPLEMENTED. RESULTED IN TO MANY FALSE POSITIVES. NEED A HARD LIST OF FAILURE CASES IN ORDER TO IMPLEMENT
//wp_ada_compliance_validate_text_look_alikes($content, $postinfo);	

}


/*********************************************************
add view report meta box
*********************************************************/
function wp_ada_compliance_report_meta_box()
{
$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));
foreach( $post_types as $type ) { 
add_meta_box( 'wp_ada_meta_box_id', 'Web Accessibility', 'wp_ada_compliance_view_report', $type, 'side', 'high', array(
        '__block_editor_compatible_meta_box' => true,
    ) );
}
}
// display initial button
function wp_ada_compliance_view_report() {  
global $post;

$enablewave = get_option('wp_ada_compliance_enablewave','true');
    
if(wp_ada_compliance_reported_errors_check($post, 1)){

    if(get_post_mime_type($post->ID) == 'application/pdf'){
$posttype = 'pdf';
} else $posttype = $post->post_type;
    
    echo  '<p class="ada_compliance_report_link"><a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&view=1&errorid='.esc_attr($post->ID).'&type='.esc_attr($posttype).'&iframe=1&TB_iframe=true&width=900&height=550" class="thickbox btnwpada btnwpada-warning adareportlink">';
	_e('Accessibility Report','wp-ada-compliance');
	echo '</a></p>';

	if($enablewave == 'true'){
	echo '<p class="wp-ada-compliance-wave-link"><a href="http://wave.webaim.org/report#/'.esc_url(site_url()).'/?p='.esc_attr($post->ID).'"><i class="far fa-check-square" aria-hidden="true"></i>';
	echo __('Evaluate with Wave','wp-ada-compliance');
	echo '</a>
    <a href="https://validator.w3.org/nu/?doc='.esc_url(site_url()).'/?p='.esc_attr($post->ID).'"><i class="fas fa-code" aria-hidden="true"></i>';
	echo __('Validate HTML','wp-ada-compliance');
	echo '</a>
    </p>';
	}
	}  
	else{
	 echo  '<p class="ada_compliance_report_link_clear ada_compliance_report_link"><i class="fas fa-thumbs-up btnwpada" aria-hidden="true" title="'.__('No Issues','wp-ada-compliance').'"></i></p>';	
     
	if($enablewave == 'true'){
		echo '<p class="wp-ada-compliance-wave-link"><a href="http://wave.webaim.org/report#/'.esc_url(site_url()).'/?p='.esc_attr($post->ID).'"><i class="far fa-check-square" aria-hidden="true"></i>';
	echo __('Evaluate with Wave','wp-ada-compliance');
	echo '</a>
      <a href="https://validator.w3.org/nu/?doc='.esc_url(site_url()).'/?p='.esc_attr($post->ID).'"><i class="fas fa-code" aria-hidden="true"></i>';
	echo __('Validate HTML','wp-ada-compliance');
	echo '</a>
    </p>';
    }
	}
}  

/**********************************************************
get term link to scan
**********************************************************/
function wp_ada_compliance_get_term_url_to_scan($id, $tax){
	
// term page
$url = get_term_link((int)$id, $tax);
if(is_string($url)) return esc_url_raw($url);
else return "";
}

/**********************************************************
get url to scan
**********************************************************/
function wp_ada_compliance_get_url_to_scan($scantype, $postinfo=""){
	
	// term page
	if($scantype == 'term' and $postinfo != ""){
		$url = get_term_link((int)$postinfo['postid'], $postinfo['taxonomy']);
		if(is_string($url)) return esc_url_raw($url);
		else return "";
	}
	
	// post or page
	if($scantype == 'post' and $postinfo != "") return esc_url_raw(get_permalink($postinfo['postid']));
	
 	// home page	
	if(str_replace(" ","",strtolower($scantype)) == "bloghome") return esc_url_raw(get_site_url());
	
	// 404 error
	if(str_replace(" ","",strtolower($scantype)) == "404page") return esc_url_raw(get_site_url().'/?page_id=010000000000000000000000000000');
	
	// search page
	if(str_replace(" ","",strtolower($scantype)) == "searchpage") return esc_url_raw(get_site_url().'/?s=');
	
	// get author page
	if(str_replace(" ","",strtolower($scantype)) == "authorpage") {
		return esc_url_raw(get_author_posts_url(1));
	}
	
	// return archive url
	if(strstr(str_replace(" ","",strtolower($scantype)), "_archive")) {
	$posttype = str_replace("_archive",'',$scantype);
	return esc_url_raw(get_post_type_archive_link($posttype));
	}

}
/**************************************************
inventory links 
**************************************************/
function wp_ada_compliance_inventory_links_rest(){

    check_ajax_referer('wp_rest', '_wpnonce'); 
    
// set required php settings	
wp_ada_compliance_set_php_ini_Settings();        
    
    wp_ada_compliance_inventory_links();
    
}
function wp_ada_compliance_inventory_links(){
 global $wpdb; 
    

// clean up recrds
    wp_ada_compliance_purge_deleted_records();

// change link ignore status
//wp_ada_compliance_update_inventory_ignore_status();   

// set locate flag
wp_ada_compliance_set_locate_flag(2);
    
// get theme files to be scanned
$theme_scan_items = array("Blog Home","404 Page","Search Page","Author Page");

// get author pages
if(in_array("Author Page",$theme_scan_items)){
foreach ( $wpdb->get_results("SELECT DISTINCT post_author FROM $wpdb->posts GROUP BY post_author") as $row ) {
 $author = get_userdata( $row->post_author );
if(is_object($author)){
$link = get_author_posts_url( $author->ID, $author->user_nicename );
if($link != '') $link = esc_url_raw($link);
if($link != '')
wp_ada_compliance_save_theme_links($link,'theme', $author->ID, "Author Page");     
}
}
}
    
foreach($theme_scan_items as $key => $value){	
if($value != "Author Page"){
	$link = wp_ada_compliance_get_url_to_scan( strtolower(str_replace(" ","", $value))); 
	if($link != '') $link = esc_url_raw($link);
       if($link != '')
    wp_ada_compliance_save_theme_links($link,'theme', 0, $value); 
}
	}	
	
	
 // inventory terms   
$query = 'SELECT * FROM '.$wpdb->prefix.'term_taxonomy inner join '.$wpdb->prefix.'terms ON  '.$wpdb->prefix.'term_taxonomy.term_id = '.$wpdb->prefix.'terms.term_id where %d';

$results = $wpdb->get_results( $wpdb->prepare($query, 1), ARRAY_A );
 
foreach ( $results as $row ) {
    $link = get_term_link( (int)$row[ 'term_id' ], $row[ 'taxonomy' ]);
    if(is_string($link) and $link != '')  $link = esc_url_raw($link);
    if(is_string($link) and $link != '') {
       wp_ada_compliance_save_term_record($link, 'term', $row[ 'term_id' ], $row[ 'taxonomy' ]);  
    }
}
	
    
// inventory posts
$posttypes = array();
array_unshift($posttypes,"trash");
array_unshift($posttypes,"tao_sc_publish");
array_unshift($posttypes,"cus_sc_publish");
array_unshift($posttypes,"draft");
array_unshift($posttypes,"auto-draft");
array_unshift($posttypes,"attachment");
array_unshift($posttypes,"revision");

$query = 'SELECT * FROM '.$wpdb->prefix.'posts where post_type != %s and post_type != %s and post_status NOT IN(%s,%s, %s, %s, %s)  ';

$results = $wpdb->get_results( $wpdb->prepare( $query, $posttypes), ARRAY_A );

foreach ( $results as $row ) {
if(post_type_exists($row['post_type']) and post_type_supports($row['post_type'], 'editor' ))  { 

    // save posts and attachment links
$link = get_permalink($row['ID']);
if($link != '') $link = esc_url_raw($link);    
if(is_string($link) and $link != '') {

   wp_ada_compliance_save_post_link_record($link, $row['ID'], $row['post_type']); 
}
}

}
    
// inventory attachments
    $post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));
    $scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe', 'linked'));
if(in_array('attachment', $post_types) or in_array('pdf', $scan_external_sources)){    
$posttypes = array();
array_unshift($posttypes,"trash");
array_unshift($posttypes,"tao_sc_publish");
    array_unshift($posttypes,"cus_sc_publish");
array_unshift($posttypes,"draft");
array_unshift($posttypes,"auto-draft");
array_unshift($posttypes,"attachment");

$query = 'SELECT * FROM '.$wpdb->prefix.'posts where post_type = %s and post_status NOT IN(%s,%s, %s, %s, %s)  ';

$results = $wpdb->get_results( $wpdb->prepare( $query, $posttypes), ARRAY_A );

foreach ( $results as $row ) {

    // save pdf links
if($row['post_type'] == 'attachment' and get_post_mime_type($row['ID']) == 'application/pdf') {
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));   
$pdfurl = wp_get_attachment_url($row['ID']);
if($pdfurl != '')  $pdfurl = esc_url_raw($pdfurl);
if(is_array($scan_external_sources) and in_array('pdf',$scan_external_sources))  
wp_ada_compliance_save_link_record($pdfurl, 'pdf');   
}    
 
    // save posts and attachment links
$link = get_permalink($row['ID']);
if($link != '') $link = esc_url_raw($link);    
if(is_string($link) and $link != '') {

   wp_ada_compliance_save_post_link_record($link, $row['ID'], $row['post_type']); 
}
}
}
	
	// inventory post archives
  $ignoredposttypes = array();
array_unshift($ignoredposttypes,"trash");
array_unshift($ignoredposttypes,"tao_sc_publish");
    array_unshift($ignoredposttypes,"cus_sc_publish");
array_unshift($ignoredposttypes,"draft");
array_unshift($ignoredposttypes,"auto-draft");
$query = 'SELECT DISTINCT post_type FROM '.$wpdb->prefix.'posts where post_status NOT IN(%s,%s, %s, %s, %s)  ';
$results = $wpdb->get_results( $wpdb->prepare( $query, $ignoredposttypes), ARRAY_A );

foreach ( $results as $row ) {
if(post_type_exists($row['post_type']) and post_type_supports($row['post_type'], 'editor' ))  {  			
	$link = get_post_type_archive_link($row['post_type']);
    if($link != "") $link = esc_url_raw($link);
	if($link != site_url() and $link != ""){
wp_ada_compliance_save_theme_links($link,'theme', 0, $row['post_type'].'_archive'); 	
	}
}
	
}

// purge inventory links not found
wp_ada_compliance_purge_links(2);
}

/*******************************************************
check if link is excluded
******************************************************/
function wp_ada_compliance_check_excluded_list($link)
{
    
$excluded_link_path = get_option('wp_ada_compliance_excluded_link_path',array('paged=','/page/')); 
if(!is_array($excluded_link_path)) $excluded_link_path = array();     
    
// ignore excluded paths
if(is_array($excluded_link_path)){
foreach($excluded_link_path as $excluded_key => $excluded_value){
if($excluded_value != '' and strstr($link,$excluded_value)) return 1;
}  
}
return 0;
}
/*******************************************************
round numbers
******************************************************/
function wp_ada_compliance_round_up($number, $precision = 0)
{
    $fig = (int) str_pad('1', $precision, '0');
    return (ceil($number * $fig) / $fig);
}

function wp_ada_compliance_round_down($number, $precision = 0)
{
    $fig = (int) str_pad('1', $precision, '0');
    return (floor($number * $fig) / $fig);
}

/***************************************************
display progress stats on report screen
****************************************************/
function wp_ada_compliance_display_progress_stats($rest = 0){
	global $wpdb;   

$total = $wpdb->get_var( $wpdb->prepare( 'SELECT count(id) FROM '.$wpdb->prefix.'wp_ada_compliance_links where ignre = %d',0));

 $manprogress = $wpdb->get_var( $wpdb->prepare( 'SELECT count(id) FROM '.$wpdb->prefix.'wp_ada_compliance_links where scanflag = %d and ignre = %d',1, 0));
	
 $cronprog = $wpdb->get_var( $wpdb->prepare( 'SELECT count(id) FROM '.$wpdb->prefix.'wp_ada_compliance_links where cronflag = %d and ignre = %d',1, 0));
    

// return scan stats for ajax scan    
if($rest == 1){
$scanprogress = '';	
if(wp_ada_compliance_check_complete_status() and $manprogress != 0){
$scanprogress .= wp_ada_compliance_round_up(100/($total/$manprogress));
if($scanprogress == 100) $scanprogress = 99;
} else $scanprogress .= 0;
$progress = $scanprogress .= __('% complete','wp-ada-compliance');	
$progress .= '<br /><i class="far fa-file-alt" aria-hidden="true"></i> '.esc_attr($manprogress).__( ' of ','wp-ada-compliance'). esc_attr($total).__( ' URLs scanned ','wp-ada-compliance'); 
    
    // get next url
$progress .= wp_ada_compliance_get_next_link();
    
$progress .= '</span>';	  
}     
else{ 
// return report stats
$progress = '<p class="wp-ada-scan-progress"><i class="fas fa-chart-area" aria-hidden="true"></i> ';    
$at_least_one_scan_completed = get_option( 'wp_ada_compliance_full_scan_completed', 'false');
if($at_least_one_scan_completed == 'true'){
	$progress .= '<span class="wp-ada-initial-scan">';
	$progress .= __('Initial Scan Complete','wp-ada-compliance');
	$progress .= '</span>';
}
$progress .= '<span class="wp-ada-cron-progress">';	
$scanprogress = __('Manual Scan: ','wp-ada-compliance');
if(wp_ada_compliance_check_complete_status() and $manprogress !=0){
$scanprogress .= wp_ada_compliance_round_up(100/($total/$manprogress));
} else $scanprogress .= 0;
$progress .= $scanprogress.= __('% complete','wp-ada-compliance');		
$progress .= '</span>';	
	
// cron scan progress	
$auto_scan_options = get_option('wp_ada_compliance_auto_scan_options','false');	
if($auto_scan_options != 'false'){	
$progress .= '<span class="wp-ada-cron-progress">';
$cronprogress = __('Cron Scan: ','wp-ada-compliance');	
if(wp_ada_compliance_check_complete_status(1) and $cronprog !=0){	
$cronprogress .= wp_ada_compliance_round_up(100/($total/$cronprog));
} else $cronprogress .= 0;
$cronprogress .= __('% complete','wp-ada-compliance');
$cronprogress .= '</span><span class="wp-ada-cron-progress">';	
$cronprogress .= __(' Next Cron: ','wp-ada-compliance');
$time = wp_next_scheduled( 'wp_ada_compliance_auto_scan_cron_hook');
$cronprogress.= get_date_from_gmt ( date( 'Y-m-d H:i:s', $time ), get_option('date_format') . ' - '. get_option('time_format') );
$progress .= $cronprogress;	
$progress .= '</span>';	
}
$progress .= '</p>';
}
	return $progress;	
}

/***************************************************
get next link and ignore button
****************************************************/
function wp_ada_compliance_get_next_link(){
    global $wpdb;
    
    $cycletypes = array('post','theme', 'link', 'term','css', 'pdf','iframe');
    
$nexturl = ''; 
$total_posts_to_scan_each_run = get_option('wp_ada_compliance_full_scan_post_count','5');
    
if($total_posts_to_scan_each_run != 1) return;    
    
       $nexturl .=  '<br /><div class="wp-ada-next-urls"><i class="fas fa-link" aria-hidden="true"></i>'.__( ' Next: ','wp-ada-compliance').'<br />';
    
foreach ( $cycletypes as $key => $type ) {   
    
 if($type == 'theme' or $type == 'term' or $type == 'css' or $type == 'link' or $type == 'pdf' or $type == 'iframe')  { 
$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type = %s and scanflag = %d and ignre = %d order by id limit 1';
     $results = $wpdb->get_results( $wpdb->prepare($query, $type, 0,0), ARRAY_A );
 }
else {
    $query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where type != %s and type != %s and type != %s and type != %s and type != %s and type != %s and scanflag = %d and ignre = %d order by id limit 1';
    $results = $wpdb->get_results( $wpdb->prepare($query, 'iframe','link', 'theme', 'css', 'term','pdf', 0,0), ARRAY_A );
}

foreach ( $results as $row ) {
           
        $nexturl .=  '<span><a href="'.esc_url($row['link']).'" target="_blank" title="'.esc_url($row['link']).' - '.__( ' opens in a new window ','wp-ada-compliance').'" >...'.substr(esc_url($row['link']),-45).'</a>'.' ('.esc_attr($row['type']).')';	
    
        if($row['type'] == 'theme' or $row['type'] == 'link' or $row['type'] == 'pdf' or $row['type'] == 'iframe' or $row['type'] == 'css'){
 
        if($row['type'] == 'css'){
            $scantype = $row['link'];
               $nexturl .=  ' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&wpada_ignore_post='.esc_attr($row['id']).'&scantype='.esc_attr($scantype).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($row['type']).'&cpage=1&id=" title="';
               $nexturl .= __('Ignore','wp-ada-compliance');
               $nexturl .= '" class="adastopscanignore"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
            $nexturl .=  '</a>';  
        }
        else{
            $scantype =  str_replace(" ", "",$row['themetype']);   
               $nexturl .=  ' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&wpada_ignore_post='.esc_attr($row['id']).'&scantype='.esc_attr($scantype).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($row['type']).'&cpage=1&id=" title="';
               $nexturl .= __('Ignore','wp-ada-compliance');
               $nexturl .= '" class="adastopscanignore"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
            $nexturl .=  '</a>';  		
        }

         }
            else{
                       
         	 $nexturl .=  ' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&wpada_ignore_post='.esc_attr($row['postid']).'&scantype='.esc_attr($row['themetype']).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($row['type']).'&cpage=1&id=" title="';
               $nexturl .= __('Ignore','wp-ada-compliance');
               $nexturl .= '" class="adastopscanignore"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
            $nexturl .=  '</a>';  
            }  
    $nexturl .=  '</span>'; 
}
}
    $nexturl .=  '</div>'; 
    return $nexturl;
}
//  set wordpress option when importing content to disable scans during import
function wp_ada_compliance_start_import(){
   update_option('wp_ada_compliance_import_inprocess','1'); 
}
function wp_ada_compliance_end_import(){
   update_option('wp_ada_compliance_import_inprocess','0'); 
}


/**********************************************
// update title
**********************************************/
function  wp_ada_compliance_update_link_title($link, $content, $title = '') {
global $wpdb;  
    
if($title == '')
$title = wp_ada_compliance_page_title_from_content($content);    

if($title != '')
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set posttitle = %s where link = %s', $title, $link));   

    
return $title;    
}

/********************************************************************/	
// return page title
/********************************************************************/	
function wp_ada_compliance_page_title_from_content($content){
	
$dom = new DOMDocument;
libxml_use_internal_errors(true);
$dom->loadHTML($content);	

$titles = $dom->getElementsByTagName('title');
foreach ($titles as $title) {	
if($title->nodeValue != "") return $title->nodeValue;
}
} 
?>