<?php 
/*
Plugin - WP ADA Compliance Check
functions to process widget scans
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/**********************************************
// scan multiple widgets
**********************************************/
function wp_ada_compliance_scan_widget_text(){

$scan_widgets = get_option('wp_ada_compliance_scan_widgets','true');
if($scan_widgets == 'false') return 1;
	
if ( !defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) ) return 1;
	
$text_widgets = get_option( 'widget_text' );
$html_widgets = get_option( 'widget_custom_html' );	
	

	
if((isset($text_widgets) and is_array($text_widgets)) and (isset($html_widgets) and is_array($html_widgets)) )
$widgets = array_merge($text_widgets, $html_widgets);
elseif((isset($text_widgets) and is_array($text_widgets)))	$widgets = $text_widgets;
elseif((isset($html_widgets) and is_array($html_widgets))) $widgets = $html_widgets;

if(isset($widgets)){
	    // set record check flag on previous error records
	wp_ada_remove_corrected_widget_errors(1);	

foreach ( $widgets as $key => $widget ) {	

	if($key != '_multiwidget' ){
		if(isset($widget['content']) or isset($widget['text'])){	

		if(isset($widget['title']) and $widget['title'] != "") $postinfo['title'] = $widget['title'];
		else $postinfo['title'] = __('untitled', 'wp-ada-compliance');

		// text widget
		if(isset($widget['text']))
		$postinfo['content'] = $widget['text'];
		// custom html widget
		elseif(isset($widget['content']))
		$postinfo['content'] = $widget['content'];

		if(isset($postinfo['content']) and $postinfo['content'] != ""){
			$postinfo['excerpt'] = '';	
			$postinfo['postid'] = $key;
			$postinfo['scantype'] = 'onsave';	
			$postinfo['taxonomy'] = '';
			$postinfo['type'] = 'widget';
			$postinfo['wpget'] = ''; // when saving datbase scan only is conducted to reduce confusion	
		
			wp_ada_compliance_validate_post($postinfo);

		}
		}
		}

}

			// remove any remaining widget records
	wp_ada_remove_corrected_widget_errors(2);
	
}
}

/*********************************************************
remove corrected widget errors
*******************************************************/
function wp_ada_remove_corrected_widget_errors($pre=1) {
global $wpdb;

if($pre == 1){
// set record flag before validating content	
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET recordcheck = %d WHERE type = %s ', 0, 'widget') );
}elseif($pre == 2){
// after validation is complete remove previous errors that were not found
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and recordcheck = %d  ', 'widget', 0) );
}
}
?>