<?php 
/*
Plugin - WP ADA Compliance Check
functions to display dashboard items
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/**********************************************
// add dashboard widget with stats
**********************************************/
function wp_ada_compliance_dashboard_widgets() {
global $wp_meta_boxes;

if(current_user_can('edit_pages')){ 
wp_add_dashboard_widget('wp_ada_compliance_stats_widget', 'Web Accessibility Summary', 'wp_ada_compliance_dashboard_stats');

}
}

/**********************************************
display dashboard stats widget
**********************************************/
function wp_ada_compliance_dashboard_stats() {
echo '<div class="wp_ada_dashboard_widget">';
echo wp_ada_compliance_dashboard_summary();
echo '<p style="text-align:center; clear:both;"><a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php" class="btnwpada btnwpada-primary">';
	_e('View Report','wp-ada-compliance');
echo '</a></p>';	
echo '</div>';
}

/*********************************************
create dashboard summary
********************************************/
function wp_ada_compliance_dashboard_summary(){
global $wpdb;
// count number of records	and display message
$totalitems = wp_ada_compliance_count_total_scan_records();	
	
if($totalitems == 0){
    $summary = '<ul class="wp_ada_summary_left ">';
    $summary .= '<li class="adaViewbar wp_ada_light_yellow wp_ada_light"><i class="fas fa-circle"></i>';
    $summary .= __('Run a website scan to update the report summary.', 'wp-ada-compliance');	
$summary .= '</li>';		
$summary .= '</ul>';
 return $summary;   
}
    
$posttypes = get_option('wp_ada_compliance_posttypes',array('page','post'));	
    
// count total number of pages with issues
$query = "SELECT count(DISTINCT postid) FROM ".$wpdb->prefix."wp_ada_compliance where type != %s and type != %s and type != %s and type != %s and type != %s and type != %s and type != %s and type != %s  and ignre = %d";
$totalpages = $wpdb->get_var($wpdb->prepare($query, 'widget', 'attachment', 'theme', 'term', 'css', 'link','iframe', 'pdf', 0));

// count total number of css with issues
$query = "SELECT count(DISTINCT postid) FROM ".$wpdb->prefix."wp_ada_compliance where type = %s and ignre = %d";
$totalcss = $wpdb->get_var($wpdb->prepare($query, 'css', 0));    
    
// count total number of attachments with issues
if(in_array('attachment',$posttypes)) {   
$query = "SELECT count(DISTINCT postid) FROM ".$wpdb->prefix."wp_ada_compliance where type = %s and ignre = %d";
$totalattachments = $wpdb->get_var($wpdb->prepare($query, 'attachment', 0));
}else $totalattachments =0;
    
// count total number of widgets with issues
$scan_widgets = get_option('wp_ada_compliance_scan_widgets','true');   
if($scan_widgets == 'true'){
$query = "SELECT count(DISTINCT postid) FROM ".$wpdb->prefix."wp_ada_compliance where type = %s and ignre = %d";
$totalwidgets = $wpdb->get_var($wpdb->prepare($query, 'widget', 0));
} 

	// count total number of theme pages with issues
$query = "SELECT count(DISTINCT postid) FROM ".$wpdb->prefix."wp_ada_compliance where (type = %s or type = %s or type = %s) and ignre = %d";
$totalthemes = $wpdb->get_var($wpdb->prepare($query, 'theme','link', 'iframe', 0));
    
	// count total number of pdf files with issues
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe', 'linked'));
if(is_array($scan_external_sources) and in_array('pdf',$scan_external_sources)) {      
$query = "SELECT count(*) FROM ".$wpdb->prefix."wp_ada_compliance where type = %s and ignre = %d";
$totalpdf = $wpdb->get_var($wpdb->prepare($query, 'pdf', 0));	
}
	
	// count total number of terms with issues
$query = "SELECT count(DISTINCT posttitle) FROM ".$wpdb->prefix."wp_ada_compliance where type = %s and ignre = %d";
$totalterms = $wpdb->get_var($wpdb->prepare($query, 'term', 0));	
    
    
// count protected issues
$query = "SELECT count(*) FROM ".$wpdb->prefix."wp_ada_compliance where ignre =%d";
$totalprotected = $wpdb->get_var($wpdb->prepare($query, 2));	    

// count total number of issues
$query = "SELECT count(*) FROM ".$wpdb->prefix."wp_ada_compliance where ignre =%d";
$totalissues = $wpdb->get_var($wpdb->prepare($query, 0));		

// count ignored issues	
$query = "SELECT count(*) FROM ".$wpdb->prefix."wp_ada_compliance where ignre =%d";
$totalignored = $wpdb->get_var($wpdb->prepare($query, 1));	
    
// count total items with errors
$totalwithissues = $totalpages + $totalattachments +  $totalterms + $totalthemes + $totalwidgets + $totalcss; 

// determine grade < 20% green light  21-50% yellow 50-100% red
if($totalitems == 0){
$percent = 0;	
	$percentdisplay = 0;
}else{

$percent = round($totalwithissues/($totalitems)*100,PHP_ROUND_HALF_UP);	
$percentdisplay = round($totalwithissues/($totalitems)*100);
}
// account for last 1% bug
if($percent < 1 and $totalissues > 0) {
	$percent = 1;
	$percentdisplay = 1;
}
if($percent < 20 ) $class= 'wp_ada_light_green';	
elseif($percent >= 20 and $percent < 50 ) $class = 'wp_ada_light_yellow';
elseif($percent >= 50 ) $class = 'wp_ada_light_red';	
else $class='';	

$summary = '<ul class="wp_ada_summary_left ">';

// display protected issues		
$summary = '<ul class="wp_ada_summary_left ">';
if($totalprotected > 0){	
$summary .= '<li class="adaViewbar">';
$summary .= __('Automatic protection is zapping ', 'wp-ada-compliance');
$summary .= esc_html($totalprotected);
$summary .= __(' issues! ', 'wp-ada-compliance');
$summary .='</li>';	
}    
    
// display total issues	
$summary .= '<li class="adaViewbar">';
$summary .= __('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalissues);
$summary .= __(' issues', 'wp-ada-compliance');	
//$summary .= esc_attr($totalitems);
//$summary .= __(' items ', 'wp-ada-compliance');	
$summary .= '</li>';	
    
$summary .= '<li class="adaViewbar">';
$summary .=__('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalpages);
$summary .=__(' posts or pages with issues ', 'wp-ada-compliance');
$summary .= '</li>';

if(in_array('attachment',$posttypes)) {  
$summary .= '<li class="adaViewbar">';
$summary .=__('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalattachments);
$summary .=__(' attachments with issues ', 'wp-ada-compliance');
$summary .= '</li>';
}

$summary .= '<li class="adaViewbar">';
$summary .=__('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalterms);
$summary .= __(' category pages with issues ', 'wp-ada-compliance');
$summary .= '</li>';	
	
if($scan_widgets == 'true'){    
$summary .= '<li class="adaViewbar">';
$summary .= __('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalwidgets);
$summary .= __(' widgets with issues ', 'wp-ada-compliance');
$summary .= '</li>';
}
	
$summary .= '<li class="adaViewbar">';
$summary .= __('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalthemes);
$summary .= __(' theme files or links with issues ', 'wp-ada-compliance');
$summary .= '</li>';	
    
if(is_array($scan_external_sources) and in_array('pdf',$scan_external_sources)) {    
    $summary .= '<li class="adaViewbar">';
$summary .= __('Your website has ', 'wp-ada-compliance');
$summary .= esc_html($totalpdf);
$summary .= __(' pdf files with issues ', 'wp-ada-compliance');
$summary .= '</li>';	
}

// display ignored issues	
$query = "SELECT count(*) FROM ".$wpdb->prefix."wp_ada_compliance where ignre =%d";
$total = $wpdb->get_var($wpdb->prepare($query, 1));	
$summary .= '<li class="adaViewbar">';
$summary .= __('Ignored: You are ignoring ', 'wp-ada-compliance');
$summary .= esc_html($totalignored);
$summary .= __(' issues ', 'wp-ada-compliance');
$summary .= '</li>';	
$summary .= '<li class="adaViewbar '.esc_attr($class).' wp_ada_light"><i class="fas fa-circle"></i><span>';
$summary .= esc_html($percentdisplay);
$summary .= __('% of your site has issues ', 'wp-ada-compliance');
$summary .= '</span><br /><span>';	
if($percent == 0 ) {
	$summary .= __('Congratulations, you reached your goal!', 'wp-ada-compliance');
}
elseif($percent < 5 ) $summary .= __(' You\'re doing awesome! ', 'wp-ada-compliance');		
elseif($percent == 10 ) $summary .= __(' You\'re doing great, strive for less than 5%! ', 'wp-ada-compliance');	
elseif($percent < 20 ) $summary .= __(' You\'re doing good, but you can do better! ', 'wp-ada-compliance');
elseif($percent < 40 ) $summary .= __(' You have some work to do! ', 'wp-ada-compliance');	
elseif($percent > 40 ) $summary .= __(' Don\'t get discouraged, Get R Done! ', 'wp-ada-compliance');	
$summary .= '</span></li>';		
$summary .= '</ul>';
return $summary;
}

?>