<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/***************************************
add support for Elementor Editor
*****************************************/
add_action('wp_footer', function() {
    global $post;

if(!is_object($post)) return;
    
// ignore posts not being checked    
$post_object = get_post( $post->ID );
if(!is_object($post_object))  return;
$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));    
if (!is_array($post_types) or !in_array($post->post_type, $post_types)) return;
   
// don't do anything if disabled on editor screen    
$wp_ada_compliance_deep_scan_on_editor = get_option('wp_ada_compliance_deep_scan_on_editor','true');
if($wp_ada_compliance_deep_scan_on_editor == 'disabled') return;    
    
if (!did_action( 'elementor/loaded' ) or !\Elementor\Plugin::$instance->preview->is_preview_mode() ) {
    return;
  }   
    	// include thick box
	add_thickbox();	
  ?>
<div id="ElementorADAError" class="adaError"><button type="button" aria-label="<?php _e('Dismiss error','wp-ada-compliance'); ?>" class="adadismiss">X</button></div>
<button type="button" class="wp-ada-elementor-check"><i class="fas fa-universal-access" aria-hidden="true"></i> <?php _e('Check for Issues','wp-ada-compliance'); ?></button>
  <script>
jQuery( function( $ ) {
$(document).on("click", '.adadismiss', function() {
$('#ElementorADAError').hide();
}); 

    // display message on save 
    //THIS IS DEPRECATED AND NEEDS TO BE REPLACED
if (typeof elementor !== 'undefined') {  
   // elementor.hooks.addAction( "document/save/save",  function(){
elementor.saver.on( "after:save",  function(){
wp_ada_compliance_display_error_message();
});
}
   // display message when button clicked                      
$(document).on('click','.wp-ada-elementor-check', function() { 
    wp_ada_compliance_display_error_message();
});
});
    
// display error report message  
function wp_ada_compliance_display_error_message(resturl){
jQuery( function( $ ) {    
var seperator='&';
var nonce = '<?php echo wp_create_nonce( 'wp_rest' );?>';
var resturl = '<?php echo esc_url_raw(get_rest_url()); ?>';
if(resturl.search('/wp-json/')>0) seperator='?';			

url = resturl+'wp_ada_compliance/v1/displaynotice/<?php echo $post->ID; ?>'+seperator+'_wpnonce='+nonce;
    $.ajaxSetup({
    converters: {
        "text json" : function(response) {
            return (response == "") ? null : JSON.parse(response);
        },
    },
});
$.ajax({
url: url,
error: function(jqXHR, textStatus, errorThrown) {
  console.log(textStatus, errorThrown);
},
success: 
function(data){
if(data === '' || data == '-1') {
data = '<?php _e('No web accessibility issues were found!','wp-ada-compliance');?>';    

}
 $('#ElementorADAError').html('<button type="button" aria-label="<?php _e('Dismiss error','wp-ada-compliance'); ?>" class="adadismiss">X</button>'+data); 

$('#ElementorADAError').show();       
 
}

});
    });
}
</script>
 <?php
} );

/*****************************************************
// filter elementor content when checking for issues
*****************************************************/
function wp_ada_compliance_check_elementor_content($content,$postid){
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
    
if(!is_plugin_active('elementor/elementor.php')) return $content;   
  
$contentElementor = "";

if (class_exists("\\Elementor\\Plugin")) {
    $pluginElementor = \Elementor\Plugin::instance();
    $contentElementor = $pluginElementor->frontend->get_builder_content($postid);
    if($contentElementor !='' and is_string($contentElementor)) return $contentElementor;
}

return $content;
}

/*****************************************************
// check if post uses elementor
*****************************************************/
function wp_ada_compliance_check_elementor_content_active($postid){
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
    
if(!is_plugin_active('elementor/elementor.php')) return 0;   
  
	$contentElementor = "";

if (class_exists("\\Elementor\\Plugin")) {
    $pluginElementor = \Elementor\Plugin::instance();
    $contentElementor = $pluginElementor->frontend->get_builder_content($postid);
    if($contentElementor !='' and is_string($contentElementor)) return 1;
}

return 0;
}

/**************************************************************
// add script to allow skip link to work with elementor and OceanWP 
***************************************************************/
add_action('wp_footer','wp_ada_compliance_correct_skip_links_in_elementor'); 
function wp_ada_compliance_correct_skip_links_in_elementor(){
    
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return;        

$skip_link = get_option('wp_ada_compliance_skip_links',array());	
if(!is_array($skip_link) or count($skip_link) == 0) return;

if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;   
  
 ?>
  <script>
if(jQuery){		  
  jQuery( function( $ ) {
   $('a.wp-ada-compliance-skip-link').on('click', function(event){
    event.stopPropagation();
}); 
  } );
}
</script>
 <?php
}
  

/**************************************************************
// add script correct elementor table of contents widget
***************************************************************/
add_action('wp_footer','wp_ada_compliance_correct_elementor_TOC_links');
function wp_ada_compliance_correct_elementor_TOC_links(){
    
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return;        
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
   
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;      
       
$setting = get_option('wp_ada_compliance_correct_elementor_TOC','true');

if($setting == 'false') return;
 
 ?>
  <script>  
if(jQuery){		  
jQuery(document).ready(function($){
// correct toc display toggle by adding label, role and tabindex to collapse button
$('.elementor-widget-table-of-contents').each(function( key, toc ) {
var wpadaTOCID = 'wp-ada-compliance-TOC-'+key;
jQuery('.elementor-toc__body',toc).addClass(wpadaTOCID);    
$('.elementor-toc__toggle-button',toc).each(function( keybutton, tocbutton ) {		
jQuery(tocbutton).attr('role','button');
    if(jQuery(tocbutton).hasClass('elementor-toc__toggle-button--expand')){
        jQuery(tocbutton).css('display','none');
    }
    jQuery(tocbutton).attr('class','wp-ada-compliance-TOC-button');
	jQuery(tocbutton).attr('tabindex','0');
    jQuery(tocbutton).attr('data-tocid',wpadaTOCID);
jQuery(tocbutton).attr('aria-label','<?php _e('Toggle Table of Contents','wp-ada-compliance'); ?>');
	if(jQuery('.elementor-toc__body',toc).is(':visible') === true){
		jQuery(tocbutton).attr('aria-expanded', 'true');

	}
   else {
	   jQuery(tocbutton).attr('aria-expanded', 'false');
   }
});	
});	
		
jQuery("body").on("keypress click", ".wp-ada-compliance-TOC-button", function (event) {

	if(jQuery(this).attr('aria-expanded') === 'true'){
		jQuery('.elementor-toc__toggle-button').attr('aria-expanded', 'true');
		jQuery(this).attr('aria-expanded', 'false');
        jQuery('.'+jQuery(this).attr('data-tocid')).hide('slow');
	}
   else {
	   jQuery('.elementor-toc__toggle-button').attr('aria-expanded', 'false');
	   jQuery(this).attr('aria-expanded', 'true');
       jQuery('.'+jQuery(this).attr('data-tocid')).show('slow');
   }

});		
	
    //autocorrect elementor_toc - dont remove or change this line
jQuery("body").on("click", "a.elementor-toc__list-item-text", function (event) {
event.stopPropagation();	
// window.location.hash = jQuery(this).attr('href');
var wpada_selectedid = $(this).attr('href');
	$(wpada_selectedid).attr('tabindex','-1');
	$(wpada_selectedid).focus();

});
});
}
</script>
 <?php
}

/**************************************************************
// add script correct elementor toggles widget
***************************************************************/
add_action('wp_footer','wp_ada_compliance_correct_elementor_toggle_links');
function wp_ada_compliance_correct_elementor_toggle_links(){
    
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return;        
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
   
    if(!is_plugin_active('elementor/elementor.php')) return;  
    
$setting = get_option('wp_ada_compliance_correct_elementor_toggles','true');  
if($setting == 'false') return;
 
 ?>
  <script>
if(jQuery){		  
jQuery(document).ready(function($){
   // correct toggles, tabs and accordions 
	 //autocorrect elementor_toggles - dont remove or change this line	

jQuery("body").on("keypress click", ".elementor-accordion .elementor-tab-title, .elementor-toggle .elementor-tab-title", function (event) {
var key = event.keyCode;
    if(key == 32){ // activate on space bar
		event.preventDefault();
         jQuery(this).trigger('click');
    }	
setTimeout(function(){
 jQuery('.elementor-accordion .elementor-tab-title, .elementor-toggle .elementor-tab-title').attr('tabindex','0');
}, 500);
});
	

// correct tabs
jQuery("body").on("keypress keydown", ".elementor-tabs .elementor-tab-title", function (event) {
var key = event.keyCode;

if(key == 13 || key == 32){ // trigger click on spacebar or enter
	event.preventDefault();
 jQuery(this).trigger('click');
	jQuery(this).focus();
}
if(key == 38){ 	// add up down arrow support for tabs	
event.preventDefault();	
var focusable = jQuery(this).parent().find(':focusable');
if(focusable.first().is(':focus'))
	focusable.last().focus();
else jQuery(this).prev().focus();
}
if(key == 40){ 	// add up down arrow support for tabs
event.preventDefault();	
var focusable = jQuery(this).parent().find(':focusable');
if(focusable.last().is(':focus'))
	focusable.first().focus();
else jQuery(this).next().focus();
} 
});

// remove aria-expanded	
jQuery("body").on("click keypress", ".elementor-tabs .elementor-tab-title", function (event) {
setTimeout(function(){
$('.elementor-tabs .elementor-tab-title').each(function( key, tabs ) {  	
jQuery(this).removeAttr('aria-expanded');
}, 500);
});	
});
	
});
}
</script>
 <?php
}

/***********************************************************************************
// remove autoplay from Elementor Slideshows
**********************************************************************************/
add_action('wp_footer','wp_ada_compliance_filter_stop_autoplay_image_carousel');
function wp_ada_compliance_filter_stop_autoplay_image_carousel(){
    if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;    
    
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
if($wp_ada_compliance_filter_content == 'false') return;    
    
$stop_autoplay = get_option('wp_ada_compliance_stop_autoplay_image_carousel','false');
if($stop_autoplay == 'false')	return;
	
 ?>
  <script> 
if(jQuery){		  
jQuery(document).ready(function($){
     //autocorrect elementor_carousel_autoplay - dont remove or change this line
if ( $( ".elementor-image-carousel" ).length ) {  
   $( ".elementor-image-carousel-wrapper" ).attr('role','group');
$( ".elementor-image-carousel-wrapper" ).attr('aria-label','<?php _e('image carousel','wp-ada-compliance');?>');	 
$(".elementor-image-carousel-wrapper").hover(function() {
setTimeout(function(){   
$('.elementor-image-carousel-wrapper').each(function( key, carousel ) {    
const wp_ada_compliance_imageCarousel = jQuery (this),    
wp_ada_compliance_swiperInstance = wp_ada_compliance_imageCarousel.data( 'swiper' );
	if(typeof(wp_ada_compliance_swiperInstance) !== "undefined")
wp_ada_compliance_swiperInstance.autoplay.stop();
});    
}, 1000);    
});    
    
setTimeout(function(){
$('.elementor-image-carousel-wrapper').each(function( key, carousel ) {    
const wp_ada_compliance_imageCarousel = jQuery (this),
wp_ada_compliance_swiperInstance = wp_ada_compliance_imageCarousel.data( 'swiper' );
	if(typeof(wp_ada_compliance_swiperInstance) !== "undefined")
wp_ada_compliance_swiperInstance.autoplay.stop();
});
}, 1000);
}
});
}
</script>
 <?php
}

/****************************************************************
correct elementor toggles
****************************************************************/
function wp_ada_compliance_correct_elementor_toggles($dom){

    if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    if(!is_plugin_active('elementor/elementor.php')) return $dom;  
    
$setting = get_option('wp_ada_compliance_correct_elementor_toggles','false');  
if($setting == 'false') return $dom;
 
// correct toggles and accordions	
$elements = $dom->find('div[class*=elementor-accordion], div[class*=elementor-toggle]');	
foreach ($elements as $elment) {	
$toggleitems = $elment->find('[class*=elementor-tab-title]');
foreach ($toggleitems as $toggleitem) {	
	$toggleitem->setAttribute('tabindex', '0');
	$toggleitem->setAttribute('role','button');
	$currentclass = $toggleitem->getAttribute('class');
	$toggleitem->setAttribute('data-wp-ada-autocorrect','true');
	$toggleitem->setAttribute('class', $currentclass.' wp-ada-elementor-tab-title');
$links = $toggleitem->find('a[class*=elementor-toggle-title], a[class*=elementor-accordion-title]');
foreach ($links as $link) {
		// remove inner links
		$link->outertext = $link->plaintext;

}
}
$togglecontents = $elment->find('div[class*=elementor-tab-content]');
foreach ($togglecontents as $togglecontent) {	
		$currentclass = $togglecontent->getAttribute('class');
	$togglecontent->setAttribute('class', $currentclass.' wp-ada-elementor-tab-title');
	$togglecontent->setAttribute('tabindex', '0');
	}	
}	


	// correct tabs
$elements = $dom->find('div[class*=elementor-tabs]');	
foreach ($elements as $elment) {	
$toggleitems = $elment->find('[role=tab]');
foreach ($toggleitems as $toggleitem) {	
	//$toggleitem->setAttribute('tabindex', '0');
	$currentclass = $toggleitem->getAttribute('class');
	$toggleitem->setAttribute('data-wp-ada-autocorrect','true');
	$toggleitem->removeAttribute('aria-expanded');
	$toggleitem->setAttribute('class', $currentclass.' wp-ada-elementor-tab-title');
$links = $toggleitem->find('a');
foreach ($links as $link) {
	
	// remove inner links
		$link->outertext = $link->plaintext;

}
}
$togglecontents = $elment->find('div[class*=elementor-tab-content]');
foreach ($togglecontents as $togglecontent) {	
		$currentclass = $togglecontent->getAttribute('class');
	$togglecontent->setAttribute('class', $currentclass.' wp-ada-elementor-tab-title');
	$togglecontent->setAttribute('tabindex', '0');
	}	
}	

	

    
return $dom;    
} 


	
/****************************************************************
correct elementor icon widgets
****************************************************************/
function wp_ada_compliance_correct_elementor_icon_boxes($dom){
  
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
if(!is_plugin_active('elementor/elementor.php')) return $dom;        
    
$setting = get_option('wp_ada_compliance_correct_elementor_icon_and_img_widgets','true');  
if($setting == 'false') return $dom;
		
$iconboxs = $dom->find('[class=elementor-icon-box-wrapper]');
foreach ($iconboxs as $iconbox) {
$label = '';	
$titles = $iconbox->find('[class=elementor-icon-box-title] a');
foreach ($titles as $title) {
	$label = trim($title->innertext);
}
    
$elements = $iconbox->find('[class=elementor-icon-box-icon] a');
foreach ($elements as $element) {
	if($label != '') $element->setAttribute('aria-label',$label);
    $element->setAttribute('tabindex','-1');
     $element->setAttribute('aria-hidden','true');
}
}
    
return $dom;    
}


/****************************************************************
correct elementor image box widgets
****************************************************************/
function wp_ada_compliance_correct_elementor_image_boxes($dom){

    if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    if(!is_plugin_active('elementor/elementor.php')) return $dom;  
    
$setting = get_option('wp_ada_compliance_correct_elementor_icon_and_img_widgets','false');  
if($setting == 'false') return $dom;
	
$imageboxs = $dom->find('[class=elementor-image-box-wrapper]');
foreach ($imageboxs as $imagebox) {
$label = '';
	
$label = '';	
$titles = $imagebox->find('[class=elementor-image-box-title] a');
foreach ($titles as $title) {
	$label = trim($title->innertext);
}	

$elements = $imagebox->find('figure[class=elementor-image-box-img] a');
foreach ($elements as $element) {
	if($label != '') $element->setAttribute('aria-label',$label);
    $element->setAttribute('tabindex','-1');
     $element->setAttribute('aria-hidden','true');
}
}
    
return $dom;    
}

/****************************************************************
correct elementor post widgets
****************************************************************/
function wp_ada_compliance_correct_elementor_post_widget($dom){

    if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    if(!is_plugin_active('elementor-pro/elementor-pro.php')) return $dom;  
    
$setting = get_option('wp_ada_compliance_correct_elementor_post_widget','false');  
if($setting == 'false') return $dom;
	
$ELposts = $dom->find('[class^=elementor-posts-container] article');

foreach ($ELposts as $ELpost) {
$label = '';

$titles = $ELpost->find('[class=elementor-post__title] a');
foreach ($titles as $title) {
	$label = trim($title->innertext);
}		

$elements = $ELpost->find('a[class=elementor-post__thumbnail__link]');
foreach ($elements as $element) {
	if($label != '') $element->setAttribute('aria-label',$label);
    $element->setAttribute('tabindex','-1');
     $element->setAttribute('aria-hidden','true');
}
}
    
return $dom;    
}
?>