<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/**********************************************
// check if error exists
**********************************************/
function wp_ada_compliance_error_check($postinfo, $errortype, $object) {
	global $wpdb, $wp_ada_compliance_def;
    
        $locationnotes = '';
    $themeerror = '';
   	$scantype = sanitize_text_field($postinfo['scantype']);
	$postid = (int)$postinfo['postid'];
	$title = sanitize_text_field($postinfo['title']);
	$type = sanitize_text_field($postinfo['type']);
    if(isset($postinfo['modifieddate']))
    $modifieddate = sanitize_text_field($postinfo['modifieddate']);
    else $modifieddate = '';
    $errortype = sanitize_text_field($errortype);
	if(isset($postinfo['examplecode'])) $examplecode = $postinfo['examplecode'];
	else $examplecode = "";
   	
   $ignre = wp_ada_compliance_get_ignore_value($errortype, $object, $type, $postinfo);
	
   if($type == 'theme' or $type == 'css'){
	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT id, postid, ignre FROM '.$wpdb->prefix.'wp_ada_compliance  where scantype = %s and type = %s and postid = %d and errorcode = %s and object = %s ', $scantype, $type, $postid, $errortype, $object ), ARRAY_A );
	}
	
	else{
   	
	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT id, postid, ignre FROM '.$wpdb->prefix.'wp_ada_compliance  where type = %s and postid = %d and errorcode = %s and object = %s', $type, $postid, $errortype,$object), ARRAY_A );	
	}

	if ( $results ) {
	foreach ( $results as $row) {
        
				// if being ignored, don't overwrite value
	if($row['ignre'] == 1 and $ignre == 0)  $ignre = 1;
        
		
  $locationnotes = sanitize_text_field(wp_ada_compliance_theme_error_check($errortype,$object, $type, $postid)); 
    $themeerror = wp_ada_compliance_theme_error_probability_check($object, $type, $postid, $errortype, $scantype);
    wp_ada_compliance_mark_theme_errors($object, $themeerror, $type);
	
	    // determine severity code
    if(strstr($wp_ada_compliance_def[$errortype]['DisplayError'],__('WARNING', 'wp-ada-compliance'))) $severity = 'W';
    elseif(strstr($wp_ada_compliance_def[$errortype]['DisplayError'],__('ALERT', 'wp-ada-compliance'))) $severity = 'A';
    else $severity = '';
		
		// set recordcheck to 1
	if($type == 'theme' or $type == 'css'){
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance  SET posttitle = %s, recordcheck = %d, ignre = %d, severity = %s, themeerror = %d, locationnotes  =  %s WHERE  id = %d ', $title, 1, $ignre, $severity, $themeerror, $locationnotes, $row['id']) );
		
		}
		
		else{
         

			$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance SET  posttitle = %s, recordcheck = %d, ignre = %d, modifieddate = %s, severity = %s, themeerror = %d, locationnotes  =  %s, examplecode =  %s, scantype= %s WHERE id = %d ', $title, 1, $ignre, $modifieddate, $severity, $themeerror, $locationnotes, $examplecode, $scantype, $row['id'] ) );	
			}
        
        
		
		return 1;
	}
	}
}
/**********************************************
// set ignore value
**********************************************/
function wp_ada_compliance_get_ignore_value($errortype, $object, $type, $postinfo) {	
	
	
$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 

$ignre = 0;	// default
    

// set ignore value if being auto corrected    
if($type != 'css' and $wp_ada_compliance_filter_content != 'false'){
    
 // check if being auto corrected     
if($errortype == 'absolute_fontsize' and wp_ada_compliance_validate_absolute_fontsize($object, $postinfo, 1) != '1') $ignre = 2; 
if($errortype == 'adjacent_identical_links' and  wp_ada_compliance_validate_adjacent_identical_links($object, $postinfo, 1) != '1') $ignre = 2; if($errortype == 'empty_anchor_tag' and wp_ada_compliance_validate_empty_anchor_tag($object, $postinfo, 1) != '1') $ignre = 2;  
if($errortype == 'missing_lang_attr' and wp_ada_compliance_validate_missing_lang_attr($object, $postinfo, 1) != '1') $ignre = 2;       
if($errortype == 'img_alt_invalid' and wp_ada_compliance_validate_img_alt_invalid($object, $postinfo, 1) != '1')	$ignre = 2;	
if($errortype == 'missing_th' and wp_ada_compliance_validate_missing_th($object, $postinfo, 1) != '1')	$ignre = 2;
if($errortype == 'redundant_title_tag' and wp_ada_compliance_validate_redundant_title_tag($object, $postinfo, 1) != '1') $ignre = 2;  
if($errortype == 'redundant_alt_text' and wp_ada_compliance_validate_redundant_alt_text($object, $postinfo, 1) != '1') $ignre = 2; 
if($errortype == 'text_justified' and wp_ada_compliance_validate_text_justified($object, $postinfo, 1) != '1') $ignre = 2;  
if($errortype == 'empty_heading_tag' and wp_ada_compliance_validate_empty_heading_tag($object, $postinfo, 1) != '1') $ignre = 2;  	   
if($errortype == 'new_window_tag' and wp_ada_compliance_validate_new_window_tag($object, $postinfo, 1) != '1') $ignre = 2; 	
if($errortype == 'av_tag_with_autoplay' and wp_ada_compliance_validate_av_tag_with_autoplay($object, $postinfo, 1) != '1') $ignre = 2; 	
if($errortype == 'img_linked_to_self' and wp_ada_compliance_validate_img_linked_to_self($object, $postinfo, 1) != '1') $ignre = 2; 	
if($errortype == 'iframe_missing_title' and wp_ada_compliance_validate_iframe_missing_title($object, $postinfo, 1) != '1') $ignre = 2; 	
if($errortype == 'emulating_links' and wp_ada_compliance_validate_emulating_links($object, $postinfo, 1) != '1') $ignre = 2; 
if($errortype == 'missing_onkeypress' and wp_ada_compliance_validate_missing_onkeypress($object, $postinfo, 1) != '1') $ignre = 2; 
if($type != 'widget' and $errortype == 'unlinked_anchors' and wp_ada_compliance_validate_unlinked_anchors($object, $postinfo, 1) != '1') $ignre = 2;
if($errortype == 'ambiguous_anchor_tag'  and wp_ada_compliance_validate_ambiguous_anchor_tag($object, $postinfo, 1) != '1') $ignre = 2;
if($errortype == 'redundant_anchor_text'  and wp_ada_compliance_validate_redundant_anchor_text($object, $postinfo, 1) != '1') $ignre = 2;
if($errortype == 'link_to_non_html_content'  and wp_ada_compliance_validate_link_to_non_html_content($object, $postinfo, 1) != '1') $ignre = 2;
if($errortype == 'visual_focus_removed'  and wp_ada_compliance_validate_visual_focus_removed($object, $postinfo, 1) != '1') $ignre = 2;
if($errortype == 'elementor_toc' and wp_ada_compliance_validate_elementor_toc($object, $postinfo, 1) != '1') $ignre = 2;
if($errortype == 'elementor_toggles' and wp_ada_compliance_validate_elementor_toggles($object, $postinfo, 1) != '1') $ignre = 2; 
if($errortype == 'elementor_carousel_autoplay' and wp_ada_compliance_validate_elementor_carousel_autoplay($object, $postinfo, 1) != '1') $ignre = 2;    
//if($errortype == 'empty_icon' and get_option('wp_ada_compliance_hide_font_awesome_icons','true') == 'true') $ignre = 2; 
}

return $ignre;
}


/*************************************************************
check ignored duplicate check
*************************************************************/
function wp_ada_compliance_check_if_error_is_excluded($error)
{
   $excludedErrors = array();
   $excludedErrors[] = 'multiple_ways_failure';
   $excludedErrors[] = 'skip_nav_links';
   $excludedErrors[] = 'missing_lang_attr';
   $excludedErrors[] = 'html_validation';
    $excludedErrors[] = 'untagged_document';
    $excludedErrors[] = 'missing_landmarks';
	$excludedErrors[] = 'unlabeled_landmarks';
    $excludedErrors[] = 'missing_headings';
   
if(in_array($error,$excludedErrors)) return 1;

return 0;
}
/**********************************************
// check if post has errors 
**********************************************/
function wp_ada_compliance_reported_errors_check($post, $btncheck) {
	global $wpdb;
$postid = $post->ID;  
   $type = $post->post_type;
	
	$deep_scan_on_editor = get_option('wp_ada_compliance_deep_scan_on_editor','true');
   
    if($type == 'attachment') {
        $mimetype = get_post_mime_type($post->ID);
    }
    else $mimetype = '';
    
    if($mimetype == 'application/pdf'){
        $type = 'pdf';
	$query = 'SELECT postid FROM '.$wpdb->prefix.'wp_ada_compliance where type = %s and attachmentid = %d and themeerror < 75';
    }
    else{
		
      $query = 'SELECT postid FROM '.$wpdb->prefix.'wp_ada_compliance where  type = %s and postid = %d and themeerror < 75';  
		if( $deep_scan_on_editor == 'false') $query .= " and scantype = 'onsave' ";
    }
    
    
    // used for accessibility report button check only
	if($btncheck == 1){
	// hide if auto filter is turned off
	$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	if($report_filtered_errors == 'false' or $report_filtered_errors == 'scanonly') $query .= " and ignre != 2"; 
	}
	if($btncheck == 2){
	// hide if auto filter is turned off or being ignored (block editor)
	$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	if($report_filtered_errors == 'false' or $report_filtered_errors == 'scanonly') $query .= " and ignre = 0"; 
	}
    
	$results = $wpdb->get_results( $wpdb->prepare( $query, $type, $postid), ARRAY_A );

if($wpdb->num_rows > 0) return 1;

	return 0;
}

/**********************************************
// check if attachment has errors 
**********************************************/
function wp_ada_compliance_attachment_reported_errors_check($attachmentid) {
	global $wpdb;
   
  	$query = 'SELECT postid FROM '.$wpdb->prefix.'wp_ada_compliance where attachmentid = %d and type = %s and ignre = %d';
      	
	$results = $wpdb->get_results( $wpdb->prepare( $query, $attachmentid, 'pdf', 0), ARRAY_A );

if($wpdb->num_rows > 0) return 1;

	return 0;
}

/**********************************************
// format error location message
**********************************************/
function wp_ada_compliance_format_error_location($ignre, $errorcode,$type,$errorid, $locationnotes, $themeerror, $tags = 1) {
global $wpdb;    
$source = '';
$details = '';
    
// check for error in external source (iframe or css)
if($type == 'css'){ 
$source = __('** ', 'wp-ada-compliance');
$source .= __(' css source', 'wp-ada-compliance');
$details = __('Error found in a linked CSS file.','wp-ada-compliance');
}
if($type == 'iframe'){ 
$source = __('** ', 'wp-ada-compliance');
$source .= __('iframe source', 'wp-ada-compliance');
$details= __('This error was found in an embedded Iframe.','wp-ada-compliance');
}    
    
    
// process location notes
if($locationnotes !=''){
$notes = explode('|',$locationnotes);
$source = $notes[0];
$details = $notes[1];    
}  
 
// certain error types are always theme errors       
$errorTypes = array('skip_nav_links', 'missing_lang_attr', 'multiple_ways_failure', 'missing_landmarks', 'unlabeled_landmarks');     

if($ignre == 2) {
$source = __('** auto corrected', 'wp-ada-compliance');
    $details = __('This issue is being corrected using one of the built in content filter options. To ensure changes can be reversed, content filters do not change the database content, instead issues are corrected as pages load on the website.','wp-ada-compliance');
}         
//. mark un tagged docs
elseif($errorcode == 'untagged_document') {
$source = __('** pdf content','wp-ada-compliance'); 
$details = __('This issue is in the PDF source code.','wp-ada-compliance');    
}
	// missing headings information message
elseif($errorcode == 'missing_headings') {
$source = __('** information','wp-ada-compliance'); 
$details = __('This alert refers to the editor content only and is intended to inform the user that the affected page does not have headings in the content area of the editor.','wp-ada-compliance');    
}		
// certain error types are always theme errors   
elseif(in_array($errorcode,$errorTypes)) {
 $source = __('** theme error','wp-ada-compliance'); 
$details = __('Due to the error type, there is a HIGH probability that this issue will be found somewhere external to the editor content of this file.','wp-ada-compliance'); 
}     
    
// if location notes are not set yet show probability notes
elseif($source == ''){    
if($themeerror == 10) {
$source = __('** theme error','wp-ada-compliance'); 
$details = __('Due to the number of recurrences of this issue, there is a LOW probability that this issue will be found somewhere external to the editor content of this file.','wp-ada-compliance'); 

}
elseif($themeerror == 33) {
$source = __('** theme error','wp-ada-compliance'); 
$details = __('Due to the number of recurrences of this issue, there is a MEDIUM probability that this issue will be found somewhere external to the editor content area of this file.','wp-ada-compliance'); 
       $details .= '<span class="wp-ada-theme-error">';
    $details .= __('Theme errors are errors that are not likely to be found in the content of the file listed. Instead the issue is more likely to be found in an external source such as a theme file. ','wp-ada-compliance');
    $details .= '</span>';
}
elseif($themeerror > 74 and $type != 'term' and $type != 'theme') {
$source = __('** theme error','wp-ada-compliance'); 
$details = __('Due to the number of recurrences of this issue, there is a HIGH probability that this issue will be found somewhere external to the editor content area of this file.','wp-ada-compliance'); 
} 
 elseif($themeerror == 100) {
$source = __('** theme error','wp-ada-compliance'); 
$details = __('Errors found in term and theme files are marked as theme errors by default. The exception being errors found to be caused by content present in another location (i.e... post excerpt, term description or page content).','wp-ada-compliance'); 
} 
}
  
if($source != '') {
        if(strstr($source,'theme error')){
           $details .= '<span class="wp-ada-theme-error">';
    $details .= __('Theme errors are errors that are not likely to be found in the content of the file listed. Instead the issue is more likely to be found in an external source such as a theme file. ','wp-ada-compliance');
    $details .= '</span>';
    }
    if($tags == 1)
$message = '<br /><div class="wp-ada-compliance-location-other wp-ada-compliance-location" ><span class="wp-ada-source-text">'.$source.'</span> <span class="wp-ada-screen-reader-text">'.$details.'</span></div>'; 
else  $message = $source;   
    


return $message;
}
}

/**********************************************
// check for theme errors
**********************************************/
function wp_ada_compliance_reported_errors_theme_check($errorid) {
	global $wpdb;

	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT themeerror FROM '.$wpdb->prefix.'wp_ada_compliance where id = %d ', $errorid), ARRAY_A );

foreach($results as $row => $rows){
    
    return $rows['themeerror'];
}
	return 0;

}

/**********************************************
// check for theme errors
**********************************************/
function wp_ada_compliance_process_location_notes() {
global $wpdb;
$locationnotes = '';
$results = $wpdb->get_results('SELECT id, object, postid, type, errorcode FROM '.$wpdb->prefix.'wp_ada_compliance', ARRAY_A );

foreach($results as $rows => $row){
$locationnotes = wp_ada_compliance_theme_error_check($row['errorcode'],$row['object'], $row['type'], $row['postid'], 1);
if($locationnotes != ''){
$wpdb->query($wpdb->prepare('UPDATE '.$wpdb->prefix.'wp_ada_compliance SET locationnotes = %s WHERE id = %d', $locationnotes, $row['id'])); 
}
}

}

/***************************************************************************
// check theme error probability
****************************************************************************/
function wp_ada_compliance_theme_error_check($errortype,$object, $type, $postid, $progress=0) {
global $wpdb;
$source = '';
$details = '';
 $locationnotes = ''; 
$wp_ada_compliance_deep_scan = '0';    
    
// don't go any further if widget or pdf     
if($type == 'widget' or $type == 'pdf' or $object == '' ) return;
        
if(current_filter() == 'edited_term' or current_filter() == 'edit_attachment' or current_filter() == 'save_post' or isset($_GET['wpadarescan']) or isset($_GET['scansingle']) or defined( 'DOING_CRON' ) or $progress == 1){
$wp_ada_compliance_deep_scan = '1';
}

// terms
if($type == 'term'){
$term_description = term_description($postid);
if(strstr($term_description, $object)) {
$source = __('** term description','wp-ada-compliance'); 
$details = __('This error was found in the term description.','wp-ada-compliance'); 
$locationnotes = $source.'|'.$details; 
return $locationnotes;    
}
    
// check if error is actually in a post    
if($wp_ada_compliance_deep_scan == '1'){
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT posttitle FROM '.$wpdb->prefix.'wp_ada_compliance where object = %s and type NOT IN(%s,%s,%s,%s,%s,%s,%s) and themeerror = %d ', $object, 'iframe','pdf', 'link', 'term', 'attachment', 'theme','widget', 0), ARRAY_A );
foreach($results as $rows => $row){  
    $source = __('** post content ','wp-ada-compliance'); 
    $details = __('There is a HIGH probability that this error is located in post or page content. POST TITLE: ','wp-ada-compliance').esc_attr($row['posttitle']);
    $locationnotes = $source.'|'.$details;   
    return $locationnotes;
}  

}
}

if($wp_ada_compliance_deep_scan == '1'){  
 
// check if it is in a widget
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT posttitle FROM '.$wpdb->prefix.'wp_ada_compliance where object = %s and type = %s and themeerror = %d', $object, 'widget', 0), ARRAY_A );
foreach($results as $rows => $row){  
    $source = __('** widget content ','wp-ada-compliance'); 
    $details = __('There is a HIGH probability that this error is located in widget content. WIDGET TITLE: ','wp-ada-compliance').esc_attr($row['posttitle']); 
    $locationnotes = $source.'|'.$details;   
    return $locationnotes;
} 
    
// check featured images 
if($type != 'pdf' and $type != 'term' and $type != 'attachment' and $type != 'theme' and $type  != 'widget' and $type  != 'link' and $type  != 'iframe' and strstr($errortype,'img_')){
if($img = get_the_post_thumbnail($postid) ){
    
    // get source sets
$dom1 = str_get_html($img);
$image = $dom1->find('img');
    
if(isset($image[0])){
    
$featuredimagsrcset = $image[0]->getAttribute('srcset');
    
// get source sets
$dom2 = str_get_html($object);
$image2 = $dom2->find('img');
    
if(isset($image2[0])){    
$imagehref = $image2[0]->getAttribute('src');  
    
if($imagehref != '' and stristr($featuredimagsrcset,$imagehref)) {   
$source = __('** featured image ','wp-ada-compliance'); 
$details = __('There is a HIGH probability that this error is located in the featured image.','wp-ada-compliance');
    $locationnotes = $source.'|'.$details;   
    return $locationnotes;
}
}
}
}
}  
   
// check if error is in an excerpt
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT post_title  FROM '.$wpdb->prefix.'posts where post_excerpt LIKE %s', '%'.$object.'%'), ARRAY_A );
foreach($results as $rows => $row){  
$source = __('** post excerpt ','wp-ada-compliance'); 
$details = __('There is a HIGH probability that this error is located in a post or page excerpt. POST TITLE: ','wp-ada-compliance').esc_attr($row['post_title']);
    $locationnotes = $source.'|'.$details;   
    return $locationnotes;
}  
   
// check if error is in a custom field
$keystofilter = get_option('wp_ada_compliance_metafields',array('_thumbnail_id'));	

if(!is_array($keystofilter)) $keystofilter = array();
	
$how_many = count($keystofilter);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);	
    
if($format != '') {
    
$query = 'SELECT post_id, meta_key FROM '.$wpdb->prefix.'postmeta where meta_key in('.$format.') and meta_value LIKE %s ';
$keystofilter[] = '%'.$object.'%';
if($postid != '') {
	$query .= ' and post_id= %d';
	$keystofilter[] = $postid;
}    
    

    
$results = $wpdb->get_results( $wpdb->prepare($query, $keystofilter), ARRAY_A );
foreach($results as $rows => $row){  
$source = __('** custom field ','wp-ada-compliance'); 
$details = __('There is a HIGH probability that this error is located in a post or page custom field. Field & Post Title: ','wp-ada-compliance').esc_attr($row['meta_key']).' / '.esc_attr(get_the_title($row['post_id']));
    $locationnotes = $source.'|'.$details;   
    return $locationnotes;
}    
}
}

return $locationnotes;
}
    
/***************************************************************************
// check theme error probability
****************************************************************************/
function wp_ada_compliance_theme_error_probability_check($object, $type, $postid, $errorcode, $scantype) {
global $wpdb;
$probability = '0';  
if($type == 'theme') return 100; 
if($type == 'attachment') $probability = 100; 
if($type == 'term')  $probability = 100; 
if($type == 'css')  $probability = 100;       
if($type == 'widget')  return 0; 
if($scantype == 'onsave') return 0;
    

// certain error types are always theme errors    
$errorTypes = array('skip_nav_links', 'missing_lang_attr', 'multiple_ways_failure', 'untagged_document', 'missing_landmarks', 'unlabeled_landmarks'); 
if(in_array($errorcode,$errorTypes)) return 100;
    
// certain errors are always in page content    
$errorTypes = array('incorrect_heading_order','missing_headings','duplicate_title', 'img_missing_alt_media', 'img_alt_invalid_media'); 
if(in_array($errorcode,$errorTypes)) return 0; 
    
 
if($type != 'term' and $type != 'theme' and $type != 'pdf' and $type != 'widget'){    

// next check for multiple errors that are the same and project probability   
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT id FROM '.$wpdb->prefix.'wp_ada_compliance where object = %s and errorcode = %s', $object, $errorcode), ARRAY_A );
if($wpdb->num_rows > 10) $probability = 100;
elseif($wpdb->num_rows > 6 and $wpdb->num_rows < 11) $probability =  75;     
elseif($wpdb->num_rows > 3 and $wpdb->num_rows < 7) $probability =  33;    
elseif($wpdb->num_rows > 1 and $wpdb->num_rows < 4) $probability =  10; 
    
// first check for exact match in content
if($type != 'attachment'){
$content = get_the_content('','',$postid);
$content = wp_ada_compliance_check_elementor_content($content,$postid);
$content = wp_ada_compliance_check_beaver_builder_content($content,$postid, $type, 1);
$content = apply_filters('the_content',$content);
if(strstr($content, $object)) $probability =  0;	  
}
    
} // end term, theme, link, pdf check
    
    return $probability;
}

/***************************************************************************
// mark all theme errors
****************************************************************************/
function wp_ada_compliance_mark_theme_errors($object, $probability, $type) {
global $wpdb;

$wpdb->query( $wpdb->prepare('UPDATE '.$wpdb->prefix.'wp_ada_compliance set themeerror = %d where object  = %s and type = %s', $probability, $object, $type) );   

}

/**********************************************
// check if error is in an archive
**********************************************/
function wp_ada_compliance_theme_archive_error_check($errorid) {
	global $wpdb;

	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT scantype FROM '.$wpdb->prefix.'wp_ada_compliance where id = %d', $errorid ), ARRAY_A );

foreach($results as $row => $rows){
	
	if(strstr($rows['scantype'],'_archive')) return 1;
}
	return 0;

}

/*****************************************************
// check for page exclusion
******************************************************/
function wp_ada_compliance_check_for_page_exclusions($url)
{
$pageexclusions = get_option('wp_ada_compliance_php_buffering_page_exclusions',array());
    
if(!is_array($pageexclusions)) $pageexclusions = array();
    
$pageexclusions[] = '&action=confirm_admin_email';  
    
if($url != ''){
	foreach($pageexclusions as $excludekey => $excludevalue){
		if($excludevalue != "" and stristr($url,$excludevalue)) return 1;	
	}
}
	return 0;
}
/**********************************************
// insert error
**********************************************/
function wp_ada_compliance_insert_error($postinfo, $errortype, $error, $object ) {
	global $wpdb, $wp_ada_compliance_def;
    
    
	$ignre = 0;
    $locationnotes = '';
    $themeerror = '';


     $errortype = sanitize_text_field($errortype);
    $error = sanitize_text_field($error);
	$scantype = sanitize_text_field($postinfo['scantype']);
	$postid = sanitize_text_field($postinfo['postid']);
	$title = sanitize_text_field($postinfo['title']);
	$type = sanitize_text_field($postinfo['type']);
    
    $locationnotes = sanitize_text_field(wp_ada_compliance_theme_error_check($errortype,$object, $type, $postid));
   $themeerror = wp_ada_compliance_theme_error_probability_check($object, $type, $postid, $errortype, $scantype);
    wp_ada_compliance_mark_theme_errors($object, $themeerror, $type);
    
    if(isset($postinfo['attachmentid']))
    $attachmentid = sanitize_text_field($postinfo['attachmentid']);
    else $attachmentid = '';
    
    if(isset($postinfo['modifieddate']))
    $modifieddate = sanitize_text_field($postinfo['modifieddate']);
    else $modifieddate = '';
	
	if(isset($postinfo['taxonomy'])) $taxonomy = sanitize_text_field($postinfo['taxonomy']);
	else $taxonomy = "";
		
	if(isset($postinfo['examplecode'])) $examplecode = $postinfo['examplecode'];
	else $examplecode = "";

    // determine severity code
    if(strstr($wp_ada_compliance_def[$errortype]['DisplayError'],__('WARNING', 'wp-ada-compliance'))) $severity = 'W';
    elseif(strstr($wp_ada_compliance_def[$errortype]['DisplayError'],__('ALERT', 'wp-ada-compliance'))) $severity = 'A';
    else $severity = '';
    
	$ignre = wp_ada_compliance_get_ignore_value($errortype, $object, $type, $postinfo);
	
	$timezone = get_option('timezone_string');
	if($timezone == "") $timezone = 'America/Chicago';
	date_default_timezone_set($timezone);
	$errordate = date('Y-m-d H:i.s', time()+120);
	$userid = sanitize_text_field(get_current_user_id());
	if($userid == "") $userid = 'autoscan';
	
	$wpdb->query( $wpdb->prepare( 'INSERT INTO '.$wpdb->prefix.'wp_ada_compliance (postid, object, errorcode, posttitle, type, taxonomy, date, activeuser, ignre, recordcheck, scantype, examplecode, severity, modifieddate, attachmentid, themeerror, locationnotes) values(%d,  %s, %s, %s, %s, %s, %s, %s, %d, %d, %s,  %s,%s, %s, %d, %d, %s)', $postid, $object, $errortype, $title, $type, $taxonomy, $errordate, $userid, $ignre, 1, $scantype, $examplecode, $severity, $modifieddate, $attachmentid,  $themeerror, $locationnotes) );
	
	return $wpdb->insert_id;
}


/**********************************************
// ignore error
**********************************************/
function wp_ada_compliance_jquery_ignore_error( $id, $direction, $period) {
	global $wpdb;
	
	if ( !current_user_can( "edit_pages" ) ) return 1;
	
if($period == '1'){ // temp ignore
    $ignore_period = get_option('wp_ada_compliance_temporary_ignore_period','7');
	$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d, ignoredate = DATE_ADD(NOW(), INTERVAL '.$ignore_period.' DAY) where id  = %d ', $direction, $id ) );	
}else{
   $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where id  = %d ', $direction, $id ) );	 
}
	
	
}
/****************************************************
// update temporary ignore errors
****************************************************/
function wp_ada_compliance_change_temp_ignore_status(){
	global $wpdb;
	$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d, ignoredate = %s where ignre  = %d and ignoredate  != %s and ignoredate < now()', 0,'0000-00-00 00:00:00', '1', '0000-00-00 00:00:00'));	
	
}

/**********************************************
// ignore related errors
**********************************************/
function wp_ada_compliance_jquery_ignore_related_errors( $id, $direction) {
	global $wpdb;
	
	if ( !current_user_can( "edit_pages" ) ) return 1;
    
	$errorinfo = wp_ada_compliance_get_error_type($id);
        if(is_array($errorinfo)){
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where postid  = %d and type = %s and errorcode = %s ', $direction, $errorinfo['postid'], $errorinfo['type'], $errorinfo['errorcode']  ) );
        }	
	
}

function wp_ada_compliance_jquery_ignore_all_error( $id, $direction, $errorcode) {
	global $wpdb;
	
	if ( !current_user_can( "edit_pages" ) ) return 1;

	// get error code
		$objectcode = wp_ada_compliance_get_object_code($id);
		
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where object  = %s and errorcode = %s and ignre != %d', $direction, $objectcode, $errorcode, 2) );

	
}

function wp_ada_compliance_ignore_error( $id, $errorcode, $period) {
	global $wpdb;

	if ( !current_user_can( "edit_pages" ) ) return 1;
	
	// cancel ignore
	if (isset( $_GET[ 'canxignore' ] )) {
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where id  = %d ', 0, $id ) );
		$_SESSION['my_ada_important_notices'] = __('The selected error is no longer being ignored.','wp-ada-compliance');
	} 
    	// ignore related errors
	elseif (isset( $_GET[ 'ignorerelated' ] )) {
       $errorinfo = wp_ada_compliance_get_error_type($id);
        if(is_array($errorinfo)){
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where postid  = %d and type = %s and errorcode = %s ', 1, $errorinfo['postid'], $errorinfo['type'], $errorinfo['errorcode']  ) );
		$_SESSION['my_ada_important_notices'] = __('The selected errors are now being ignored.','wp-ada-compliance');
        }
	} 
    	// cancel ignore related errors
	elseif (isset( $_GET[ 'canxignorerelated' ] )) {
        $errorinfo = wp_ada_compliance_get_error_type($id);
          if(is_array($errorinfo)){
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where postid  = %d and type = %s and errorcode = %s', 0, $errorinfo['postid'], $errorinfo['type'], $errorinfo['errorcode'] ) );
		$_SESSION['my_ada_important_notices'] = __('The selected errors are now being ignored.','wp-ada-compliance');
          }
	} 
	// ignore all errors with identical error code
	elseif ( isset( $_GET[ 'ignoreall' ] )  and $errorcode != "" ) {
		
		// get error code
		$objectcode = wp_ada_compliance_get_object_code($id);
     		
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where object  = %s and errorcode = %s and ignre != %d', 1, $objectcode, $errorcode, 2) );
		$_SESSION['my_ada_important_notices'] = __('The selected error is now being ignored.','wp-ada-compliance');
	} 
	elseif ( isset( $_GET[ 'canxall' ] ) and $errorcode != "") {
		
		// get error code
		$objectcode = wp_ada_compliance_get_object_code($id);
		
		$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where object  = %s  and errorcode = %s and ignre != %d', 0, $objectcode, $errorcode, 2 ) );
		$_SESSION['my_ada_important_notices'] = __('The selected error is no longer being ignored.','wp-ada-compliance');
	} 
	// ignore just this id
	else {
        
        if($period == '1'){ // ignore for 7 days
	$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d, ignoredate = NOW() where id  = %d ', 1, $id ) );	
}else{
   $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set ignre = %d where id  = %d ', 1, $id ) ); 
}
	

	$_SESSION['my_ada_important_notices'] = __('The selected error is now being ignored.','wp-ada-compliance');
		}
}
/**********************************************
// check ignore status
**********************************************/
function wp_ada_compliance_ignore_check( $errortype, $postid, $object, $type ) {
	global $wpdb;
	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance where type= %s and postid = %d and errorcode = %s and object = %s and ignre = %d', $type, $postid, $errortype, $object, 1 ), ARRAY_A );


	if ( $results ) {
		return 1;
	}
}
/**********************************************
// check ignore status by errorr id
**********************************************/
function wp_ada_compliance_ignore_status_check( $errorid) {
	global $wpdb;
	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT ignre FROM '.$wpdb->prefix.'wp_ada_compliance where id = %d ', $errorid), ARRAY_A );


	foreach ( $results as $row ) {
		return $row['ignre'];
	}
}

/**********************************************
// get error code to update ignore all
**********************************************/
function wp_ada_compliance_get_object_code($id){
	global $wpdb;
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT object FROM '.$wpdb->prefix.'wp_ada_compliance where id = %d', $id), ARRAY_A );

	foreach ( $results as $row ) {
		return $row['object'];
	}
}
/**********************************************
// get error type update ignore all
**********************************************/
function wp_ada_compliance_get_error_type($id){
	global $wpdb;
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT errorcode, type, postid FROM '.$wpdb->prefix.'wp_ada_compliance where id = %d', $id), ARRAY_A );

	foreach ( $results as $row ) {
		$data['errorcode'] = $row['errorcode'];
        $data['type'] = $row['type'];
        $data['postid'] = $row['postid'];
        
        return $data;
	}
    
}
/**********************************************
// check for matching error code
**********************************************/
function wp_ada_compliance_check_object_code($object,$errorcode, $ignre=1){
	global $wpdb;	

    
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT object FROM '.$wpdb->prefix.'wp_ada_compliance where object = %s and ignre != %d and errorcode = %s', $object, $ignre, $errorcode ), ARRAY_A );

	if(count($results) > 1) return 1;

	return 0;
}

/**********************************************
// get error list for affected post
**********************************************/
function wp_ada_compliance_get_error_list_for_post($postid, $posttype){
	global $wpdb, $wp_ada_compliance_def;
    $errornotices = '';
$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
    
if($posttype == 'pdf'){
 $results = $wpdb->get_results( $wpdb->prepare( 'SELECT distinct errorcode FROM '.$wpdb->prefix.'wp_ada_compliance where attachmentid = %d and type = %s and ignre != %d', $postid, $posttype, '1'), ARRAY_A );  

}elseif($posttype == 'term'){
    if($report_filtered_errors == 'true'){
          $results = $wpdb->get_results( $wpdb->prepare( 'SELECT distinct errorcode FROM '.$wpdb->prefix.'wp_ada_compliance where postid = %d and type = %s  and ignre != %d and locationnotes LIKE %s ', $postid, $posttype, '1', '%term description%'), ARRAY_A );  
    }
    else 
    $results = $wpdb->get_results( $wpdb->prepare( 'SELECT distinct errorcode FROM '.$wpdb->prefix.'wp_ada_compliance where postid = %d and type = %s  and ignre != %d and ignre != %d and locationnotes LIKE %s ', $postid, $posttype, '1','2', '%term description%'), ARRAY_A );

}
else{
    if($report_filtered_errors == 'true'){
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT distinct errorcode FROM '.$wpdb->prefix.'wp_ada_compliance where postid = %d and type = %s  and ignre != %d and themeerror = %d ', $postid, $posttype, '1', '0'), ARRAY_A );
    }
    else $results = $wpdb->get_results( $wpdb->prepare( 'SELECT distinct errorcode FROM '.$wpdb->prefix.'wp_ada_compliance where postid = %d and type = %s  and ignre != %d and ignre != %d and themeerror = %d ', $postid, $posttype, '1', '2','0'), ARRAY_A );
}

	foreach ( $results as $row ) {
     $errorcode = $row['errorcode'];

			$errornotices .= '<p>';
			$errornotices .= $wp_ada_compliance_def[$errorcode]['DisplayError'];
			if($wp_ada_compliance_def[$errorcode]['Reference'] != "") 
            $errornotices .= ' <a href="'.$wp_ada_compliance_def[$errorcode]['ReferenceURL'].'" target="_blank" class="adaNewWindowInfo">'.$wp_ada_compliance_def[$errorcode]['Reference'].'<i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';  
			 $errornotices .= '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&view=1&errorid='.esc_attr($postid).'&type='.esc_attr($posttype).'&iframe=1&TB_iframe=true&width=900&height=550" class="thickbox adaNewWindowInfo adaErrorText adareportlink" target="_blank"><i class="fas fa-eye" aria-hidden="true"></i>';
             $errornotices .= __('View Accessibility Report for Help Options','wp-ada-compliance');
             $errornotices .= '</a>'; 
			$errornotices .= '</p>';
	}
    return $errornotices;
}
/*
function wp_ada_compliance_check_object_code_for_jquery($object,$errorcode){
	global $wpdb;	
$results = $wpdb->get_results( $wpdb->prepare( 'SELECT id FROM '.$wpdb->prefix.'wp_ada_compliance where object = %s and errorcode = %s limit 1', $object, $errorcode ), ARRAY_A );

	if ( $results ) {
	foreach ( $results as $row) {
		return $row['id'];
	}
	}

}*/

/**********************************************
// check if ambiguous link text can be corrected
**********************************************
function wp_ada_compliance_check_if_ambiguous_link_can_be_corrected($content){

// correct issues with encoding when website is using non utf-8
if(function_exists('mb_convert_encoding'))
$content = mb_convert_encoding($content, 'HTML-ENTITIES', "UTF-8");	

$dom = new DOMDocument;
libxml_use_internal_errors(true);
$dom->loadHTML($content);	

$links = $dom->getElementsByTagName('a');
foreach ($links as $link) {	
		
$url = esc_url($link->getAttribute('href'));
$post_id = url_to_postid($url);
if(get_the_title($post_id) != "" and $post_id != 0) return 1;
	
}
	return 0;
}
/*******************************************************************
check if elementor icon is corrected
********************************************************************
function wp_ada_compliance_check_elementor_icon_correction($errorcode, $postid){
    $correct_empty_anchor_tags = get_option('wp_ada_compliance_link_titles_font_awesome','true');
if($correct_empty_anchor_tags == 'false') return 0;
    
$elementor_content = wp_ada_compliance_check_elementor_content($errorcode,$postid);

$dom = str_get_html($elementor_content);
   
$divs = $dom->find('div[data-screen-reader-text]');
foreach ($divs as $div) {
    $links = $div->find('a');
    foreach ($links as $link) { 
        $iconcode = '';
        $icons = $link->find('i');
        if(isset($icons[0])) $iconcode = $icons[0]->outertext;
         
        if(strstr($link->getAttribute('class'),'elementor-icon')){
           
          if(strstr($errorcode,$link->getAttribute('href')) and strstr($errorcode, $iconcode) and strstr($errorcode,$link->getAttribute('class')))
            return 1;
        }
       
    }
}
	
 return 0;
}*/

/**********************************************
// check if font awesome link can be corrected
**********************************************/
function wp_ada_compliance_check_if_font_awesome_link_can_be_corrected($content){
$correct_empty_anchor_tags = get_option('wp_ada_compliance_link_titles_font_awesome','true');
if($correct_empty_anchor_tags == 'false') return 0;
    
// correct issues with encoding when website is using non utf-8
if(function_exists('mb_convert_encoding'))
$content = mb_convert_encoding($content, 'HTML-ENTITIES', "UTF-8");	

$dom = new DOMDocument;
libxml_use_internal_errors(true);
$dom->loadHTML($content);	

$links = $dom->getElementsByTagName('a');
	
foreach ($links as $link) {
	
$elements = $link->getElementsByTagName("*");
foreach ($elements as $i) {
if(isset($i) and strip_tags(trim($link->nodeValue)) == ''){	
 
if(wp_ada_compliance_get_font_awesome_icons_alt_text($i->getAttribute('class'))) return 1;
}
}
}
	
return 0;
}


/**********************************************************
retrieve aria value and return
**********************************************************/
function wp_ada_compliance_get_aria_values($dom, $element, $field){
    
if($field == 'aria-labelledby' and $element->getAttribute('aria-labelledby') != "") {
			$ariaid = $element->getAttribute('aria-labelledby');
    if(isset($dom->getElementById($ariaid)->plaintext))          
    return trim($dom->getElementById($ariaid)->plaintext);
		}

if($field == 'aria-describedby' and $element->getAttribute('aria-describedby') != "") {
			$ariaid = $element->getAttribute('aria-describedby');
    if(isset($dom->getElementById($ariaid)->plaintext))     
    return trim($dom->getElementById($ariaid)->plaintext);
} 
    
return ;    
}

/******************************************************
check for html validation errors
*******************************************************/
function wp_ada_compliance_check_html_validation_errors($url, $postid, $title){
global $wpdb, $wp_ada_compliance_def ;   
    include_once(ABSPATH.'wp-admin/includes/plugin.php');
if (!is_plugin_active('html-validation/html-validation.php') )  return ;

    // enforce ignore rule
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array()); 
if(in_array('html_validation', $wp_ada_compliance_scanoptions)) return 1;    
    
 $results = $wpdb->get_results($wpdb->prepare('SELECT * FROM '.$wpdb->prefix.'html_validation_links as table1 inner join '.$wpdb->prefix.'html_validation_errors as table2 on table1.linkid = table2.linkid where table2.adamarker = 1 and errorignre = 0 and link = %s', $url), ARRAY_A );

	foreach ( $results as $row ) {
        $code = '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=html_validation/report.php&adamarker=1&linkid='.esc_attr($row['linkid']).'" target="_blank" class="adaNewWindowInfo">';
		$code .= __('Go to the HTML Validation report to address this error','wp-ada-compliance');
        $code .= '<span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i>';
        $code .= '</a>';
        $postinfo['title'] =$title;
        
        $postinfo['postid'] = $postid;
        
        $postinfo['modifieddate'] = '';
        if($row['type'] == 'posttype'){
            $post_object = get_post( (int)$row['postid'] );
           if(is_object($post_object)){
            $postinfo['modifieddate'] = $post_object->post_modified;   
           }
           $postinfo['type'] = $row['subtype'];
           $postinfo['taxonomy'] = ''; 
        }else{
            $postinfo['type'] = $row['type'];
           $postinfo['taxonomy'] = $row['subtype'];     
        }
        if($postinfo['type'] == 'theme') $postinfo['scantype'] = $row['subtype'];
		else $postinfo['scantype'] = 'fullscan';	
		
		$postinfo['wpget'] = 1;
        if(!$insertid = wp_ada_compliance_error_check($postinfo,"html_validation", $code))
			$insertid = wp_ada_compliance_insert_error($postinfo,"html_validation",$wp_ada_compliance_def['html_validation']['StoredError'], $code);
	}   
    
}

/*******************************************
count total errros
********************************************/
function wp_ada_compliance_count_errors(){
    global $wpdb;
    
    // count total number of pages with issues
$query = "SELECT count(DISTINCT postid) FROM ".$wpdb->prefix."wp_ada_compliance where type != %s and type != %s and type != %s and type != %s and type != %s and type != %s and type != %s  and ignre = %d";
$totalpages = $wpdb->get_var($wpdb->prepare($query, 'widget', 'attachment', 'theme', 'term', 'css', 'link', 'pdf', 0));
    
    return $totalpages;
}
?>