<?php
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

echo '<div id="wp-ada-help-themes" class="wp-ada-help-topic">';
echo '<p class="wp-ada-help-title">';
_e('Hide theme errors? What does that do?', 'wp-ada-compliance');
echo '</p>';
echo '<p>';
_e('Locating issues in your content can sometimes be confusing. Sometimes issues may be labeled as in posts when they are actually in theme files or an external file such as iframe or css src rather than the post itself. Hiding theme errors will allow you to focus on the the issues found only in the post content.', 'wp-ada-compliance');
echo '</p>';
echo '</div>';

echo '<div id="wp-ada-help-dups" class="wp-ada-help-topic">';
echo '<p class="wp-ada-help-title">';
_e('Hide duplicates? What does that do?', 'wp-ada-compliance');
echo '</p>';
echo '<p>';
_e('This setting will hide all duplicate errors in the list. Duplicate errors are errors with the same code found in multiple locations. They are most likely, but not always, the same error found in different locations across the website. Correcting these errors in the original location will normally correct the issue sitewide. Hiding duplicate errors will reduce confusion and allow you to focus on errors with known locations.', 'wp-ada-compliance');
echo '</p>';
echo '</div>';


echo '<div id="wp-ada-help" class="wp-ada-help-topic">';
echo '<p class="wp-ada-help-title">';
_e('Having trouble getting started?  The following steps outline the best approach to resolving issues on your website with as little confusion as possible:', 'wp-ada-compliance');
echo '</p>';
echo '<ol>';
echo '<li>';
_e('Choose, "Quick Scan" or "Crawl & Scan" if the link scanning feature is enabled. When link scanning is enabled all of the links on your website will be inventoried and scanned. Note: Subsequent scans will go much faster if you choose “Quick Scan” which will skip the link inventory process and only scan known content.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('Place a checkmark next to "hide theme errors" and "hide duplicates" and choose filter.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('If desired you can also filter the list by widget, post, page or term.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('After filtering the list, review each error to ensure you understand the problem. Refer to the live view, help section, view code and reference material to gain a better understanding.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('Some issues may not require correction, if that is the case, choose "Ignore" and "This Error". If the issue is found in multiple locations there will also be an ignore "Duplicates" option which will ignore the current issue along with any duplicates that were found. You may optionally ignore "This Rule" which will remove the error from all future scans of your content.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('If the issue requires correction, choose "Edit" which will open the page in a new tab for editing. Once the issue has been corrected, close the tab to return to the error report.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('Choose "Refresh View" to clear any errors that were corrected.', 'wp-ada-compliance');
echo '</li>';
echo '<li>';
_e('Once all the issues have been reviewed and appropriate actions taken, remove the check mark from "hide theme errors" and work through the remaining issues as you did with the other content. There is one primary difference. Theme errors can not always be corrected in Wordpress. Instead you may need to make changes to the source files in your themes folder, update or replace plugins.','wp-ada-compliance');
echo '</li><li>';
_e('Once all listed issues have been addressed, complete the  “Manual Checks” found under the dashboard “Web Accessibility” menu, use the WAVE Evaluation Tool and screen reading software to further enhance the accessibility of your website. ','wp-ada-compliance');
echo ' <a href="https://www.alumnionlineservices.com/docs/getting-started/will-the-wp-ada-compliance-plugin-make-my-website-completely-compliant/" class="adaNewWindowInfo" target="_blank">';
_e('Read more about suggested actions to reach full compliance.','wp-ada-compliance');
echo '</a>';
echo '</li></ol>';
echo ' <a href="https://www.alumnionlineservices.com/docs/" class="btnwpada btnwpada-primary adaNewWindowInfo" target="_blank"><i class="fas fa-book" aria-hidden="true"></i> '.__('View the Users Manual for More Help', 'wp-ada-compliance').'<i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden wp-ada-manual-link">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
echo '</div>';
?>