<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*********************************************
INSTALLATION FUNCTIONS
**********************************************/

// redirect to settings page
function wp_ada_compliance_activation_redirect( $plugin ) {
       if( $plugin == 'wp-ada-compliance/wp-ada-compliance.php' ) {
	// Don't forget to exit() because wp_redirect doesn't exit automatically
    exit( wp_redirect(esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin'));
	}
}
add_action( 'activated_plugin', 'wp_ada_compliance_activation_redirect' );

// deactivate basic plugin
function wp_ada_compliance_deactivate_basic_plugin() {
    if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/fl-builder.php' );     
    
    if ( is_plugin_active('wp-ada-compliance-basic/wp-ada-compliance-basic.php') ) {
    deactivate_plugins('wp-ada-compliance-basic/wp-ada-compliance-basic.php');    
    }
      if ( is_plugin_active('wp-ada-compliance-check-basic/wp-ada-compliance-basic.php') ) {
    deactivate_plugins('wp-ada-compliance-check-basic/wp-ada-compliance-basic.php');    
    }
}

// activate plugin
function wp_ada_compliance_install( $network_wide = false ) {
		
    global $wpdb;
	
    if ( is_multisite()) {
        // Get all blogs in the network and activate plugin on each one
        $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
        foreach ( $blog_ids as $blog_id ) {
            switch_to_blog( $blog_id );
			// deactivate basic plugin
			wp_ada_compliance_deactivate_basic_plugin();
			
            wp_ada_compliance_create_tables();	
            restore_current_blog();
        }
    } else {
		// deactivate basic plugin
		wp_ada_compliance_deactivate_basic_plugin();
        wp_ada_compliance_create_tables();	
    }

}

// create database table
function wp_ada_compliance_create_tables() {
	global $wpdb;
	
	$charset_collate = $wpdb->get_charset_collate();
	$table_name1 = $wpdb->prefix . 'wp_ada_compliance';
    $table_name2 = $wpdb->prefix . 'wp_ada_compliance_links';

	$sql = "CREATE TABLE $table_name1 (
		id int(11) NOT NULL AUTO_INCREMENT, 
		postid int(11) NOT NULL, 
		ignre mediumint(9) NOT NULL, 
		siteid text NOT NULL, 
		type text NOT NULL, 
        themeerror mediumint(9) NOT NULL, 
                 locationnotes text NOT NULL, 
		scantype text NOT NULL, 
		taxonomy text NOT NULL,  
		errorcode text NOT NULL, 
        severity text NOT NULL, 
		object mediumtext NOT NULL,
        duplicatecode text NOT NULL,
		posttitle text NOT NULL,  
		recordcheck mediumint(9) NOT NULL, 
		date datetime NOT NULL, 
        ignoredate datetime NOT NULL,
		activeuser text NOT NULL, 
		examplecode text NOT NULL,
          modifieddate datetime NOT NULL,
          attachmentid int(11) NOT NULL, 
		PRIMARY KEY  (id)
	) $charset_collate;";
    
    $sql2 = " CREATE TABLE $table_name2 (
		id int(11) NOT NULL AUTO_INCREMENT, 
		link text NOT NULL, 
		type text NOT NULL,
        scanflag mediumint(9) NOT NULL, 
        cronflag mediumint(9) NOT NULL, 
        purgeflag mediumint(9) NOT NULL,
        locateflag mediumint(9) NOT NULL,
        postid int(11) NOT NULL,
        taxonomy text NOT NULL,
		themetype text NOT NULL,
		linkstatus text NOT NULL,
        modifieddate datetime NOT NULL,
		ignre mediumint(9) NOT NULL, 
        posttitle text NOT NULL,  
        attachmentid int(11) NOT NULL,
        filesize int(11) NOT NULL, 
		PRIMARY KEY  (id)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	
	dbDelta($sql);
    dbDelta($sql2);
		
    // clear update schedule
    //if (wp_next_scheduled('puc_cron_check_updates-wp-ada-compliance')) {    
     //   wp_clear_scheduled_hook('puc_cron_check_updates-wp-ada-compliance'); 
    //}
    
    
    	// schedule daily activities
	if (!wp_next_scheduled('wp_ada_compliance_daily_cron_hook')) {
	wp_schedule_event(time(), 'daily', 'wp_ada_compliance_daily_cron_hook');
	}

	// schedule scans
	if (!wp_next_scheduled('wp_ada_compliance_auto_scan_cron_hook')) {
	wp_schedule_event(time(), 'hourly', 'wp_ada_compliance_auto_scan_cron_hook');
	}
	// schedule notifications
	$emailnotifications = get_option('wp_ada_compliance_notification_email','');
	$notification_frequency = get_option('wp_ada_compliance_notification_frequency','daily');
	if ($emailnotifications != "" and !wp_next_scheduled('wp_ada_compliance_email_notification_hook')) {
	wp_schedule_event(time(), $notification_frequency, 'wp_ada_compliance_email_notification_hook');
	}
    
}
/***********************************************
//deactivate hook
***********************************************/
function wp_ada_compliance_deactivate(){
    wp_ada_compliance_uninstall(1);
}

/**************************************************
UNINSTALL FUNCTIONS
***************************************************/
// remove plugin
function wp_ada_compliance_uninstall($deactivate = 0) {
	global $wpdb;

    if ( is_multisite()) {
		
        // Get all blogs in the network and activate plugin on each one
        $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
        foreach ( $blog_ids as $blog_id ) {
            switch_to_blog( $blog_id );
			$retain_settings = get_option('wp_ada_compliance_retain_settings','false');	
           if($retain_settings == 'false' and $deactivate != 1)	{	
            wp_ada_compliance_delete_tables();	
			wp_ada_compliance_remove_options();
		   }
            
			// clear crons 
			wp_clear_scheduled_hook('wp_ada_compliance_email_notification_hook');	
			wp_clear_scheduled_hook('wp_ada_compliance_auto_scan_cron_hook');
            //wp_clear_scheduled_hook('puc_cron_check_updates-wp-ada-compliance'); 
            wp_clear_scheduled_hook('wp_ada_compliance_daily_cron_hook'); 
			
			restore_current_blog();
        }
    } else {
		$retain_settings = get_option('wp_ada_compliance_retain_settings','false');	
		if($retain_settings=='false' and $deactivate != 1)	{
        wp_ada_compliance_delete_tables();
		wp_ada_compliance_remove_options();
		  }
		// clear crons on uninstall	
		wp_clear_scheduled_hook('wp_ada_compliance_email_notification_hook');	
		wp_clear_scheduled_hook('wp_ada_compliance_auto_scan_cron_hook');
        //wp_clear_scheduled_hook('puc_cron_check_updates-wp-ada-compliance'); 
        wp_clear_scheduled_hook('wp_ada_compliance_daily_cron_hook'); 
    }

}
// remove tables
function wp_ada_compliance_delete_tables() {
global $wpdb;
	
$table_name = $wpdb->prefix . 'wp_ada_compliance';	
$sql = "DROP TABLE IF EXISTS $table_name";
$wpdb->query( $sql );

$table_name2 = $wpdb->prefix . 'wp_ada_compliance_links';	    
$sql = "DROP TABLE IF EXISTS $table_name2";
$wpdb->query( $sql );   
}

// remove options
function wp_ada_compliance_remove_options(){
foreach ( wp_load_alloptions() as $option => $value ) {
if ( strpos( $option, 'wp_ada_compliance_' ) === 0 
	and !strstr( $option, 'wp_ada_compliance_pdf_') 
	and !strstr( $option, 'wp_ada_compliance_basic_')) {
	 delete_option( $option ); 
} 
}	
}

// reset options
function wp_ada_compliance_reset_options(){
foreach ( wp_load_alloptions() as $option => $value ) {
if ( strpos( $option, 'wp_ada_compliance_' ) === 0 
	and !strstr( $option, 'wp_ada_compliance_pdf_') 
	and !strstr( $option, 'wp_ada_compliance_basic_')
   and $option != 'wp_ada_compliance_license_key'
     and $option != 'wp_ada_compliance_secret_key'
    and $option != 'wp_ada_compliance_secret_iv'
    and $option != 'wp_ada_compliance_setting_password_protect_password'
    and $option != 'wp_ada_compliance_setting_password_protect_username'
    and $option != 'wp_ada_compliance_enable_secure_site_scans'
   and $option != 'wp_ada_compliance_license_status_check') {
	 delete_option( $option ); 
} 
}

}

// Deleting the table whenever a blog is deleted
function wp_ada_compliance_delete_blog( $tables ) {
    global $wpdb;
    $tables[] = $wpdb->prefix . 'wp_ada_compliance';
    
	return $tables;
}
add_filter( 'wpmu_drop_tables', 'wp_ada_compliance_delete_blog' );

/*********************************************
// check version number for database updates
**********************************************/
function wp_ada_compliance_check_version() {
	if(!is_admin()) return 0;
	$current_version = wp_ada_compliance_plugin_get("Version");
	$stored_option_version = get_option('wp_ada_compliance_version');
	if ($current_version != $stored_option_version){
		wp_ada_compliance_install();
        
        
        if($stored_option_version != "" and version_compare($stored_option_version, '2.2', '<='))
		wp_ada_compliance_convert_old_table();
        
		//wp_ada_compliance_remove_duplicate_filter_issue();
        
        if($stored_option_version != "" and version_compare($stored_option_version, '2.2.7', '<='))
        wp_ada_compliance_delete_filter_log_table();
		
        
        if($stored_option_version != "" and version_compare($stored_option_version, '2.3', '<=')){
			// add support link scanning and clean up options
        delete_option('wp_ada_compliance_css_files');
		wp_ada_compliance_add_link_scanning(); 	
		}
        
        // change title convert option to no convert. Titles are now read in all modern browsers and screen readers
        if($stored_option_version != "" and version_compare($stored_option_version, '2.3.7', '<=')){
        update_option('wp_ada_compliance_link_titles','noconvert');
        }
        
            if($stored_option_version != "" and version_compare($stored_option_version, '2.3.14', '<=')){
        wp_ada_compliance_upgrade_to_version_2_3_14();
        }
        
        if($stored_option_version != "" and version_compare($stored_option_version, '3.0', '<=')){
       wp_ada_compliance_upgrade_to_version_3_0(); 
        }
		
        // notifiy user to rescan
         update_option('wp_ada_compliance_rescan_required', 'true'); 
        
        update_option('wp_ada_compliance_version', $current_version);
	}
}

/*********************************************
// update scan options to ignore
**********************************************/
function wp_ada_compliance_update_scan_rule_ignore_options() {
	global $wp_ada_compliance_def;
	
	$ignore_rules = array();
	
$scan_rules = get_option('wp_ada_compliance_scan_rules');
if($scan_rules != "" and is_array($scan_rules)){	
foreach ($wp_ada_compliance_def as $rows => $row){	
	if(!in_array($rows,$scan_rules)) $ignore_rules[] = $rows;		
}	
}
    
update_option('wp_ada_compliance_ignore_scan_rules', $ignore_rules);
}


/*********************************************
// set default scan rule settings
**********************************************/
function wp_ada_compliance_set_scan_rule_options() {
global $wp_ada_compliance_def;

$scan_rules = get_option('wp_ada_compliance_scan_rules', '');
$ignore_rules = get_option('wp_ada_compliance_ignore_scan_rules', array());	

$scan_rule_options = array();
	
if(!is_array($ignore_rules)) $ignore_rules = array();	
	
foreach ($wp_ada_compliance_def as $rows => $row){	
	if(!in_array($rows,$ignore_rules)) {
        $scan_rule_options[] = $rows;
    }

}
   
    
	update_option('wp_ada_compliance_scan_rules', $scan_rule_options);
    

}


/*********************************************
// ignore a rule
**********************************************/
function wp_ada_compliance_ignore_scan_rule($rule) {

$ignore_rules = get_option('wp_ada_compliance_ignore_scan_rules', array());	
if(!is_array($ignore_rules)) $ignore_rules = array();
	
if(is_array($ignore_rules) and !in_array($rule,$ignore_rules))	
$ignore_rules[] = $rule;

update_option('wp_ada_compliance_ignore_scan_rules', $ignore_rules);

}

/*********************************************
// ignore a post
**********************************************/
function wp_ada_compliance_ignore_post($post, $scantype, $type) {

if($type == 'theme' and $scantype  != 'AuthorPage'){
// ignore post archives
if(strstr($scantype,'_archive')){
$ignoredPosts = get_option('wp_ada_compliance_posts_to_ignore',array());
if(!is_array($ignoredPosts)) $ignoredPosts = array();	
$toadd = $type.'|'.$post.'|'.$scantype;	
if(!in_array($toadd,$ignoredPosts))	{
	$ignoredPosts[] = $toadd;
	update_option('wp_ada_compliance_posts_to_ignore', $ignoredPosts);
}	
}
else{
// ignore theme files	
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page"));	
	
$types['bloghome'] = 'Blog Home';
$types['404page'] = "404 Page";
$types['searchpage'] = "Search Page";
$types['authorpage'] = "Author Page";
	
if (($key = array_search($types[str_replace(" ",'',strtolower($scantype))], $theme_scan_items)) !== false) {

    unset($theme_scan_items[$key]);
}
update_option('wp_ada_compliance_scan_themes', $theme_scan_items);	
}
}
else{	
$ignoredPosts = get_option('wp_ada_compliance_posts_to_ignore',array());
if(!is_array($ignoredPosts)) $ignoredPosts = array();
$toadd = $type.'|'.$post.'|'.$scantype;	
if(!in_array($toadd,$ignoredPosts))	{
	$ignoredPosts[] = $toadd;
	update_option('wp_ada_compliance_posts_to_ignore', $ignoredPosts);
}
}
}


/*********************************************************
add link scan to external sources and delete old theme errors
*******************************************************/
function wp_ada_compliance_add_link_scanning() {
global $wpdb;
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(!is_array($scan_external_sources) or 
   !in_array('linked', $scan_external_sources)) $scan_external_sources =array('linked');
	
	update_option('wp_ada_compliance_scan_external_sources', $scan_external_sources);
	
// purge theme errors with a post type of 0 which are prior to the link table	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s and postid = %d ', array('theme', 0)) );	
       
}

/*************************************************************
// process upgrade to version 2.3.14
*************************************************************/
function wp_ada_compliance_upgrade_to_version_2_3_14() {
global $wpdb;   
    
if ( is_multisite()) {

// Get all blogs in the network and activate plugin on each one
$blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
foreach ( $blog_ids as $blog_id ) {
switch_to_blog( $blog_id );
	

// turn off report filtered    
update_option('wp_ada_compliance_report_filtered_errors','false');
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE ignre= %s ', array('2')) );   
    
restore_current_blog();
}
}
else{   
	
	
// turn off report filtered    
update_option('wp_ada_compliance_report_filtered_errors','false');
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE ignre= %s ', array('2')) );	

}


}

/*************************************************************
// process upgrade to version 3.0
*************************************************************/
function wp_ada_compliance_upgrade_to_version_3_0() {
global $wpdb;   
    
if ( is_multisite()) {

// Get all blogs in the network and activate plugin on each one
$blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
foreach ( $blog_ids as $blog_id ) {
switch_to_blog( $blog_id );
	
// set skip links from id
$skip_link_id = get_option('wp_ada_compliance_skip_link_id','');
$skip_links = get_option('wp_ada_compliance_skip_links','');
if($skip_link_id != '' and (!is_array($skip_links) or $skip_links == '') ){
$skiplink = __('Skip to main content','wp-ada-compliance').'=#'.$skip_link_id;
update_option('wp_ada_compliance_skip_links',array($skiplink));
//update_option('wp_ada_compliance_skip_link_id','');
}	
	
// update editor screen options
$editorscreen = get_option('wp_ada_compliance_deep_scan_on_editor','');
if($editorscreen == 'false') update_option('wp_ada_compliance_deep_scan_on_editor','true');	

    // remove iframe errors
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE externalsrc LIKE %s ', array("iframe|%")) );    
    
// remove custom fields, excerpts, and onsave records 
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s ', array('customfield')) );	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE scantype= %s and (posttitle LIKE %s or type = %s)', array('onsave', '%- post excerpt%', 'excerpt')) );	
    
// change scan type to fullscan
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set scantype = %s where scantype = %s', 'fullscan', 'onsave') );    

// mark theme errors    
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set themeerror = %d where (type = %s or type = %s or type = %s or type = %s)', 100, 'css', 'theme', 'term', 'attachment') );   

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set themeerror = %d where errorcode = %s or errorcode = %s or errorcode = %s or errorcode = %s', 100, 'skip_nav_links', 'missing_lang_attr', 'multiple_ways_failure' , 'untagged_document') );  
    
// change image alt file name errors to invalid alt
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set errorcode = %s, severity = %s where errorcode = %s',  'img_alt_invalid', 'W', 'img_alt_filename') );    
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set errorcode = %s, severity = %s where errorcode = %s',  'img_alt_invalid_media', 'A', 'img_alt_filename_media') );    
    
    // turn off report filtered    
update_option('wp_ada_compliance_report_filtered_errors','false');
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE ignre= %s ', array('2')) ); 

restore_current_blog();
}
}
else{   
	
// set skip links from id
$skip_link_id = get_option('wp_ada_compliance_skip_link_id','');
$skip_links = get_option('wp_ada_compliance_skip_links','');
if($skip_link_id != '' and (!is_array($skip_links) or $skip_links == '') ){
$skiplink = __('Skip to main content','wp-ada-compliance').'=#'.$skip_link_id;
    
update_option('wp_ada_compliance_skip_links',array($skiplink));
}
	
// update editor screen options
$editorscreen = get_option('wp_ada_compliance_deep_scan_on_editor','');
if($editorscreen == 'false') update_option('wp_ada_compliance_deep_scan_on_editor','true');
    
// remove iframe errors
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE externalsrc LIKE %s ', array("iframe|%")) ); 

// remove custom fields, excerpts, and onsave records
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s ', array('customfield')) );	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE scantype= %s and (posttitle LIKE %s or type = %s)', array('onsave', '%- post excerpt%', 'excerpt')) );	


// change scan type to fullscan
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set scantype = %s where scantype = %s', 'fullscan', 'onsave') );    

// mark theme errors    
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set themeerror = %d where (type = %s or type = %s or type = %s or type = %s)', 100, 'css', 'theme', 'term', 'attachment') );   

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set themeerror = %d where errorcode = %s or errorcode = %s or errorcode = %s or errorcode = %s', 100, 'skip_nav_links', 'missing_lang_attr', 'multiple_ways_failure' , 'untagged_document') );  
    
// change image alt file name errors to invalid alt
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set errorcode = %s, severity = %s where errorcode = %s',  'img_alt_invalid', 'W', 'img_alt_filename') );    
$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance set errorcode = %s, severity = %s where errorcode = %s',  'img_alt_invalid_media', 'A', 'img_alt_filename_media') );    
    
// turn off report filtered    
update_option('wp_ada_compliance_report_filtered_errors','false');
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE ignre= %s ', array('2')) );     
}


}


/*********************************************************
REMOVE FILTER LOG TABLE - NO LONGER REQUIRED
*******************************************************/
function wp_ada_compliance_delete_filter_log_table() {
global $wpdb;
	
if ( is_multisite()) {
		
        // Get all blogs in the network and activate plugin on each one
        $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
        foreach ( $blog_ids as $blog_id ) {
            switch_to_blog( $blog_id );
			
        $table_name2 = $wpdb->prefix . 'wp_ada_compliance_filter_log';	
        $sql2 = "DROP TABLE IF EXISTS $table_name2";
        $wpdb->query( $sql2 );	

        $conversiontext = get_option('wp_ada_compliance_font_awesome_conversion_text','');	
        if($conversiontext == 'fa-close=Close,fa-filter=Filter') {
        update_option('wp_ada_compliance_font_awesome_conversion_text', '');     
       
        } 
		restore_current_blog();
        }
}
else{    
    
$table_name2 = $wpdb->prefix . 'wp_ada_compliance_filter_log';	
$sql2 = "DROP TABLE IF EXISTS $table_name2";
$wpdb->query( $sql2 );	
	
$conversiontext = get_option('wp_ada_compliance_font_awesome_conversion_text','');	
if($conversiontext == 'fa-close=Close,fa-filter=Filter') {
update_option('wp_ada_compliance_font_awesome_conversion_text', '');
}
}
}

/*********************************************************
FUNCTIONS TO CONVERT TABLE TO PREFIX FORMAT 
*******************************************************/
function wp_ada_compliance_convert_old_table() {
global $wpdb;

$querycheck = "SELECT EXISTS(SELECT siteid FROM wp_ada_compliance)";
$results = $wpdb->get_results($querycheck, ARRAY_A);
if($results) {	
	
	// process single site
if (!is_multisite()){	
//delete table
$sql = 'DROP TABLE IF EXISTS '.$wpdb->prefix . 'wp_ada_compliance;';
$wpdb->query( $sql );
	
$query = 'RENAME TABLE wp_ada_compliance TO '.$wpdb->prefix . 'wp_ada_compliance;';	
$wpdb->query( $query );	
return;
}

// process multisite	
if (is_multisite()) {	

$query = 'SELECT * FROM wp_ada_compliance';
$results = $wpdb->get_results($query, ARRAY_A );
foreach ( $results as $row ) {
 switch_to_blog( $row['siteid'] );

//check if error exists first 
if(!wp_ada_compliance_error_record_exists_check( $row['type'], $row['postid'], $row['errorcode'], $row['object'], $row['siteid'], $row['scantype'], $row['date'],$row['posttitle'])){

$table_name = $wpdb->prefix . 'wp_ada_compliance';
$wpdb->query($wpdb->prepare('INSERT INTO '.$table_name.' (postid, ignre, siteid, type, scantype, taxonomy, errorcode, object, posttitle, recordcheck, date, activeuser, examplecode) VALUES(%d,%d,%s,%s,%s,%s,%s,%s,%s,%d,%s,%s,%s)',$row['postid'], $row['ignre'], $row['siteid'], $row['type'], $row['scantype'], $row['taxonomy'], $row['errorcode'], $row['object'], $row['posttitle'], $row['recordcheck'], $row['date'], $row['activeuser'], $row['examplecode']));
}

restore_current_blog();		
}
}
//delete table
$sql = "DROP TABLE IF EXISTS wp_ada_compliance;";
$wpdb->query( $sql );
}
return;	
}
/**********************************************
// check if record already exists
**********************************************/
function wp_ada_compliance_error_record_exists_check( $type, $postid, $errorcode, $object, $siteid, $scantype, $date, $posttitle ) {
	global $wpdb;
	$table_name = $wpdb->prefix . 'wp_ada_compliance';
	$results = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM '.$table_name.' where type= %s and postid = %d and errorcode = %s and object = %s and siteid = %d and scantype= %s and date = %s and posttitle = %s', $type, $postid, $errorcode, $object, $siteid, $scantype, $date, $posttitle), ARRAY_A );

if($results) {
		return 1;
	}
}
/*********************************************************
END FUNCTIONS TO CONVERT TABLE TO PREFIX FORMAT
**********************************************************/
/**********************************************
// check demo mode
**********************************************/
function wp_ada_compliance_checkdemo_date(){

$mode= 'live'; // demo or live
$demo_expire_date = '2018/08/31'; #could be (almost) any string date	

// validate license once per week
$wp_ada_compliance_license_check_date = get_option('wp_ada_compliance_license_check_date',strtotime('-9 days'));
$license_status_check = get_option('wp_ada_compliance_license_status_check','unchecked');	
if($mode=='live') {
if(strtotime($wp_ada_compliance_license_check_date) < strtotime('-7 days')) { 
// set next check date
$nextdate = wp_ada_compliance_get_next_staggered_date(0);
update_option('wp_ada_compliance_license_check_date',$nextdate);		
if(wp_ada_compliance_validateLicenseKey(1)) {
	update_option('wp_ada_compliance_license_status_check',0);	
	return 0;  
} else{
	update_option('wp_ada_compliance_license_status_check',1);	
	return 1;
} 	
}else return $license_status_check;
} 

// if not live the demo mode has a date limit
$today_start = strtotime('today');
$today_end = strtotime('tomorrow');

$date_timestamp = strtotime($demo_expire_date);

if ($date_timestamp >= $today_end) {
   return 0;
} elseif ($date_timestamp < $today_start) {
    return 1;
} else {
    return 1;
}		
}
/******************************************************
run daily to validate license and other activities as required
*******************************************************/
function wp_ada_compliance_daily_cron(){
    global $wp_ada_compliance_Updates;


    
    // only run during cron on plugin update or wp-ada-compliance pages
   if (!defined( 'DOING_CRON' ) and !strstr($_SERVER['REQUEST_URI'],'/plugins.php') and !strstr($_SERVER['REQUEST_URI'],'page=ada_compliance') and !strstr($_SERVER['REQUEST_URI'],'page=wp-ada-compliance-admin')) return; 
       
    // update temporary ignore errors
    wp_ada_compliance_change_temp_ignore_status();
    
    // validate license
    wp_ada_compliance_checkdemo_date();
    
    // check for updates every 4 days
    $check_date = get_option('wp_ada_compliance_update_check_date',strtotime('-5 days'));
    if(strtotime($check_date) < strtotime('-4 days')) { 
   // set next check date
    $nextdate = wp_ada_compliance_get_next_staggered_date(0);
    $wp_ada_compliance_Updates->checkForUpdates();
    update_option('wp_ada_compliance_update_check_date',$nextdate);
        
        // update admin notices
        wp_ada_compliance_get_notices();
    }
}

/******************************************************
stagger license check date and time
*******************************************************/
function wp_ada_compliance_get_next_staggered_date($pre=0){
$nextdate = date('Y-n-j '.rand(0, 23).':'.rand(0, 59).':s');    
if($pre == 1){ 
$nextdate = date('Y-m-d '.rand(0, 23).':'.rand(0, 59).':s', strtotime("$nextdate - ".rand(10, 14)." day"));
}
    return $nextdate;
}
/*************************************************
check server requirements
***************************************************/
function wp_ada_compliance_check_server_requirements() {
global $wp_ada_compliance_unsupported_deepscan;
	$notice = '';
	$dismissable = '';
	
	// check if deep scan is supported
    if(strstr($_SERVER['REQUEST_URI'],'admin.php?page=wp-ada-compliance-admin'))
$wp_ada_compliance_unsupported_deepscan = wp_ada_compliance_check_deep_scan_support();
	
	if(strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance'))
		$dismissable = ' data-dismissible="notice-three-1" ';
	
	elseif(strstr($_SERVER['REQUEST_URI'],'admin.php?page=wp-ada-compliance-admin')) 
		$dismissable = '';
	
	// fileinfo extension
	if(!function_exists('finfo_open')) {
		$dismissable = '';
		$notice .= '<p>'.__('PHP Fileinfo: Your server does not have the PHP Fileinfo Extensions enabled. Issues in theme content will not be corrected.','wp-ada-compliance').'</p>';
	}
	// mb convert encoding
	if(!function_exists('mb_convert_encoding')) 
		{
		$dismissable = '';
		$notice .= '<p>'.__('PHP mb_convert_encoding: Your server does not support mb_convert_encoding. Plugin will not work as expected.','wp-ada-compliance').'</p>';
	}
		// php version
	if(!version_compare(phpversion(), '5.6')) {
		$dismissable = '';
		$notice .= '<p>'.__('PHP version: Your server is using an unsupported version of PHP. Upgrade PHP to at least version 5.6.','wp-ada-compliance').'</p>';
	}
	// wordpress version	
	if(!wp_version_check() > '4.6') {
		$dismissable = '';
		$notice .= '<p>'.__('You are using an unsupported version of Wordpress. Upgrade to at least version 4.6.','wp-ada-compliance').'</p>';
	}
	
	  if(strstr($_SERVER['REQUEST_URI'],'admin.php?page=wp-ada-compliance-admin') and !$wp_ada_compliance_unsupported_deepscan){
		$notice .= '<p>'.__('Website scanning doesn\'t appear to be working correctly. Ensure that your website supports PHP curl and that you do not have a security plugin that is blocking the scan process. If your website requires password authentication refer to the Password Protected Website Settings found under "Scan & Notification Settings"', 'wp-ada-compliance').'</p>';
	}
	// max execution time
	if(ini_get('max_execution_time') < 300 and ini_get('max_execution_time')  != 0) {
		$notice .= '<p>'.__('PHP max_execution_time: The max_execution_time on your server may be set too low. Increase the PHP max_execution_time value to 300 if you experience failures while scanning content.', 'wp-ada-compliance').'</p>';
	}
	// php memory limit
	if(wp_ada_compliance_return_bytes(ini_get('memory_limit')) < 268435456) {
		$notice .= '<p>'.__('PHP memory_limit: The memory_limit on your server may be set too low. Increase the PHP memory_limit value to 256M or 700M when scanning large PDF files if you experience failures while scanning content.', 'wp-ada-compliance').'</p>';
	}
	// license check
	if(get_option('wp_ada_compliance_license_key', "") == '' and !isset($_POST['wp_ada_compliance_license_key']) and wp_ada_compliance_checkdemo_date()){
		$dismissable = '';
		$notice .= '<p>'.__('License Key:  Enter the license key from your purchase email.', 'wp-ada-compliance').'</p>';
	}
	// license check
	if(!isset($_REQUEST['activate_license']) and get_option('wp_ada_compliance_license_key', "") != '' and wp_ada_compliance_checkdemo_date()){
		$dismissable = '';
		$notice .= '<p>'.__('License Key:  License key has been suspended or is not valid for the software version that you are using.', 'wp-ada-compliance').'</p>';
	}
	// settings need set
	if(get_option('wp_ada_compliance_posttypes', '') == '') {
		$notice .= '<p>'.__('Plugin Settings: Review the default settings and choose the content to be protected.', 'wp-ada-compliance').'</p>';
	}
	
	
	// ob_start support
	if(!function_exists('ob_start') or !function_exists('ob_end_flush')){ 
	$dismissable = '';
	$notice .= '<p>'.__('PHP output buffering: Your server does not support output buffering. Issues in theme content will not be corrected.', 'wp-ada-compliance').'</p>';			
	}
	
	// detect browser support
	$agent = $_SERVER['HTTP_USER_AGENT'];
   if(strpos($agent, 'Windows') 
	  and !(strpos($agent, 'Opera') or strpos($agent, 'Edge') or strpos($agent, 'Chrome') or strpos($agent, 'Firefox'))
	  or strpos($agent, 'Macintosh') 
	  and !(strpos($agent, 'Opera') or strpos($agent, 'Edge') or strpos($agent, 'Chrome') or strpos($agent, 'Firefox') or strpos($agent, 'Safari'))
	  or strpos($agent, 'Edge/15') or strpos($agent, 'Firefox/5') 
	 ){
	$dismissable = '';
	$notice .= '<p>'.__('Unsupported Browser: The browser you are using has know issues when using features of this plugin. Please upgrade to the latest version of Edge, Chrome, Firefox, Opera or on Mac Safari is also supported.', 'wp-ada-compliance').'</p>';	
		}
	
	if($dismissable == ' data-dismissible="notice-three-1" ' and !PAnD::is_admin_notice_active( 'notice-three-1' )) return;

	if($notice != '') {
        $noticeheader ='';
	$noticeheader = '<h2>';
	$noticeheader .=__('WP ADA Compliance Plugin - Additional Setup','wp-ada-compliance');	
	$noticeheader .= '</h2>';	
	$notice = '<div '.$dismissable.' class="notice notice-error is-dismissible wp-ada-compliance-additionalsetup">'.$noticeheader.$notice.'</div>';
	
  	echo $notice;
	}
}
?>