<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/**********************************************
// process login
**********************************************/
function wp_ada_compliance_process_login($url, $timeout = 10){
    
$args = array('timeout'  => $timeout,
              'redirection' => $timeout,
              'sslverify'   => false, 
              'user-agent' => 'WP ADA COMPLIANCE CRAWLER');
    
// add cookies to allow scanning of secure website  
$enable_secure_site_scans = get_option('wp_ada_compliance_enable_secure_site_scans','false'); 
if($enable_secure_site_scans == 'true' and stristr($url,get_site_url())){
    
$cookies  = array();
foreach ( $_COOKIE as $name => $value ) {
$cookies[] = new WP_Http_Cookie( array( 'name' => $name, 'value' => $value ) );
}
if(count($cookies) > 0) $args['cookies'] = $cookies;
    
// htacess authentication
$username = get_option('wp_ada_compliance_setting_password_protect_username','');
$password = get_option('wp_ada_compliance_setting_password_protect_password','');     
    
if( $username != '' and $password != '') {
$username = wp_ada_compliance_encrypt_decrypt('decrypt', $username);
$password = wp_ada_compliance_encrypt_decrypt('decrypt', $password);     
$auth = base64_encode( $username . ':' . $password );
$args['headers'] = array("Authorization" => "Basic $auth" );
}
  
}
    
return $args;
    
}

/**********************************************
// check if password protection is enabled
**********************************************/
function wp_ada_compliance_check_pw_protected_login_status(){
$password_protected_scan = get_option( 'wp_ada_compliance_enable_secure_site_scans', 'false'); 
$password_protected_username = get_option( 'wp_ada_compliance_setting_password_protect_username', '');
$password_protected_password = get_option( 'wp_ada_compliance_setting_password_protect_password', '');
 
if($password_protected_scan == 'true' and $password_protected_password != '' and $password_protected_username != '') return 1;    
elseif($password_protected_scan == 'true') return 2;
else return 0;    
}
?>