<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/**********************************************
display notices
********************************************/
function wp_ada_compliance_admin_notices(){
$allowed_html = array(
  'a' => array('href' => array(), 'target' => array(), 'class' => array()),
  'p' => array('class' => array()),
'span' => array('class' => array()),	
	'i' => array('class' => array(), 'aria-hidden' => array()),
  'strong' => array(),
  'br' => array(),
	'h2' => array(),
);	
    
		// display general notices above the fold
if(isset($_SESSION['wp_ada_notices_top'])) {    
	echo $_SESSION['wp_ada_notices_top'];
	unset($_SESSION['wp_ada_notices_top']);
} 
    
	// clear on iframe display
if(defined( 'DOING_CRON' ) or isset($_GET['iframe']) or (!strstr($_SERVER['REQUEST_URI'],'/wp-admin/post.php?post=') and !strstr($_SERVER['REQUEST_URI'],'/wp-admin/term.php?') and (isset($_SESSION['my_ada_notices']) and !strstr($_SESSION['my_ada_notices'],'Invalid License Key Found!')))){
	$_SESSION['my_ada_notices'] = "";
}
if(!empty($_SESSION['my_ada_notices']) and (stristr($_SERVER['PHP_SELF'], "post.php") or stristr($_SERVER['PHP_SELF'], "term.php") or strstr($_SESSION['my_ada_notices'],'Invalid License Key Found!'))) {
	 echo '<div class="adaError"><h2>';
	_e('Web Accessibility Compliance Issues:','wp-ada-compliance');
	echo '</h2>';
	echo wp_kses($_SESSION['my_ada_notices'], $allowed_html);
	echo '</div>';
  }
  elseif(!empty($_SESSION['my_ada_notices']) and stristr($_SERVER['PHP_SELF'], "admin.php")) {
	  echo '<div class="adaAllGood">';
	  echo wp_kses($_SESSION['my_ada_notices'], $allowed_html);
	  echo '</div>';
  }elseif(isset($_SESSION['wp_failure_on_deep_scan']) and $_SESSION['wp_failure_on_deep_scan'] != ""){
	  echo '<div class="notice notice-error wpadaFatalError">';
	  echo wp_kses($_SESSION['wp_failure_on_deep_scan'], $allowed_html);
	  
		echo '</div>'; 
  }
   if ( session_id() )	{
	   unset($_SESSION['wp_failure_on_deep_scan']);
	unset ($_SESSION['my_ada_notices']);
   }
}

/****************************************
//Returns current plugin info.
*******************************************/
function wp_ada_compliance_plugin_get($i) {
global $wp_ada_compliance_plugin_directory;
	if ( ! function_exists( 'get_plugins' ) )
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	$plugin_folder = get_plugins( '/' . plugin_basename( dirname( $wp_ada_compliance_plugin_directory ) ) );
	$plugin_file = basename( ( $wp_ada_compliance_plugin_directory ) );
	return $plugin_folder[$plugin_file][$i];
}

/*******************************************************
display expired notification
*********************************************************/
add_action( 'admin_notices', 'wp_ada_compliance_plugin_expired_notification' );
function wp_ada_compliance_plugin_expired_notification() {
// don't dispaly if activating license	 
if (isset($_REQUEST['activate_license'])) return;
    
if (! PAnD::is_admin_notice_active( 'notice-expired-15' ) ) {
		return;
	}	

$license_expire_date = get_option('wp_ada_compliance_license_expire_date','');    
if($license_expire_date != '' and strtotime($license_expire_date) < time() and !isset($_REQUEST['activate_license'])){
echo '<div data-dismissible="notice-expired-15" class="notice notice-error is-dismissible ada-compliance-expired-notice">
<p>';  
    echo '<a href="https://www.alumnionlineservices.com/validate-purchase/?download=1" class="btn btn-warning">';
    echo __('Renew License','wp-ada-compliance');
    echo '</a>';
echo __('Your WP ADA Compliance plugin license has expired and you are no longer protected from new ADA compliance requirements. The latest version addresses all known security vulnerabilities and introduces additional ADA compliance checks.','wp-ada-compliance');

echo '</p></div>';	
}

}
/*******************************************************
display html_validation notification
*********************************************************/
add_action( 'admin_notices', 'wp_ada_compliance_html_validation_notification' );
function wp_ada_compliance_html_validation_notification() {
    
if(!strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance') and !strstr($_SERVER['REQUEST_URI'],'page=wp-ada-compliance-admin') and !strstr($_SERVER['REQUEST_URI'],'/wp-admin/index.php')) return;
    
if (! PAnD::is_admin_notice_active( 'notice-htmlvalidation-30' ) ) {
		return;
	}	    

// html validation
if (!is_plugin_active('html-validation/html-validation.php') ) {
$notice = __('HTML code validation is an important part of ensuring ADA compliance of your website. Install the ', 'wp-ada-compliance');
$notice .= '<a href="https://www.alumnionlineservices.com/php-scripts/html-validation/">';
$notice .= __('FREE HTML Validation plugin', 'wp-ada-compliance');
$notice .= '</a>';
$notice .= __(' to find and correct HTML code issues.', 'wp-ada-compliance');   

   
echo '<div data-dismissible="notice-htmlvalidation-30" class="notice notice-error is-dismissible wp-ada-compliance-notification" >';
echo $notice;
echo '</div>';
}
}
/*******************************************************
display facebook notification
*********************************************************/
//add_action( 'admin_notices', 'wp_ada_compliance_facebook_notification' );
function wp_ada_compliance_facebook_notification() {
    
if(!strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance') and !strstr($_SERVER['REQUEST_URI'],'page=wp-ada-compliance-admin')) return;
	
if (! PAnD::is_admin_notice_active( 'notice-facebook-30' ) ) {
		return;
	}	
    
// add facebook like link or saved notice
$usernotice = get_option('wp_ada_compliance_user_notice','');
/*$wpa_ada_compliance_facebook_link = __('Follow us on Facebook to receive web accessibility tips in your news feed: ','wp-ada-compliance').'<div id="fb-root"></div>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v8.0&appId=301645814260711&autoLogAppEvents=1" nonce="DiVhmSyN"></script><div class="fb-like" data-href="https://www.facebook.com/WPADAPlugin" data-width="" data-layout="button" data-action="like" data-size="large" data-share="true"></div>';*/
if($usernotice != '') {   
echo '<div data-dismissible="notice-facebook-30" class="notice notice-warning is-dismissible wp-ada-facebook-like" >';

echo $usernotice;
//echo $wpa_ada_compliance_facebook_link; 

//else echo $wpa_ada_compliance_facebook_link;
echo '</div>';
}

}
/*********************************************************
display shopping cart notice
**********************************************************/
add_action( 'admin_notices', 'wp_ada_compliance_plugin_admin_notice_shopping_cart' );
function wp_ada_compliance_plugin_admin_notice_shopping_cart() {
	if ( ! PAnD::is_admin_notice_active( 'notice-cart-30' ) ) {
        update_option('wp_ada_compliance_shopping_cart_found','false');
		return;
	}

if(!strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance')) return;    
$cartfound = get_option('wp_ada_compliance_shopping_cart_found','false');
    
 if($cartfound == 'true') {
    echo '<div data-dismissible="notice-cart-30" class="shoppingcartnotice notice notice-warning is-dismissible" >';
    
    _e('A shopping cart page was detected while running an ADA compliance scan of your website. Issues in shopping carts that are visible only when an item is in the cart will not be detected. Add an item to the shopping cart and complete the scan again to ensure the shopping cart is completely validated.','wp-ada-compliance');
     
     echo '</div>';
 }

}


/*******************************************
get notices
****************************************/
function wp_ada_compliance_get_notices() {	

$url = "https://www.alumnionlineservices.com/ADA-Full-notices.php";
	
$args = array('timeout'     => 5,'redirection' => 5,'sslverify'   => false,'user-agent' => 'WP ADA COMPLIANCE CRAWLER');
	$response = wp_remote_get( $url, $args );
	
	if( is_wp_error( $response ) )  return;

	update_option('wp_ada_compliance_user_notice',strip_tags($response['body'],'<p><a>'));

}

/*********************************************************
display rescan required notice
**********************************************************/
add_action( 'admin_notices', 'wp_ada_compliance_plugin_admin_notice_rescan_required' );
function wp_ada_compliance_plugin_admin_notice_rescan_required() {
	if ( ! PAnD::is_admin_notice_active( 'notice-rescan-30' ) ) {
		return;
	}

if(!strstr($_SERVER['REQUEST_URI'],'admin.php?page=ada_compliance')) return;    
$option = get_option('wp_ada_compliance_rescan_required','false');
    
 if($option == 'true') {
    echo '<div data-dismissible="notice-rescan-30" class="wp-ada-rescannotice notice notice-warning is-dismissible" >';
    
    _e('A new version of WP ADA Compliance has been installed. Please rescan your website to take advantage of the new features and compliance checks that were added.','wp-ada-compliance');
     
     echo '</div>';
 }

}
update_option('wp_ada_compliance_rescan_required', '1'); 
?>