<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/**********************************************
// purge data
**********************************************/
function wp_ada_compliance_purge() {
global $wpdb;
    
$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');
    
	if ( !current_user_can($settingsuser) ) return 1;
	
	$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE %d', 1) );
	
	$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE %d', 1 ) );
	
	$_SESSION['my_ada_notices'] = __('Report data has been reset.','wp-ada-compliance');
	
	update_option( 'wp_ada_compliance_full_scan_completed', 'false');
	
}

/********************************************
// purge all content no longer monitored (called when settinsg are updated)
*********************************************
function  wp_ada_compliance_purge_records_not_monitored() {
  
if ( !defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) ) return 1;

// purge excerpts
wp_ada_compliance_purge_excerpts();
    
// purge widgets
wp_ada_compliance_purge_widgets();   
    
// purge rules
wp_ada_compliance_purge_rules();    
 
// purge excluded file paths
wp_ada_compliance_purge_excluded_paths(); 
  
// purge external domains    
wp_ada_compliance_purge_external_domains();    

// purge deepscan records when using basic scans    
wp_ada_compliance_purge_deep_scan_records();
    
// purge external sources when not being monitored (iframe, css, links)
wp_ada_compliance_purge_external_src();
    
// purge ignored content
wp_ada_compliance_purge_ignored_content(); 
    
// purge post type records not monitored
 wp_ada_compliance_purge_post_types();    

// purge terms not being monitored
 wp_ada_compliance_purge_terms();	
    
// purge custom fields
wp_ada_compliance_purge_custom_fields();        
}*/

/********************************************
// purge deleted posts and terms (called during link invtory to clean up database records) 
// filters should remove them as they are updated
*********************************************/
function  wp_ada_compliance_purge_deleted_records() {
    
if ( !defined( 'DOING_CRON' ) and !current_user_can( "edit_pages" ) ) return 1;   
    
// purge term that have been deleted 
wp_ada_compliance_cleanup_remove_deleted_terms(); 	
    
// purge post type and archive records     
wp_ada_compliance_purge_post_types();    
	
// purge trashed records 
wp_ada_compliance_purge_trashed_post_records();
	
// purge records for posts moved to draft
wp_ada_compliance_purge_draft_post_records();	
	
// purge invalid taxonomy records
wp_ada_compliance_purge_invalid_taxonomys();	
	
// purge excluded paths	
wp_ada_compliance_purge_excluded_paths();	
	
// purge onsave records when deep scan is used on editor screen
wp_ada_compliance_purge_onsave_errors();	

    
}

/********************************************
// purge css or iframe errors in files from external domains if no longer monitored
*********************************************/
function  wp_ada_compliance_purge_external_domains() {
global $wpdb;

$scan_external_domains = get_option('wp_ada_compliance_scan_external_domains','false');
 if($scan_external_domains == 'false'){    
$results = $wpdb->get_results($wpdb->prepare("SELECT link, id FROM ".$wpdb->prefix."wp_ada_compliance_links WHERE type=%s and link NOT LIKE %s ", array('css','%'.get_site_url().'%')), ARRAY_A);	
if($results){
foreach($results as $row){ 
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type= %s ', array($row['id'],'css')) );
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and link = %s ', array('css',$row['link'])) );	 
}	
}
}	
}

/********************************************
// purge update ignore settings when links are purged
*********************************************/
function  wp_ada_compliance_update_ignore_settings() {
    
$ignoredPosts = get_option('wp_ada_compliance_posts_to_ignore',array());

if(!is_array($ignoredPosts)) $ignoredPosts = array();
 
foreach($ignoredPosts as $value){    
    $parts=explode('|',$value);
   
  if(!wp_ada_compliance_check_for_link_record($parts)){ 
                                                     
      if (($key = array_search($value, $ignoredPosts)) !== false) {
        
   unset($ignoredPosts[$key]);
}
  }
}
 update_option('wp_ada_compliance_posts_to_ignore', $ignoredPosts);   
}

/********************************************
// purge external sources when not monitored (iframe, css, links)
*********************************************/
function  wp_ada_compliance_purge_external_src() {
global $wpdb;
  
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
       

    // purge external sources	
if(!is_array($scan_external_sources) or !in_array('css',$scan_external_sources) ){
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s ', array("css")) );	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s ', array("css")) );		
}
if(!is_array($scan_external_sources) or !in_array('iframe',$scan_external_sources)){
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s ', array("iframe")) );	

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s ', array("iframe")) );	
}
if(!is_array($scan_external_sources) or !in_array('linked',$scan_external_sources)){
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s ', array("link")) );	

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s ', array("link")) );		
	
}
if(!is_array($scan_external_sources) or !in_array('pdf',$scan_external_sources)){

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s ', array("pdf")) );	

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s ', array("pdf")) );		
	
}    
}

/********************************************
// purge ignored content
*********************************************/
function  wp_ada_compliance_purge_autocorrect_errors() {
global $wpdb;
  
if(get_option('wp_ada_compliance_report_filtered_errors','false') == 'false')    
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE ignre= %s ', array('2')) );      
    
}

/********************************************
// purge onsave errors
*********************************************/
function  wp_ada_compliance_purge_onsave_errors() {
global $wpdb;
  
if(get_option('wp_ada_compliance_deep_scan_on_editor','') != 'false')    
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE scantype = %s ', array('onsave')) );      
    
}

/********************************************
// purge ignored content
*********************************************/
function  wp_ada_compliance_purge_ignored_content() {
global $wpdb;
    
    // update link ignore status
wp_ada_compliance_update_link_ignore_status();
    
//  purge theme items records
wp_ada_compliance_purge_theme_scan_item();    

$wp_ada_compliance_ignored_posts = get_option('wp_ada_compliance_posts_to_ignore',array());	    
    
if(is_array($wp_ada_compliance_ignored_posts) and count($wp_ada_compliance_ignored_posts) > 0){
    
foreach($wp_ada_compliance_ignored_posts as $post => $value){	
$parts = explode('|',$value);
if(count($parts) == 3){
    
if($parts[1] == '0' and !strstr($parts[2],'_archive') and $parts[2] != 'AuthorPage'){

}
elseif($parts[1] == '0' and strstr($parts[2],'_archive')){

// delete iframe srcs	
$query = 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE scantype = %s';	
$wpdb->query($wpdb->prepare( $query, array($parts[2])));

}	
else{
      
$query = 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s';	
$wpdb->query($wpdb->prepare( $query, array($parts[1],$parts[0])));	
   
// also remove custom fields
if($parts[0] != 'term' and $parts[0] != 'theme' and $parts[0] != 'widget'){
 $query = 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d ';
$wpdb->query($wpdb->prepare( $query, array($parts[1])));
}	
}
if($parts[2] == 'AuthorPage' and $parts[0] == 'theme'){ 

$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and id = %s and themetype = %s ', array(1, $parts[0], $parts[1], 'Author Page')) );
 
}  
if($parts[0] == 'link' or $parts[0] == 'pdf' or $parts[0] == 'iframe' or $parts[0] == 'css'){    
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and id = %d ', array(1, $parts[0], $parts[1])) );	
}   
    
elseif($parts[0] != 'theme' and $parts[0] != 'widget'){    
 $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and postid = %d ', array(1, $parts[0], $parts[1])) );	
}
}
}

}
}

/********************************************
// purge errors no longer being scanned
*********************************************/
function  wp_ada_compliance_purge_rules() {
global $wpdb;

wp_ada_compliance_update_scan_rule_ignore_options();
    
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array()); 

if(is_array($wp_ada_compliance_scanoptions) and count($wp_ada_compliance_scanoptions) > 0){
$rule_count = count($wp_ada_compliance_scanoptions);
$ruleplaceholders = array_fill(0, $rule_count, '%s');
$ruleformat = implode(', ', $ruleplaceholders);	

$query = 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE errorcode in('.$ruleformat.') ';	
$wpdb->query( 
	$wpdb->prepare( $query, $wp_ada_compliance_scanoptions));	
}
}

/********************************************
//  purge theme items records
*********************************************/
function  wp_ada_compliance_purge_theme_scan_item() {
global $wpdb, $wp_ada_compliance_theme_scan_items;
   
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page", ));
 
if(!is_array($theme_scan_items)){
	$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s and scantype NOT LIKE %s ', array('theme', '%_archive')) );
	
	$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s', array(1, 'theme')) );	
}
elseif(!in_array("all",$theme_scan_items)) {
	foreach($wp_ada_compliance_theme_scan_items as $key => $value){
	if(!in_array($value,$theme_scan_items)){
	$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s and scantype LIKE %s ', array('theme', $value."%")) );
		
	$wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and themetype = %s ', array(1, 'theme', $value)) );		
	}
	}
}    
    
}


/********************************************
// purge widgets
*********************************************/
function  wp_ada_compliance_purge_widgets() {
global $wpdb;
$scan_widgets = get_option('wp_ada_compliance_scan_widgets','true');

if($scan_widgets == 'false') {

	$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s ', array('widget') ) );
}    
    
}

/********************************************
// purge post type records not monitored
*********************************************/
function  wp_ada_compliance_purge_post_types() {
global $wpdb;
    // purge invalid post types
	wp_ada_compliance_purge_invalid_post_types();
	
    $checked = get_option('wp_ada_compliance_posttypes', array('page','post'));
 
// purge posts		
$results = $wpdb->get_results($wpdb->prepare("SELECT distinct(post_type) FROM ".$wpdb->prefix."posts  where post_status = %s or post_type = %s", array("publish", "attachment")), ARRAY_A);	
	
if($results){
foreach($results as $row){ 
	
	// delete posts type errors with a postid of 0;
	$query = 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s and postid = %s ';
	$wpdb->query($wpdb->prepare($query, array($row['post_type'], 0)));	
	
	 if(!is_array($checked) or is_array($checked) and !in_array($row['post_type'], $checked))  {
        
// purge archives errors and links
$query = 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s and scantype = %s ';
$wpdb->query($wpdb->prepare($query, array('theme', $row['post_type'].'_archive')));	
$query = 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type= %s and themetype = %s ';
$wpdb->query($wpdb->prepare($query, array(1, 'theme', $row['post_type'].'_archive')));	
		
         // purge posts		
$results2 = $wpdb->get_results($wpdb->prepare("SELECT distinct(postid) FROM ".$wpdb->prefix."wp_ada_compliance where type = %s", array($row['post_type'])), ARRAY_A);	
	
    // delete post type errors
    $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s ', array($row['post_type']) ) );
         
    // ignore links
     $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s ', array(1, $row['post_type'])) );	         

}
}    
    
}
}

/********************************************
// purge terms not being monitored
*********************************************/
function  wp_ada_compliance_purge_terms() {
global $wpdb;
// purge taxonomy	
	
// purge invalid taxonomy records
wp_ada_compliance_purge_invalid_taxonomys();	
	
$categories = get_option('wp_ada_compliance_terms', array('category'));	

$results = $wpdb->get_results("SELECT distinct(taxonomy) FROM ".$wpdb->prefix."term_taxonomy", ARRAY_A);
	if($results){
foreach($results as $row){ 
 if(!is_array($categories) or is_array($categories) and !in_array($row['taxonomy'], $categories))  {
		
		$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE taxonomy= %s ', array($row['taxonomy']) ) );
	 
	 	$wpdb->query( $wpdb->prepare( 'update '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and taxonomy = %s', array(1, 'term', $row['taxonomy'])) );		
	 }
    else{
        if(isset($row['term_id']) and isset($row['taxonomy'])){
        $link = get_term_link((int)$row['term_id'], $row['taxonomy']);
 if(!is_string($link)) {    
      $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type= %s and taxonomy = %s and postid = %d ', array('term', $row['taxonomy'], $row[ 'term_id'])) );
 }
}    
}
}
}  
}


/**********************************************
// purge deleted post records 
**********************************************/
function wp_ada_compliance_purge_trashed_post_records(){
global $wpdb;
  
$results = $wpdb->get_results($wpdb->prepare("SELECT ".$wpdb->prefix."posts.ID, ".$wpdb->prefix."posts.post_type FROM ".$wpdb->prefix."posts inner join ".$wpdb->prefix."wp_ada_compliance_links on ".$wpdb->prefix."wp_ada_compliance_links.postid = ".$wpdb->prefix."posts.ID where post_status = %s", "trash"), ARRAY_A);
    
	
foreach($results as $row){ 	

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s ', $row['ID'], $row['post_type']) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d', array($row['post_type'], $row['ID'])) );			
}
	
}

/********************************************
// purge trashed attachments
********************************************/ 
function wp_ada_compliance_purge_trashed_attachment_links($id){
global $wpdb;

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s ', $id, 'attachment') );
    
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d', array('attachment', $id)) );	
    
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE attachmentid = %d and type = %s ', $id, 'pdf') );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and attachmentid = %d', array('pdf', $id)) );			
	
}


/**********************************************
// purge deleted post when deleted from trash bin
**********************************************/
function wp_ada_compliance_delete_post( $null, $post, $force_delete ) { 
	global $wpdb;
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s ', $post->ID, $post->post_type) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d', array($post->post_type, $post->ID)) );	
} 

/**********************************************
// purge errors and linsk when status changes to draft
**********************************************/
function wp_ada_compliance_delete_draft_posts($new_status, $old_status, $post ) { 
	global $wpdb;
 if ( $new_status == 'draft' or $new_status == 'trash'  ) {    
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s ', $post->ID, $post->post_type) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d', array($post->post_type, $post->ID)) );
 }
} 

/**********************************************
// purge errors and linsk when status changes to draft
**********************************************/
function wp_ada_compliance_delete_draft_posts_by_id($postid, $post_type) { 
	global $wpdb;
  
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s ', $postid, $post_type) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d', array($post_type, $postid)) );

} 


/**********************************************
// purge excluded paths
**********************************************/
function wp_ada_compliance_purge_excluded_paths(){
global $wpdb;
    // exclude paths
$excluded_link_path = get_option('wp_ada_compliance_excluded_link_path',array('paged=','/page/')); 
if(!is_array($excluded_link_path)) $excluded_link_path = array();
    
foreach($excluded_link_path as $key => $value){
if($value != ''){
    
    $results = $wpdb->get_results($wpdb->prepare("SELECT postid, id, type, themetype FROM ".$wpdb->prefix."wp_ada_compliance_links where ignre = %d and link LIKE %s ", array(0, "%".$value."%")), ARRAY_A);	

    foreach($results as $row){ 	
		
	if($row['type'] == 'theme'){	
      $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE scantype = %s and type = %s ', $row['themetype'], $row['type']));

    $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and themetype = %s', array(1, $row['type'], $row['themetype'])) );	
	}
	elseif($row['postid'] == '0'){
	  $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s ', $row['id'], $row['type']));

    $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and id = %d', array(1, $row['type'], $row['id'])) );				
		}
	else{
	 $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d and type = %s  ', $row['postid'], $row['type']));

    $wpdb->query( $wpdb->prepare( 'UPDATE '.$wpdb->prefix.'wp_ada_compliance_links set ignre = %d WHERE type = %s and postid = %d', array(1, $row['type'], $row['postid'])) );		
	}
		
    }    
}
}
    
}

/**********************************************
// purge draft post records
**********************************************/
function wp_ada_compliance_purge_draft_post_records(){
global $wpdb;
$results = $wpdb->get_results($wpdb->prepare("SELECT ID, post_type FROM ".$wpdb->prefix."posts where post_status = %s or post_status = %s or post_status = %s or post_type = %s or post_status = %s or post_status = %s", "tao_sc_publish","draft","auto-draft","revision","private","cus_sc_publish"), ARRAY_A);	

foreach($results as $row){ 	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and postid = %d', $row['post_type'], $row['ID']) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d', array($row['post_type'], $row['ID'])) );			
}
	
}

/*********************************************************
remove deleted term
*******************************************************/
function wp_ada_compliance_remove_deleted_terms($term_id, $tx_id, $taxonomy, $deleted_term) {
global $wpdb;
if($term_id != '' and $taxonomy!=''){
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d  and type = %s and taxonomy = %s', $term_id, 'term', $taxonomy) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d and taxonomy = %s', array('term', $term_id, $taxonomy)) );
}

}
/*********************************************************
remove deleted term durng link inventory 
**********************************************************/
function wp_ada_compliance_cleanup_remove_deleted_terms() {
global $wpdb;
	
$query = 'SELECT distinct postid, type, taxonomy FROM '.$wpdb->prefix.'wp_ada_compliance where type= %s';

	$results = $wpdb->get_results( $wpdb->prepare($query, 'term'), ARRAY_A );

	if($results){
		foreach($results as $row){ 	

$term = term_exists((int)$row['postid']);
    
if ( 0 == $term or null == $term ) {

$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE postid = %d  and type = %s and taxonomy = %s', $row['postid'], 'term', $row['taxonomy']) );
	
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and postid = %d and taxonomy = %s', array('term', $row['postid'], $row['taxonomy'])) );		
}
		}
	}

}

/**********************************************
// update link status
**********************************************/
function wp_ada_compliance_update_link_ignore_status() {
global $wpdb;   
$ignoredPosts = get_option('wp_ada_compliance_posts_to_ignore',array());
if(!is_array($ignoredPosts)) $ignoredPosts = array();
    
$theme_scan_items = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page", ));	
if(!is_array($theme_scan_items)) $theme_scan_items = array();	
    
$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(!is_array($scan_external_sources)) $scan_external_sources = array();   
        
$result = $wpdb->get_results($wpdb->prepare('SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance_links where %d', 1), ARRAY_A );
foreach($result as $row){
    if($row['themetype'] == 'AuthorPage'){
        $check = $row['type'].'|'.$row['postid'].'|'.$row['themetype'];
        if(in_array($check,$ignoredPosts)){
       wp_ada_compliance_set_ignore_flag($row['id'], 1); 
    } 
    }
  elseif($row['type'] == 'theme'){
       if(!in_array($row['themetype'],$theme_scan_items)){
         wp_ada_compliance_set_ignore_flag($row['id'], 1); 
    } else{
      wp_ada_compliance_set_ignore_flag($row['id'], 0);  
    }
   }elseif($row['type'] == 'css' or $row['type'] == 'link' or $row['type'] == 'iframe' or $row['type'] == 'pdf'){
    
    if($row['type'] == 'css')
    $check = $row['type'].'|0|'.$row['link']; 
    elseif($row['type'] == 'link')
    $check = $row['type'].'|'.$row['id'].'|';
    elseif($row['type'] == 'iframe')
    $check = $row['type'].'|'.$row['id'].'|';
    elseif($row['type'] == 'pdf')
    $check = $row['type'].'|'.$row['id'].'|';  
  
    //$check = $row['type'].'|'.$row['postid'].'|';
   
    if(!in_array($check,$ignoredPosts) )   
    wp_ada_compliance_set_ignore_flag($row['id'], 0);
    else
     wp_ada_compliance_set_ignore_flag($row['id'], 1);

   }
}

}


/**********************************************
// purge meta keys for post types not monitored
**********************************************/
function wp_ada_compliance_purge_metafields(){
global $wpdb;
$keystofilter = get_option('wp_ada_compliance_metafields',array('_thumbnail_id'));	
$post_types = get_option('wp_ada_compliance_posttypes',array('page','post'));
$found = 0;	
if(!is_array($keystofilter)) return false;

if(!is_array($post_types) or count($post_types) == 0) {
update_option('wp_ada_compliance_metafields','');	
	return false;
}
	
foreach($keystofilter as $key => $value){	
	$query = 'SELECT distinct post_type FROM '.$wpdb->prefix.'postmeta inner join '.$wpdb->prefix.'posts on '.$wpdb->prefix.'posts.ID = '.$wpdb->prefix.'postmeta.post_id where meta_key = %s';

	$results = $wpdb->get_results( $wpdb->prepare($query, $value), ARRAY_A );

	if($results){
		foreach($results as $row){ 
		
		if(in_array($row['post_type'],$post_types)) $found = 1;
		}
	}
	if($found != 1) {
		 unset($keystofilter[$key]);
		
	}
	$found = 0;	
}
	
	update_option('wp_ada_compliance_metafields',$keystofilter);
}

/********************************************
// purge invalid post types
*********************************************/
function  wp_ada_compliance_purge_invalid_post_types() {
global $wpdb;

$valid_post_types = get_post_types( '', 'names' );
	
$results = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT type FROM ".$wpdb->prefix."wp_ada_compliance_links WHERE type != %s and type != %s and type != %s and type != %s and type != %s and type != %s ", array('iframe','link', 'theme', 'css', 'term','pdf')), ARRAY_A);	
if($results){
foreach($results as $row){ 
if(!in_array($row['type'],$valid_post_types)){
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s ', array($row['type'])) );
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s ', array($row['type'])) );
}
}	
}

}

/********************************************
// purge invalid taxonomies 
*********************************************/
function  wp_ada_compliance_purge_invalid_taxonomys() {
global $wpdb;
	
$results = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT taxonomy FROM ".$wpdb->prefix."wp_ada_compliance_links WHERE type = %s and taxonomy != %s ", array('term','')), ARRAY_A);	
if($results){
foreach($results as $row){ 
if(!taxonomy_exists($row['taxonomy'])){
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance WHERE type = %s and taxonomy = %s ', array('term',$row['taxonomy'])));
$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$wpdb->prefix.'wp_ada_compliance_links WHERE type = %s and taxonomy = %s ', array('term',$row['taxonomy'])));
}
}	
}

}
?>