<?php
/*
functions to support display or reports and reference pages
*/
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/**********************************************
REFRESH REPORT PAGE
********************************************/
function wp_ada_compliance_refresh_report_page(){
    
// set required php settings	
wp_ada_compliance_set_php_ini_Settings();
    
	check_ajax_referer('wp_rest', '_wpnonce');
	
	//if(!isset($_GET['status']) or $_GET['status'] == 0)
       // wp_ada_compliance_purge_deleted_records(); 
	
	wp_ada_compliance_report_page(1);
}
/********************************************
// display stats/error report
**********************************************/
function wp_ada_compliance_report_page($scaninprogress=0) {
global $wpdb, $wp_ada_compliance_def;

// include help topics	
include('helptopics.php');
  
    // unset iframe if not set to 1
if(isset($_GET['iframe']) and $_GET['iframe'] != '1') unset($_GET['iframe']);   
	
// check cap allowed to edit settings
$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');
    
	
// check auto correct settings	
$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');    
	
// remove nounce to keep it from breaking thickbox links	
$_SERVER['REQUEST_URI'] = remove_query_arg( '_wpnonce', $_SERVER['REQUEST_URI'] );	
    
wp_ada_compliance_validate_form_values();
    
if($scaninprogress == 1 and isset($_GET['status'])){
 $scaninprogress = (int)$_GET['status'];  
}
    
    

// create pagination offset	
$per_page = get_option('wp_ada_compliance_errors_per_page','15');
$total = 0;
$page = isset( $_GET['cpage'] ) ? abs( (int) $_GET['cpage'] ) : 1;
if ($page > 1) {
   $offset = $page * $per_page - $per_page;
} else {
    $offset = 0;
}	
    
    //filter by mod date
	if(isset($_GET['modifieddate']) and $_GET['modifieddate'] != '') {
		$moddate = sanitize_text_field($_GET['modifieddate']);
	}
	else {
		$_GET['modifieddate'] = '';
		$moddate = '';
	}
	
	//filter by view
	if(isset($_GET['view']) and $_GET['view'] != '') {
		$view = (int)$_GET['view'];
	}
	else {
		$_GET['view'] = 1;
		$view = 1;
	}
	
		//sort 
	if ( isset( $_GET[ 'sort' ] ) and $_GET[ 'sort' ] != "") { 
		if($_GET[ 'sort' ] == 1) {
			$sort = 1;
			$sortby = 'date DESC, '.$wpdb->prefix.'wp_ada_compliance.id DESC';
		}
		if($_GET[ 'sort' ] == 2) {
			$sort = 2;
			$sortby = $wpdb->prefix.'wp_ada_compliance.type asc';
		}
		if($_GET[ 'sort' ] == 3) {
			$sort = 3;
			$sortby = 'errorcode asc';
		}
		if($_GET[ 'sort' ] == 4) {
			$sort = 4;
			$sortby = $wpdb->prefix.'wp_ada_compliance.ignre desc';
		}
		if($_GET[ 'sort' ] == 5) {
			$sort = 5;
			$sortby = $wpdb->prefix.'wp_ada_compliance.posttitle asc';
		}
		if($_GET[ 'sort' ] == 6) {
			$sort = 6;
			$sortby = 'scantype desc';
		}
	} else {
		$sort = 1;
		$sortby = 'date DESC, '.$wpdb->prefix.'wp_ada_compliance.id DESC ';
	}
	
	// exclude duplicates
	if(isset($_GET['excludedups'])) {
		$excludedups = (int)$_GET['excludedups'];
	} else $excludedups = 0;
    
	if(isset($_GET['excludethemes'])) {
		$excludethemes = (int)$_GET['excludethemes'];
	} else $excludethemes = 0;
	
	// filter by post type
	if (isset($_GET['type'])) {
	 $type = sanitize_text_field($_GET[ 'type' ]);
	} else{
		$_GET['type'] = "";
		$type = "";
	}

	
	// filter by error code
	if (isset( $_GET['errorw']) and !isset( $_GET['error'])) $_GET['error'] = $_GET['errorw'];
	if (isset( $_GET['error'])) {
		$error = sanitize_text_field($_GET[ 'error' ]);
	} else $error = "";	

	// specific post
	if ( isset( $_GET[ 'errorid' ] ) and $_GET[ 'errorid' ] != "") { 
			$errorid = ( int )$_GET[ 'errorid' ];
	} else $errorid = "";
	
	// filter by search
	if (isset( $_GET['searchtitle'])) {
		if(is_numeric($_GET['searchtitle'])) {
			$errorid= (int)$_GET['searchtitle'];
			$searchtitle = "";
		}
		else $searchtitle = sanitize_text_field($_GET['searchtitle']);
		
		//$_GET['searchtitle'] = sanitize_text_field($_GET['searchtitle']);
		
	} else $searchtitle = "";
	

	
	echo '<a id="adascrollbutton" aria-label="Top"><i class="fas fa-chevron-up"></i></a>';	
	    echo '<div class="wp_ada_compliance_report">';

	
	if (!isset($_GET['iframe']) and !isset($_GET['_wpnonce'])){
		// display system requirement issues and additional setup:
	wp_ada_compliance_check_server_requirements();
	}
	
                // get logo image    
$license_expire_date = get_option('wp_ada_compliance_license_expire_date','');    
if($license_expire_date == '' or strtotime($license_expire_date) > time()){    
 $image_id  = get_option( 'wp_ada_compliance_report_logo');
if( intval( $image_id ) > 0 ) {
// Change with the image size you want to use
echo wp_get_attachment_image( $image_id, 'full', false, array( 'id' => 'wp-ada-compliance-logo-reportscreen' ) );
}
}
	echo '<h2>';
	echo __('Web Accessibility Report: ', 'wp-ada-compliance');
	if($errorid != "") echo esc_html(get_the_title($errorid));
	elseif($searchtitle != "") echo stripslashes(esc_html($searchtitle));
	else echo esc_html(get_bloginfo('name'));
	echo '</h2>';

			$queryVariablesMain = array();
		$queryVariablesTotal = array();
	
	if ($errorid != "" and isset($_GET['iframe'])) { // specific post
     
        // get post
        $post = get_post($errorid); 
    if($type == 'pdf'){
        $query = "SELECT * FROM ".$wpdb->prefix."wp_ada_compliance where attachmentid = %d and type = %s ";
               $queryVariablesMain[] = $errorid;
         $queryVariablesMain[] = 'pdf';
    }
        elseif($type == 'term'){
$query = "SELECT * FROM ".$wpdb->prefix."wp_ada_compliance where postid = %d and type = %s and locationnotes LIKE %s ";
        $queryVariablesMain[] = $errorid;
         $queryVariablesMain[] = 'term';
         $queryVariablesMain[] = '%term description%';
        }
        else{
			$deep_scan_on_editor = get_option('wp_ada_compliance_deep_scan_on_editor','true');
			
	if($deep_scan_on_editor == 'false'){
		$query = "SELECT * FROM ".$wpdb->prefix."wp_ada_compliance where postid = %d and scantype = %s and type = %s";
        $queryVariablesMain[] = $errorid;
		         $queryVariablesMain[] = 'onsave';
         $queryVariablesMain[] = $post->post_type;

	}	else{	
$query = "SELECT * FROM ".$wpdb->prefix."wp_ada_compliance where postid = %d and type = %s and themeerror < %d ";
        $queryVariablesMain[] = $errorid;
         $queryVariablesMain[] = $post->post_type;
         $queryVariablesMain[] = 75;
	}
        }
		
        	// hide if auto filter is turned off
		if($report_filtered_errors == 'false' or $report_filtered_errors == 'scanonly') $query .= " and ignre != 2 "; 
        
		$query .= "order by ignre";

		$results = $wpdb->get_results( $wpdb->prepare( $query, $queryVariablesMain), ARRAY_A );
		$title = esc_html(get_the_title($errorid));
		$showresults ="View=PostID: $errorid".'; ';
		if($title != "") $showresults .= __('Title=','wp-ada-compliance').stripslashes($title).';';

	} 
	else{ 
		$showresults ="";
        
        // search links
        if(strstr($searchtitle,'/')){
        $linkquery = 'left join '.$wpdb->prefix.'wp_ada_compliance_links on '.$wpdb->prefix.'wp_ada_compliance_links.postid = '.$wpdb->prefix.'wp_ada_compliance.postid'; 
        } else $linkquery = '';
        
		$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance '.$linkquery.' where %d ';
		$queryVariablesMain[] = 1;
		
		$totalquery = 'SELECT count('.$wpdb->prefix.'wp_ada_compliance.id) FROM '.$wpdb->prefix.'wp_ada_compliance '.$linkquery.' where %d  ';
		$queryVariablesTotal[] = 1;
		
        		// hide if auto filter is turned off
		if($report_filtered_errors == 'false') $query .= " and ".$wpdb->prefix."wp_ada_compliance.ignre != 2 "; 
		
		if( $view == 1 ) { // current
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';

			$queryVariablesMain[] = 0;
			$queryVariablesTotal[] = 0;
			
			$showresults .= __(" View=Current; ",'wp-ada-compliance');

		}
		if ( $view == 2 ) { // all
				
			$showresults .= __(" View=All; ",'wp-ada-compliance');

		}

		if ( $view == 3 ) { // ignored
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d';

			$queryVariablesMain[] = 1;
			$queryVariablesTotal[] = 1;
			
			$showresults .=__(" View=Ignored; ",'wp-ada-compliance');

		}
        		if( $view == 4 ) { // auto corrected issues
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d';

			$queryVariablesMain[] = 2;
			$queryVariablesTotal[] = 2;
			
			$showresults .= __(" View=Auto Corrected; ",'wp-ada-compliance');

		}
	
       
        if ($type=='attachment' and $errorid != '' ) { // filter by attachment
            
		$query .= ' and (postid = %d or attachmentid = %d) ';
			$totalquery .= ' and (postid = %d or attachmentid = %d) ';
		
			$queryVariablesMain[] = $errorid;
			$queryVariablesTotal[] = $errorid;
            $queryVariablesMain[] = $errorid;
			$queryVariablesTotal[] = $errorid;
			
			$showresults = __(' View=PostID: ','wp-ada-compliance').$errorid.';';
			}
		elseif ( $errorid != '' ) { // filter by post type
		$query .= ' and postid = %d ';
			$totalquery .= " and postid = %d ";
		
			$queryVariablesMain[] = $errorid;
			$queryVariablesTotal[] = $errorid;
			
			$showresults = __(' View=PostID: ','wp-ada-compliance').$errorid.';';
			}
	
		if ($excludethemes == 1) { // remove theme errors
            
             $query.= ' and (themeerror = %d )';
            $queryVariablesMain[] = 0;
			
            $totalquery .= ' and (themeerror = %d )';
            $queryVariablesTotal[] = 0;	
			
			}
		
		if ( $type != '' ) { // filter by post type
			if ( $type == 'excludethemes' ) { // filter by post type
			$query .= ' and (themeerror = %d )';
			$totalquery .= '  and (themeerror = %d )';
			$queryVariablesMain[] = 0;
			$queryVariablesTotal[] = 0;	
			}
	      	elseif ( $type == 'customfield' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** custom field%";
			$queryVariablesTotal[] = "%** custom field%";
			}
                     	elseif ( $type == 'excerpt' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** post excerpt%";
			$queryVariablesTotal[] = "%** post excerpt%";
			}
			elseif ( $type == 'theme' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = $type;
			$queryVariablesTotal[] = $type;
			}
            elseif($type == 'attachment' and $errorid != '' ){
      		$query .= ' and ( '.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = 'attachment';
			$queryVariablesTotal[] = 'attachment';
            $queryVariablesMain[] = 'pdf';
            $queryVariablesTotal[] = 'pdf';
			}
            elseif($errorid != '' ){
			$query .= ' and  '.$wpdb->prefix.'wp_ada_compliance.type = %s ';
			$totalquery .= '  and '.$wpdb->prefix.'wp_ada_compliance.type = %s';
			$queryVariablesMain[] = $type;
			$queryVariablesTotal[] = $type;
     
			}
			else{
			$query .= ' and ( '.$wpdb->prefix.'wp_ada_compliance.type = %s )';
			$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.type = %s )';
			$queryVariablesMain[] = $type;
			$queryVariablesTotal[] = $type;
			}
			
			$showresults .= __(' Post type=','wp-ada-compliance').$type.'; ';
			}
		if ( $error != '' ) { // filter by error code
			if($error == 'W' or $error == 'A'){
                $query .= " and severity = %s ";			
                $totalquery .= " and severity = %s ";
            }else{
               $query .= " and errorcode = %s ";			
                $totalquery .= " and errorcode = %s"; 
            }
			
			$queryVariablesTotal[] = $error;
			$queryVariablesMain[] = $error;
			
			$showresults .=__(' Error type=','wp-ada-compliance').$error.'; ';
		}
		
		if ( $searchtitle != '' ) { // filter by post title
            if($linkquery != ''){
                $query .= " and link LIKE %s ";			
			$totalquery .= " and link LIKE %s";
			
			$queryVariablesTotal[] = '%'.$searchtitle.'%';
			$queryVariablesMain[] = '%'.$searchtitle.'%';
			
			$showresults .=__(' Link=','wp-ada-compliance').$searchtitle.'; ';
            }else{
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.posttitle LIKE %s ';			
			$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.posttitle LIKE %s';
			
			$queryVariablesTotal[] = '%'.$searchtitle.'%';
			$queryVariablesMain[] = '%'.$searchtitle.'%';
			
			$showresults .=__(' Title=','wp-ada-compliance').stripslashes($searchtitle).'; ';
            }
		}
        
        if ( $moddate != '' ) { // filter by modified date
			$query .= " and (modifieddate >= %s or modifieddate = %s)";			
			$totalquery .= " and (modifieddate >= %s or modifieddate = %s)";
			$queryVariablesTotal[] = $moddate;
			$queryVariablesMain[] = $moddate;
            $queryVariablesTotal[] = '0000-00-00 00:00:00';
			$queryVariablesMain[] = '0000-00-00 00:00:00';
			
			$showresults .=__(' Modified Date=','wp-ada-compliance').$moddate.'; ';
		}
		
		if ($excludedups == 1) { // remove duplicates
			$query .= ' GROUP BY errorcode, object ';
			$totalquery .= " GROUP BY errorcode, object ";
			$showresults .= __(' Excluding: duplicates; ', 'wp-ada-compliance') ;
		}

		$query .= " order by $sortby limit %d offset %d";
       

		$queryVariablesMain[] = $per_page;
		$queryVariablesMain[] = $offset;

        if ($excludedups == 1) { 
		 $totalresults = $wpdb->get_results($wpdb->prepare($totalquery, $queryVariablesTotal));
            $total = count($totalresults);
        }else{
          $total = $wpdb->get_var($wpdb->prepare($totalquery, $queryVariablesTotal));  
        }

		$results = $wpdb->get_results( $wpdb->prepare($query, $queryVariablesMain), ARRAY_A );

			// display error summary
		$report_summary = get_option('wp_ada_compliance_report_summary','true');
		if($report_summary == 'true'){
		if (isset($_COOKIE['hide-wp-ada-summary']) or (isset($_GET['displaysummary']) and $_GET['displaysummary'] == 0)) $hidesummary = 1;
		
		if(isset($hidesummary)) 
		echo '<button type="button" class="summary-dismiss"><i class="fas fa-toggle-off"></i> '.__('Show Summary','wp-ada-compliance').'</button>';
		else 
		echo '<button type="button" class="summary-dismiss"><i class="fas fa-toggle-on"></i> '.__('Hide Summary','wp-ada-compliance').'</button>';
                
		echo '<div class="wp_ada_summary"';
		if(isset($hidesummary)) echo ' style="display:none;" ';
		echo'>';
           
            	
		echo wp_ada_compliance_report_error_summary($view, $type, $error, $searchtitle, $errorid, $excludethemes, $excludedups, $moddate);
	 	echo '</div>';
		}
		
	}
	// enforce license
if(!wp_ada_compliance_checkdemo_date()) {	
if(!isset($_GET['iframe'])){ // specific post
	
echo '<div class="wp-ada-compliance-buttns">';	

if(wp_ada_compliance_check_complete_status() > 0) {	
	
	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php';
    $crawl_status = get_option('wp_ada_compliance_crawl_status','1');
    if($crawl_status == 0) echo '&crawl=0'; 
    else echo '&crawl=1'; 
    echo '&startscan=1&scanmore=1&sort='.esc_attr($sort).'" class="startscan continue btnwpada btnwpada-primary wpa-control-scan-button ';
    if($crawl_status == 0) echo ' nocrawl ';
    else echo 'crawl';
    echo '" data-scanmore="1" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo ' title="Continue last scan."><i class="fas fa-forward" aria-hidden="true"></i> ';
	_e('Continue', 'wp-ada-compliance');
	echo '</a> ';		
	}    
	

    
	// display crawl link if link scan is enabled
	$scan_external_sources = get_option('wp_ada_compliance_scan_external_sources',array('iframe','linked'));
if(is_array($scan_external_sources) and in_array('linked', $scan_external_sources) ){
   if(get_option( 'wp_ada_compliance_full_scan_completed', 'false')=='true') {	
    	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&crawl=0&startscan=1&sort='.esc_attr($sort).'" class="nocrawl startscan btnwpada btnwpada-primary wpa-control-scan-button" data-scanmore="0" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo ' title="';
    _e('Scan website without crawling to locate links.', 'wp-ada-compliance');
    echo '"><i class="fas fa-play" aria-hidden="true"></i> ';
	_e('Quick Scan', 'wp-ada-compliance');
	echo '</a> ';	
    }
    
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&crawl=1&startscan=1&sort='.esc_attr($sort).'" class="startscan btnwpada btnwpada-primary wpa-control-scan-button" data-scanmore="0" style="';
    if($scaninprogress == 1) echo ' display:none;';
    
    echo ' margin-left:20px;" title="';
    _e('Crawl website to locate links during scan.', 'wp-ada-compliance');
    echo '"><i class="fas fa-play-circle" aria-hidden="true"></i> ';
	_e('Crawl & Scan', 'wp-ada-compliance');
	echo '</a> ';
    }
    else{ // link scan disabled
 	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&crawl=0&startscan=1&sort='.esc_attr($sort).'" class="nocrawl startscan btnwpada btnwpada-primary wpa-control-scan-button" data-scanmore="0" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo '><i class="fas fa-play" aria-hidden="true"></i> ';
	_e('Quick Scan', 'wp-ada-compliance');
	echo '</a> ';	   
}
    
       echo '<a href="#" class="adastopscan btnwpada btnwpada-primary"';
    if($scaninprogress != 1) echo ' style="display:none;"';
    echo '><i class="fas fa-stop" aria-hidden="true"></i> ';
	_e('Stop', 'wp-ada-compliance');
	echo '</a> ';	
    
	echo '<span class="ada_report_options">';
    
	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&refresh=1&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'&modifieddate='.esc_attr($moddate).'&sort='.esc_attr($sort).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'" id="refreshbtn" class="btnwpada btnwpada-primary wpa-control-button" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo '><i class="fas fa-sync-alt" aria-hidden="true"></i> ';
	_e('Refresh View', 'wp-ada-compliance');
	echo '</a> ';	
	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&view=1&type=&error=&errorid=&searchtitle=&refresh=1&sort=&excludedups=&excludethemes=" class="btnwpada btnwpada-primary wpa-control-button" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo '><i class="fas fa-filter" aria-hidden="true"></i> ';
	_e('Clear Filters', 'wp-ada-compliance');
	echo '</a> ';	
    
	
	if (current_user_can($settingsuser) ){ 
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin" class="btnwpada btnwpada-primary wpa-control-button" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo '><i class="fas fa-cog" aria-hidden="true"></i> ';
	_e('Settings', 'wp-ada-compliance');
	echo '</a> ';
	
	}

echo ' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/print-report.php&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&error='.esc_attr($error).'&type='.esc_attr($type).'&errorid='.esc_attr($errorid).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'&view='.esc_attr($view).'&modifieddate='.esc_attr($moddate).'&iframe=1&TB_iframe=true&width=450&height=350"  class="thickbox btnwpada btnwpada-primary wpa-control-button" name="'.__('Print and Email Reports', 'wp-ada-compliance').'" ';
    if($scaninprogress == 1) echo ' style="display:none;"';
    echo '><i class="fas fa-print" aria-hidden="true"></i> '.__('Reports', 'wp-ada-compliance').'</a>';	

echo '</div>';
echo '</span>';
// display dropdown filters		
echo wp_ada_compliance_dropdown_builder($excludedups, $excludethemes, $moddate, $view, $error, $type, $searchtitle, $showresults, $sort, $scaninprogress);	
}
elseif(count($results) > 0)	{
	
	echo ' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/print-report.php&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&error='.esc_attr($error).'&type='.esc_attr($type).'&errorid='.esc_attr($errorid).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'&view=2&iframe=1&TB_iframe=true&width=450&height=250" class="thickbox btnwpada btnwpada-primary wp-ada-print-btn" name="'.__('Print','wp-ada-compliance').'"><i class="fas fa-print" aria-hidden="true"></i> '.__('Print', 'wp-ada-compliance').'</a>';	
	
}
//}// end enforce license
echo '<div class="wp_ada_compliance_notice_container">';
echo '<button aria-label="'.__('hide notices','wp-ada-compliance').'" class="wpadahidenotices"><i class="fas fa-times" aria-hidden="true"></i></button>';
    
if(!isset($_GET['iframe'])){ //hide notices on editor screen
		// display messages
if(!isset($_GET['scansingle'])){    
echo '<span class="wp_ada_compliance_notices">';
if(isset($_SESSION['my_ada_important_notices'])) {
	echo '<i class="fas fa-info-circle" aria-hidden="true"></i> '.esc_html($_SESSION['my_ada_important_notices']);
	unset($_SESSION['my_ada_important_notices']);
}elseif($scaninprogress == 1){
    echo '<span class="adaworking">&nbsp;</span> ';
    _e('Scan in Progress... ','wp-ada-compliance'); 
    echo wp_ada_compliance_display_progress_stats(1); 
}elseif($scaninprogress == 3){
 echo '<i class="fas fa-info-circle" aria-hidden="true"></i> ';
    _e('Scan Cancelled','wp-ada-compliance');       
}else { 
     echo '<i class="fas fa-info-circle" aria-hidden="true"></i> ';
    _e('Look for status notices here.','wp-ada-compliance');   
}
echo '</span>';
}

// manual scan notices   
if(isset($_GET['scansingle'])){
echo '<p class="adaoldmessage wp_ada_compliance_notices">';
if(isset($_GET['scansingle'])) {
    echo '<i class="far fa-check-circle" aria-hidden="true"></i> ';
if(isset($total) and $total == 0) 
_e('SCAN IS COMPLETE: No issues were found!','wp-ada-compliance');	
else
_e('SCAN IS COMPLETE: Results are displayed in the report below.','wp-ada-compliance');	
}
elseif(isset($_GET['startscan']) and wp_ada_compliance_check_complete_status() == 0) {
_e('SCAN IS COMPLETE: All of your content has been scanned and errors are displayed below. If you have enabled automatic scans your content will be continually monitored for issues.','wp-ada-compliance');	
}
elseif(isset($_GET['startscan'])){
echo strtoupper(wp_ada_compliance_display_progress_stats(1));
_e(' : Based on your scan settings all content has not been scanned. Click "Continue" to continue the scan. ','wp-ada-compliance');
	
}else {
    if(isset($_SESSION['my_ada_important_notices'])) {
	echo '<i class="fas fa-info-circle" aria-hidden="true"></i> '.esc_html($_SESSION['my_ada_important_notices']);
	unset($_SESSION['my_ada_important_notices']);
    }
    else    
     echo '<i class="fas fa-info-circle" aria-hidden="true"></i> ';
    _e('Look for status notices here.','wp-ada-compliance');   
}    
echo '</p>';   
}
   
}else{
 echo '<span class="wp_ada_compliance_notices">';
 echo '<i class="fas fa-info-circle" aria-hidden="true"></i> ';
_e('Look for status notices here.','wp-ada-compliance');   
echo '</span>';   
}
echo '</div>'; 	    
if (isset($_GET['startscan']) or $results) {

if ( $results and $scaninprogress != 1){		
	
	//display the pagination
$pagination = paginate_links(array(
    'base' => add_query_arg('cpage', '%#%', esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&refresh=1&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'&modifieddate='.esc_attr($moddate).'&sort='.esc_attr($sort).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes)),
    'format' => '',
	'mid_size'  => 2,
	'current' => 'true',
    'prev_text' => __('&laquo;'),
    'next_text' => __('&raquo;'),
    'total' => ceil($total / $per_page),
    'current' => $page
));
if($pagination != "") echo $pagination = "<p>".$pagination."</p>";
echo '<div id="reportdata"><table class="ada_error"><tr>';
	echo '<th scope="column">';
	_e('Title', 'wp-ada-compliance');
	echo '</th>';
	echo '<th scope="column" class="contenttype">';
		_e('Content Type', 'wp-ada-compliance');

	echo '</th>';
	echo '<th scope="column">';
		_e('Error Type', 'wp-ada-compliance');
	
	echo '</th>';
	echo '<th scope="column" >';
	_e('Error', 'wp-ada-compliance');
	echo '</th>';
	echo '<th scope="column" class="printhidden wp_ada_code_column">';
	_e('Affected Code', 'wp-ada-compliance');
	echo '</th>';
	echo '<th scope="column" class="printhidden wp_ada_action_column">';
	_e('Actions', 'wp-ada-compliance');
	echo '</th></tr>';

		foreach ( $results as $row ) {

	echo '<tr class="ruleid_'.esc_attr($row['errorcode']).' fileid'.esc_attr($row['postid']).''.str_replace(array(' ','.',':'),'',esc_attr($row['scantype'])).'">';
		echo '<td>';
		if(!isset($_GET['iframe'])){ // hide in iframe	
       if($row['posttitle'] !='') {
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&searchtitle='.esc_attr($row['posttitle']).'&modifieddate='.esc_attr($moddate).'&refresh=1&sort='.esc_attr($sort).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'" title="'.__('filter results on this title', 'wp-ada-compliance').'">';
		printf(__('%s', 'wp-ada-compliance'), esc_attr($row['posttitle']));
		echo '</a>';	
       }
		}
		else printf(__('%s', 'wp-ada-compliance'), esc_attr($row['posttitle']));
			echo '<br />';
			if($row['ignre'] == 1 and $row['ignoredate'] == '0000-00-00 00:00:00') {
                echo ' <span class="adaIgnored ignore'.esc_attr($row['id']).'" >'.__('** permanent ignore', 'wp-ada-compliance').'</span>';
            }
            elseif($row['ignre'] == 1 and $row['ignoredate'] != '0000-00-00 00:00:00') {
                echo ' <span class="adaIgnored ignore'.esc_attr($row['id']).'" >'.__('** temporary ignore', 'wp-ada-compliance').'</span>';
            }
     	
		echo '</td>';
		echo '<td class="contenttype">';
		printf(__('%s', 'wp-ada-compliance'), esc_attr($row['type']));

           echo wp_ada_compliance_format_error_location($row['ignre'], $row['errorcode'],$row['type'],$row['id'], $row['locationnotes'], $row['themeerror'],1);
		
		
			echo '</td>';
		echo '<td>';
		printf(__('%s', 'wp-ada-compliance'), str_replace("_", " ", esc_attr($row['errorcode'])));
			echo '</td>';
		echo '<td class="printfixedwidth">';
		if(strstr($wp_ada_compliance_def[$row['errorcode']]['DisplayError'],__("WARNING",'wp-ada-compliance'))) echo '<i class="fas fa-ban" aria-hidden="true"></i>';
		elseif(strstr($wp_ada_compliance_def[$row['errorcode']]['DisplayError'],__("ALERT",'wp-ada-compliance'))) echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i>';
          		
		printf(__('%s', 'wp-ada-compliance'), esc_html($wp_ada_compliance_def[$row['errorcode']]['StoredError']));
            
		echo '</div>';
		
		// display error references	
		if(is_array($wp_ada_compliance_def)){
		if($wp_ada_compliance_def[$row['errorcode']]['Reference'] != "") echo ' <a href="'.esc_attr($wp_ada_compliance_def[$row['errorcode']]['ReferenceURL']).'" target="_blank" class="adaNewWindowInfo">'.esc_html($wp_ada_compliance_def[$row['errorcode']]['Reference']).' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
		echo '<a href="#" class="adaHelpLinkToggle adaHelpLink viewHelp' . esc_attr($row['id']) . '"><i class="fas fa-question-circle" aria-hidden="true"></i> '.__('HELP', 'wp-ada-compliance').'';
		echo '</a><div class="adaHelpText helptext' . esc_attr($row['id']) . '">'.$wp_ada_compliance_def[$row['errorcode']]['HelpINSTR']; // don't escape this it will break help instructions
		if($wp_ada_compliance_def[$row['errorcode']]['HelpURL'] != "") echo ' <a href="'.esc_url($wp_ada_compliance_def[$row['errorcode']]['HelpURL']).'" target="_blank" class="adaViewbar adaNewWindowInfo">'.__('More Help', 'wp-ada-compliance').'  <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
		
            echo '</div>';
		
		}
	    echo '<p class="wp-ada-found-date"><i class="far fa-clock" aria-hidden="true"></i>';
            echo __('Date Found: ', 'wp-ada-compliance').date("n-j-Y g:i a",strtotime($row['date']));
            echo '</p>';
		echo '</td>';
		echo '<td class="printfixedwidth">';
        if($scaninprogress != 1){	
		echo '<span class="viewCode'.esc_attr($row['id']).' adaViewCode"><a href="#TB_inline?width=550&height=500&inlineId=code'.esc_attr($row['id']).'" class="thickbox" name="'.__('Code View','wp-ada-compliance').'"><i class="fas fa-eye" aria-hidden="true"></i>';
		_e('View Code','wp-ada-compliance');
		echo '</a></span>';

		echo '<div class="adaEffectedCode code'.esc_attr($row['id']).'" id="code'.esc_attr($row['id']).'">';
        
      if($row['errorcode'] != 'html_validation' and $row['errorcode'] != 'missing_landmarks' and $row['errorcode'] != 'unlabeled_landmarks' and $row['errorcode'] != 'skip_nav_links' )
       echo ' <code style="background-color: #fff;">'.wp_ada_compliance_filter_autoplay_av_tags(esc_html($row['object']), "1").'</code>';
 

            $trustedtags = '<svg><metadata><g><path><button><embed><iframe><p><br /><a><img><h1><h2><h3><h4><h5><h6><input><map><area><audio><video><pre><textarea><label><select><span><blink><i><fieldset><caption><form><legend><br><div><nav><main><aside><main><header><footer>';
		if(stristr($row['object'],'<table') or stristr($row['object'],'</th>') or stristr($row['object'],'</td>')) {
			$row['object'] = wp_ada_compliance_close_unclosed_tables($row['object']);
			$trustedtags .= '<table><tr><td><th><tbody><thead>';
		}

		echo '<br /><div style="background-color: #fff;">'.$row['object'].'</div>';	
			
		if($row['examplecode'] != "") {
			echo '<br /><br /><div style="background-color: #fff;">'.strip_tags($row['examplecode'],$trustedtags) .'</div>';	
		}	
		echo '</div>';
		}	else {
        echo '<i class="fas fa-eye" aria-hidden="true"></i>';
            _e('View Code','wp-ada-compliance');
        }
		echo '</td>'; 
		echo '<td class="wp_ada_action_column printhidden"> ';
		if($row['ignre'] != 2){	
		echo '<div> <a href="#" class="wp-ada-ignore-options-click wp-ada-ignore-options-click'.esc_attr($row['id']).'"><i class="fas fa-cog" aria-hidden="true"></i>'.__('Ignore','wp-ada-compliance').'</a>';
		}
		echo '<span class="wp-ada-ignore-options wp-ada-ignore-options'.esc_attr($row['id']).'">';
		
		if($row['ignre'] == 0){		
			// ignore this instance
		echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&wpada_ignore='.esc_attr($row['id']).'&sort='.esc_attr($sort).'&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle));
		if(isset($_GET['iframe'])) echo '&iframe=1';
		echo '" title="'.__('Ignore this instance of the error.','wp-ada-compliance').'" id="wpadaignore_'.esc_attr($row['id']).'_'.esc_attr($row['ignre']).'" class="wp_ada_compliance_ignoreerror"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
		_e('This Error','wp-ada-compliance');
		echo '</a><br />';
            	echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&wpada_ignore='.esc_attr($row['id']).'&period=1&sort='.esc_attr($sort).'&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle));
		if(isset($_GET['iframe'])) echo '&iframe=1';
		echo '" title="'.__('Ignore this item for 7 days','wp-ada-compliance').'" id="wpadaignore_'.esc_attr($row['id']).'_'.esc_attr($row['ignre'].'_period').'" class="wp_ada_compliance_ignoreerror"><i class="fas fa-forward" aria-hidden="true"></i>';
		_e('Skip','wp-ada-compliance');
		echo '</a><br />';
            
            // ignore related
        if(!wp_ada_compliance_check_if_error_is_excluded($row['errorcode'])){
		echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&ignorerelated=1&wpada_ignore='.esc_attr($row['id']).'&sort='.esc_attr($sort).'&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle));
		if(isset($_GET['iframe'])) echo '&iframe=1';
		echo '" title="'.__('Ignore all errors of this type found in this page.','wp-ada-compliance').'" id="wpadaignore_'.esc_attr($row['id']).'_'.esc_attr($row['ignre']).'" class="wp_ada_compliance_ignorerelated"><i class="fas fa-list" aria-hidden="true"></i>';
		_e('In This Page','wp-ada-compliance');
		echo '</a><br />';
        }
		}
		elseif($row['ignre'] == 1){
		echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&wpada_ignore='.($row['id']).'&sort='.esc_attr($sort).'&canxignore=1&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle));
		if(isset($_GET['iframe'])) echo '&iframe=1';
		echo'" title="'.__('Remove ignore from this error instance.','wp-ada-compliance').'"  id="wpadaignore_'.esc_attr($row['id']).'_'.esc_attr($row['ignre']).'" class="wp_ada_compliance_ignoreerror"><i class="fas fa-times-circle"></i>';
		_e('This Error','wp-ada-compliance');
		echo '</a><br />';
            // related
         if(!wp_ada_compliance_check_if_error_is_excluded($row['errorcode'])){   
        echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&canxignorerelated=1&wpada_ignore='.esc_attr($row['id']).'&sort='.esc_attr($sort).'&view='.esc_attr($view).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle));
		if(isset($_GET['iframe'])) echo '&iframe=1';
		echo '" title="'.__('Remove ignore from all errors of this type found in this page.','wp-ada-compliance').'" id="wpadaignore_'.esc_attr($row['id']).'_'.esc_attr($row['ignre']).'" class="wp_ada_compliance_ignorerelated removeignore"><i class="fas fa-times-circle"></i>';
		_e('In This Page','wp-ada-compliance');
		echo '</a><br />';
         }
		}
		if($row['ignre'] == 0 and !isset($_GET['iframe']) and wp_ada_compliance_check_object_code($row['object'], $row['errorcode'], 1) ){ // hide in iframe	
			// ignore all 
			if(!wp_ada_compliance_check_if_error_is_excluded($row['errorcode'])){
		echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&ignoreall=1&wpada_ignore='.esc_attr($row['id']).'&sort='.esc_attr($sort).'&view='.esc_attr($view).'&errorcode='.esc_attr($row['errorcode']).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'" title="'.__('Ignore this issue and all errors that appear to be duplicates of it.','wp-ada-compliance').'" id="wpadaignoreall-'.esc_attr($row['id']).'-'.esc_attr($row['errorcode']).'-'.md5($row['object']).'" class="wp_ada_compliance_ignoreerrorall dup'.esc_attr($row['errorcode']).'-'.md5($row['object']).' addignore"> <i class="far fa-clone" aria-hidden="true"></i>';
	_e('Duplicates','wp-ada-compliance');
	echo '</a><br />';
		}
		}
		elseif($row['ignre'] == 1 and wp_ada_compliance_check_object_code($row['object'], $row['errorcode'], 0)){
		    if(!wp_ada_compliance_check_if_error_is_excluded($row['errorcode'])){
			echo' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&wpada_ignore='.esc_attr($row['id']).'&sort='.esc_attr($sort).'&canxall=1&view='.esc_attr($view).'&errorcode='.esc_attr($row['errorcode']).'&type='.esc_attr($type).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle));
		if(isset($_GET['iframe'])) echo '&iframe=1';
		echo'" title="'.__('Remove ignore from this error and all errors that appear to be duplicates of it.','wp-ada-compliance').'" id="wpadaignoreall-'.esc_attr($row['id']).'-'.esc_attr($row['errorcode']).'-'.md5($row['object']).'" class="wp_ada_compliance_ignoreerrorall dup'.esc_attr($row['errorcode']).'-'.md5($row['object']).' removeignore"><i class="fas fa-times-circle"></i>';
		_e('Duplicates','wp-ada-compliance');
		echo '</a><br />';
		    }
			}	
			
	
		if (current_user_can($settingsuser) ){ 
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&wpada_ignore_rule='.esc_attr($row['errorcode']).'&type='.esc_attr($type).'&view='.esc_attr($view).'&sort='.esc_attr($sort).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&modifieddate='.esc_attr($moddate).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'" title="'.__('Remove this error type from the results as well as all future scans.','wp-ada-compliance').'" id="wpadaignorerule|'.esc_attr($row['id']).'|'.esc_attr($row['errorcode']).'" class="wp_ada_compliance_ignorerule"><i class="fas fa-tasks" aria-hidden="true"></i>';
		_e('This Rule','wp-ada-compliance');
		echo '</a><br />'; 
		
		// ignore all other files
      
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&wpada_ignore_post='.esc_attr($row['postid']).'&scantype='.esc_attr(str_replace(" ", "",$row['scantype'])).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($type).'&view='.esc_attr($view).'&sort='.esc_attr($sort).'&error='.esc_attr($error).'&errorid='.esc_attr($errorid).'&searchtitle='.stripslashes(esc_attr($searchtitle)).'&modifieddate='.esc_attr($moddate).'&excludedups='.esc_attr($excludedups).'&excludethemes='.esc_attr($excludethemes).'&id='.esc_attr($row['id']).'" title="'.__('Remove this item from the results and future scans.','wp-ada-compliance').'" class="wp_ada_compliance_ignorefile" id="wpadaignorefile|'.esc_attr($row['postid']).'|'.str_replace(array(' ','.',':'),'',esc_attr(str_replace(" ", "",$row['scantype']))).'|'.esc_attr($row['type']).'|'.esc_attr($row['id']).'"><i class="far fa-file" aria-hidden="true"></i>';
		_e('This File','wp-ada-compliance');
		echo '</a><br />';	
           
		}		
		echo '</span>';
			echo '</div>';
		
		// display edit options
		if(!isset($_GET['iframe'])){ // hide in iframe	
	
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&scansingle=1&errorid='.esc_attr($row['id']).'&sort='.esc_attr($sort).'&type='.esc_attr($row['type']).'&taxonomy='.esc_attr($row['taxonomy']).'&postid='.esc_attr($row['postid']).'&view='.esc_attr($view).'&modifieddate='.esc_attr($moddate).'&searchtitle='.esc_attr($row['postid']).'" class="wp_ada_compliance_recheck" id="'.esc_attr($row['type']).'|'.esc_attr($row['id']).'|'.esc_attr($row['postid']).'|'.esc_attr($row['taxonomy']).'"><i class="fas fa-sync-alt" aria-hidden="true"></i>';
		_e('Recheck','wp-ada-compliance');
		echo '</a>'; 
       
             
			echo '<br />';
			
		if($row['type'] == "widget") {
		echo '<a href="widgets.php" target="_blank" class="adaNewWindowInfo"><i class="far fa-edit" aria-hidden="true"></i>';
		_e('Edit','wp-ada-compliance');
				echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>'; 	
			echo '<br />';
		}
		elseif($row['type'] == "term") {
		echo '<a href="term.php?taxonomy='.esc_attr($row['taxonomy']).'&tag_ID='.esc_attr($row['postid']).'" target="_blank" class="adaNewWindowInfo"><i class="far fa-edit" aria-hidden="true"></i>';
		_e('Edit','wp-ada-compliance');
		echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>'; 
			echo '<br />';
		}
		elseif($row['type'] != "theme" and $row['type'] != "css" and $row['type'] != "term" and $row['type'] != "link" and $row['type'] != "pdf") {	
		echo '<a href="post.php?post='.esc_attr($row['postid']).'&action=edit"  target="_blank" class="adaNewWindowInfo"><i class="far fa-edit" aria-hidden="true" ></i>';
		_e('Edit','wp-ada-compliance');
		echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
			echo '<br />';
		}
      elseif($row['type'] == "pdf") {	
          if($pdfattachmentid = attachment_url_to_postid(wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type']) )){
		echo '<a href="post.php?post='.esc_attr($pdfattachmentid).'&action=edit"  target="_blank" class="adaNewWindowInfo"><i class="far fa-edit" aria-hidden="true" ></i>';
		_e('Edit','wp-ada-compliance');
		echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
			echo '<br />';
          }
		}
			
		// display view options
		
		if($row['type'] == "term" and wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])) {
			echo '<a href="'.esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])).'" target="_blank"><i class="fas fa-eye" aria-hidden="true" ></i>';
			_e('View','wp-ada-compliance');
			echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
            echo '<br />';
                       
			
		}

		elseif($row['type'] == "theme") {	
          
			echo '<a href="'.esc_url(wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type'], $row['scantype'])).'" target="_blank" class="adaNewWindowInfo"><i class="fas fa-eye" aria-hidden="true" ></i>';
		_e('View','wp-ada-compliance');
		echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';	
			echo '<br />';
            
                   
		}	
		elseif($row['type'] == "link" or $row['type'] == "pdf" or $row['type'] == "css" or $row['type'] == "iframe") {	
			echo '<a href="'.esc_url(wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type'])).'" target="_blank" class="adaNewWindowInfo"><i class="fas fa-eye" aria-hidden="true" ></i>';
		_e('View','wp-ada-compliance');
		echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';	
			echo '<br />';
            
   
            
		}	
	
		elseif($row['type'] != "widget" and $row['type'] != "theme" and $row['type'] != "term") {
		echo '<a href="'.esc_url(get_permalink($row['postid'])).'" target="_blank" class="adaNewWindowInfo"><i class="fas fa-eye" aria-hidden="true" ></i>';
		_e('View','wp-ada-compliance');
		echo ' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
			echo '<br />';
           
		}
		}
	
		echo '</td>';
		echo '</tr>';
	}
		echo '</table></div>';

		if(isset($pagination)){
			echo $pagination;
			if($view != 2) echo '<p style="text-align:center; display:none;" class="adaloadmore"><a href="" class="btnwpada btnwpada-primary">Load More</a></p>';
		}
		
		echo '<p class="wp_ada_error_key">';
		echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i> ';
		_e('ALERTS - issues that MAY BE corrected to improve web accessibility, enhance a user\'s experience or avoid the possibility of inaccessible content inadvertently being introduced into a website.','wp-ada-compliance');	
				echo '<br /><br />';
		echo '<i class="fas fa-ban" aria-hidden="true"></i> ';
		_e('WARNINGS - issues that MUST BE corrected to ensure compliance with Section 508 or WCAG 2.1 LEVEL A/AA Web Accessibility Standards and ensure content is accessible to users with disabilities. ','wp-ada-compliance');	
	echo '<br /><br /><span class="adaBoldText adadisclaimer">';
		echo __('The WP ADA Compliance Plugin should be used along with the WAVE Web Accessibility Evaluation Tool and/or others tools to ensure complete compliance. Review of WC3 standards and some manual verification is required to ensure compliance.','wp-ada-compliance');
		
		echo ' <a href="https://www.alumnionlineservices.com/docs/getting-started/will-the-wp-ada-compliance-plugin-make-my-website-completely-compliant/">';
		echo __('Learn more about how to reach full compliance.','wp-ada-compliance');
		echo '</a></span>';

		echo '</p>';
		echo '</div>';
}
	}		
	
	if(!$results){
		echo '<div class="adaoldmessage wp_ada_compliance_scanstatus">';
	if(isset($_GET['startscan']) or isset($_GET['scansingle'])) {
			_e('No issues were found!','wp-ada-compliance');	
		}
	else{	
		_e('Click "START SCAN" to begin - Please be patient while the scan completes. Enable automatic scans to complete the scan process over a few hours or days and continually monitor your website content.','wp-ada-compliance');
	
	}
        echo '</div>';
		// dispaly additional checks links
        echo '<div class="adaoldmessage wp_ada_compliance_scanstatus">';
		echo '<p class="adaBoldText">';
		echo __('The WP ADA Compliance Plugin should be used along with the WAVE Web Accessibility Evaluation Tool and/or others tools to ensure complete compliance. Review of WC3 standards and some manual verification is required to ensure compliance.','wp-ada-compliance');
		
		echo ' <a href="https://www.alumnionlineservices.com/docs/getting-started/will-the-wp-ada-compliance-plugin-make-my-website-completely-compliant/">';
		echo __('Learn more about how to reach full compliance.','wp-ada-compliance');
		echo '</a>';
		echo '</p>';
		echo '</div>';
	}
    }// end enforce license
			// stop header sent warnings
		if (isset($_GET['_wpnonce'])) exit;
}

/********************************************
// create guidelines reference page
***********************************************/
function wp_ada_compliance_referencereport_page() {
global $wp_ada_compliance_def, $wp_ada_compliance_manual_def;
	// check cap allowed to edit settings
$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');	
	
	echo '<div class="adaReferenceReport">';
	echo '<h2>'.__('ADA Compliance Guidelines Reference', 'wp-ada-compliance').'</h2>';	
	
			echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php" class="btnwpada btnwpada-primary"><i class="fas fa-file-alt" aria-hidden="true"></i> ';
	_e('View Report', 'wp-ada-compliance');
	echo '</a> ';
	
	if (current_user_can( $settingsuser ) ){ 
		echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin" class="btnwpada btnwpada-primary"><i class="fas fa-cog" aria-hidden="true"></i> ';
	_e('Settings', 'wp-ada-compliance');
	echo '</a> ';
	}
	
	echo '<a href="#" class="btnwpada btnwpada-primary" onclick="javascript:window.print(); return false;"><i class="fas fa-print" aria-hidden="true"></i> '.__('Print', 'wp-ada-compliance').'</a>';

echo '<p class="wp_ada_error_key">';
	echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i> ';
		_e('ALERTS - issues that MAY BE corrected to improve web accessibility, enhance a user\'s experience or avoid the possibility of inaccessible content inadvertently being introduced into a website.','wp-ada-compliance');	
				echo '<br /><br />';
		echo '<i class="fas fa-ban" aria-hidden="true"></i> ';
		_e('WARNINGS - issues that MUST BE corrected to ensure compliance with Section 508 or WCAG 2.1 LEVEL A/AA Web Accessibility Standards and ensure content is accessible to users with disabilities. ','wp-ada-compliance');	


		echo '</p>';
	echo '<a id="adascrollbutton" aria-label="Top"><i class="fas fa-chevron-up"></i></a>';
	
if(is_array($wp_ada_compliance_def) and !isset($_GET['manual_checks'])){
		echo '<h3 class="reports_subheader">'.__('Automated Checks', 'wp-ada-compliance').'</h3>';
	echo '<p class="adaBoldText">'.__('Automated checks are checks done automatically by the WP ADA Compliance plugin. You will be prompted to correct these issues as they are identified and they will be included in the error report. Visit the linked reference to learn more about the requirement or choose HELP for information on how to correct an issue.', 'wp-ada-compliance').'</p>';	
	
foreach ($wp_ada_compliance_def as $rows => $row){	
	
	echo '<div class="adaReference">';
	if(strstr($row['DisplayError'],"WARNING")) echo '<i class="fas fa-ban" aria-hidden="true"></i>';
		elseif(strstr($row['DisplayError'],"ALERT")) echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i>';
   	echo esc_html($row['StoredError']);
	if($row['Reference'] != "") echo ' <a href="'.esc_url($row['ReferenceURL']).'" target="_blank" class="adaNewWindowInfo">'.esc_attr($row['Reference']).' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
	echo '<a href="#" class="adaHelpLink viewHelp adaHelpLinkToggle"><i class="fas fa-question-circle" aria-hidden="true"></i> '.__('HELP', 'wp-ada-compliance').' </i></a>';
	echo '<div class="adaHelpText helptext' . esc_attr($rows) . '">'.$row['HelpINSTR']; // don't esc this it will break help instructions
	if($row['HelpURL'] != "") echo ' <a href="'.esc_url($row['HelpURL']).'" target="_blank" class="adaViewbar adaNewWindowInfo">'.__('More Help', 'wp-ada-compliance').' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
	echo '</div>';
	echo '</div>';
	
}
}
	// manual checks
if(is_array($wp_ada_compliance_manual_def)){
echo '<h3 class="reports_subheader">'.__('Manual Checks', 'wp-ada-compliance').'</h3>';
echo '<p class="adaBoldText">'.__('Manual checks are checks that can not be completed automatically. Visit the linked reference to learn more about the requirement or choose Read More for a complete description and information on how to correct the issue.', 'wp-ada-compliance').'</p>';	
	
foreach ($wp_ada_compliance_manual_def as $rowmanuals => $rowmanual){	
	echo '<div class="adaReference">';
    if(substr($rowmanual['DisplayError'], 0, 1) === 'F')  echo '<i class="fas fa-ban" aria-hidden="true"></i>';
    else echo '<i class="fas fa-exclamation-circle" aria-hidden="true"></i>';
	echo esc_html($rowmanual['DisplayError']);
	if($rowmanual['Reference'] != "") echo ' <a href="'.esc_url($rowmanual['ReferenceURL']).'" target="_blank" class="adaNewWindowInfo">'.esc_attr($rowmanual['Reference']).' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
	if($rowmanual['ReadMore'] != "") echo ' <a href="'.esc_url($rowmanual['ReadMore']).'" target="_blank" class="adaViewbar adaNewWindowInfo">'.__('Read More', 'wp-ada-compliance').' <i class="fas fa-external-link-alt" aria-hidden="true"><span class="wp_ada_hidden">'.__('opens in a new window', 'wp-ada-compliance').'</span></i></a>';
	echo '</div>';	
	
	
}
}

echo '</div>';
}

/*********************************************
REPORT PAGE SUPPORT FUNCTIONS
********************************************/
/*********************************************
create filter drop downs
********************************************/
function wp_ada_compliance_dropdown_builder($excludedups, $excludethemes, $moddate, $view, $error, $type, $searchtitle, $showresults, $sort, $scaninprogress=0){
global $wpdb;
    
    
$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	
$dropdownlists= '<form name="filtererrors" class="wp_ada_form wpa-control-button" ';
     if($scaninprogress == 1) $dropdownlists .=' style="display:none;"';
    $dropdownlists .= 'action="'.esc_url(get_site_url()).'/wp-admin/admin.php" method="get"><input type="hidden" name="page" value="ada_compliance/compliancereport.php" />
<input type="hidden" name="sort" value="'.esc_attr($sort).'" />';
	
// display view by
$dropdownlists .= '<label for="view" class="wp_ada_label">'.__('View: ', 'wp-ada-compliance').'<select name="view" id="view">';
$dropdownlists.= '<option value="2"';
if($view == '2') $dropdownlists.= ' selected';
$dropdownlists .='>'.__('All','wp-ada-compliance').'</option>';	
    if($report_filtered_errors != 'false'){
$dropdownlists.= '<option value="4"';
if($view == '4') $dropdownlists.= ' selected';
$dropdownlists .='>'.__('Auto Corrected','wp-ada-compliance').'</option>';	
}
$dropdownlists.= '<option value="3"';
if($view == '3') $dropdownlists.= ' selected';
$dropdownlists .='>'.__('Ignored','wp-ada-compliance').'</option>';	
	$dropdownlists.= '<option value="1"';
if($view == '1') $dropdownlists.= ' selected';
$dropdownlists .='>'.__('Current','wp-ada-compliance').'</option>';	
$dropdownlists.= "</select></label>";	
	
// filter by error code
$query = "SELECT distinct(errorcode) FROM ".$wpdb->prefix."wp_ada_compliance order by errorcode";
$results = $wpdb->get_results($query, ARRAY_A ); 	
$dropdownlists .= '<label for="errortype" class="wp_ada_label">'.__('Error Type: ', 'wp-ada-compliance').'<select name="errorw" id="errortype">';
$dropdownlists.= '<option value="">'.__('Any','wp-ada-compliance').'</option>';	
$dropdownlists.= '<option value="A" ';
if($error == 'A') $dropdownlists.= ' selected';
$dropdownlists .= '>'.__('ALL ALERTS','wp-ada-compliance').'</option>'; 	   
$dropdownlists.= '<option value="W" ';
if($error == 'W') $dropdownlists.= ' selected';
$dropdownlists .= '>'.__('ALL WARNINGS','wp-ada-compliance').'</option>';  
    
foreach ( $results as $row ) {
$dropdownlists.= '<option value="'.esc_attr($row['errorcode']).'"';
if($error == $row['errorcode']) $dropdownlists.= ' selected';
$dropdownlists.= '>'.esc_attr__(str_replace("_", " ", $row['errorcode']),'wp-ada-compliance').'</option>';
}
$dropdownlists.= "</select></label>";
	
// filter by post type	
$query = "SELECT distinct(type) FROM ".$wpdb->prefix."wp_ada_compliance ";
$results = $wpdb->get_results($query, ARRAY_A );
$dropdownlists .= '<label for="posttype" class="wp_ada_label">'.__('Post Type: ', 'wp-ada-compliance').'<select name="type" id="posttype">';
$dropdownlists.= '<option value="">'.__('Any','wp-ada-compliance').'</option>';
foreach ( $results as $row ) {
$dropdownlists.= '<option value="'.esc_attr($row['type']).'"';
if($type == $row['type']) $dropdownlists.= ' selected';
$dropdownlists.= '>'.esc_attr__($row['type'],'wp-ada-compliance').'</option>';
	if($row['type'] == 'theme') $themefound=1;
}
if(!isset($themefound)){
$dropdownlists.= '<option value="theme"';
if($type == 'theme') $dropdownlists.= ' selected';
$dropdownlists.= '>theme</option>';		
}
$dropdownlists.= '<option value="customfield"';
if($type == 'customfield') $dropdownlists.= ' selected';
$dropdownlists .= '>'.__('custom field','wp-ada-compliance').'</option>';
$dropdownlists.= '<option value="excerpt"';
if($type == 'excerpt') $dropdownlists.= ' selected';
$dropdownlists .= '>'.__('post excerpt','wp-ada-compliance').'</option>';	 
$dropdownlists.= '</select></label> ';
$dropdownlists.= '<label for="searchtitle" class="wp_ada_label">';
$dropdownlists.= __('Search: ','wp-ada-compliance');
$dropdownlists.= '<input size="20" type="text" name="searchtitle" id="searchtitle" value="';
$dropdownlists.= stripslashes(esc_attr($searchtitle));	
$dropdownlists.= '" title="'.__('Title, ID or Link', 'wp-ada-compliance').'" placeholder="'.__('Title, ID or Link', 'wp-ada-compliance').'" onfocus="this.value=\'\'"></label>';
  $dropdownlists.= '</p><p>';


// sort list
$dropdownlists.= '<label for="sort" class="wp_ada_label">'.__('Sort by: ','wp-ada-compliance').' <select id="sort" name="sort">
';
$dropdownlists.= '<option value="1"';
if($sort == 1) $dropdownlists.= ' selected';	
$dropdownlists.= '>';
$dropdownlists.= __('Date', 'wp-ada-compliance');
$dropdownlists.= '</option>';
$dropdownlists.= '<option value="2"';
if($sort == 2) $dropdownlists.= ' selected';	
$dropdownlists.= '>';
$dropdownlists.= __('Content Type', 'wp-ada-compliance');
$dropdownlists.= '</option>';
$dropdownlists.= '<option value="3"';
if($sort == 3) $dropdownlists.= ' selected';	
$dropdownlists.= '>';
$dropdownlists.= __('Error Type', 'wp-ada-compliance');
$dropdownlists.= '</option>';
$dropdownlists.= '<option value="4"';
if($sort == 4) $dropdownlists.= ' selected';	
$dropdownlists.= '>';
$dropdownlists.= __('Error State (ignore, current, etc)', 'wp-ada-compliance');
$dropdownlists.= '</option>';	
$dropdownlists.= ' <option value="5"';
if($sort == 5) $dropdownlists.= ' selected';	
$dropdownlists.= '>';
$dropdownlists.= __('Title', 'wp-ada-compliance');
$dropdownlists.= '</option>';	
	$dropdownlists.= ' <option value="6"';
if($sort == 6) $dropdownlists.= ' selected';	
$dropdownlists.= '>';
$dropdownlists.= __('Themes Last', 'wp-ada-compliance');
$dropdownlists.= '</option>';	
$dropdownlists.= '</select></label>';
    
    // date range
$dropdownlists.= '<label for="modifieddate" class="wp_ada_label">';
$dropdownlists.= __('Modified Date: ','wp-ada-compliance');
$dropdownlists.= '<input size="10" type="date" name="modifieddate" id="modifieddate" value="';
$dropdownlists.= $moddate;	
$dropdownlists.= '" title="'.__('If date is entered, only errors in pages modified after this date will be displayed.', 'wp-ada-compliance').'"></label>';        

// if deep scan is enabled allow filtering of themes and duplicates

$scan_themes = get_option('wp_ada_compliance_scan_themes',array('Blog Home',"404 Page","Search Page"));

$dropdownlists .='<p class="wp-ada-compliance-filters">
<label for="excludethemes" class="wp_ada_label"><input type="checkbox" name="excludethemes" id="excludethemes" value="1" ';
if($excludethemes == '1') $dropdownlists .= ' checked ';
$dropdownlists.= ' >'.__('hide theme errors', 'wp-ada-compliance').'<a href="#TB_inline?width=600&height=200&inlineId=wp-ada-help-themes" class="thickbox wp-ada-help-icon-small" name="'.__('What does this option do?','wp-ada-compliance').'" aria-label="'.__('HELP', 'wp-ada-compliance').'"><i class="fas fa-question-circle"></i></a></label>



<label for="excludedups" class="wp_ada_label"><input type="checkbox" name="excludedups" id="excludedups" value="1" ';
if($excludedups == '1') $dropdownlists .= ' checked ';	
$dropdownlists.= '>'.__('hide duplicates', 'wp-ada-compliance').'<a name="'.__('What does this option do?','wp-ada-compliance').'" href="#TB_inline?width=600&height=200&inlineId=wp-ada-help-dups" class="thickbox wp-ada-help-icon-small" aria-label="'.__('HELP', 'wp-ada-compliance').'"><i class="fas fa-question-circle"></i></a></label>

</p>';	
    	
	// submit	
$dropdownlists.= '<input type="submit" value="'.__('Filter', 'wp-ada-compliance').'" class=" wp_ada_label btnwpada btnwpada-primary filterbtn" /> <button id="wpadasavesearch" class=" btnwpada btnwpada-primary filterbtn" title="'.__('Create a Bookmark', 'wp-ada-compliance').'"><i class="far fa-save" aria-hidden="true"></i> Save</button>';


 $dropdownlists.= ' <a href="#TB_inline?width=600&height=550&inlineId=wp-ada-help" name="'.__('How to use this screen?','wp-ada-compliance').'" class="thickbox btnwpada btnwpada-primary wp-ada-help-icon"><i class="fas fa-question-circle"></i> '.__('HELP', 'wp-ada-compliance').'</a>';	


	// display filter message
if(isset($showresults)){
$dropdownlists .='<p class="adashowingmessage">';

$dropdownlists .=__('Filters: ', 'wp-ada-compliance');
$dropdownlists .= sprintf(__('%s', 'wp-ada-compliance'), esc_attr($showresults));
$dropdownlists .='</p>';	
$dropdownlists.= wp_ada_compliance_display_progress_stats();
	}	
	
$dropdownlists .='</form>';		
return $dropdownlists;	
}
/***************************************************
create error stats from report or dashboard request
**************************************************/
function wp_ada_compliance_report_error_summary($view, $type, $error, $searchtitle, $errorid, $excludethemes, $excludedups, $moddate){
global $wpdb;
    
    //wp_ada_compliance_set_php_ini_Settings(1);
	
$queryVariables = array();
 // search links
if(strstr($searchtitle,'/')){
$linkquery = 'left join '.$wpdb->prefix.'wp_ada_compliance_links on '.$wpdb->prefix.'wp_ada_compliance_links.postid = '.$wpdb->prefix.'wp_ada_compliance.postid'; 
} else $linkquery = '';    
    
$query = "SELECT count(DISTINCT ".$wpdb->prefix."wp_ada_compliance.id) as total  FROM ".$wpdb->prefix."wp_ada_compliance $linkquery where %d";
$queryVariables[] = 1;	
$totalquery ='';	
    
// hide if auto filter is turned off
$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
if($report_filtered_errors == 'false') $totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre != 2 '; 	    
	
if( $view == 1 ) { // current
$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d';
$queryVariables[] = 0;
}
if ( $view == 3 ) { // ignored
$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d';
$queryVariables[] = 1;
}
    
    if ( $view == 4 ) { // ignored
$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d';
$queryVariables[] = 2;
}

if ( $type != '' ) { // filter by post type
if ( $type == 'theme' ){
$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
$queryVariables[] = $type;
}
elseif ( $type == 'customfield' ){
$totalquery .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
$queryVariables[] = "%** custom field%";
}
elseif ( $type == 'excerpt' ){
$totalquery .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
$queryVariables[] = "%** post excerpt%";
}
elseif($type == 'attachment'){
$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
$queryVariables[] = 'attachment';
$queryVariables[] = 'pdf';
}
else{
$totalquery .= '  and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
$queryVariables[] = $type;
}
}
if ( $error != '' ) { // filter by error code
if($error == 'W' or $error == 'A')
$totalquery .= " and severity = %s "; 	    
else $totalquery .= " and errorcode = %s";
$queryVariables[] = $error;
}
if ( $searchtitle != '' ) { // filter by error code	
 if($linkquery != ''){
$totalquery .= " and link LIKE %s";
$queryVariables[] = '%'.$searchtitle.'%';
}else{    
$totalquery .= ' and '.$wpdb->prefix.'wp_ada_compliance.posttitle LIKE %s';		
$queryVariables[] = '%'.$searchtitle.'%';
 }
}
if ($type == 'attachment' and $errorid != '' and $errorid != 0 ) { // filter by error code	
$totalquery .= " and (postid = %d or attachmentid = %d )";
$queryVariables[] = $errorid;
$queryVariables[] = $errorid;    
}	
elseif ( $errorid != '' and $errorid != 0 ) { // filter by error code	
$totalquery .= " and postid = %d ";
$queryVariables[] = $errorid;
}	
	
if ($excludethemes == 1) { // remove theme errors
$totalquery .= '  and (themeerror = %d )';
$queryVariables[] = 0;

}	
    
if ( $moddate != '' ) { // filter by modified date
$totalquery .= " and (modifieddate >= %s or modifieddate = %s)";
$queryVariables[] = $moddate;
    $queryVariables[] = '0000-00-00 00:00:00';
}
 
$query.=$totalquery;
	
if ($excludedups == 1) { // remove duplicates
	$query .= " GROUP BY errorcode, object  ";
}

return wp_ada_compliance_error_summary($query,$queryVariables,$view, $type, $error, $searchtitle, $errorid, $excludethemes, $excludedups,$totalquery, $moddate);	
}


/*********************************************
create error summary
********************************************/
function wp_ada_compliance_error_summary($query,$queryVariables,$view, $type, $error, $searchtitle, $errorid, $excludethemes, $excludedups, $totalquery){
global $wpdb;

$results = $wpdb->get_results($wpdb->prepare($query, $queryVariables),ARRAY_A);	
$total = 0;
    
$summary = '';
if($excludedups == 1){
   $total = count($results);	 
}
else{
foreach ( $results as $row ) {
$total = $row['total'];	
}
}

$summary .= wp_ada_compliance_dashboard_summary();
$summary .= '<div class="wp_ada_summary_right">';
$summary .= '<h2 class="wp_ada_summary_header">'; 
$summary .= __('Issue Summary','wp-ada-compliance');	
$summary .= '</h2>'; 	
$summary .= '<p class="wp_ada_issue_sum">';
$summary .= '<span class="adaViewbar">';
$summary .=__('total issues: ', 'wp-ada-compliance');
$summary .= '</span>';
$summary .= esc_html($total);
$summary .= '</p>';
if($total == 0 ) {

		
	// dispaly additional checks links
    if(!isset($_GET['wp-ada-report'])){
		$summary .= '<br /><p class="ada_manual_checks_prompt">';
		$summary .= __('Click "Crawl & Scan" to locate issues on your website. After correcting the reported issues, ','wp-ada-compliance');
		$summary .= ' <a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance%2Fcompliancereferencereport.php&manual_checks=1">';
		$summary .= __(' complete the list of manual checks, ','wp-ada-compliance');
		$summary .= '</a>';
		$summary .= __(' use the ','wp-ada-compliance');
		$summary .= '<a href="'.esc_url_raw('http://wave.webaim.org/report#/'.get_site_url()).'">';
		$summary .= __(' WAVE evaluation tool, ','wp-ada-compliance');
		$summary .= '</a>';
		$summary .= __('a broken link checker, HTML validator and the NVDA screen reader to ensure compliance. ','wp-ada-compliance');
    		$summary .= '<a href="https://www.alumnionlineservices.com/docs/getting-started/will-the-wp-ada-compliance-plugin-make-my-website-completely-compliant/">';
		$summary .= __('Learn more about how to reach full compliance.','wp-ada-compliance');
		$summary .= '</a>';
		//$summary .= '</p>';
    }
}	
	

if ( $error == '' or $error == 'A' or $error == 'W' ) {	
$query = "SELECT distinct(errorcode) FROM ".$wpdb->prefix."wp_ada_compliance ";
$results = $wpdb->get_results($query, ARRAY_A );	

foreach ( $results as $row ) {
$summary .= '<p class="wp_ada_issue_sum">';	
$summary .= wp_ada_compliance_error_count($row['errorcode'], $totalquery, $queryVariables, $excludedups);
$summary .= '</p>';
}
}
$summary .= '</div>';	
	
return $summary;	
}
/*********************************************
count errors
********************************************/
function wp_ada_compliance_error_count($errorcode, $totalquery, $queryVariables, $excludedups){
global $wpdb;
    
 // search links
if(strstr($totalquery,'link LIKE')){
$linkquery = 'left join '.$wpdb->prefix.'wp_ada_compliance_links on '.$wpdb->prefix.'wp_ada_compliance_links.postid = '.$wpdb->prefix.'wp_ada_compliance.postid'; 
} else $linkquery = '';     
    
$query = "SELECT * FROM ".$wpdb->prefix."wp_ada_compliance $linkquery where %d ";
    
$query.=$totalquery;	
	
$query .= " and errorcode = %s ";
$queryVariables[] = $errorcode;	
	
if ($excludedups == 1) { // remove duplicates
	 $query .= " GROUP BY object  ";
}	

$results = $wpdb->get_results( $wpdb->prepare( $query, $queryVariables), ARRAY_A );	

$total = count($results);	
	
foreach ( $results as $row ) {
return '<span class="adaViewbar">'.str_replace("_", " ", esc_attr($errorcode)).':</span> '.esc_attr($total).'<br />';
}
}
/********************************************
format summary report results
********************************************/
function wp_ada_compliance_format_summary_results($results, $postinfo){
    global $wp_ada_compliance_def;
    $report = '';
    $errorcode = '';
    

    foreach ( $results as $row ) {
        if($errorcode != $row['errorcode']) {
        $errorcode = $row['errorcode'];
        
        $report .= '<h3 style="clear:both; ">'.str_replace('_',' ',esc_attr($errorcode));
        $report .= ': '.esc_attr(wp_ada_compliance_count_array_values($results, $errorcode));
        $report .= '</h3>';
        $report .= '<p style="border-left: 2px dotted maroon; padding-left: 10px;">';
  
        if(strstr($wp_ada_compliance_def[$errorcode]['DisplayError'], __('ALERT', 'wp-ada-compliance'))) $report .=  __('ALERT: ', 'wp-ada-compliance');
        if(strstr($wp_ada_compliance_def[$errorcode]['DisplayError'], __('WARNING', 'wp-ada-compliance'))) $report .=  __('WARNING: ', 'wp-ada-compliance');
        
	
        $report .= esc_html($wp_ada_compliance_def[$errorcode]['StoredError']);
        
         $report .= ' <a href="'.esc_url($wp_ada_compliance_def[$errorcode]['ReferenceURL']).'" >'.esc_html($wp_ada_compliance_def[$errorcode]['Reference']).'</a>';
            $report .='</p>';
			if($postinfo['searchtitle'] == '' and ($postinfo['errorid'] == 0 or $postinfo['errorid'] == '')){	
            $report .= '<h4 style="font-size:110%">';
        $report .= __('Affected Pages:','wp-ada-compliance');
         $report .= '</h4>'; 
        $report .= wp_ada_compliance_get_affected_pages($errorcode,$postinfo);
            }
        }
       
        
    }
    return $report;
}
/********************************************
// get affected pages
**********************************************/
function wp_ada_compliance_get_affected_pages($errorcode,$postinfo) {  
    global $wpdb;
 $pages = '';
	if($postinfo['searchtitle'] == '' and $postinfo['errorid'] == ''){
	$query = 'SELECT errorcode, ignre, posttitle, type, postid, taxonomy, scantype, id, locationnotes, themeerror FROM '.$wpdb->prefix.'wp_ada_compliance where errorcode = %s ';
        
        $queryVariablesMain[] = $errorcode;
        
    	if(array_key_exists("view",$postinfo)){	
	if($postinfo['view'] == 1 ) {
		$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
		$queryVariablesMain[] = 0;
		}
    elseif ( $postinfo['view'] == 3 ) { // ignored
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 1;
		}
	}		

        
    if (array_key_exists("type",$postinfo) and  $postinfo['type'] != '' ) { // filter by post type
			if ( $postinfo['type'] == 'theme' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] =$postinfo['type'];
			}
		
			elseif( $postinfo['type'] == 'attachment'){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = 'attachment';
            $queryVariablesMain[] = 'pdf';
			}
          	elseif ( $postinfo['type'] == 'customfield' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** custom field%";
			}
            elseif ( $postinfo['type'] == 'excerpt' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** post excerpt%";
			}
			else{
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = $postinfo['type'];
			}
			}    
        
     if (array_key_exists("excludethemes",$postinfo) and  $postinfo['excludethemes'] != 0 ) { 
		$query .= '  and (themeerror = %d )';
		$queryVariablesMain[] = 0;
	
		}			

if (array_key_exists("modifieddate",$postinfo) and  $postinfo['modifieddate'] !='' ) { // filter by modified date
$query .= " and (modifieddate >= %s or modifieddate = %s)";			
$queryVariablesMain[] =  $postinfo['modifieddate'];
$queryVariablesMain[] = '0000-00-00 00:00:00';    
} 
    
 $query .= 'group by posttitle, type, postid';
        
    $results = $wpdb->get_results( $wpdb->prepare($query, $queryVariablesMain), ARRAY_A );
	}
	elseif($postinfo['searchtitle'] != '') {
	$query = 'SELECT posttitle, type, postid, taxonomy, scantype, id,locationnotes, themeerror FROM '.$wpdb->prefix.'wp_ada_compliance where errorcode = %s and posttitle LIKE %s group by posttitle, type, postid';
    $results = $wpdb->get_results( $wpdb->prepare($query, $errorcode,$postinfo['searchtitle']), ARRAY_A );	
	}
	elseif($postinfo['errorid'] != '') {
	$query = 'SELECT posttitle, type, postid, taxonomy, scantype, id, locationnotes, themeerror FROM '.$wpdb->prefix.'wp_ada_compliance where errorcode = %s and postid = %d group by posttitle, type, postid';
    $results = $wpdb->get_results( $wpdb->prepare($query, $errorcode, $postinfo['errorid']), ARRAY_A );	
	}

	if ( sizeof($results) > 0 ) {	
     foreach ( $results as $row ) {
         if($row['posttitle'] == '') $title= 'UNTITLED';
         else $title = $row['posttitle'];
          $pages .= '<p>'.esc_attr($title).': ';
         $pages .='('.esc_attr($row['type']);
         
     
	   $pages .= strip_tags(wp_ada_compliance_format_error_location($row['ignre'], $row['errorcode'],$row['type'], $row['id'], $row['locationnotes'], $row['themeerror'], 0));
        
		
        $pages .= ') <br />';
         
         // display link
      if($row['type'] == "term") {
			 $pages .= '<a href="'.esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])).'">';
			 $pages .= esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy']));
			 $pages .= '</a>';
		}
		
		elseif($row['type'] == "theme") {	
			 $pages .= '<a href="'.esc_url(wp_ada_compliance_get_url_to_scan($row['scantype'])).'" >';
		 $pages .= esc_url(wp_ada_compliance_get_url_to_scan($row['scantype']));
		 $pages .= '</a>';	
		}	
	
		elseif($row['type'] != "widget" and $row['type'] != "theme") {
		 $pages .= '<a href="'.esc_url(get_permalink($row['postid'])).'">';
		 $pages .= esc_url(get_permalink($row['postid']));
		 $pages .= '</a>';
		}
         $pages .='</p>';
     }
    }

    return $pages; 
} 
/********************************************
// count values
**********************************************/
function wp_ada_compliance_count_array_values($results, $match) 
{ 
    $count = 0; 
     foreach ( $results as $row ) {
    foreach ($row as $key => $value) 
    { 
        if ($value == $match) 
        { 
            $count++; 
        } 
    } 
     }
    
    return $count; 
} 

/********************************************
// create summary report
**********************************************/
function wp_ada_compliance_create_summary_report($postinfo, $type='print') {
global $wpdb, $wp_ada_compliance_def;
	$showresults = "";

     // search links
    if (array_key_exists("searchtitle",$postinfo) and strstr($postinfo['searchtitle'],'/') ) { 
    $linkquery = 'left join '.$wpdb->prefix.'wp_ada_compliance_links on '.$wpdb->prefix.'wp_ada_compliance_links.postid = '.$wpdb->prefix.'wp_ada_compliance.postid'; 
    } else $linkquery = '';
    
	$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance '.$linkquery.' where %d ';
    
    	// hide if auto filter is turned off
	$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	if($report_filtered_errors == 'false') $query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre != 2 '; 
    
		$queryVariablesMain = array();
	$queryVariablesMain[] = 1;
	if(array_key_exists("view",$postinfo)){	
	if($postinfo['view'] == 1 ) {
		$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
		$queryVariablesMain[] = 0;
		$showresults .= __(" View=Current; ",'wp-ada-compliance');
		}
	if($postinfo['view'] == 2 ) {
		$showresults .= __(' View=All; ','wp-ada-compliance');
		}	
    if ( $postinfo['view'] == 3 ) { // ignored
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 1;
			$showresults .= __(" View=Ignored; ",'wp-ada-compliance');

		}
        
        if( $postinfo['view'] == 4 ) { // auto corrected issues
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 2;
		$showresults .= __(" View=Auto Corrected; ",'wp-ada-compliance');
		}


	}	
	if (array_key_exists("errorid",$postinfo) and $postinfo['errorid'] != '' ) { // filter by post type
		 if($postinfo['type'] == 'attachment'){
           $query .= ' and (postid = %d or attachmentid = %d)';
			$queryVariablesMain[] = $postinfo['errorid'];
           $queryVariablesMain[] = $postinfo['errorid'];
       }
        else{
			$query .= ' and postid = %d ';
			$queryVariablesMain[] = $postinfo['errorid'];
        }
		$showresults = __(' View=PostID: ','wp-ada-compliance').$postinfo['errorid'].';';
			
		}
	if (array_key_exists("type",$postinfo) and  $postinfo['type'] != '' ) { // filter by post type
			if ( $postinfo['type'] == 'theme' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] =$postinfo['type'];
			}
		
			elseif( $postinfo['type'] == 'attachment'){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = 'attachment';
            $queryVariablesMain[] = 'pdf';
			}
          	elseif ( $postinfo['type'] == 'customfield' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** custom field%";
			}
            elseif ( $postinfo['type'] == 'excerpt' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** post excerpt%";
			}
			else{
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = $postinfo['type'];
			}
		
			$showresults .= __(' Post type=','wp-ada-compliance').$postinfo['type'].'; ';
			}
	if (array_key_exists("error",$postinfo) and  $postinfo['error'] != '' ) { // filter by error code
		if($postinfo['error'] == 'W' or $postinfo['error'] == 'A')
                $query .= " and severity = %s ";
            else  $query .= " and errorcode = %s ";			
			$queryVariablesMain[] = $postinfo['error'];
			$showresults .=__(' Error type=','wp-ada-compliance').$postinfo['error'].'; ';
		}
		if (array_key_exists("searchtitle",$postinfo) and  $postinfo['searchtitle'] != '' ) { // filter by post title
            if($linkquery != ''){
        $query .= " and link LIKE %s";
        $queryVariablesMain[] = '%'.$postinfo['searchtitle'].'%';
                $showresults .=__(' Link=','wp-ada-compliance').stripslashes($postinfo['searchtitle']).'; ';
        }else{     
			$query .= " and ".$wpdb->prefix."wp_ada_compliance.posttitle LIKE %s ";			
			$queryVariablesMain[] = '%'.$postinfo['searchtitle'].'%';
			$showresults .=__(' Title=','wp-ada-compliance').stripslashes($postinfo['searchtitle']).'; ';
		}
        }
	
	if (array_key_exists("excludethemes",$postinfo) and  $postinfo['excludethemes'] != 0 ) { 
		$query .= '  and (themeerror = %d )';
		$queryVariablesMain[] = 0;
	
		}			

if (array_key_exists("modifieddate",$postinfo) and  $postinfo['modifieddate'] !='' ) { // filter by modified date
$query .= " and (modifieddate >= %s or modifieddate = %s)";			
$queryVariablesMain[] =  $postinfo['modifieddate'];
$queryVariablesMain[] = '0000-00-00 00:00:00';    
 $showresults .=__(' Modified Date=','wp-ada-compliance').$postinfo['modifieddate'].'; ';
} 
    
if (array_key_exists("excludedups",$postinfo) and  $postinfo['excludedups'] != 0 ) { 
// remove duplicates
    $query .= ' GROUP BY object ';
   $showresults .=__(' Excluding: duplicates; ','wp-ada-compliance');
}
	$sortby = 'errorcode asc';
	
	$query .= " order by $sortby ";

	$results = $wpdb->get_results( $wpdb->prepare($query, $queryVariablesMain), ARRAY_A );

	//if ( sizeof($results) > 0 ) {	
         $report = '';
	//$report = '<h2>'.__('Web Accessibility Report', 'wp-ada-compliance').'</h2>';
	 $report .= '<div class="wp_ada_summary">'; 
	$report_summary = get_option('wp_ada_compliance_report_summary','true');
	if($report_summary == 'true'){	
    $report .= wp_ada_compliance_report_error_summary($postinfo['view'], $postinfo['type'], $postinfo['error'], $postinfo['searchtitle'], $postinfo['errorid'], $postinfo['excludethemes'], $postinfo['excludedups'],$postinfo['modifieddate']);    
   $report .= "</div>";
	}
    $report .= wp_ada_compliance_format_summary_results($results, $postinfo);
		
    if($type == 'print') // add styles
	$report.= '
    <style>
    .wp_ada_summary {
     border-bottom: 1px dashed #0073aa;
   
width: 795px;
    
     margin: 0px;
     margin-left: -40px;
	padding-bottom: 20px;
}
.wp_ada_summary_right {
width:465px;
margin-left: 10px;
}
.wp_ada_summary_left {
    float: left;
    width: 330px;
	margin-left: 0px;
}
 ul.wp_ada_summary_left {
list-style:none;
}
.wp_ada_issue_sum {
    float:left;
    width: 233px;
        text-overflow: ellipsis;
overflow: hidden;

	}

    </style>
    ';
    $issuefound = 1;
         
        
        
    
	if(isset($issuefound))	return $report;
	else return "";
}


/********************************************
// create email report
**********************************************/
function wp_ada_compliance_create_email_report($email, $postinfo=0) {
global $wpdb, $wp_ada_compliance_def;
    
    $includeLinkColumn = get_option('wp_ada_compliance_report_include_link_column','false');
    
	$showresults = "";
	if(is_array($postinfo)){
        
             // search links
    if (array_key_exists("searchtitle",$postinfo) and strstr($postinfo['searchtitle'],'/') ) { 
    $linkquery = 'left join '.$wpdb->prefix.'wp_ada_compliance_links on '.$wpdb->prefix.'wp_ada_compliance_links.postid = '.$wpdb->prefix.'wp_ada_compliance.postid'; 
    } else $linkquery = '';
        
        
	$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance '.$linkquery.' where %d ';
        
        	// hide if auto filter is turned off
	$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	if($report_filtered_errors == 'false') $query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre != 2 '; 
		
	$queryVariablesMain[] = 1;
        
	if(array_key_exists("view",$postinfo)){	
	if($postinfo['view'] == 1 ) {
		$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
		$queryVariablesMain[] = 0;
		$showresults .= __(" View=Current; ",'wp-ada-compliance');
		}
	if($postinfo['view'] == 2 ) {
		$showresults .= __(' View=All; ','wp-ada-compliance');
		}	
    if ( $postinfo['view'] == 3 ) { // ignored
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 1;
			$showresults .= __(" View=Ignored; ",'wp-ada-compliance');

		}
        if( $postinfo['view'] == 4 ) { // auto corrected issues
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 2;
		$showresults .= __(" View=Auto Corrected; ",'wp-ada-compliance');
		}

	}		
	if (array_key_exists("errorid",$postinfo) and $postinfo['errorid'] != '' ) { // filter by post type
       if($postinfo['type'] == 'attachment'){
           $query .= ' and (postid = %d or attachmentid = %d)';
			$queryVariablesMain[] = $postinfo['errorid'];
           $queryVariablesMain[] = $postinfo['errorid'];
       }
        else{
			$query .= ' and postid = %d ';
			$queryVariablesMain[] = $postinfo['errorid'];
        }
		$showresults = __(' View=PostID: ','wp-ada-compliance').$postinfo['errorid'].';';
			
		}
	if (array_key_exists("type",$postinfo) and  $postinfo['type'] != '' ) { // filter by post type
			if ( $postinfo['type'] == 'theme' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] =$postinfo['type'];
			}
		
        elseif( $postinfo['type'] == 'attachment'){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = 'attachment';
            $queryVariablesMain[] = 'pdf';
			}
          	elseif ( $postinfo['type'] == 'customfield' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** custom field%";
			}
                     	elseif ( $postinfo['type'] == 'excerpt' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** post excerpt%";
			}
			else{
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = $postinfo['type'];
			}
		
			$showresults .= __(' Post type=','wp-ada-compliance').$postinfo['type'].'; ';
			}
	if (array_key_exists("error",$postinfo) and  $postinfo['error'] != '' ) { // filter by error code
			if($postinfo['error'] == 'W' or $postinfo['error'] == 'A')
                $query .= " and severity = %s ";
            else $query .= " and errorcode = %s ";			
			$queryVariablesMain[] = $postinfo['error'];
			$showresults .=__(' Error type=','wp-ada-compliance').$postinfo['error'].'; ';
		}
		if (array_key_exists("searchtitle",$postinfo) and  $postinfo['searchtitle'] != '' ) { // filter by post title
               if($linkquery != ''){
        $query .= " and link LIKE %s";
        $queryVariablesMain[] = '%'.$postinfo['searchtitle'].'%';
                $showresults .=__(' Link=','wp-ada-compliance').stripslashes($postinfo['searchtitle']).'; ';
        }else{     
			$query .= " and ".$wpdb->prefix."wp_ada_compliance.posttitle LIKE %s ";			
			$queryVariablesMain[] = '%'.$postinfo['searchtitle'].'%';
			$showresults .=__(' Title=','wp-ada-compliance').stripslashes($postinfo['searchtitle']).'; ';
               }
		}	
	
	if (array_key_exists("excludethemes",$postinfo) and  $postinfo['excludethemes'] != 0 ) { 
		$query .= '  and (themeerror = %d )';
		$queryVariablesMain[] = 0;
	    $showresults .=__(' Title=','wp-ada-compliance').stripslashes($postinfo['searchtitle']).'; ';
		}		
	
    	if (array_key_exists("modifieddate",$postinfo) and  $postinfo['modifieddate'] != '' ) { 
		$query .= '  and (modifieddate >= %s or modifieddate = %s)';
		$queryVariablesMain[] = $postinfo['modifieddate'];
            $queryVariablesMain[] = '0000-00-00 00:00:00';
         $showresults .=__(' Modified Date=','wp-ada-compliance').$postinfo['modifieddate'].'; ';
		}	    
        
	if (array_key_exists("excludedups",$postinfo) and  $postinfo['excludedups'] != 0 ) { 
		// remove duplicates
			$query .= ' GROUP BY object ';
		   $showresults .=__(' Excluding: duplicates; ','wp-ada-compliance');
		}	
		
	if (array_key_exists("sort",$postinfo)) {
	if($postinfo['sort'] == 1) $sortby = 'date DESC, '.$wpdb->prefix.'wp_ada_compliance.id DESC ';
	if($postinfo['sort'] == 2) $sortby = $wpdb->prefix.'wp_ada_compliance.type asc';
	if($postinfo['sort'] == 3) $sortby = 'errorcode asc';
	if($postinfo['sort'] == 4) $sortby = $wpdb->prefix.'wp_ada_compliance.ignre desc';
	if($postinfo['sort'] == 5)$sortby = $wpdb->prefix.'wp_ada_compliance.posttitle asc';
	if($postinfo['sort'] == 6)$sortby = 'scantype desc';
	} else $sortby = 'date DESC, '.$wpdb->prefix.'wp_ada_compliance.id DESC ';
	
	$query .= " order by $sortby ";
		
	}
else{
	$notification_frequency = get_option('wp_ada_compliance_notification_frequency','daily');

	
	// create interval based on frequency
	if($notification_frequency == 'monthly') $interval = '30 DAY';	
	if($notification_frequency == 'weekly') $interval = '7 DAY';	
	if($notification_frequency == 'daily') $interval = '1 DAY';	
	if($notification_frequency == 'twicedaily') $interval = '12 HOUR';	
	if($notification_frequency == 'hourly') $interval = '1 HOUR';	

	$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance where %d and ignre = %d ';
	
    	// hide if auto filter is turned off
	$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	if($report_filtered_errors == 'false') $query .= " and ignre != 2 "; 
 
    $send_reminders = get_option('wp_ada_compliance_notification_send_reminders','true');
    if($send_reminders == 'true'){
    $reminderQuery = $query. ' order by date DESC, id DESC  LIMIT 50';
    }
    
	$query .= ' and date >= DATE_SUB(NOW(),INTERVAL '.$interval.') order by date DESC, id DESC ';
    
	$queryVariablesMain[] = 1;
	$queryVariablesMain[] = 0;
	}

	$results = $wpdb->get_results( $wpdb->prepare($query, $queryVariablesMain), ARRAY_A );
    
    // no results so process reminder instead
    if(sizeof($results) == 0) {
       // send reminders
    if(isset($reminderQuery)){
    $results = $wpdb->get_results( $wpdb->prepare($reminderQuery, $queryVariablesMain), ARRAY_A ); 
        $remindersent = 1;
    }
    }

	if ( sizeof($results) > 0 ) {
        $report = '';
    if(isset($remindersent)) $report .= '<p>'.__('You have uncorrected issues on your website: ', 'wp-ada-compliance'). '</p>';
	else if(isset($interval)) $report .= '<p>'.__('This report includes issues identified in the past '.esc_attr($interval).'.', 'wp-ada-compliance'). '</p>';
	elseif($showresults != "") $report .= '<p>'.esc_html($showresults).'</p>';	
    $report .= '<table class="ada_error wp-ada-print-report" border="1"><tr>';
	$report .=  '<th scope="column" >';
	$report .= __('Title', 'wp-ada-compliance');
	$report .=  '</th>';
    if($includeLinkColumn == 'true') {   
	$report .=  '<th scope="column" >';
	$report .= __('Link', 'wp-ada-compliance');
	$report .=  '</th>';
    }
	$report .=  '<th scope="column">';
	$report .= __('Content Type', 'wp-ada-compliance');
	$report .=  '</th>';
	$report .=  '<th scope="column" >';
	$report .= __('Error Type', 'wp-ada-compliance');
	$report .=  '</th>';
        	$report .=  '<th scope="column" >';
	$report .= __('Severity', 'wp-ada-compliance');
	$report .=  '</th>';
	$report .=  '<th scope="column" >';
	$report .= __('Error', 'wp-ada-compliance');
	$report .=  '</th></tr>';

	foreach ( $results as $row ) {
	
	$userid = get_userdata($row['activeuser']);
		
			
	if((is_array($postinfo) and ($email != "" or $email == 'print')) or ($email != "" and $email != $userid->user_email)){	
		$issuefound = 1;
		
		// define title variable
		$title = sprintf(__('%s', 'wp-ada-compliance'), esc_attr($row['posttitle']));

				
	$report .=  '<tr>';
		$report .=  '<td>';
	   
		// display link and title
	if($row['type'] == "term") {
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])).'">';
			$report .= $title;
			$report .= '</a>';
		}
	
		elseif($row['type'] == "theme") {	
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_url_to_scan($row['scantype'])).'" >';
		$report .= $title;
		$report .= '</a>';	
		}	
		elseif($row['type'] == "link" or $row['type'] == "pdf" or $row['type'] == "css" or $row['type'] == "iframe") {	
			 $report .= '<a href="'.esc_url(wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type'])).'">';
            $report .= $title;
             $report .= '</a>';	
		
		}	
		elseif($row['type'] != "widget" and $row['type'] != "theme") {
		$report .= '<a href="'.esc_url(get_permalink($row['postid'])).'">';
		$report .= $title;
		$report .= '</a>';
		}	
		
		if($row['ignre'] == 1) {
			$report .='<br /><span class="adaIgnored">';
			$report .=__('** being ignored', 'wp-ada-compliance');
			$report .= '</span>';
		}
		
		$report .=  '</td>';
         if($includeLinkColumn == 'true') {   
		$report .=  '<td>';
		// display link
if($row['type'] == "term") {
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])).'">';
			$report .= esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy']));
			$report .= '</a>';
		}
	
		elseif($row['type'] == "theme") {	
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_url_to_scan($row['scantype'])).'" >';
		$report .= esc_url(wp_ada_compliance_get_url_to_scan($row['scantype']));
		$report .= '</a>';	
		}	
	       elseif($row['type'] == "link" or $row['type'] == "pdf" or $row['type'] == "iframe" or $row['type'] == "css") {	
            $linkurl = wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type']);
			 $report .= '<a href="'.esc_url($linkurl).'">';
            $report .= esc_url($linkurl);
             $report .= '</a>';	
		
		}	
		elseif($row['type'] != "widget" and $row['type'] != "theme") {
		$report .= '<a href="'.esc_url(get_permalink($row['postid'])).'">';
		$report .= esc_url(get_permalink($row['postid']));
		$report .= '</a>';
		}
		$report .=  '</td>';
         }
		$report .=  '<td>';
		$report .= sprintf(__('%s', 'wp-ada-compliance'), esc_attr($row['type']));

		$report .= wp_ada_compliance_format_error_location($row['ignre'], $row['errorcode'],$row['type'], $row['id'],$row['locationnotes'], $row['themeerror'], 0);
		
		$report .=  '</td>';
		$report .=  '<td>';
		$report .= sprintf(__('%s', 'wp-ada-compliance'), str_replace("_", " ", esc_attr($row['errorcode'])));
		$report .=  '</td>';
		$report .=  '<td>';
        if($row['severity'] == 'A') $report .=  __('ALERT', 'wp-ada-compliance');
        if($row['severity'] == 'W') $report .=  __('WARNING', 'wp-ada-compliance');
		$report .=  '</td>';
        $report .=  '<td>';
        $report .= sprintf(__('%s', 'wp-ada-compliance'), esc_html($wp_ada_compliance_def[$row['errorcode']]['StoredError']));
		
        	 $report .= '<p class="wp-ada-found-date">';
            $report .= __('Date Found: ', 'wp-ada-compliance').date("n-j-Y g:i a",strtotime($row['date']));
           $report .= '</p>';
        
		// if printing display error
		if($email == 'print'){
		$report .= '<div class="adaEffectedCode code'.esc_attr($row['id']).'" id="code'.esc_attr($row['id']).'">';
           
            if($row['errorcode'] != 'html_validation' and $row['errorcode'] != 'missing_landmarks' and $row['errorcode'] != 'unlabeled_landmarks' and $row['errorcode'] != 'skip_nav_links' )
            $report .= '<code style="background-color: #fff;">'.wp_ada_compliance_filter_autoplay_av_tags(esc_html($row['object']), "1").'</code>';

     $trustedtags = '<svg><metadata><g><path><button><embed><iframe><p><br /><a><img><h1><h2><h3><h4><h5><h6><input><map><area><audio><video><pre><textarea><label><select><span><blink><i><fieldset><caption><form><legend><br><div><nav><main><aside><main><header><footer>';
		if(stristr($row['object'],'<table') or stristr($row['object'],'</th>') or stristr($row['object'],'</td>')) {
			$row['object'] = wp_ada_compliance_close_unclosed_tables($row['object']);
			$trustedtags .= '<table><tr><td><th><tbody><thead><span>';
		}
          
		$report .= '<br /><div style="background-color: #fff;">'.strip_tags($row['object'],$trustedtags).'</div>';	
            
            if($row['examplecode'] != "") {
			$report .= '<br /><br /><div style="background-color: #fff;">'.strip_tags($row['examplecode'],$trustedtags) .'</div>';	
		}	
		$report .= '</div>';
		}
		
		$report .=  '</td>';
		$report .=  '</tr>';
		}			
		}
		$report .=  '</table>';

		$report .= '
		<style>
		table{
		border-collapse: collapse;
		}
		table.ada_error td, table.ada_error th
		{
		padding: 5px; 
		color: #000; 
		min-width: 75px; 
		background-color:#ccc;
		}
		table.ada_error td
		{
		background-color:#fff;
		}
		</style>';
	}
	
	if(isset($issuefound))	return $report;
	else return "";
}

/****************************************************
export report
******************************************************/
add_action('admin_init','wp_ada_compliance_export_report');
function wp_ada_compliance_export_report(){
$includeLinkColumn = get_option('wp_ada_compliance_report_include_link_column','false');
if (isset($_SERVER['REQUEST_URI']) and stristr($_SERVER['REQUEST_URI'], 'ada_compliance/export-report.php')) {	
	
	global $wpdb, $wp_ada_compliance_def;
	
	$report= '';
    
    wp_ada_compliance_validate_form_values();
    
     // search links
    if (isset($_GET['searchtitle']) and strstr($_GET['searchtitle'],'/') ) { 
    $linkquery = 'left join '.$wpdb->prefix.'wp_ada_compliance_links on '.$wpdb->prefix.'wp_ada_compliance_links.postid = '.$wpdb->prefix.'wp_ada_compliance.postid'; 
    } else $linkquery = '';
    
	$query = 'SELECT * FROM '.$wpdb->prefix.'wp_ada_compliance '.$linkquery.' where %d ';
    
    	// hide if auto filter is turned off
	$report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');
	if($report_filtered_errors == 'false') $query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre != 2 '; 
		
	$queryVariablesMain[] = 1;
	
	if (isset($_GET['view']) and $_GET['view'] != '') {
	if($_GET['view'] == 1) {
		$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
		$queryVariablesMain[] = 0;
		}
    if ( $_GET['view'] == 3 ) { // ignored
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 1;
		}
	if( $_GET['view'] == 4 ) { // auto corrected issues
			$query .= ' and '.$wpdb->prefix.'wp_ada_compliance.ignre = %d ';
			$queryVariablesMain[] = 2;
		} 
	
	if (isset($_GET['errorid'])  and  $_GET['errorid'] != '' and  $_GET['errorid'] != 0 ) { // filter by post type
		if($_GET['type'] == 'attachment'){
               $query .= ' and (postid = %d or attachmentid = %d) ';
			$queryVariablesMain[] = (int)$_GET['errorid'];
            $queryVariablesMain[] = (int)$_GET['errorid'];
        }else{
        $query .= ' and postid = %d ';
			$queryVariablesMain[] = (int)$_GET['errorid'];
        }
			}
	if (isset($_GET['type']) and $_GET['type'] != '' ) { // filter by post type
			if ( $_GET['type'] == 'theme' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] =sanitize_text_field($_GET['type']);
			}

          	elseif ( $_GET['type'] == 'customfield' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** custom field%";
			}
            elseif ( $_GET['type'] == 'excerpt' ){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.locationnotes LIKE %s)';
			$queryVariablesMain[] = "%** post excerpt%";
			}
     elseif( $_GET['type'] == 'attachment'){
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s or '.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = 'attachment';
            $queryVariablesMain[] = 'pdf';
			}
      else{
			$query .= ' and ('.$wpdb->prefix.'wp_ada_compliance.type = %s)';
			$queryVariablesMain[] = sanitize_text_field($_GET['type']);
			}
     }
	if (isset($_GET['error']) and $_GET['error'] != '' ) { // filter by error code
			if($_GET['error'] == 'W' or $_GET['error'] == 'A')
                $query .= " and severity = %s ";
             else $query .= " and errorcode = %s ";			
			$queryVariablesMain[] = sanitize_text_field($_GET['error']);
		}
		if (isset($_GET['searchtitle']) and  $_GET['searchtitle'] != '' ) { // filter by post title
        if($linkquery != ''){
        $query .= " and link LIKE %s";
        $queryVariablesMain[] = '%'.sanitize_text_field($_GET['searchtitle']).'%';
  
        }else{     
			$query .= " and ".$wpdb->prefix."wp_ada_compliance.posttitle LIKE %s ";			
			$queryVariablesMain[] = '%'.sanitize_text_field($_GET['searchtitle']).'%';
         }
		}	
	
	if (isset($_GET['excludethemes']) and    $_GET['excludethemes'] != 0 ) { 
		$query .= '  and (themeerror = %d)';
		$queryVariablesMain[] = 0;
		}
        
    	if (isset($_GET['modifieddate']) and    $_GET['modifieddate'] != '' ) { 
		$query .= '  and (modifieddate >= %s or modifieddate = %s)';
		$queryVariablesMain[] = sanitize_text_field($_GET['modifieddate']);
            $queryVariablesMain[] = '0000-00-00 00:00:00';

		}    
		
	if (isset($_GET['excludedups']) and    $_GET['excludedups'] != 0 ) {
		// remove duplicates
			$query .= ' GROUP BY object ';

		}	
		
	if (isset($_GET['sort'])) {
	if($_GET['sort'] == 1) $sortby = 'date DESC, '.$wpdb->prefix.'wp_ada_compliance.id DESC';
	if($_GET['sort'] == 2) $sortby = $wpdb->prefix.'wp_ada_compliance.type asc';
	if($_GET['sort'] == 3) $sortby = 'errorcode asc';
	if($_GET['sort'] == 4) $sortby = $wpdb->prefix.'wp_ada_compliance.ignre desc';
	if($_GET['sort'] == 5)$sortby = $wpdb->prefix.'wp_ada_compliance.posttitle asc';
	if($_GET['sort'] == 6)$sortby = 'scantype desc';
	} else $sortby = 'date DESC, '.$wpdb->prefix.'wp_ada_compliance.id DESC';
	
	$query .= " order by $sortby ";
		
	}
    
	$results = $wpdb->get_results( $wpdb->prepare($query, $queryVariablesMain), ARRAY_A );

	if ( sizeof($results) > 0 ) {			
    $report .= '<table class="ada_error wp-ada-print-report" border="1"><tr>';
	$report .=  '<th scope="column" >';
	$report .= __('Title', 'wp-ada-compliance');
	$report .=  '</th>';
    if($includeLinkColumn == 'true') {   
	$report .=  '<th scope="column" >';
	$report .= __('Link', 'wp-ada-compliance');
	$report .=  '</th>';
     }
	$report .=  '<th scope="column">';
	$report .= __('Content Type', 'wp-ada-compliance');
	$report .=  '</th>';
	$report .=  '<th scope="column" >';
	$report .= __('Error Type', 'wp-ada-compliance');
	$report .=  '</th>';
            	$report .=  '<th scope="column" >';
	$report .= __('Severity', 'wp-ada-compliance');
	$report .=  '</th>';    
	$report .=  '<th scope="column" >';
	$report .= __('Error', 'wp-ada-compliance');
	$report .=  '</th></tr>';

	foreach ( $results as $row ) {		
		

		$title = sprintf(__('%s', 'wp-ada-compliance'), esc_attr($row['posttitle']));
		
	$report .=  '<tr>';
		$report .=  '<td>';
			// display link and title
	if($row['type'] == "term") {
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])).'">';
			$report .= $title;
			$report .= '</a>';
		}
	
		elseif($row['type'] == "theme") {	
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_url_to_scan($row['scantype'])).'" >';
		$report .= $title;
		$report .= '</a>';	
		}	
	elseif($row['type'] == "link" or $row['type'] == "pdf" or $row['type'] == "css" or $row['type'] == "iframe") {	
			 $report .= '<a href="'.esc_url(wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type'])).'">';
            $report .= $title;
             $report .= '</a>';	
		
		}	
		elseif($row['type'] != "widget" and $row['type'] != "theme") {
		$report .= '<a href="'.esc_url(get_permalink($row['postid'])).'">';
		$report .= $title;
		$report .= '</a>';
		}	
		
		if($row['ignre'] == 1) {
			$report .='<br /><span class="adaIgnored">';
			$report .=__('** being ignored', 'wp-ada-compliance');
			$report .= '</span>';
		}
		
		$report .=  '</td>';
           if($includeLinkColumn == 'true') {   
		$report .=  '<td>';
		// display link and title
		if($row['type'] == "term") {
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy'])).'">';
			$report .= esc_url(wp_ada_compliance_get_term_url_to_scan((int)$row['postid'], $row['taxonomy']));
			$report .= '</a>';
		}
		elseif($row['type'] == "theme") {	
			$report .= '<a href="'.esc_url(wp_ada_compliance_get_url_to_scan($row['scantype'])).'" >';
		$report .= esc_url(wp_ada_compliance_get_url_to_scan($row['scantype']));
		$report .= '</a>';	
		}	

        elseif($row['type'] == "link" or $row['type'] == "pdf" or $row['type'] == "css" or $row['type'] == "iframe") {	
            $linkurl = wp_ada_compliance_retrieve_link((int)$row['postid'],$row['type']);
			 $report .= '<a href="'.esc_url($linkurl).'">';
            $report .= esc_url($linkurl);
             $report .= '</a>';	
		
		}	       
		elseif($row['type'] != "widget" and $row['type'] != "theme") {
		$report .= '<a href="'.esc_url(get_permalink($row['postid'])).'">';
		$report .= esc_url(get_permalink($row['postid']));
		$report .= '</a>';
		}
		$report .=  '</td>';
           }
		$report .=  '<td>';
		$report .= sprintf(__('%s', 'wp-ada-compliance'), esc_attr($row['type']));

		
    $report .= strip_tags(wp_ada_compliance_format_error_location($row['ignre'], $row['errorcode'],$row['type'], $row['id'], $row['locationnotes'], $row['themeerror'],0));
        
		
		$report .=  '</td>';
		$report .=  '<td>';
		$report .= sprintf(__('%s', 'wp-ada-compliance'), str_replace("_", " ", esc_attr($row['errorcode'])));
		$report .=  '</td>';
        $report .=  '<td>';
        if($row['severity'] == 'A') $report .=  __('ALERT', 'wp-ada-compliance');
        if($row['severity'] == 'W') $report .=  __('WARNING', 'wp-ada-compliance');
		$report .=  '</td>';
		$report .=  '<td>';
		$report .= sprintf(__('%s', 'wp-ada-compliance'), esc_html($wp_ada_compliance_def[$row['errorcode']]['StoredError']));
		
		$report .= '<code>'.wp_ada_compliance_filter_autoplay_av_tags(esc_html($row['object']), "1").'</code>';
	        	 $report .= '<p class="wp-ada-found-date">';
            $report .= __('Date Found: ', 'wp-ada-compliance').date("n-j-Y g:i a",strtotime($row['date']));
           $report .= '</p>';
		$report .=  '</td>';
		$report .=  '</tr>';
		}	
		$report .=  '</table>';
		}

if(isset($_SERVER['HTTP_USER_AGENT']) and strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')) {
    session_cache_limiter("public");
}
	
header( 'Content-Description: File Transfer' );
header( 'Content-type: vnd.ms-excel' );
header("Content-Disposition: attachment; filename=extraction.xls");
header("Expires: 0");
header("Cache-Control: no-store, no-cache, no-transform, must-revalidate, private");	

echo $report;
	die();
}
}
add_action( 'template_redirect', 'wp_ada_compliance_export_report' );
/*********************************************
Modify media library to add filter for images missing alternate text
**********************************************/
add_action('restrict_manage_posts', 'wp_ada_compliance_media_library_dropdown');
add_action('pre_get_posts','wp_ada_compliance_media_filter');

function wp_ada_compliance_media_library_dropdown()
{
    
$scr = get_current_screen();
if ( $scr->base !== 'upload' ) return;
	
if (isset($_GET['accessibility-filter'])){
  $value = sanitize_text_field($_GET['accessibility-filter']);
} else $value = "";
	
echo '
	<label for="accessibility-filter" class="screen-reader-text">Filter by accessibility</label>
	<select class="accessibility-filter" name="accessibility-filter" id="accessibility-filter">
	<option value=""';
	if($value == "") echo ' selected';
	echo '>';
	_e('Accessibility Issues', 'wp-ada-compliance');
	echo '</option>';
    	echo '<option value="viewall"';
	if($value == "viewall") echo ' selected';
	echo '>';
	_e('View All Images With Accessibility Issues', 'wp-ada-compliance');
	echo '</option>';
	echo '<option value="missingalt"';
	if($value == "missingalt") echo ' selected';
	echo '>';
	_e('Missing Alternate Text', 'wp-ada-compliance');
	echo '</option>';
	echo '<option value="invalidalt"';
	if($value == "invalidalt") echo ' selected';
	echo '>';
	_e('Invalid Alternate Text', 'wp-ada-compliance');
	echo '</option>';
	echo '</select>';
}
function wp_ada_compliance_media_filter($query) {
    if ( is_admin() && $query->is_main_query() ) {
        if (isset($_GET['accessibility-filter'])){ 
			if($_GET['accessibility-filter'] == "missingalt") {
            $query->set('meta_query', array(
			'relation' => 'OR',
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '',
			'compare' => '='
		),
			array(
			'key' => '_wp_attachment_image_alt',
			'compare' => 'NOT EXISTS'
		)
			));
        }
	    if ($_GET['accessibility-filter'] == "invalidalt") {
            $query->set('meta_query', array(
			'relation' => 'OR',
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.jpg',
			'compare' => 'LIKE'
			),
                	array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.jpeg',
			'compare' => 'LIKE'
			),
				array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.png',
			'compare' => 'LIKE'
			),
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.gif',
			'compare' => 'LIKE'
			),	
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '_',
			'compare' => 'LIKE'
			),	
				array(
			'key' => '_wp_attachment_image_alt',
			'value' => 'photo of',
			'compare' => 'LIKE'
			),
			array(
				'key' => '_wp_attachment_image_alt',
			'value' => 'image of',
			'compare' => 'LIKE'
		),
		array(
				'key' => '_wp_attachment_image_alt',
			'value' => 'graphic of',
			'compare' => 'LIKE'
		)
		)
		);
        }
        
     if($_GET['accessibility-filter'] == 'viewall') {
            $query->set('meta_query', array(
			'relation' => 'OR',
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '',
			'compare' => '='
		),
			array(
			'key' => '_wp_attachment_image_alt',
			'compare' => 'NOT EXISTS'
		),
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.jpg',
			'compare' => 'LIKE'
			),
                	array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.jpeg',
			'compare' => 'LIKE'
			),
				array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.png',
			'compare' => 'LIKE'
			),
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '.gif',
			'compare' => 'LIKE'
			),	
			array(
			'key' => '_wp_attachment_image_alt',
			'value' => '_',
			'compare' => 'LIKE'
			),	
				array(
			'key' => '_wp_attachment_image_alt',
			'value' => 'photo of',
			'compare' => 'LIKE'
			),
			array(
				'key' => '_wp_attachment_image_alt',
			'value' => 'image of',
			'compare' => 'LIKE'
		),
		array(
				'key' => '_wp_attachment_image_alt',
			'value' => 'graphic of',
			'compare' => 'LIKE'
		)
		)
		);
		}

    }
    }
}
/*************************************************
closed unclosed tags to keep from breaking report
*************************************************/
function wp_ada_compliance_close_unclosed_tables($object){ 
	if(substr( $object, 0, 3 ) == '<td' and strstr($object,'</td>') and !strstr($object,'<table>')){
		$object = '<table><tr>'.$object.'<tr></table>';
	} 
	if(substr( $object, 0, 3 ) == '<th' and strstr($object,'</th>') and !strstr($object,'<table>')){
		$object = '<table><tr>'.$object.'<tr></table>';
	} 
	
	$tabletags = substr_count($object,'<table');
	$tableclosetags = substr_count($object,'</table>');
	if($tabletags > $tableclosetags){
	$numbertoadd = ($tabletags - $tabletags);
		for($i = 1; $i <= $numbertoadd; $i++){
		$object.="</table>";	
		}
	}
	return $object;
}
/*************************************************
display link inventory
*************************************************/
function wp_ada_compliance_link_report(){
  global $wpdb; 
    
 wp_ada_compliance_validate_form_values();
    
    // update link status
   if(isset($_GET['wpada_ignore_post'])) {
       wp_ada_compliance_update_link_ignore_status();
       wp_ada_compliance_purge_ignored_content();
   }
    

    if (isset( $_GET['search'])) $search = sanitize_text_field($_GET['search']);
    else $search = '';
    
	if (isset( $_GET['searchtype'])) $searchtype = sanitize_text_field($_GET['searchtype']);
    else $searchtype = '';
    
	if (isset( $_GET['linkstatus'])) $linkstatus = sanitize_text_field($_GET['linkstatus']);
    else $linkstatus = '';
        
	if (isset( $_GET['monitor'])) $monitor = sanitize_text_field($_GET['monitor']);
    else $monitor = '';
    
    
    echo '<h1>';
_e('Link Inventory', 'wp-ada-compliance');
    echo '</h1>';
    
    echo '<p>';
_e('The link inventory includes a list of links found on your website and can be used to identify areas where your website may not be protected. If the link status is in error state it means the link is broken or redirected and could not be scanned. To ensure these links are protected install a broken link plugin to monitor and correct broken links on your website. A link status of "OK" and a monitor status of "Not Monitored" means one or more plugin settings are blocking the link from being scanned.', 'wp-ada-compliance');
    echo '</p>';  
    
echo '<div class="wp_ada_compliance_notice_container">';
echo '<button aria-label="'.__('hide notices','wp-ada-compliance').'" class="wpadahidenotices"><i class="fas fa-times" aria-hidden="true"></i></button>';    
echo '<span class="wp_ada_compliance_notices">';
echo '<i class="fas fa-info-circle" aria-hidden="true"></i> ';
if(isset($_SESSION['my_ada_important_notices'])) {
    echo $_SESSION['my_ada_important_notices'];
	unset($_SESSION['my_ada_important_notices']); 
          }
else {
    _e('Look for status notices here.','wp-ada-compliance');    
}
echo '</span>';
    echo '</div>';


 echo '<form name="filtererrors" class="wp_ada_form" action="'.esc_url(get_site_url()).'/wp-admin/admin.php" method="get"><input type="hidden" name="page" value="ada_compliance/links.php" />';

// monitor status    
echo '<label for="monitor" class="wp_ada_label">'.__('Monitor Status: ', 'wp-ada-compliance').'<select name="monitor" id="monitor">';
echo '<option value="">'.__('Any','wp-ada-compliance').'</option>';
echo '<option value="yes"';
if(isset($_GET['monitor']) and $_GET['monitor'] == 'yes') echo ' selected';
echo '>'.__('Monitored','wp-ada-compliance').'</option>';
echo '<option value="no"';
if(isset($_GET['monitor']) and $_GET['monitor'] == 'no') echo ' selected';
echo '>'.__('Not Monitored','wp-ada-compliance').'</option>';	
    echo '<option value="ignore"';
if(isset($_GET['monitor']) and $_GET['monitor'] == 'ignore') echo ' selected';
echo '>'.__('Ignored','wp-ada-compliance').'</option>';	    
echo '</select></label> ';

// link status    
echo '<label for="linkstatus" class="wp_ada_label">'.__('Link Status: ', 'wp-ada-compliance').'<select name="linkstatus" id="linkstatus">';
echo '<option value="">'.__('Any','wp-ada-compliance').'</option>'; 
    
$query2 = "SELECT distinct(linkstatus) FROM ".$wpdb->prefix."wp_ada_compliance_links where linkstatus != %s and linkstatus != %s ";
$results2 = $wpdb->get_results( $wpdb->prepare( $query2, '', '200'), ARRAY_A );
foreach ( $results2 as $row2 ) {
echo '<option value="'.esc_attr($row2['linkstatus']).'"';
if(isset($_GET['linkstatus']) and $_GET['linkstatus'] == $row2['linkstatus']) echo ' selected';
echo '>'.esc_attr($row2['linkstatus']).'</option>';
}
echo '</select></label> ';
  
// filter by post type	
$query = "SELECT distinct(type) FROM ".$wpdb->prefix."wp_ada_compliance_links ";
$results = $wpdb->get_results($query, ARRAY_A );
echo '<label for="posttype" class="wp_ada_label">'.__('Post Type: ', 'wp-ada-compliance').'<select name="searchtype" id="posttype">';
echo '<option value="">'.__('Any','wp-ada-compliance').'</option>';
foreach ( $results as $row ) {

echo '<option value="'.esc_attr($row['type']).'"';
if(isset($_GET['searchtype']) and $_GET['searchtype'] == $row['type']) echo ' selected';
echo '>'.esc_attr__($row['type'],'wp-ada-compliance').'</option>';
	if($row['type'] == 'theme') $themefound=1;
  }  

if(!isset($themefound)){
echo '<option value="theme"';
if(isset($_GET['searchtype']) and $_GET['searchtype'] == 'theme') echo ' selected';
echo '>theme</option>';		
}

echo '</select></label> ';    
    
// search    
    echo '<label for="search" class="wp_ada_label" >';
_e('Search:','wp-ada-compliance');
echo '<input type="text" name="search" id="search" value="';
if(isset($_GET['search'])) {
	echo esc_attr($_GET['search']);	
}
echo '" /></label>';
// submit	
echo '<input type="submit" value="'.__('Filter', 'wp-ada-compliance').'" class=" wp_ada_label btnwpada btnwpada-primary filterbtn" />';	
echo '</form>';		
    
$query = "SELECT * FROM ".$wpdb->prefix."wp_ada_compliance_links where %d ";
$totalquery = "SELECT count(id) FROM ".$wpdb->prefix."wp_ada_compliance_links where %d ";
 $querystring = '';   
$queryVariables = array('1');  
    
    // filter by search
	if ($search != '') {
        $querystring .= ' and link LIKE %s ';
        $queryVariables[] = '%'.$search.'%';
	}
            // filter by type
	if ($searchtype != '') {
        $querystring .= ' and type = %s ';
        $queryVariables[] = $searchtype;
	}
    
        // filter by linkstatus
	if ($linkstatus != '') {
        $querystring .= ' and linkstatus = %s ';
        $queryVariables[] = $linkstatus;
	}
        // filter by monitor
	if ($monitor != '') {
         if($monitor == 'ignore'){
       $querystring .= ' and (ignre = %s and (linkstatus = %s or linkstatus = %s))';
            $queryVariables[] = '1';
          $queryVariables[] = '';
             $queryVariables[] = '200';
        }
        elseif($monitor == 'no'){
       $querystring .= ' and (ignre = %s or (linkstatus != %s and linkstatus != %s))';
            $queryVariables[] = '1';
            $queryVariables[] = '';
             $queryVariables[] = '200';
        }
        elseif($monitor == 'yes'){
       $querystring .= ' and (ignre = %s and (linkstatus = %s or linkstatus = %s))';
            $queryVariables[] = '0';
            $queryVariables[] = '';
             $queryVariables[] = '200';
        }
	}     
$query.=$querystring; 
$totalquery.=$querystring;   
    
// create pagination offset	
$per_page = get_option('wp_ada_compliance_errors_per_page','15');
$total = 0;
$page = isset( $_GET['cpage'] ) ? abs( (int) $_GET['cpage'] ) : 1;
if ($page > 1) {
   $offset = $page * $per_page - $per_page;
} else {
    $offset = 0;
}  
 $total = $wpdb->get_var($wpdb->prepare($totalquery, $queryVariables));
    
  	//display the pagination
$pagination = paginate_links(array(
    'base' => add_query_arg('cpage', '%#%', esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&monitor='.esc_attr($monitor).'&linkstatus='.esc_attr($linkstatus).'&search='.esc_attr($search)),
    'format' => '',
	'mid_size'  => 2,
	'current' => 'true',
    'prev_text' => __('&laquo;'),
    'next_text' => __('&raquo;'),
    'total' => ceil($total / $per_page),
    'current' => $page
));
   
$query .= " order by id limit %d offset %d";
$queryVariables[] = $per_page;
$queryVariables[] = $offset;    
$results = $wpdb->get_results( $wpdb->prepare($query, $queryVariables), ARRAY_A );    
  
if($results) {   
if($pagination != "") echo $pagination = "<p>".$pagination."</p>";
    
echo '<div id="reportdata"><table class="ada_error"><tr>';
	echo '<th scope="column">';
	_e('Link', 'wp-ada-compliance');
	echo '</th>';
    	echo '<th scope="column">';
	_e('Modified Date', 'wp-ada-compliance');
	echo '</th>';
	echo '<th scope="column">';
		_e('Type', 'wp-ada-compliance');
	echo '</th>';
        	echo '<th scope="column" >';
	_e('Size', 'wp-ada-compliance');
	echo '</th>';
	echo '<th scope="column" >';
	_e('Link Status', 'wp-ada-compliance');
	echo '</th>';

	echo '<th scope="column">';
	_e('Monitor Status', 'wp-ada-compliance');
	echo '</th>';  
   	echo '<th scope="column">';
	_e('Actions', 'wp-ada-compliance');
	echo '</th>';  
	echo '</tr>';  
    
	foreach ( $results as $row ) {
        
    echo '<tr>';  
    echo '<td>'; 
    echo '<a href="';
    echo esc_url($row['link']); 
    echo '" target="_blank" title="opens in a new window" aria-label="';
    _e('Open Link ','wp-ada-compliance');
    echo esc_url($row['link']);
    echo '">';    
    echo esc_url($row['link']); 
    echo '</a>';    
    echo '</td>';
   echo '<td>';
        if($row['modifieddate'] !='0000-00-00 00:00:00')
    echo esc_attr(date('n-j-Y', strtotime($row['modifieddate'])));
    echo '</td>';
    echo '<td>'; 
    echo esc_attr($row['type']); 
    if($row['type'] == 'attachment') echo ' - '.esc_attr(get_post_mime_type($row['postid']));   
    if($row['themetype'] != "") echo ' - '. esc_attr($row['themetype']);  
    if($row['taxonomy'] != "") echo ' - '. esc_attr($row['taxonomy']);   
    echo '</td>'; 
                   echo '<td>'; 

        if($row['filesize'] == 0) $filesize = '';
        else{
        $filesize = number_format($row['filesize'] / 1048576, 0);
        if($filesize == 0) $filesize = ' < 1';
        $filesize .= __(' MB','wp-ada-compliance');
        }
        echo esc_attr($filesize);
           echo '</td>'; 
    echo '<td>'; 
     if($row['linkstatus'] != "" and $row['linkstatus'] != "200") {
         echo '<span class="adaRedText adaBoldText">';
          _e('Error: ','wp-ada-compliance'); 
         echo esc_attr($row['linkstatus']);
        echo '</span>';
     }
    else {
          echo '<span class="adaAllGood adaBoldText">';
        _e('OK','wp-ada-compliance');  
         echo '</span>';
    }
    echo '</td>';

    echo '<td>'; 
      if($row['linkstatus'] != "" and $row['linkstatus'] != "200") {
         echo '<span class="adaRedText adaBoldText">';
        _e('Not Monitored', 'wp-ada-compliance');
        echo '<br />';
         _e('Unsupported Link Status', 'wp-ada-compliance');
        echo '</span>';
     }
      else if($row['ignre'] == 1) {
         echo '<span class="adaRedText adaBoldText">';
        _e('Not Monitored', 'wp-ada-compliance'); 
           echo '<br />';
          if(strstr($row['themetype'],'_archive')) $checktype = str_replace('_archive','',$row['themetype']);
          else $checktype = $row['type'];
          
          if($row['type'] != 'term' 
              and $row['type'] != 'link' 
              and $row['type'] != 'pdf'
             and $row['type'] != 'css'
             and $row['type'] != 'iframe' 
             and ($row['type'] != 'theme' or ($row['type'] == 'theme' and strstr($row['themetype'],'_archive'))) and !post_type_exists($checktype)){
              _e('inactive post type', 'wp-ada-compliance');
          } else{
           _e('Ignored', 'wp-ada-compliance');
          } 
          
        echo '</span>';
     }
    else {
          echo '<span class="adaAllGood adaBoldText">';
        _e('Monitored', 'wp-ada-compliance'); 
         echo '</span>';
    }    
        
    echo '</td>'; 
      
 echo '<td>'; 
        if($row['ignre'] == 0  and ($row['linkstatus'] == ""  or $row['linkstatus'] == "200")) {          
        if($row['type'] == 'theme' or $row['type'] == 'link' or $row['type'] == 'iframe' or $row['type'] == 'css' or $row['type'] == 'pdf'){
 
       /* if($row['type'] == 'css'){
            $scantype = $row['link'];
              echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&wpada_ignore_post='.esc_attr($row['id']).'&scantype='.esc_attr($scantype).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($row['type']).'&id=&cpage='.esc_attr($page).'&monitor='.esc_attr($monitor).'&linkstatus='.esc_attr($linkstatus).'&searchtype='.esc_attr($searchtype).'&search='.esc_attr($search).'"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
		_e('Ignore','wp-ada-compliance');
            echo '</a>';  		
        }
        else{*/
            $scantype =  str_replace(" ", "",$row['themetype']);   
              echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&wpada_ignore_post='.esc_attr($row['id']).'&scantype='.esc_attr($scantype).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($row['type']).'&id=&cpage='.esc_attr($page).'&monitor='.esc_attr($monitor).'&linkstatus='.esc_attr($linkstatus).'&searchtype='.esc_attr($searchtype).'&modifieddate='.esc_attr($row['modifieddate']).'&search='.esc_attr($search).'"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
		_e('Ignore','wp-ada-compliance');
            echo '</a>';  		
        //}
            
            echo '<br />';
                echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&scansingle=1&type='.esc_attr($row['type']).'&taxonomy='.esc_attr($row['taxonomy']).'&postid='.esc_attr($row['id']).'&searchtitle='.esc_attr($row['id']).'" ><i class="far fa-check-circle" aria-hidden="true"></i>';
                _e('Scan','wp-ada-compliance');
                echo '</a>'; 
         }
            else{
                       
         	echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/links.php&wpada_ignore_post='.esc_attr($row['postid']).'&scantype='.esc_attr($row['themetype']).'&posttype='.esc_attr($row['type']).'&type='.esc_attr($row['type']).'&id=&cpage='.esc_attr($page).'&monitor='.esc_attr($monitor).'&linkstatus='.esc_attr($linkstatus).'&searchtype='.esc_attr($searchtype).'&modifieddate='.esc_attr($row['modifieddate']).'&search='.esc_attr($search).'"><i class="fas fa-eye-slash" aria-hidden="true"></i>';
		_e('Ignore','wp-ada-compliance');
		echo '</a>';
       echo '<br />';
                echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=ada_compliance/compliancereport.php&scansingle=1&type='.esc_attr($row['type']).'&taxonomy='.esc_attr($row['taxonomy']).'&postid='.esc_attr($row['postid']).'&searchtitle='.esc_attr($row['postid']).'" ><i class="far fa-check-circle" aria-hidden="true"></i>';
                _e('Scan','wp-ada-compliance');
                echo '</a>';    
            }
        }else{
            // check cap allowed to edit settings
$settingsuser = get_option('wp_ada_compliance_settingsusers','manage_options');
            if (current_user_can($settingsuser) ){ 
              if($row['linkstatus'] != "" and $row['linkstatus'] != "200"){
               echo '<span class="adaRedText adaBoldText">';
                  _e('Correct link issue','wp-ada-compliance'); 
                   echo '</span>';
              }else{
	          echo '<a href="'.esc_url(get_site_url()).'/wp-admin/admin.php?page=wp-ada-compliance-admin" class="btnwpada btnwpada-primary" title="';
                _e('Adjust settings to change ignore status','wp-ada-compliance');
                  echo '"><i class="fas fa-cog" aria-hidden="true"></i> ';
                _e('Settings','wp-ada-compliance');
                echo '</a>';
              }
            }
        }
         echo '</td>'; 
    echo '</tr>';
   
    }
 echo '</table></div>';   
} else{
    echo '<p class="adaAllGood">';
 _e('Run a full website scan and check back to see the link inventory.','wp-ada-compliance');   echo '</p>';
}
    
if($pagination != "") echo "<p>".$pagination."</p>";    
}
?>