<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;

/********************************************************************/	
// validate absolute font tags
/********************************************************************/	
function wp_ada_compliance_validate_absolute_fontsize($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
    	
// check if being scanned
if(in_array('absolute_fontsize', $wp_ada_compliance_scanoptions)) return 0;
  
// non css files    
if($postinfo['type'] != 'css')	{
          
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
    
$content = wp_ada_compliance_change_fontsize($content);
}    
    
$dom = str_get_html($content);		

$elements = $dom->find('*[style*=font-size:], *[style*=font:]');
foreach ($elements as $element) {
   
$absolute_fontsize_errorcode = $element->outertext;    
$fontsearchpatterns = array();
$fontsearchpatterns[] = "|font\-size:\s?([\d]+)pt|i";
$fontsearchpatterns[] = "|font\-size:\s?([\d]+)px|i";
$fontsearchpatterns[] = "|font:\s?[\w\s\d*\s]*([\d]+)pt|i";
$fontsearchpatterns[] = "|font:\s?[\w\s\d*\s]*([\d]+)px|i";

foreach($fontsearchpatterns as $key => $pattern){

	if(preg_match($pattern, $absolute_fontsize_errorcode)){

        if($filteredcheck == 1) return 1;
        
		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"absolute_fontsize", $absolute_fontsize_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "absolute_fontsize", $wp_ada_compliance_def['absolute_fontsize']['StoredError'], $absolute_fontsize_errorcode);
		}
		
	}
}
}
    
    
// // parse and scan style tag content in post files
if(stristr($content, '<style'))	{
foreach ($dom->find('style') as $style) {	

$absolute_fontsize_errorcode = $style->outertext;    
$fontsearchpatterns = array();
$fontsearchpatterns[] = "|font\-size:\s?([\d]+)pt|i";
$fontsearchpatterns[] = "|font\-size:\s?([\d]+)px|i";
$fontsearchpatterns[] = "|font:\s?[\w\s\d*\s]*([\d]+)pt|i";
$fontsearchpatterns[] = "|font:\s?[\w\s\d*\s]*([\d]+)px|i";

foreach($fontsearchpatterns as $key => $pattern){

	if(preg_match($pattern, $absolute_fontsize_errorcode)){
     
        
        if($filteredcheck == 1) return 1;

		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"absolute_fontsize", $absolute_fontsize_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "absolute_fontsize", $wp_ada_compliance_def['absolute_fontsize']['StoredError'], $absolute_fontsize_errorcode);
		}
		
	}
}
}
}
} 
else{ // css files
    
$fontsearchpatterns = array();
$fontsearchpatterns[] = "|font\-size:\s?([\d]+)pt|i";
$fontsearchpatterns[] = "|font\-size:\s?([\d]+)px|i";
$fontsearchpatterns[] = "|font:\s?[\w\s\d*\s]*([\d]+)pt|i";
$fontsearchpatterns[] = "|font:\s?[\w\s\d*\s]*([\d]+)px|i";

foreach($fontsearchpatterns as $key => $pattern){

	if(preg_match_all($pattern, $content, $matches,PREG_OFFSET_CAPTURE)){
	$matchsize = sizeof($matches[0]);
	
	for($i=0; $i < $matchsize; $i++){
        if(isset($matches[0][$i][0]) and $matches[0][$i][0] != ""){
				
			
		$absolute_fontsize_errorcode = htmlspecialchars($matches[0][$i][0]).__(' (char #: ','wp-ada-compliance').$matches[0][$i][1].')';	

		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"absolute_fontsize", $absolute_fontsize_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "absolute_fontsize", $wp_ada_compliance_def['absolute_fontsize']['StoredError'], $absolute_fontsize_errorcode);
		}
		
	}
	}
	}
	
}
}
	return 0;
} 
?>