<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// // validate adjacent identical links
/********************************************************************/	
function wp_ada_compliance_validate_adjacent_identical_links($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('adjacent_identical_links', $wp_ada_compliance_scanoptions)) return;
	
	// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');  
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
 $dom = str_get_html($content);	 
    
$dom = wp_ada_compliance_correct_elementor_post_widget($dom);    
$dom = wp_ada_compliance_remove_redundant_alttext($dom);
$dom = wp_ada_compliance_correct_elementor_icon_boxes($dom);    
$dom = wp_ada_compliance_correct_elementor_image_boxes($dom); 
  
if(is_object($dom)){
$content = $dom->save();  

} else return;	
}	

if($content == '') return;	
    
$dom = str_get_html($content);	 
    
    // define site url	
$siteurl = esc_url_raw(get_site_url());
$replacement_patterns = array();
$replacement_patterns[] =  '|'.$siteurl."|i";
$replacement_patterns[] = '|'.preg_replace('#^[^\/]*#', '', preg_replace('#((https://)|http://)*#i','',$siteurl))."|i";
$replacement_patterns[] =  '|https://|i';
$replacement_patterns[] =  '|http://|i';	

$links = $dom->find('a');
	$count = 1;
    $linktext = array();
    $linkcode = array();
    $linkdestination = array();
   
   // $valuetemp = '';
	foreach ($links as $link) {

        // exclude links hidden from screen readers
if($link->getAttribute('tabindex') != '-1'){
// remove auto correct code
//$link = wp_ada_compliance_remove_filtering_code($link);
        
       $arialabelledby = wp_ada_compliance_get_aria_values($dom, $link, 'aria-labelledby');
      $ariadescribedby = wp_ada_compliance_get_aria_values($dom, $link, 'aria-describedby');
        $img = $link->find('img');
        $svg = $link->find('svg');
                
        // aria label on lnks
       if($link->getAttribute('aria-label') != ""){
		$linktext[$count] = $link->getAttribute('aria-label');	
		}
        // aria - described by
        elseif($ariadescribedby != ""){
           $linktext[$count] =  $ariadescribedby;
        }
        // aria - labelled by 
        elseif( $arialabelledby != ""){
           $linktext[$count] =   $arialabelledby;
        }
    
        // images
        elseif(isset($img[0]) and $link->plaintext == '') {
            if($img[0]->getAttribute('alt') != ''){
            $linktext[$count] = $img[0]->getAttribute('alt');
        }
        }  
         // svg
        elseif(isset($svg[0])) {
        $linktext[$count] = trim(wp_ada_compliance_check_svg_img_alt_text($svg[0], $dom)); 
            }  
        else{
        $temptext = '';
        // title and link text
        if($link->getAttribute('title') != ""){ 
		$temptext .= ' '.$link->getAttribute('title');	
		}  
            // alt text from image
         if(isset($img[0]) and $img[0]->getAttribute('alt') != ''){
          $temptext .= ' '.$img[0]->getAttribute('alt');
         }
         if(isset($svg[0])){
    
          $temptext .= ' '.trim(wp_ada_compliance_check_svg_img_alt_text($svg[0], $dom)); 
          $linktext[$count] = $temptext;	
         }
        else
		$linktext[$count] = $link->plaintext.$temptext;	
		}
		    
         if($link->parent->getAttribute('class') == 'elementor-image-box-img' or $link->parent->getAttribute('class') == 'elementor-icon-box-icon' or $link->parent->getAttribute('class') == 'elementor-icon-box-title' or $link->parent->getAttribute('class') == 'elementor-image-box-title'){
                 $linkcode[$count] = $link->parent->parent->parent->parent->parent->outertext;
            } 
             else {
        $linkcode[$count] = $link->outertext;
             }
        
        
        $linkdestination[$count] = preg_replace($replacement_patterns, '',$link->getAttribute('href'));
        
        $excludedlinks[] = '';
        $excludedlinks[] = 'x';
        $excludedlinks[] = __('close','wp-ada-compliance');
        
            $matchfound = 0;
               
            foreach($linktext as $key => $value){
               if(array_key_exists($key-1,$linkcode) and array_key_exists($key,$linkcode) 
                    and array_key_exists($key,$linktext) and array_key_exists($key-1,$linktext)
                   and trim(strtolower($linktext[$key])) == trim(strtolower($linktext[$key-1]))
                   and $linkdestination[$key] == $linkdestination[$key-1]
                  ) { 
                    if(!in_array(trim(strtolower($value)),$excludedlinks)){ 
                     
            if(strstr($linkcode[$key], 'elementor-image-box-img') or strstr($linkcode[$key], 'elementor-icon-box-icon')){
                 $atagcode = $linkcode[$key];
            } 
             else {
                 $atagcode = $linkcode[$key-1].' ... '.$linkcode[$key];
              
             }
                        
            $matchfound = 1;
                     
                }
                }
               
               
            }
            if($matchfound == 1){
                
                if($filteredcheck == 1) return 1;
		
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"adjacent_identical_links", $atagcode)){
			$insertid = wp_ada_compliance_insert_error($postinfo,"adjacent_identical_links", $wp_ada_compliance_def['adjacent_identical_links']['StoredError'],  $atagcode);
			}
			
            }

      $count++;
    
}
}
return 0;
} 

/**********************************************************
get svg alt image
**********************************************************/
function wp_ada_compliance_check_svg_img_alt_text($svg, $dom){
$alt = '';
if(is_array($svg)) {   
    
if(count($svg) == 0) return 1;     
    
$title = $svg[0]->find('title');

if(count($title) == 0) $alt = $title[0]->innertext;
if($alt == '') $alt = wp_ada_compliance_get_aria_values($dom, $svg[0], 'aria-labelledby'); 
if($alt == '') $alt = wp_ada_compliance_get_aria_values($dom, $svg[0], 'aria-describedby');

}else{
$title = $svg->find('title');

if(count($title) > 0) $alt = $title[0]->innertext;
if($alt == '') $alt = wp_ada_compliance_get_aria_values($dom, $svg, 'aria-labelledby'); 
if($alt == '') $alt = wp_ada_compliance_get_aria_values($dom, $svg, 'aria-describedby'); 
    
}
 
return $alt;    
}
?>