<?php
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate animated images
/********************************************************************/
function wp_ada_compliance_validate_animated_image($content, $postinfo){
	
global $wp_ada_compliance_def;
	
$dom = str_get_html($content);	

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('animated_image', $wp_ada_compliance_scanoptions)) return;		

$images = $dom->find('img');
foreach ($images as $image) {
     if (isset($image) and (stristr($image->getAttribute('src'),".gif") or stristr($image->getAttribute('src'),".png"))){

	if(wp_ada_compliance_isAnimatedGif($image->getAttribute('src'))){			
			
				
			$imagecode = $image->outertext;
		 
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"animated_image", $imagecode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"animated_image", $wp_ada_compliance_def['animated_image']['StoredError'], $imagecode);
			
			}
		}
}
	return;
}
/***************************************************
check for animated gif
**************************************************/
function wp_ada_compliance_isAnimatedGif($filename)
  {
  $filecontents =''; 
    
// get args from login routine
$args = wp_ada_compliance_process_login($filename);
    
$response = wp_remote_get($filename, $args);	
if ( is_array( $response ) ) {
$response_code = wp_remote_retrieve_response_code($response);
if($response_code == '200') $filecontents = wp_remote_retrieve_body($response);
}
if($filecontents == '') return;    
     // check animated png
   if(strpos(substr($filecontents, 0, strpos($filecontents, 'IDAT')), 
                 'acTL')!==false)
            {
        return true;
        }
    
    // check animated gif
    $str_loc=0;
    $count=0;
 
    // There is no point in continuing after we find a 2nd frame
    while ($count < 2) 
    {
      $where1=strpos($filecontents,"\x00\x21\xF9\x04", $str_loc);
      if ($where1 === FALSE) {
        break;
      }
 
      $str_loc = $where1+1;
      $where2  = strpos($filecontents,"\x00\x2C",$str_loc);
      if ($where2 === FALSE) {
        break;
      }
      else {
        if ($where1+8 == $where2) {
          $count++;
        }
        $str_loc = $where2+1;
      }
    }
 
    // gif is animated when it has two or more frames
    return ($count >= 2); 
  }

/*
function wp_ada_compliance_is_apng($filename){
    
 $filecontents =''; 
    
// get args from login routine
$args = wp_ada_compliance_process_login($filename);
    
$response = wp_remote_get($filename, $args);	
    
    
    $f = new \SplFileObject($filename, 'rb');
    $header = $f->fread(8);
    if ($header !== "\x89PNG\r\n\x1A\n") {
        return false;
    }
    while (!$f->eof()) {
        $bytes = $f->fread(8);
        if (strlen($bytes) < 8) {
            return false;
        }
        $chunk = unpack('Nlength/a4name', $bytes);
        switch ($chunk['name']) {
            case 'acTL':
                return true;
            case 'IDAT':
                return false;
        }
        $f->fseek($chunk['length'] + 4, SEEK_CUR);
    }
    return false;
}*/
?>