<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************	
check for aria attributes with missing or invalid ids
********************************************************************/	
function wp_ada_compliance_validate_aria_attribute_invalid_id($content, $postinfo){
	
global $wp_ada_compliance_def;
	
$dom = str_get_html($content);

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('aria_attribute_invalid_id', $wp_ada_compliance_scanoptions)) return;	

$elements = $dom->find('[aria-labelledby], [aria-describedby]');
foreach ($elements as $element) {

$errorcode = $element->outertext;
  
if(strstr($errorcode,'aria-describedby')) {
    $attribute = 'aria-describedby';  
    $attributevalue = $element->getAttribute('aria-describedby');   
}
if(strstr($errorcode,'aria-labelledby')) {
    $attribute = 'aria-labelledby'; 
    $attributevalue = $element->getAttribute('aria-labelledby');   
} 
    
if(wp_ada_compliance_get_aria_values($dom, $element, $attribute) == '' or !wp_ada_compliance_check_for_missing_aria_id($dom, $attributevalue)){
			
$errorcode = $element->outertext;

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"aria_attribute_invalid_id", $errorcode))
$insertid = wp_ada_compliance_insert_error($postinfo,"aria_attribute_invalid_id",$wp_ada_compliance_def['aria_attribute_invalid_id']['StoredError'], $errorcode);
						
}
				
}
return;
}

/**************************************
// check if id is pressent
*************************************/
function wp_ada_compliance_check_for_missing_aria_id($dom, $attributevalue){
$elements = $dom->find("[id=$attributevalue]");
if(count($elements) == 1) return 1;

return 0;    
}
?>