<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
/// check video with autoplay
/********************************************************************/	
function wp_ada_compliance_validate_av_tag_with_autoplay($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('av_tag_with_autoplay', $wp_ada_compliance_scanoptions)) return;	
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	
$dom = wp_ada_compliance_filter_autoplay_av_tags_dom($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	    
	
$videos = $dom->find('video');
foreach ($videos as $video) {
		$videocode = $video->outertext;
		if (isset($video) and (stristr($videocode,'autoplay') and !stristr($videocode,'muted'))){	
            
            if($filteredcheck == 1) return 1;   
            
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"av_tag_with_autoplay", $videocode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"av_tag_with_autoplay", $wp_ada_compliance_def['av_tag_with_autoplay']['StoredError'], $videocode);
			
		}
}	
// check audio tags for autoplay	
$audios = $dom->find('audio');
foreach ($audios as $audio) {
		$audiocode = $audio->outertext;
		if (isset($audio) and (strstr($audiocode,'autoplay') and !strstr($audiocode,'muted'))){	
            
            if($filteredcheck == 1) return 1;   
            
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"av_tag_with_autoplay", $audiocode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"av_tag_with_autoplay", $wp_ada_compliance_def['av_tag_with_autoplay']['StoredError'], $audiocode);
			

		}
}
//Check object tags for auto play
$objects = $dom->find('object');
foreach ($objects as $object) {	
			$nodes = $object->children;
		foreach ($nodes as $node) {
			if($node->tag == "param") {
				
			if((strtolower($node->getAttribute('name')) == "autoplay" and strtolower($node->getAttribute('value')) == "true") or (strtolower($node->getAttribute('name')) == "flashvars" 
		and stristr($node->getAttribute('value'),"autoPlay=true"))){
				   
            if($filteredcheck == 1) return 1;       
			
			$objectcode = $object->outertext;	
					
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"av_tag_with_autoplay", $objectcode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"av_tag_with_autoplay", $wp_ada_compliance_def['av_tag_with_autoplay']['StoredError'], $objectcode);
			

	
		}// end child attribute check
		}		
}// end child node foreach object
}

// check embed tags for autostart	
$embeds = $dom->find('embed');
foreach ($embeds as $embed) {
		$embedcode = $embed->outertext;
		if (isset($embed) and $embed->getAttribute('autostart') == 'true'){		
            
            if($filteredcheck == 1) return 1;   
            
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"av_tag_with_autoplay", $embedcode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"av_tag_with_autoplay", $wp_ada_compliance_def['av_tag_with_autoplay']['StoredError'], $embedcode);
			

		}
}	
    
// iframe with mp3 or mp4	
$iframes = $dom->find('iframe');
foreach ($iframes as $iframe) {
		$iframecode = $iframe->outertext;
		if (stristr($iframe->getAttribute('src'),'.mp3') or stristr($iframe->getAttribute('src'),'.mp4')){		
            
            if($filteredcheck == 1) return 1;   
            
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"av_tag_with_autoplay", $iframecode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"av_tag_with_autoplay", $wp_ada_compliance_def['av_tag_with_autoplay']['StoredError'], $iframecode);
			

		}
}	    
	
return;	
}
?>