<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// look for content inserted using css
/********************************************************************/	
function wp_ada_compliance_validate_css_content_insertion($content, $postinfo){
	
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

	
// check if being scanned
if(in_array('css_content_insertion', $wp_ada_compliance_scanoptions)) return;
	

	
$pattern = "/:\s*(before|after)\s*{\s*content:\s*(\"|')(.{2,20})(\"|')/i";
//$pattern = "/:\s*(before|after)\s*{\s*content:\s*((\"|')(?!\\f|\s)).{1,50}(\"|')/i"; //ignores font awesome	
	

	if(preg_match_all($pattern, $content, $matches,PREG_OFFSET_CAPTURE)){

	$matchsize = sizeof($matches[0]);
	
	for($i=0; $i < $matchsize; $i++){
        if(isset($matches[0][$i]) 
		   and $matches[0][$i][0] != "" 
		   and !stristr($matches[0][$i][0],'attr(')
		   and !stristr($matches[0][$i][0],'\f')
		    and !stristr($matches[0][$i][0],'\e')
		   and !stristr($matches[0][$i][0],'\0')
		   and !stristr($matches[0][$i][0],' | ')
		   and !stristr($matches[0][$i][0],'\2')
		   //and !stristr($matches[0][$i][0],"' '")
		   //and !stristr($matches[0][$i][0],'"."')
		   //and !stristr($matches[0][$i][0],"'.'")
		  // and !stristr($matches[0][$i][0],"'|'")
		  // and !stristr($matches[0][$i][0],'"|"')
		   and !stristr($matches[0][$i][0],"content: none")
		  ){
		
			
		$css_content_insertion_errorcode = htmlspecialchars($matches[0][$i][0]).__(' (char #: ','wp-ada-compliance').$matches[0][$i][1].')';	

		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"css_content_insertion", $css_content_insertion_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "css_content_insertion", $wp_ada_compliance_def['css_content_insertion']['StoredError'], $css_content_insertion_errorcode);
		}
		

	}
	}
	
}
	return;
} 
?>