<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate data tables marked as presentation 	
/********************************************************************/	
function wp_ada_compliance_validate_data_table_marked_presentation($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);
$dom = wp_ada_compliance_filter_presentation_tables($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	  
	
// check if being scanned
if(in_array('data_table_marked_presentation', $wp_ada_compliance_scanoptions)) return;	

$tables = $dom->find('table');

foreach ($tables as $table) {	

$tablecode = $table->outertext;	
	
if($table != "" 
   and (stristr($table->getAttribute('role'), "presentation")) 
   and (stristr(wp_ada_compliance_stripInnerTables($tablecode), "<th") 
		or $table->getAttribute('summary') != "" 
		or stristr(wp_ada_compliance_stripInnerTables($tablecode), "<caption>"))
  ){	
				
	// save error
	if(!$insertid = wp_ada_compliance_error_check($postinfo,"data_table_marked_presentation", $tablecode)){		
	$insertid = wp_ada_compliance_insert_error($postinfo,"data_table_marked_presentation", $wp_ada_compliance_def['data_table_marked_presentation']['StoredError'],  $tablecode);	
	}

	}
	
}
return;
}

/*************************************************************
strip inner tables
*************************************************************/
function wp_ada_compliance_stripInnerTables($html){
$dom = new \DOMDocument;
$dom->preserveWhiteSpace = false;
$dom->loadHTML($html);

// Declare array with numeric vlaues
$remainImages = array(0);

$nodes = $dom->getElementsByTagName("table");

  for($i = 0; $i < $nodes->length; $i++) {
    if (!in_array($i,$remainImages)) {
        $image = $nodes->item($i);
        $image->parentNode->removeChild($image);
     }  
}

$newhtml = $dom->saveHTML();
return $newhtml;		
}	

?>