<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/****************************************
check duplicate page titles
****************************************/
function wp_ada_compliance_validate_duplicate_title($postinfo){
global $wp_ada_compliance_def;

     if(isset($postinfo['posttitle'])) $title = $postinfo['posttitle'];
    else $title = $postinfo['title'];
    
if($postinfo['type'] == 'widget' or $title == '') return;
    
    if(isset($postinfo['posttitle'])) $title = $postinfo['posttitle'];
    else $title = $postinfo['title'];
  
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('duplicate_title', $wp_ada_compliance_scanoptions)) return;	

if($links = wp_ada_compliance_title_check_link_table($title)){	
	$postinfo['examplecode'] = $links;
	$duplicate_title_errorcode = '<title>'.$title.'</title>'; 
	// save error
	if(!$insertid = wp_ada_compliance_error_check($postinfo,"duplicate_title", $duplicate_title_errorcode)){	
		$insertid = wp_ada_compliance_insert_error($postinfo,"duplicate_title", $wp_ada_compliance_def['duplicate_title']['StoredError'], $duplicate_title_errorcode);
		}

}
}
/*******************************************
scan page titles
******************************************/
function wp_ada_compliance_title_check_link_table($title){
global $wpdb;
    
if($title == '') return 0;
    
$links = '';
    $count = 1;
$query = 'SELECT link FROM '.$wpdb->prefix.'wp_ada_compliance_links where posttitle = %s and ignre = %d';
$linksfound = array();
$results = $wpdb->get_results( $wpdb->prepare( $query,$title, 0), ARRAY_A );
    foreach ( $results as $row ) {
        
        if(!in_array(rtrim($row['link'],'/'),$linksfound)){
        $links .= '<a href="'.$row['link'].'">'.$row['link'].'</a><br />';
            $count++;
        }
        $linksfound[] = rtrim($row['link'],'/');
    }
if($links != '' and $count > 2) {
   $returnvalue = __('Pages:','wp-ada-compliance').'<br />'.$links;
    
return $returnvalue;
}
    return 0;
}


/*******************************************
scan page titles
******************************************/
function wp_ada_compliance_title_single_check($title){
global $wpdb;
	
// get post types to be scanned
$variables = get_option('wp_ada_compliance_posttypes',array('page','post'));
//$check_attachments = get_option('wp_ada_compliance_attachmenttitles','false');	

if(!is_array($variables)) return false;
	
if($check_attachments == 'false'){
$attach_loc = array_search('attachment',$variables);
unset($variables["$attach_loc"]); 	
}
	
$how_many = count($variables);
$placeholders = array_fill(0, $how_many, '%s');
$format = implode(', ', $placeholders);
	
array_unshift($variables,$title);	
array_unshift($posttypes,"trash");
	array_unshift($posttypes,"auto-draft");
	array_unshift($posttypes,"draft");
	array_unshift($posttypes,"private");
	array_unshift($posttypes,"tao_sc_publish");
    array_unshift($posttypes,"cus_sc_publish");
array_unshift($variables,"revision");
	
$query = 'SELECT COUNT(*) FROM '.$wpdb->prefix.'posts where post_type NOT IN(%s) and post_status NOT IN(%s, %s, %s, %s, %s, %s) and post_title = %s and post_type IN('.$format.')';

$total = $wpdb->get_var( $wpdb->prepare( $query,$variables));
if($total > 1) return $total;
else return 0;
}
?>