<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// look for elementor image carousel set to autoplay
/********************************************************************/	
function wp_ada_compliance_validate_elementor_carousel_autoplay($content, $postinfo, $filteredcheck=0){
global $wp_ada_compliance_def;
    
if ( ! function_exists( 'is_plugin_active' ) )
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );    
if(!is_plugin_active('elementor-pro/elementor-pro.php')) return;       
		
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('elementor_carousel_autoplay', $wp_ada_compliance_scanoptions)) return;
 
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
$autocorrected = 0;
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     if(strstr($content,'//autocorrect elementor_carousel_autoplay') or strstr($content,'data-wp-ada-autocorrect') ){
  
        $autocorrected = 1;
     }
// don't report if auto correcting	onsave
if($postinfo['scantype'] == 'onsave' and get_option('wp_ada_compliance_stop_autoplay_image_carousel','false') == 'true') $autocorrected = 1; 	
}     
    

$dom = str_get_html($content);
   
$elements = $dom->find('[class*=elementor-widget-image-carousel]');

foreach ($elements as $element) {			
	
if(isset($element)){    
if($autocorrected == 0){
if(strstr($element->getAttribute('data-settings'),'&quot;autoplay&quot;:&quot;yes&quot;') 
   or strstr($element->getAttribute('data-settings'),'"autoplay":"yes"')){    

if($filteredcheck == 1) return 1;
        
if(strstr($content,'//autocorrect elementor_carousel_autoplay')){
$element->setAttribute('data-wp-ada-autocorrect', 'true');
}

$elementor_carousel_autoplay_errorcode = $element->outertext;	

if(!$insertid = wp_ada_compliance_error_check($postinfo,"elementor_carousel_autoplay", $elementor_carousel_autoplay_errorcode)){

$insertid = wp_ada_compliance_insert_error($postinfo, "elementor_carousel_autoplay", $wp_ada_compliance_def['elementor_carousel_autoplay']['StoredError'], $elementor_carousel_autoplay_errorcode);
}		
}
}
}
}
}
?>