<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************	
check for empty anchor tag	
********************************************************************/	
function wp_ada_compliance_validate_empty_anchor_tag($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('empty_anchor_tag', $wp_ada_compliance_scanoptions)) return 0;	   
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
 $dom = str_get_html($content);	
    $dom = wp_ada_compliance_correct_elementor_post_widget($dom);  
$dom = wp_ada_compliance_correct_elementor_icon_boxes($dom);    
$dom = wp_ada_compliance_correct_elementor_image_boxes($dom);      
$dom = wp_ada_compliance_remove_empty_tags_dom($dom);
$dom = wp_ada_compliance_filter_font_awesome_link_title_attributes($dom);
$dom = wp_ada_compliance_convert_link_title_attributes_to_aria_labels($dom);      
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}

	
if($content == '') return;	
    
$dom = str_get_html($content);	    
    
$links = $dom->find('a');
foreach ($links as $link) {
    
         // exclude links hidden from screen readers
if($link->getAttribute('tabindex') != '-1'){
    
$svg = $link->find('svg');
$svgalt = 1;
if(isset($svg[0])) {
$meta = $svg[0]->find('metadata');
    
if(isset($meta[0]))     
$metatext = $meta[0]->innertext;
else $metatext = '';
    
$svgalt = wp_ada_compliance_check_svg_img_alt_text($svg[0], $dom);
}    

if ((str_ireplace(array(' ','&nbsp;','-','_'),'',trim($link->plaintext)) == "" or ($svgalt == '' and (trim($metatext)==trim($link->plaintext))))
	and $link->hasAttribute('href') 
    and !strstr($link->getAttribute('class'),'addtoany_share')
	and $link->getAttribute('aria-label') == "" 
	and $link->getAttribute('title') == ""
        and wp_ada_compliance_get_aria_values($dom, $link, 'aria-labelledby') == ''
    and wp_ada_compliance_get_aria_values($dom, $link, 'aria-describedby') == ''
  ) {

		                      // ADD CODE TO TRACK AUTO CORRECT
        if($link->parent->getAttribute('class') == 'elementor-image-box-img' or $link->parent->getAttribute('class') == 'elementor-icon-box-icon' or $link->parent->getAttribute('class') == 'elementor-icon-box-title' or $link->parent->getAttribute('class') == 'elementor-image-box-title'){
            $link->setAttribute('data-class','elementor-image-or-icon-box');  
             $atagcode = $link->parent->parent->parent->parent->outertext;
            } 
      else $atagcode = $link->outertext;
    
            $image = $link->find('img');
            ;
           
		
            if($atagcode != "" 
               and !$link->hasAttribute('id') 
               and !$link->hasAttribute('name') 
              
             and (!isset($image[0]) or trim($image[0]->getAttribute('alt')) == "") 
                )   
             {
             if($filteredcheck == 1) return 1;
			
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"empty_anchor_tag", $atagcode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"empty_anchor_tag",$wp_ada_compliance_def['empty_anchor_tag']['StoredError'], $atagcode);
			
	
			}
		}
}
}
    return 0;
}


/**********************************************************
check svg image
**********************************************************/
function wp_ada_compliance_check_svg_img($svg, $dom){
    
if(is_array($svg)) {   
    
if(count($svg) == 0) return 1;     
    
$title = $svg[0]->find('title');

if((count($title) == 0 or $title[0]->innertext == '')
   and wp_ada_compliance_get_aria_values($dom, $svg[0], 'aria-labelledby') == '' 
    and wp_ada_compliance_get_aria_values($dom, $svg[0], 'aria-describedby') == '') { 
    return 0; 
}
}else{
$title = $svg->find('title');

if((count($title) == 0 or $title[0]->innertext == '')
   and wp_ada_compliance_get_aria_values($dom, $svg, 'aria-labelledby') == '' 
    and wp_ada_compliance_get_aria_values($dom, $svg, 'aria-describedby') == '') { 
    return 0; 
}    
    
}
    
return 1;    
}
?>