<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/
 //VALIDATE EMPTY TAGS
/********************************************************************/
function wp_ada_compliance_validate_empty_heading_tag($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
$dom = str_get_html($content);

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('empty_heading_tag', $wp_ada_compliance_scanoptions)) return;	
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
    $dom = str_get_html($content);
$dom = wp_ada_compliance_remove_empty_tags_dom($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
    $dom = str_get_html($content);
	
for ($i = 1; $i <= 6; $i++) {
	$headings = $dom->find('h'.$i);
	foreach ($headings as $heading) {

 $headingcode = $heading->outertext;

      if ((str_ireplace(array(' ','&nbsp;','-','_'),'',htmlentities(trim($heading->plaintext))) == "" or str_ireplace(array(' ','&nbsp;','-','_'),'',trim($heading->plaintext))== "")  and !preg_match('#<img(\S|\s)*alt=(\'|\")(\w|\s)(\w|\s|\p{P}|\(|\)|\p{Sm}|~|`|’|\^|\$)+(\'|\")#',$headingcode)) {
          
          	if($filteredcheck == 1) return 1;
				
		
				// save error
				if(!$insertid = wp_ada_compliance_error_check($postinfo,"empty_heading_tag", $headingcode))
				$insertid = wp_ada_compliance_insert_error($postinfo,"empty_heading_tag", $wp_ada_compliance_def['empty_heading_tag']['StoredError'], $headingcode);
				
			
			}
		
	}
}
	
return;
} 
?>