<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
	
/********************************************************************/	
// look for tags with onclick used to emulate links
/********************************************************************/	
function wp_ada_compliance_validate_emulating_links($content, $postinfo, $filteredcheck=0){
		
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('emulating_links', $wp_ada_compliance_scanoptions)) return;
    

    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	
$dom = wp_ada_compliance_correct_emulating_links($dom);  
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	        
    
$elements = $dom->find('*');
	
foreach ($elements as $element) {
	
	if(($element->getAttribute('onclick') or $element->getAttribute('ondblclick') 
		or $element->getAttribute('onmousedown') or $element->getAttribute('onmouseup')
		or $element->getAttribute('onkeypress') or $element->getAttribute('onkeydown') 
		or $element->getAttribute('onkeyup') or $element->getAttribute('onmouseover') 
		or $element->getAttribute('onmouseout') or $element->getAttribute('onmousemove')
		or $element->getAttribute('onfocus') or $element->getAttribute('onblur')) 
	   and $element->tag != 'a' 
	   and $element->tag != 'button' 
	   and $element->tag != 'input' 
	   and $element->tag != 'select' 
	   and $element->tag != 'textarea' 
	   and $element->tag != 'area' 
	   and $element->tag != 'datalist' 
	   and $element->tag != 'output' 
	   and (!$element->getAttribute('role')
	   or !$element->hasAttribute('tabindex'))
	  ){

        if($filteredcheck == 1) return 1;   
        
		$ahtagcode = $element->outertext;
		
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"emulating_links", $ahtagcode)){
			$insertid = wp_ada_compliance_insert_error($postinfo,"emulating_links", $wp_ada_compliance_def['emulating_links']['StoredError'],  $ahtagcode);
			}
			
		
		
		}
}

	return;
} 

?>