<?php
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate alt text content
/********************************************************************/
function wp_ada_compliance_validate_img_alt_invalid($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('img_alt_invalid', $wp_ada_compliance_scanoptions)) return;			

// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	
$dom = wp_ada_compliance_remove_invalid_img_alt_text($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	
    
/********************************************************************/	
// redundant alt text on image in a series
/********************************************************************	
$images = $dom->find('img');
$alttext='';
$redundantalttag = '';
foreach ($images as $image) {
if($image->getAttribute('alt') != ""){

if (wp_ada_compliance_compare_strings($alttext,$image->getAttribute('alt'))){
   $redundantalttag .= $image->outertext;

}
$alttext = $image->getAttribute('alt');

}
}

if($redundantalttag != ''){ 

if($filteredcheck == 1) return 1;

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_alt_invalid", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"img_alt_invalid", $wp_ada_compliance_def['img_alt_invalid']['StoredError'], $redundantalttag);  
    
} */    
    
    
// check svgs
$svgs = $dom->find('svg');
foreach ($svgs as $svg) {
if (isset($svg)) {
  $alt = wp_ada_compliance_check_svg_img_alt_text($svg, $dom);
   $error = wp_ada_compliance_check_image_alt_validity($alt,'',$dom);
    
    
if($error > 0){	 

$imagecode = $svg->outertext;
    
    if($filteredcheck == 1) return 1;  

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_alt_invalid", $imagecode))
$insertid = wp_ada_compliance_insert_error($postinfo,"img_alt_invalid", $wp_ada_compliance_def['img_alt_invalid']['StoredError'], $imagecode);

}
}  
}
    
// check images    
$images = $dom->find('img');
foreach ($images as $image) {
	
if (isset($image)) {

// check imag alt
$alt = $image->getAttribute('alt');
if($image->getAttribute('title') != '') $alt .= $image->getAttribute('title');
$error = wp_ada_compliance_check_image_alt_validity($alt, $image,$dom);

    
if($error > 0){	 

$imagecode = $image->outertext;
    
    if($filteredcheck == 1) return 1;  

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_alt_invalid", $imagecode))
$insertid = wp_ada_compliance_insert_error($postinfo,"img_alt_invalid", $wp_ada_compliance_def['img_alt_invalid']['StoredError'], $imagecode);

}
}
}
return;
}


   
/**********************************************************
check if the image alt is valid
**********************************************************/   
function wp_ada_compliance_check_image_alt_validity($alt,$image, $dom){
$error = 0;

 
    // exclude check if linked to larger image
//if($image == '' or $image->parent()->tag != 'a' or !strstr($image->parent()->href,substr($image->getAttribute('src'),-4,4))){ 
if($image == '' or !wp_ada_compliance_check_image_wrapped_in_anchor($dom, $image->getAttribute('alt'))){  
if(stristr($alt,__('image of','wp-ada-compliance'))) $error = 2;
if(stristr($alt,__('graphic of','wp-ada-compliance')))  $error = 2;
if(stristr($alt,__('photo of','wp-ada-compliance'))) $error = 2;
}    
    
// cehck for file name    
if (stristr($alt,__('.jpg','wp-ada-compliance')) 
or stristr($alt,__('.png','wp-ada-compliance')) 
    or stristr($alt,__('.svg','wp-ada-compliance')) 
    or stristr($alt,__('.jpeg','wp-ada-compliance'))
or stristr($alt,__('.gif','wp-ada-compliance'))  
or stristr($alt,__('DSCN','wp-ada-compliance')) 
    or stristr($alt,__('DSCF','wp-ada-compliance')) 
or stristr($alt,__('_','wp-ada-compliance'))
or preg_match('/^\d[a-zA-Z]\d[a-zA-Z][\w\-_]+\d$/',$alt)
or preg_match('/^[a-zA-Z]+\d$/',$alt)) $error = 1; 
    
    
if(strtolower($alt) == __('alt""','wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('alt=""','wp-ada-compliance')) $error = 1;
if(stristr($alt,__('click this','wp-ada-compliance'))) $error = 1;
if(stristr($alt,__('link to','wp-ada-compliance'))) $error = 1;
if(stristr($alt,__('image001','wp-ada-compliance'))) $error = 1;
if(stristr($alt,__('Featured Image','wp-ada-compliance'))) $error = 1;
if(strstr($alt,__('IMG ','wp-ada-compliance'))) $error = 1;
if(strtolower($alt) == __('spacer','wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('image','wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('picture','wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('logo','wp-ada-compliance')) $error = 1;
if($alt == __('OLYMPUS DIGITAL CAMERA','wp-ada-compliance')) $error = 1;
    
if(stristr($alt,__('UNTITLED','wp-ada-compliance'))) $error = 1;    

if(trim($alt) == '*') $error = 1;
for($i=1; $i < 10; $i++) {
if(strtolower($alt) == __('picture '.$i,'wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('image '.$i,'wp-ada-compliance')) $error = 1;

if(strtolower($alt) == __('spacer '.$i,'wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('000'.$i,'wp-ada-compliance')) $error = 1;
if(strtolower($alt) == __('intro#'.$i,'wp-ada-compliance')) $error = 1;

}

return $error;

}
?>