<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/****************************************
media library image with invalid alt text
****************************************/
function wp_ada_compliance_validate_img_alt_invalid_media($content, $postinfo){
	
global $wp_ada_compliance_def;

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('img_alt_invalid_media', $wp_ada_compliance_scanoptions)) return;
	
		$alt_text = get_post_meta($postinfo['postid'], '_wp_attachment_image_alt', true);
    $filename  = get_post_meta($postinfo['postid'], '_wp_attached_file', true); 
	$imagecode = '<img src="'.esc_url(site_url()).'/wp-content/uploads/'.trim(strip_tags($filename)).'" width="150" height="75" alt="'.$alt_text.'" />';
	
	
	// check for program space holders
	for($i=1; $i < 10; $i++) {
			if(strtolower($alt_text) == __('picture '.$i,'wp-ada-compliance')) $error = 1;
			if(strtolower($alt_text) == __('image '.$i,'wp-ada-compliance')) $error = 1;
			if(strtolower($alt_text) == __('spacer '.$i,'wp-ada-compliance')) $error = 1;
			if(strtolower($alt_text) == __('000'.$i,'wp-ada-compliance')) $error = 1;
			if(strtolower($alt_text) == __('intro#'.$i,'wp-ada-compliance')) $error = 1;
		}
   
     if (stristr($alt_text ,__('.jpg','wp-ada-compliance')) 
			or stristr($alt_text ,__('.jpeg','wp-ada-compliance')) 
            or stristr($alt_text ,__('.svg','wp-ada-compliance')) 
            or stristr($alt_text ,__('.png','wp-ada-compliance')) 
			or stristr($alt_text ,__('.gif','wp-ada-compliance'))  
            or stristr($alt_text ,__('DSCN','wp-ada-compliance')) 
            or stristr($alt_text ,__('DSCF','wp-ada-compliance'))
            or stristr($alt_text,__('UNTITLED','wp-ada-compliance'))
			or stristr($alt_text ,__('_','wp-ada-compliance'))
			or preg_match('/^\d[a-zA-Z]\d[a-zA-Z][\w\-_]+\d$/',$alt_text)
			or preg_match('/^[a-zA-Z]+\d$/',$alt_text)
		   ) $error = 1;
	
	if(isset($error) 
	  or trim($alt_text) == '*'
	  or stristr($alt_text,__('alt""','wp-ada-compliance'))
	   or stristr($alt_text,__('alt=""','wp-ada-compliance'))
	   or stristr($alt_text,__('image of','wp-ada-compliance'))
	   or stristr($alt_text,__('graphic of','wp-ada-compliance'))
	   or stristr($alt_text,__('photo of','wp-ada-compliance'))
	   or stristr($alt_text,__('Featured Image','wp-ada-compliance'))
	   or strstr($alt_text,__('IMG ','wp-ada-compliance'))
	    or stristr($alt_text,__('image001','wp-ada-compliance'))
	   or strtolower($alt_text) == __('picture','wp-ada-compliance')
	   or strtolower($alt_text) == __('image','wp-ada-compliance')
	   or strtolower($alt_text) == __('logo','wp-ada-compliance')
	   	or strtolower($alt_text) == __('spacer','wp-ada-compliance')
      or $alt_text == __('OLYMPUS DIGITAL CAMERA','wp-ada-compliance')) {
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_alt_invalid_media", $imagecode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"img_alt_invalid_media", $wp_ada_compliance_def['img_alt_invalid_media']['StoredError'], $imagecode);

			
	}
	}
?>