<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// image with alt text marked presentation
/********************************************************************/	
function wp_ada_compliance_validate_img_alt_marked_presentation($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('img_alt_marked_presentation', $wp_ada_compliance_scanoptions)) return;		

// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	
$dom = wp_ada_compliance_filter_presentation_tables($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	  
		
$images = $dom->find('img');	
	
foreach ($images as $image) {

if (isset($image) and $image->hasAttribute('alt') and $image->getAttribute('alt') != "" and ($image->getAttribute('role') == "presentation" or $image->getAttribute('aria-hidden') == "true")) {
			
			$imagecode = $image->outertext;
			
			// ignore certain images
			if(wp_ada_compliance_ignore_plugin_issues($imagecode))	goto img_alt_marked_presentationbottom;
			
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_alt_marked_presentation", $imagecode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"img_alt_marked_presentation", $wp_ada_compliance_def['img_alt_marked_presentation']['StoredError'], $imagecode);
			

			
		}
	img_alt_marked_presentationbottom:
		}
	

	return;
} 

?>