<?php
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate alt text
/********************************************************************/
function wp_ada_compliance_validate_img_duplicate_alt($content, $postinfo){
	
global $wp_ada_compliance_def;

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('img_duplicate_alt', $wp_ada_compliance_scanoptions)) return;			
	
if($content == '') return;	
    
$dom = str_get_html($content);	     
    
$images = $dom->find('img');
$alttext=array();
$redundantalttag = '';
$imagecode = array();    
$count = 0;
foreach ($images as $image) {
 
// skip if parent is hidden from screen readers
$element = $image;    
do {
$element = $element->parent();
if($element->getAttribute('aria-hidden') == "true") goto skipimage;
} 
while (!is_null($element->parent()));
    
if($image->getAttribute('role') != "presentation" and $image->getAttribute('aria-hidden') != "true"){    
    
if($image->getAttribute('alt') != ""){
   $alttext[$count] = strtolower($image->getAttribute('alt'));
   $imagecode[$count] = $image->outertext;
}
elseif(!is_null($image->parent()) and $image->parent()->tag != 'a' and trim($image->parent()->plaintext) != ''){  
$alttext[$count] = strtolower($image->parent()->plaintext); 
$imagecode[$count] = $image->parent()->outertext;    
}
elseif(!is_null($image->parent()->parent()) and trim($image->parent()->parent()->plaintext) != ''){  
$alttext[$count] = strtolower($image->parent()->parent()->plaintext); 
$imagecode[$count] = $image->parent()->parent()->outertext;

}   
elseif(!is_null($image->parent()->parent()->parent()) and trim($image->parent()->parent()->parent()->plaintext) != '' and strstr($image->parent()->parent()->parent()->getAttribute('class'),'swiper-slide')){ // only used for elementor sliders
$alttext[$count] = strtolower($image->parent()->parent()->parent()->plaintext); 
$imagecode[$count] = $image->parent()->parent()->parent()->outertext;
}        

$count++;
}
skipimage:
}

foreach ($alttext as $key => $value) {
if($value != ''){   
$redundantkeys = array_keys($alttext, $value);
if(count($redundantkeys) > 1){ 
    
$redundantalttag = '';     
foreach ($redundantkeys as $key2 => $value2) {
    if(array_key_exists($key2, $imagecode)) {
        $redundantalttag .= $imagecode[$value2];
    }
}
}

if($redundantalttag != ''){    

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_duplicate_alt", $redundantalttag))
$insertid = wp_ada_compliance_insert_error($postinfo,"img_duplicate_alt", $wp_ada_compliance_def['img_duplicate_alt']['StoredError'], $redundantalttag);  
    
}
}
}

return;
}
?>