<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// image empty alt text
/********************************************************************/	
function wp_ada_compliance_validate_img_empty_alt($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
	

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('img_empty_alt', $wp_ada_compliance_scanoptions)) return;	
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);
$dom = wp_ada_compliance_filter_presentation_tables($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	        
	
$tags = array('img', 'input');	
	
foreach ($tags as $tag) {		
$elements = $dom->find($tag);	
	
foreach ($elements as $element) {
 
   
if (isset($element) 
	and ($element->tag == 'img' and $element->hasAttribute('alt') and $element->getAttribute('alt') == "" and $element->getAttribute('class') != "role-presentation" and $element->getAttribute('role') != "presentation" and $element->getAttribute('aria-hidden') != "true")
	or  ($element->tag == 'input' 
		 and $element->hasAttribute('alt') and $element->getAttribute('type') == "image" and $element->getAttribute('alt') == "")
   ) {
			

			 $imagecode = $element->outertext;
			 
			// ignore certain images
			if(wp_ada_compliance_ignore_plugin_issues($imagecode))	goto img_empty_altbottom;
			
			// ignore images with captions
			if(wp_ada_compliance_ignore_inside_valid_caption($imagecode, $content)) goto img_empty_altbottom;
	
			// save error
   $insertid = wp_ada_compliance_error_check($postinfo,"img_empty_alt", $imagecode);
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_empty_alt", $imagecode)){
			$insertid = wp_ada_compliance_insert_error($postinfo,"img_empty_alt", $wp_ada_compliance_def['img_empty_alt']['StoredError'], $imagecode);
            }
			

			
		}
	img_empty_altbottom:
		}
	
}
	return;
} 

?>