<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************	
check for anchor tags linking images to them self
********************************************************************/	
function wp_ada_compliance_validate_img_linked_to_self($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('img_linked_to_self', $wp_ada_compliance_scanoptions)) return;
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	    
$dom = wp_ada_compliance_remove_img_linked_to_self($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
	
$dom = str_get_html($content); 

$links = $dom->find('a');
    
foreach ($links as $link) {

$images = $link->find('img');
if(isset($images)){
foreach ($images as $image) {
	$baseSRC = basename ($image->getAttribute('src'));
}
if(isset($baseSRC)){
	$alttext = '';
if($link->getAttribute('title') != '') $alttext = $link->getAttribute('title');	
$alttext .= $image->getAttribute('alt');	
if(basename($link->getAttribute('href')) == $baseSRC and !wp_ada_compliance_check_if_alt_text_includes_exclusion($alttext )){
		
	  if($filteredcheck == 1) return 1; 	
    
			$atagcode = $link->outertext;
		
			
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"img_linked_to_self", $atagcode))
			$insertid = wp_ada_compliance_insert_error($postinfo,"img_linked_to_self",$wp_ada_compliance_def['img_linked_to_self']['StoredError'], $atagcode);
			

}
}
}
}
return;
}
/****************************************************************
exclude images that include 
****************************************************************/
function wp_ada_compliance_check_if_alt_text_includes_exclusion($alt){
 $excludedALT[] = __('view larger image','wp-ada-compliance'); 
    $excludedALT[] = __('view a larger image','wp-ada-compliance');
foreach($excludedALT as $value){
 if(stristr($alt,$value)) return 1;   
}
 return 0;   
}
?>