<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate page structure, look for headings that are not in order
/********************************************************************/	
function wp_ada_compliance_validate_incorrect_heading_order($content, $postinfo){

    
// check only posts and when running a database scan
if($postinfo['type'] == "css" 
   or $postinfo['type'] == "widget"
  ) return; 
	
global $wp_ada_compliance_def;
	
	
$dom = str_get_html($content);
	
// remove empty headings before testing
$dom = wp_ada_compliance_remove_empty_tags_dom($dom);
    
// remove nav elements
$dom = wp_ada_compliance_remove_nav_elements($dom);
	
// save simple dom	
$content = $dom->save();	

if($content == "") return;   
    
$dom = str_get_html($content);		

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
$wp_ada_compliance_starting_H_level = get_option('wp_ada_compliance_starting_H_level','h2');	
	
// check if being scanned
if(in_array('incorrect_heading_order', $wp_ada_compliance_scanoptions)) return;	

// when scanning in editors check this	
if($postinfo['scantype'] == 'onsave'){
	
$errorcode = '';

  
// check using page structure    
$headings = $dom->find('h1,h2,h3,h4,h5,h6');
$previous = '';
foreach ($headings as $heading) {
    
 if($wp_ada_compliance_starting_H_level == 'h1'){    
if(strtolower($heading->tag) == 'h1' and $previous != '') {
    $errorcode .= __('more than one h1; ', 'wp-ada-compliance');  
	$errorcode .= $heading->outertext;
}

if(strtolower($heading->tag) == 'h2' and $previous != 'h1' and $previous != 'h2' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6' ) {
    $errorcode .= __('h2 without h1; ', 'wp-ada-compliance'); 
	$errorcode .= $heading->outertext;
}
}  
elseif($wp_ada_compliance_starting_H_level == 'h2'){    
if(strtolower($heading->tag) == 'h2' and $previous != 'h1' and $previous != 'h2' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6' and $previous != '') {
    $errorcode .= __('h2 before h1; ', 'wp-ada-compliance');
	$errorcode .= $heading->outertext;
}
}


if(strtolower($heading->tag) == 'h3' and $previous != 'h2' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6'   ){ 
    $errorcode .= __('h3 before h2; ', 'wp-ada-compliance');
	$errorcode .= $heading->outertext;
}
    
if(strtolower($heading->tag) == 'h4' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6' ) {
    $errorcode .= __('h4 before h3; ', 'wp-ada-compliance');   
	$errorcode .= $heading->outertext;
}
    
if(strtolower($heading->tag) == 'h5' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6'){ 
    $errorcode .= __('h5 before h4; ', 'wp-ada-compliance');  
	$errorcode .= $heading->outertext;
}
if(strtolower($heading->tag) == 'h6' and $previous != 'h5' and $previous != 'h6') {
    $errorcode .= __('h6 before h5; ', 'wp-ada-compliance');
	$errorcode .= $heading->outertext;
}
   

$previous = strtolower($heading->tag);
}

if($errorcode != ''){
$errorcode = 'Issues: '.$errorcode;	
	
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"incorrect_heading_order", $errorcode))
$insertid = wp_ada_compliance_insert_error($postinfo,"incorrect_heading_order", $wp_ada_compliance_def['incorrect_heading_order']['StoredError'], $errorcode);
}	
}
else{ // when scanning the full content do this	
$errorcode = '';	

$h1 = count($dom->find('h1'));	
if($h1 == 0) $errorcode .= __('no first level heading h1; ', 'wp-ada-compliance');		
elseif($h1 > 1) $errorcode .= __('more than one h1; ', 'wp-ada-compliance');
    
$h1s = $dom->find('h1');
$frontpage_id = get_option( 'page_on_front' );
foreach ($h1s as $h1value){

   if((trim(wp_ada_compliance_replaceSpecialCharacters($postinfo['title'])) != "" and trim(wp_ada_compliance_replaceSpecialCharacters($h1value->plaintext)) != "")
	and !stristr(trim(wp_ada_compliance_replaceSpecialCharacters($h1value->plaintext)), trim(wp_ada_compliance_replaceSpecialCharacters($postinfo['title']))) 
    and !stristr(trim(wp_ada_compliance_replaceSpecialCharacters($postinfo['title'])), trim(wp_ada_compliance_replaceSpecialCharacters($h1value->plaintext)))   
	 and !stristr(trim($h1value->plaintext), trim($postinfo['title'])) 
     and !stristr(trim($postinfo['title']), trim($h1value->plaintext))   
	 and !strstr($errorcode, __('h1 not page title; ', 'wp-ada-compliance'))
	 and $postinfo['postid'] != $frontpage_id
	 ) 
	 $errorcode .= __('h1 not page title; ', 'wp-ada-compliance');

	if(strstr($errorcode, __('h1 not page title; ', 'wp-ada-compliance')) or strstr($errorcode, __('more than one h1; ', 'wp-ada-compliance')))
	$errorcode .= $h1value->outertext;
}
    
// check that heading 1 is found inside the main content area
$mains = $dom->find('main,[role=main]');
foreach ($mains as $main) {
 $headings = $main->find('h1');
if(count($headings) < 1) $errorcode .= __('h1 not found in the main content area; ', 'wp-ada-compliance');  
}    
	   
// check using page structure    
$headings = $dom->find('h1,h2,h3,h4,h5,h6');
$previous = '';
foreach ($headings as $heading) {
        
if(strtolower($heading->tag) == 'h1' and $previous != ''){ 
    $errorcode .= __('more than one h1; ', 'wp-ada-compliance'); 
    $errorcode .= $heading->outertext;	
}
    
if(strtolower($heading->tag) == 'h2' and $previous != 'h1' and $previous != 'h2' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6') {
    $errorcode .= __('h2 before h1; ', 'wp-ada-compliance');
	$errorcode .= $heading->outertext;
}

if(strtolower($heading->tag) == 'h3' and $previous != 'h2' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6'   ){ 
    $errorcode .= __('h3 before h2; ', 'wp-ada-compliance');
	$errorcode .= $heading->outertext;
}
    
if(strtolower($heading->tag) == 'h4' and $previous != 'h3' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6' ) {
    $errorcode .= __('h4 before h3; ', 'wp-ada-compliance');   
	$errorcode .= $heading->outertext;
}
    
if(strtolower($heading->tag) == 'h5' and $previous != 'h4' and $previous != 'h5' and $previous != 'h6'){ 
    $errorcode .= __('h5 before h4; ', 'wp-ada-compliance');  
	$errorcode .= $heading->outertext;
}

if(strtolower($heading->tag) == 'h6' and $previous != 'h5' and $previous != 'h6') {
    $errorcode .= __('h6 before h5; ', 'wp-ada-compliance');
	$errorcode .= $heading->outertext;
}

$previous = strtolower($heading->tag);
}    
    

if($errorcode != ''){
$errorcode = 'Issues: '.$errorcode;			
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"incorrect_heading_order", $errorcode))
$insertid = wp_ada_compliance_insert_error($postinfo,"incorrect_heading_order", $wp_ada_compliance_def['incorrect_heading_order']['StoredError'], $errorcode);


}
	$errorcode = '';

}
return;
}
/********************************************************************
replace special Characters
*********************************************************************/
function wp_ada_compliance_replaceSpecialCharacters($value){
    $value = trim($value);

    $value = str_ireplace("   ", " ", $value);
    $value = str_ireplace("  ", " ", $value);
   $value = str_ireplace("‘", "'", $value);
    $value = str_ireplace("&amp;", "&", $value); 
	$value = str_ireplace("‘", "'", $value);
	$value = str_ireplace("’", "'", $value);
	$value = str_ireplace("”", '"', $value);
	$value = str_ireplace("“", '"', $value);
	$value = str_ireplace("&ldquo;", '"', $value);
	$value = str_ireplace("&rdquo;", '"', $value);
	$value = str_ireplace("&rsquo;", '"', $value);
	$value = str_ireplace("&ndash;", '"', $value);
	$value = str_ireplace("–", "-", $value);
	$value = str_ireplace("…", "...", $value);
	$value = str_ireplace("&oacute;", '', $value);
	$value = str_ireplace("&eacute;", '', $value);
	$value = str_ireplace("&aacute;", '', $value);
	$value = str_ireplace("&middot;", '', $value);
	$value = str_ireplace("&uacute;", '', $value);
	$value = str_ireplace("&uuml;", '', $value);
	$value = str_ireplace("&ograve;", '', $value);
	$value = str_ireplace("&egrave;", '', $value);
	$value = str_ireplace("&iacute;", '', $value);
	$value = str_ireplace("&ccedil;", '', $value);
	$value = str_ireplace("&agrave;", '', $value);
	
	$value = preg_replace("/[^a-zA-Z ]/u","", $value); 

 //  echo $value;
return $value;
}
/**********************************************
// remove nav elements before checking
**********************************************/
function wp_ada_compliance_remove_nav_elements( $dom ) {
	
$navs = $dom->find('nav, [role=navigation]');

	foreach ($navs as $nav) {
	    if(stristr($nav->outertext,'<h2') and !stristr($nav->outertext,'<h3') and !stristr($nav->outertext,'<h4') and !stristr($nav->outertext,'<h5') and !stristr($nav->outertext,'<h6'))
        $nav->outertext = '';
    }
    return $dom;
}
?>