<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************	
check for links with aria-labels that are not the same as the link text
********************************************************************/	
function wp_ada_compliance_validate_invalid_aria_label($content, $postinfo){
	
global $wp_ada_compliance_def;  

$dom = str_get_html($content);	

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('invalid_aria_label', $wp_ada_compliance_scanoptions)) return;	

$links = $dom->find('a');
    
foreach ($links as $link) {
	$text = trim(strtolower(wp_ada_compliance_replaceSpecialCharacters($link->plaintext)));
	$label = trim(strtolower(wp_ada_compliance_replaceSpecialCharacters($link->getAttribute('aria-label'))));
if ($link->hasAttribute('aria-label') 
	and $link->getAttribute('aria-hidden') != 'true' 
	and $text != '' 
	and wp_ada_compliance_check_invalid_aria_label_exception($text, $label, $link->getAttribute('class')) 
	and ($label == "" or (!stristr($label, $text) and !stristr($text,$label)))) {

$atagcode = $link->outertext;

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"invalid_aria_label", $atagcode))
$insertid = wp_ada_compliance_insert_error($postinfo,"invalid_aria_label",$wp_ada_compliance_def['invalid_aria_label']['StoredError'], $atagcode);
}
}
return;
}
/*******************************************************************
check exceptions
******************************************************************/
function wp_ada_compliance_check_invalid_aria_label_exception($text, $class){
	
	// class exceptions
    $class_exceptions[] = 'read-more-link';
	if(in_array($class,$class_exceptions)) return 0;
	
	// $exceptions[ARIA-LABEL] = LINK TEXT;
	$exceptions[] = __('X','wp-ada-compliance');
	$exceptions[] = __('Read More','wp-ada-compliance');
	$exceptions[] = __('View More','wp-ada-compliance');
	$exceptions[] = __('Website','wp-ada-compliance');
	$exceptions[] = __('Click Here','wp-ada-compliance');
		$exceptions[] = __('Agenda','wp-ada-compliance');
	$exceptions[] = __('Minutes','wp-ada-compliance');
	$exceptions[] = __('http','wp-ada-compliance');
	
	foreach($exceptions as $key => $value){
		if(strlen($value) == 1 and strtolower(trim($value)) == strtolower(trim($text))) return 0;
		if(strlen($value) > 1 and stristr(strtolower(trim($text)),strtolower(trim($value)))) return 0;
	}
	
	return 1;
}
?>