<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// check for anchors in the same page
/********************************************************************/	
function wp_ada_compliance_validate_link_to_in_page_content($content, $postinfo){
	
global $wp_ada_compliance_def;
	
$dom = str_get_html($content);

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('link_to_in_page_content', $wp_ada_compliance_scanoptions)) return;	

    
$links = $dom->find('a');
foreach ($links as $link) {
 
$imagealtiscompliant = 0;
	// check embeded image for compliance
	$nodes = $link->children();
		foreach ($nodes as $node) {
        
			if($node->tag == "img" or $node->tag == "i") {
				if(stristr($node->getAttribute('alt'), __('in page link','wp-ada-compliance'))
				   or stristr($node->getAttribute('title'), __('in page link','wp-ada-compliance'))
				  or stristr($node->getAttribute('aria-label'),__('in page link','wp-ada-compliance')) 
				  ){
				$imagealtiscompliant = 1;
				}
			}
           
			}
	if(substr($link->getAttribute('href'), 0, 1) == '#' 
       and strlen($link->getAttribute('href')) > 1
       and !stristr($link->plaintext, __('skip','wp-ada-compliance')) 
        and !stristr($link->getAttribute('class'), __('skip-link','wp-ada-compliance'))
       and !stristr($link->getAttribute('class'), __('screen-reader-text','wp-ada-compliance')) 
        and !stristr($link->plaintext, __('in page link','wp-ada-compliance')) 
       and !stristr($link->getAttribute('title'), __('in page link','wp-ada-compliance')) 
       and !stristr($link->getAttribute('aria-label'), __('in page link','wp-ada-compliance')) 
	   and $imagealtiscompliant == 0
      ) {
		    
	
			$code = $link->outertext;
		
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"link_to_in_page_content", $code))
			$insertid = wp_ada_compliance_insert_error($postinfo,"link_to_in_page_content", $wp_ada_compliance_def['link_to_in_page_content']['StoredError'], $code);
			
		
	
}
}
	return;
}

?>