<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
	
/********************************************************************/	
// validate lists with incorrect markup
/********************************************************************/	
function wp_ada_compliance_validate_list_incorrect_markup($content, $postinfo){
		
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('list_incorrect_markup', $wp_ada_compliance_scanoptions)) return;
	
$content = mb_convert_encoding($content, 'HTML-ENTITIES', "UTF-8");	
$dom = str_get_html($content);

	
$includes = array();
$excludes = array();
	
//$includes[] = '/^\s*\({0,1}(∙|⁍|⁌|⁃|◦|‣|-|–|·|•|&#8226;|&bull;|&#8227;|&#9702;|&#8259;|&#8268;|&#8269;|&#8729;|\(2\)|\(i\)|\(1\)|1\.|1\)|2-|a\.|a\))(\w|\s|[[:punct:]]|[^<(\/>)]){2,}$/im';	    
   
// all other bullets    
$includes['all'] = '/^(<br( ?\/){0,1}>)*\s*\({0,1}(∙|⁍|⁌|⁃|◦|‣|\p{Pd}|·|•|\(2\)|\(i\)|\(1\)|1\.|1\)|2-|A\.|a\.|a\))(\w|\s|[[:punct:]]|[^<(\/>)]){2,}$/um';	

//asterisks    
$includes['asterisks'] = '/^(<br( ?\/){0,1}>)*\s*\({0,1}(\*)(\w|\s|[[:punct:]]|[^<(\/>)]){2,}$/um';	
    
// exclude these    
$excludes[0] = '/^a\.(\w\.)/i';
$excludes[1] = '/^[0-9]\.[0-9]{1,2}/';
$excludes[2] = '/^\*\*/';
	
$elements = $dom->find('p,h1,h2,h3,h4,h5,h6,article div');
	
foreach ($elements as $element) {
if(// other bullets
(preg_match($includes['all'],preg_replace("/&nbsp;/", "", trim(html_entity_decode ($element->plaintext)))) 
and !preg_match($excludes[0],trim($element->plaintext)) 
and !preg_match($excludes[1],trim($element->plaintext)) 
 )
// asterisks
   or (preg_match($includes['asterisks'],trim($element->plaintext))
   and !preg_match($excludes[2],trim($element->plaintext))
    and substr_count($element->plaintext, '*') > 1)
){

$errorcode = trim(strip_tags($element->innertext,'<p>,<br>,<h1>,<h2>,<h3>,<h4>,<h5>'));

// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"list_incorrect_markup", $errorcode)){
$insertid = wp_ada_compliance_insert_error($postinfo,"list_incorrect_markup", $wp_ada_compliance_def['list_incorrect_markup']['StoredError'],  $errorcode);
}


}
}
	return;
} 

?>