<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// look for form labels without matching form field ids
/********************************************************************/	
function wp_ada_compliance_validate_missing_form_fieldid($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;
	
// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());
	
// check if being scanned
if(in_array('missing_form_fieldid', $wp_ada_compliance_scanoptions)) return;	
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	    
$dom = wp_ada_compliance_correct_VFP_labels($dom);
$dom = wp_ada_compliance_correct_GravityForms_labels($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
 $dom = str_get_html($content);		

// find labels with for attributes that don't match a field id 
$fields = $dom->find('input,select,textarea');
$fieldids = array();
foreach ($fields as $field) {
if(isset($field)) $fieldids[] = $field->getAttribute('id');
}
if(!isset($fieldids)) $fieldids[] = "%^&*";
  
$labels = $dom->find('label');
foreach ($labels as $label) {
 if(!in_array($label->getAttribute('for'),$fieldids) and !preg_match('/display:\s?none;/i',$label->parent()->getAttribute('style')) and !preg_match('/display:\s?none;/i',$label->getAttribute('style'))){
    $missing_form_fieldid_errorcode = $label->outertext;
		
	// if not hidden from screen readers
	if(!stristr($missing_form_fieldid_errorcode,'tabindex="-1"') and !stristr($missing_form_fieldid_errorcode,"tabindex='-1'")){
		// save error
		if(!$insertid = wp_ada_compliance_error_check($postinfo,"missing_form_fieldid", $missing_form_fieldid_errorcode)){
			
		$insertid = wp_ada_compliance_insert_error($postinfo, "missing_form_fieldid", $wp_ada_compliance_def['missing_form_fieldid']['StoredError'], $missing_form_fieldid_errorcode);
		}
		
		
	} 
 }
}
    
	
	return;
}
?>