<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate page structure, look for missing headings
/********************************************************************/	
function wp_ada_compliance_validate_missing_headings($postinfo){
global $wp_ada_compliance_def;

    // get content from database instead    
$content = get_the_content('','',$postinfo['postid']);	
 
      
 /******************************************************************    
// onsave heading check - look no headings in the content area
*******************************************************************/   
// check only posts and when running a database scan
if($postinfo['type'] == "css" 
   or $postinfo['type'] == "term" 
   or $postinfo['type'] == "widget"
   or $postinfo['type'] == "theme"
   or $postinfo['type'] == "attachment"
   or $postinfo['type'] == "pdf"
  or strlen($content) < 1000) return;

    
$dom = str_get_html($content);

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());    
	
// check if being scanned
if(in_array('missing_headings', $wp_ada_compliance_scanoptions)) return;	

	
$h1 = count($dom->find('h1'));
$h2 = count($dom->find('h2'));
$h3 = count($dom->find('h3'));
$h4 = count($dom->find('h4'));
$h5 = count($dom->find('h5'));
$h6 = count($dom->find('h6'));	

$headings = ($h1+$h2+$h3+$h4+$h5+$h6);


if($headings == 0){
$errorcode = __('Missing headings - Post ID: ', 'wp-ada-compliance').$postinfo['postid'];
			
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"missing_headings", $errorcode))
$insertid = wp_ada_compliance_insert_error($postinfo,"missing_headings", $wp_ada_compliance_def['missing_headings']['StoredError'], $errorcode);


}	
return;
}
?>