<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/********************************************************************/	
// validate missing laguage attributes in theme files
/********************************************************************/
function wp_ada_compliance_validate_missing_lang_attr($content, $postinfo, $filteredcheck=0){
	
global $wp_ada_compliance_def;

// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('missing_lang_attr', $wp_ada_compliance_scanoptions)) return;
    
	    
	
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);
$dom = wp_ada_compliance_add_lang_attribute( $dom,2);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	   
    
$html = $dom->find('html');

foreach ($html as $htmlcode) {	
if ($htmlcode->getAttribute('lang') != "" or $htmlcode->getAttribute('xml:lang') != "") return;


$code = substr($htmlcode->outertext, 0, strpos($htmlcode->outertext, '>')+1);	
$code = str_replace('data-wp-ada-scanner="true"','',$code);	
    
if($filteredcheck == 1) return 1;    
   
// save error
if(!$insertid = wp_ada_compliance_error_check($postinfo,"missing_lang_attr", $code)){
$insertid = wp_ada_compliance_insert_error($postinfo,"missing_lang_attr", $wp_ada_compliance_def['missing_lang_attr']['StoredError'], $code);
}
}
}	
?>
