<?php 
// Exit if called directly.
if ( ! defined( 'ABSPATH' ) ) die;
/*********************************************************************************/	
// validate elments with onclick but not onkeypress
/*********************************************************************************/	
function wp_ada_compliance_validate_missing_onkeypress($content, $postinfo, $filteredcheck=0){

global $wp_ada_compliance_def;
	


// get options
$wp_ada_compliance_scanoptions = get_option('wp_ada_compliance_ignore_scan_rules', array());

// check if being scanned
if(in_array('missing_onkeypress', $wp_ada_compliance_scanoptions)) return;	
    
// apply filters   
$wp_ada_compliance_filter_content = get_option('wp_ada_compliance_filter_content','true'); 
$wp_ada_compliance_report_filtered_errors = get_option('wp_ada_compliance_report_filtered_errors','false');     
    
if($wp_ada_compliance_filter_content == 'true' and (($wp_ada_compliance_report_filtered_errors == 'false' and strstr($content,'data-wp-ada-scanner')) or $filteredcheck == 1)) {
     
$dom = str_get_html($content);	
$dom = wp_ada_compliance_correct_event_handlers($dom);
if(is_object($dom)){
$content = $dom->save();  
} else return;	
}  
	
if($content == '') return;	
    
$dom = str_get_html($content);	       
    
	
$elements = $dom->find("*");

foreach ($elements as $element) {

// ignore 	
if(isset($element)){
$founderror = 0;
	// click events
	if (($element->getAttribute('onclick') or $element->getAttribute('ondblclick') 
		 or $element->getAttribute('onmousedown') or $element->getAttribute('onmouseup'))
		and !$element->getAttribute('onkeypress') and !$element->getAttribute('onkeydown') and !$element->getAttribute('onkeyup')) $founderror = 1;
	
	// focus and blur events
	if (($element->getAttribute('onmouseover') or $element->getAttribute('onmouseout') or $element->getAttribute('onmousemove'))
		and !$element->getAttribute('onfocus') and !$element->getAttribute('onblur')) $founderror = 1;
	
	if($founderror == 1){
        
        if($filteredcheck == 1) return 1;   
				
			$code = $element->outertext;
			
			// save error
			if(!$insertid = wp_ada_compliance_error_check($postinfo,"missing_onkeypress", $code))
			$insertid = wp_ada_compliance_insert_error($postinfo,"missing_onkeypress", $wp_ada_compliance_def['missing_onkeypress']['StoredError'], $code);
			

			
		}
	}
}
	return;
}
?>